// Closure to isolate scope, as per best practices
(function() {
	"use strict";

	// Get a reference to the reportsBuilder module
	var app = angular.module('reports');

	app
			.directive('cvLegendComponent',
					[
							'customReportSvc',
							'dataSource',
							'$timeout',
							function(customReportSvc, $dataSource, $timeout) {
								return {
									restrict : "AEC",
									scope : false,
									templateUrl : customReports.contextPath +
											'/reportsplus/components/legends/legend.jsp',
									controller : [
											'$scope','$sce',
											function($scope,$sce) {
												customReportSvc
														.registerCallback("redrawAllComponents",
																function(data, isAutoRefresh) {
																	if (data &&
																			data.dataSet &&
																			data.dataSet.dataSetName !== $scope.component.dataSet.dataSetName) {
																		return false;
																	}
																	$scope.loadComponent(isAutoRefresh);
																});
												customReportSvc.registerCallback("refreshComponent", function(
														componentId) {
													if (componentId === $scope.component.id) {
														$scope.loadComponent();
													}
												});

												customReportSvc.registerCallback("resetLegendHTMLTemplate",function(){
													//Resetting to default template code
													$scope.component.htmlContent = $scope.component.defaultHTMLTemplate; 
												});

												$scope.evalExpression = function() {
													var args = arguments && arguments.length > 0 ? arguments[0] : {};
													//add the common ones; required for custom script
													if (!args.expression) {
															args["expression"] = $scope.component.htmlContent;
													}
													if (!args.rows && $scope.component.currentFetchedRecords) {
														args["rows"] = $scope.component.currentFetchedRecords;
													}
													args["componentId"] = $scope.component.id;
													if ($scope.dataSet && $scope.dataSet.dCubeDataSet) {
														args["dCubeDataSet"] = $scope.dataSet.dCubeDataSet;
													}

													var x = rpt.evalExpression(args);
													if (typeof x === 'string') {
														x = $sce.trustAsHtml(x);
													}

													if($scope.component.autoHeight){
														$scope.resizeGridComponent();
													}

													return x;
												}

												$scope.resizeGridComponent = function () {
													var selector = $("li[comp=" + $scope.component.id + "]");
										             $timeout(function () {
										                     var compHeight = selector.find(".customLegend").outerHeight(true) +  $("#"+$scope.component.id+"-component-title").outerHeight(true)+30;
										                     var compWidth = selector.width();
										                     var gridsterCurColWidth = $("#reportContentWrapper").size() > 0 ? $("#reportContentWrapper").width() / 12 : $scope.gridster.curColWidth;
										                     if ($scope.gridsterItem && $scope.gridsterItem.$element && !$scope.component.collapsed && compWidth > 0 && gridsterCurColWidth > 0) {
										                         $scope.gridsterItem.sizeY = Math.ceil(compHeight / $scope.gridster.rowHeight);
										                     }
										             }, 100);
												 };
												
												$scope.loadComponent = function(isAutoRefresh,primaryLoadAfterDrop) {
													var successCallback = function(resultData) {

														var response = resultData.data;
														var records = response.records;
														var columns = response.columns;
														var failures = response.failures;
														var data = {};
														var rows = {};
														for (var i = 0; i < records.length; i++) {
															var resultRow = records[i];
															var row = {};
															for (var j = 0; j < columns.length; j++) {
																var col = columns[j];
																var id = col.name;
																if ($scope.dataSet.endpoint === 'DATACUBE' &&
																		!$scope.useCREApiForSolr) {
																	row[id] = resultRow[id]
																} else {
																	row[id] = resultRow[j];
																}
																if (col.type === "TimeStamp" || col.type === "Date") {
																	row[id] = rpt.formatDateByColType(row[id], col);
																}
															}
															rows[i] = row;
														}

														function renderApplier(key,columnIndex){
															let value = rows[0][key];
														    if(key == "CommServeGUID"){
															        value =value.slice(-10);
															        value = value.slice(0, 3) + "-" + value.slice(3, 6) + "-" + value.slice(6);
														    }else if(key == "commcellid"){
														        value = parseInt(value).toString(16);
														    }

															//apply column formatter
															if($scope.component.columns[columnIndex].cellExpression){
																value = customReportSvc.getFormattedValue(value,$scope.component.columns[columnIndex].cellExpression,rows[0],0,columnIndex,value,$scope.component.dataset);
															}

															return value;
														}

														function createDefaultHTML(){
															let defaultHtml =  "<ul id='cvLegend'>";
															Object.keys(rows[0]).forEach( (key,index)=> {
																let value = renderApplier(key,index);
																rows[0][key] = value;
																let line = '\n\t<li class = "keyValuePair">\n\t\t<span class = "LegendKey">{{rpt.translate("'+ key + '")}}:</span>\n\t\t<span class = "LegendValue">{{rows[0]["'+key+'"]}}</span>\n\t</li>';
																defaultHtml+= line;						
															});
															defaultHtml +=  "\n</ul>";
															return defaultHtml;
														}

														if( (!$scope.component.htmlContent || $scope.component.htmlContent == $scope.component.defaultHTMLTemplate)&& rows[0]){
															$scope.component.defaultHTMLTemplate = createDefaultHTML();
															$scope.component.htmlContent = $scope.component.defaultHTMLTemplate;
														}

														//finally evaluating the content
														if ($scope.component.htmlContent) {
															$scope.htmlRendered = $scope.evalExpression({
																"rows" : rows
															});
														}
														$scope.component.currentFetchedRecords = rows;
														$scope.component.isComponentLoading = false;
														if ($scope.exportType) {
															$scope.setAllComponentsIntialized($scope.component);
														}
													};
													if ($scope.dataSet && $scope.dataSet.endpoint === 'DATACUBE' &&
															!$scope.useCREApiForSolr) {
														if(!isAutoRefresh)
															$scope.component.isComponentLoading = true;
														// evalExprOnly - when the usecase is to only execute the expression and not load the component even when data columns are provided
														// data columns are provided to identify the data set details
														if ($scope.component.evalExprOnly &&
																$scope.component.htmlContent) {
															$scope.htmlRendered = $scope.evalExpression();
														} else if ($scope.component.customQuery) {
															var customQuery = undefined;
															try {
																var options = {
																	dataSet : $scope.dataSet,
																	customQuery : JSON.parse($scope.component.customQuery),
																	inputParams : customReportSvc.applyInputsToDataSet($scope.dataSet, $scope.page.inputs)
																};
																$dataSource
																		.getDataSource($scope.dataSet.endpoint)
																		.getCustomData(options,
																				function(data) {
																					if ($scope.component.htmlContent) {
																						$scope.htmlRendered = $scope
																								.evalExpression({
																									"data" : data
																								});
																					}
																					$scope.component.isComponentLoading = false;
																				});
															} catch (ex) {
																alert("Error parsing the custom query response.");
																$scope.component.isComponentLoading = false;
															}
														} else {
															var tableParams = {
																columns : $scope.component.columns,
																limit : 1
															};
															$dataSource.getDataSource($scope.dataSet.endpoint)
																	.getTableData({
																		dataSet : $scope.dataSet,
																		componentType : $scope.component.type,
																		tableParams : tableParams
																	}, function(resp) {
																		successCallback({
																			data : resp
																		});
																	});
														}
													} else {
														if ($scope.dataSet) {
															$scope.getData(undefined, false, isAutoRefresh).then(successCallback, function(error) {
																console.log(error);
															});
														}
													}

												}

												$scope.reloadComponent = function(refreshCache) {
													$scope.loadComponent();
												};

												if (!$scope.component.columns) {
													$scope.component.columns = [];
												}

												$scope.dropped = function(dragEl, dropEl) {
													var source = document.getElementById(dragEl);
													if ($scope.reportMode == "viewer") {
														return;
													}

													if (!$scope.component.isSelected) {
														customReportSvc
																.errorToast('Select the component to add a column.');
														return;
													}

													if (typeof $scope.component.hideHeader === 'undefined') {
														$scope.component.hideHeader = true;
													}

													var dest = document.getElementById(dropEl);
													var src = document.getElementById(dragEl);
													var drag = angular.element(src);
													var drop = angular.element(dest);
													if (drag.data("componenttype") != "COLUMN") { //check is needed because rearranging columns also triggered drop
														$scope.columnRearranged = true;
														return;
													}

													var columnName = drag.attr("data-name");
													var columnType = drag.attr("data-type");
													var origType = drag.attr("data-origtype");
													var dataField = drag.attr("data-datafield");
													var dataSetEntity = drag.data("datasetentity");
													var dataSetName = dataSetEntity.dataSetName;

													if ($scope.isTileBuilder && $scope.tileProperties) {
														if (drop.attr("data-tile-component-type")) {
															var eleType = drop.attr("data-tile-component-type"); //outcome or remarks
															var guid = drag.data("datasetguid");
															if (!guid) {
																guid = dataSetEntity.dataSetGuid;
															}
															$scope.tileProperties[eleType + "Dataset"] = guid;
															$scope.tileProperties[eleType + "Column"] = columnName;
														}
													}

													if (!$scope.component.dataSet ||
															!$scope.component.dataSet.dataSetName) {
														$scope.associateDataSetToComponent(dataSetEntity);
													} else if ($scope.component.dataSet.dataSetName != dataSetName) {
														alert("Mismatched data Sets");
														return;
													}

													$timeout(function() {
														$scope.component.columns.push({
															displayName : columnName,
															name : columnName,
															dataField : columnName,
															type : columnType,
															id : columnName.replace(/\s/g, "")
														});

														$scope.loadComponent(undefined,true);
													});
												};

												if ($scope.component.dataSet && $scope.component.columns.length > 0 &&
														$scope.component.htmlContent) {
													$scope.loadComponent();
												} else if (!$scope.component.dataSet && $scope.component.tileCompType) {
													$scope.htmlRendered = '';
												} else if ($scope.component.htmlContent) {
													$scope.htmlRendered = $scope.evalExpression();
													if ($scope.exportType) {
														$scope.setAllComponentsIntialized($scope.component);
													}
												}

												$scope.removeDuplicates = function (workflows) {
													return workflows;
												};

												$scope.deleteColumn = function(index, subType) {
													$scope.component.columns.splice(index, 1);
													if ($scope.component.columns.length === 0) { //remove the data set association when the last column is removed.
														$scope.component.dataSet = undefined;
													}
													$scope.loadComponent();

													if (subType && $scope.isTileBuilder && $scope.tileProperties) {
														var dsProp = subType + "Dataset";
														var colProp = subType + "Column";
														delete $scope.tileProperties[subType + "Dataset"];
														delete $scope.tileProperties[subType + "Column"];
													}
												};
												if ($scope.reportMode == 'builder') {
													$scope.$watch('component.htmlContent', function(newVal, oldVal) {
														if (newVal !== undefined && newVal !== oldVal) {
															$scope.htmlRendered = $scope.evalExpression({
																"expression" : newVal
															});
														}
													});
												}
											} ]
								}
							} ]);

})();
