import { exportConstants } from '../../js/constants';
(function() {
	"use strict";

	angular.module("reports").controller("tableKendoCtrl", kendoGridCtrl);

	kendoGridCtrl.$inject = [ '$scope', 'reportService', 'customReportSvc', 'dataSource', '$timeout', '$http', '$sce', '$compile', '$q' ,'$uibModal' ,'$rootScope', '$sanitize'];

	function kendoGridCtrl($scope, reportService, customReportSvc, $dataSource, $timeout, $http, $sce, $compile , $q, $uibModal, $rootScope, $sanitize) {
		$scope.gridInitialized = false;
		$scope.kendoGridOptions = {};
		$scope.colOrder = {};
		$scope.showDropColumnsMessage = false;
		$scope.settingsDropDownOptions  = {
								openOnClick: {rootMenuItems: true},
								direction:'left',
								activate:function(){
									$("li[comp=" + $scope.component.id + "]").css('z-index',12);
								},
								deactivate:function(){
									console.log('de active');
									$("li[comp=" + $scope.component.id + "]").css('z-index',2);
								}};
		var actionsEnabled = false;
		$scope.grouped = false;
		var rowSelectionEnabled = false;
		var resetColumns = $scope.component.allColumns;
		var initialDataBound = false;
		var isFooterHidden = false;
		$scope.selectedObj = {
            selectedRows: {},
            allRowsSelected: false,
		 }
		$scope.allRows = {selected:false};
		$scope.SYS_ROWID = 'sys_rowid';
		if($scope.component.shared && $scope.component.sys_rowid_col){
			$scope.SYS_ROWID = $scope.component.sys_rowid_col;
		}
		$scope.selectedRows = {};
		$scope.singleSelectValue="";
		$scope.showSelectedRowsLabel = false;
		$scope.checkboxes = {};
		//$scope.child = {offset:0};
		var isAdvancedfilter = false;
		var offlineBehaviorAdded = false;
		var colsCopy = [];
		var columnsById = {};
		var kendoColumns = [];
		var cvKendoTypeMap = {"String":"string","Integer":"number","Long":"number","TimeStamp":"date","Date":"date","DateTime":"date"};
		var cvKendoModelTypeMap = {"String":"string","Integer":"number","Long":"number","Decimal":"number","TimeStamp":"string","Date":"string","DateTime":"string"};
		$scope.globalSearch = "";
		let globalSearchVal = $scope.requestParms[$scope.component.id + ".filter.*"];
		if(globalSearchVal)
			$scope.globalSearch = globalSearchVal;
		else if(!$.isEmptyObject($scope.dataSet) && $scope.dataSet.endpoint === 'DATACUBE' && !$.isEmptyObject($scope.pageFilters) &&
			!$.isEmptyObject($scope.pageFilters["viewer"])) {
			let dataSetName = $scope.dataSet.dataSet.dataSetName,
			filters = $scope.pageFilters["viewer"];
			if(!$.isEmptyObject(filters[dataSetName]) && !$.isEmptyObject(filters[dataSetName]["globalSearch"] &&
				filters[dataSetName]["globalSearch"].filterValue))
				$scope.globalSearch = filters[dataSetName]["globalSearch"].filterValue;
		}

		$scope.searchApplied = $scope.globalSearch ? true : false;
		$scope.searchEnabled = $scope.globalSearch ? true : false;
		var defaultRowTemplate, defaultAltRowTemplate, isGrouped;
		var columnsByDataField = {}; // temp storage for faster retrieval by dataField.
		$scope.translatedColNames = {}; // temp storage for faster retrieval by id.
		var colIndexByIds = {}; // temp storage for faster retrieval by id.
		var kendoFieldModel = {};
		$scope.component.showFilterByDefault =  $scope.component.showFilterByDefault || false;
		var isReadMe = customReportSvc.getParameterByName("readme");
		$scope.hiddenColumns = [];
		$scope.visibleColumns = [];
		var initVisibleColumsFromUrl = function(){
			var hiddenColumnStr = $scope.mergedParams[$scope.component.id + ".hide"];
			if (hiddenColumnStr) {
				$scope.hiddenColumns = hiddenColumnStr.split(",");
			}


			var visibleColumnStr = $scope.mergedParams[$scope.component.id + ".show"];
			if (visibleColumnStr) {
				$scope.visibleColumns = visibleColumnStr.split(",");
			}
		}


		if($scope.component.allColumns && $scope.dataSet) {
			var columnsToDisplay = $scope.component.columnsToDisplay;
			if(columnsToDisplay ) {//when allColumns set to true and columnsToDisplay is given in the config then
				//we are adding those visible columns in the table so that we can get data only for visible columns and not for all
				var operator = "or",noOfColsToDisp = $scope.dataSet.fields.length;
				if(columnsToDisplay.operator)
					operator = columnsToDisplay.operator.toLowerCase().trim();
				if(columnsToDisplay.noOfColumns)
					noOfColsToDisp = columnsToDisplay.noOfColumns;
			}
			if(!$scope.component.columns)
				$scope.component.columns = []

			var remainingFields,col,field,isAddCol, columns = $scope.component.columns,
			isColDefAvailable =  columns.length > 0;

			if(!isColDefAvailable && columnsToDisplay && columnsToDisplay.columnProperties) {
				remainingFields = $.map($scope.dataSet.fields, function(field) {
					var filteredProp = columnsToDisplay.columnProperties.filter(function(property) {
						return field[property.propertyName] === property.propertyValue;

					}).length;
					isAddCol = operator === "or" ? filteredProp > 0 : filteredProp === columnsToDisplay.columnProperties.length;

					if(isAddCol && columns.length < noOfColsToDisp) {
						col = {
							name : field.name,
							dataField : field.dataField,
							type : field.type
						};
						col = addColumn(col);
					} else
						return field;
				});
				if(columns.length < noOfColsToDisp) { //add remaining columns
					for(var i = 0; i <remainingFields.length; i++) {
					    var field = remainingFields[i];
				 		col = {
								name : field.name,
								dataField : field.dataField,
								type : field.type
							};
						col = addColumn(col);
						if(columns.length >= noOfColsToDisp)
							break;
					 }
				}
			}

		}


		colsCopy = angular.copy($scope.component.columns); // holds the column preferences in case of allColumns feature.


		//handle default page size.
		var pageSizeUrl = customReportSvc.getParameterByName(encodeURIComponent($scope.component.id) + ".limit");
		var exportPageSize = customReportSvc.getParameterByName("pageSize");
		$scope.component.pageSize = pageSizeUrl != "" ? parseInt(pageSizeUrl): $scope.component.pageSize;
		//$scope.component.enableHorizontalScroll = $scope.component.enableHorizontalScroll ? $scope.component.enableHorizontalScroll : undefined;
        $scope.toggleScrollMode = function(){
        	$scope.component.enableHorizontalScroll = !$scope.component.enableHorizontalScroll;
        }
		if (exportPageSize == "-1" && $scope.dataSet.endpoint !== 'DATACUBE'){$scope.component.pageSize = 1000;}
		if($scope.exportType === "csv" || $scope.exportType === "pdf" || $scope.exportType === "html" || $scope.exportType === 'email_body'){
			window.pendingRequests += 1; // To make sure export waits till the below timeout is called.
			if($scope.dataSet.endpoint !== 'DATACUBE'){// TEMPORARY Check for HotFix
				$scope.component.pageSize = 2;
			}
		}

		if(isReadMe){
			$scope.component.pageSize = 5;
		}

		var cvKendoTypeMap = {"String":"string","Integer":"number","Long":"number","Decimal":"number","Double":"number","TimeStamp":"date","Date":"date","DateTime":"date"};
		$scope.numberArray = [ 'Double', 'Float', 'Integer', 'Long', 'Short', 'Decimal' ];
		$scope.dateOperators = {
				relative: "Relative",
				btw: "Between"
        }



		$scope.setChildScope($scope);

		$scope.trustHtml = function(html){
			return $sce.trustAsHtml(html);
		}

		$scope.toTrusted = function(dataItem,column) {
			var someHTML = dataItem[column.id+'_formatted'] === undefined ? dataItem[column.id] : dataItem[column.id+'_formatted']
			if (typeof dataItem[column.id+"_formatted"] === "string"){
				someHTML = $scope.trustHtml(dataItem[column.id+"_formatted"]);
			}
			return someHTML;
		}

		var defaultPageSize = $scope.component.pageSize || 20;
		function clearSpecialCharecters(columnId) {
			return columnId.replace(/[^a-zA-Z0-9_]/g, '');
		}
		function generateColumnId(dataField) {
			var id = "";
			var orginalId = "";
			var replaceCharecter = $scope.dataSet.endpoint === "MONITORING_POLICY" ? " " : "";
			id = dataField.replace(/\s/g, replaceCharecter);
			orginalId = dataField.replace(/\s/g, replaceCharecter);
			// if column is only number adding string before to it.
			if(!isNaN(id)){
				id = "col"+id
			}

			let match = id.match(/^[0-9]+/g);
			if(match && match.length > 0){
				match = match[0];
				id = id + match; // moving the number to the end.
				id = id.replace(/^[0-9]+/g,'')
			}
			id = clearSpecialCharecters(id);
			var i = 1;
			while (id in columnsById) {
				id = id + i;
				i++;
			}

			return id;

		};

		function getColumnInfo(col) {
			var retCol;
			for (var k = 0; k < colsCopy.length; k++) {
				if(colsCopy[k].dataField.toLowerCase() === col.dataField.toLowerCase() || (col.name && colsCopy[k].id.toLowerCase() === col.name.toLowerCase())){
					retCol = colsCopy[k];
					break;
				}
			}
			return retCol;
		};

		$scope.loadDistinctdataForColumn = function(colId,params,aggrType,skipSameColumnFilters,isGroupBy){
			var dataset = $scope.dataSet;
			var originalColumn = columnsById[colId];
			if (dataset && dataset.endpoint && dataset.endpoint === "DATACUBE") {
				var parametersList = customReportSvc.applyInputsToDataSet(dataset,$scope.inputs,$scope.customReport.builderVersion);
				return new Promise(function (resolve, reject) {
					 $dataSource.getDataSource(dataset.endpoint).getChartData({
							dataSet : dataset,
							measureDataField : [ {
								'column' : originalColumn.dataField,
								'aggrType' : 'Count'
							} ],
							dimensionDataField : [
									{
										'column' : originalColumn.dataField,
										'numPointsToDisplay' : {
											"maxPoints" : 100
										},
										'sortDirection' : 'asc'
									},
									{
										'column' : originalColumn.dataField,
										'sortDirection' : 'asc'
									} ],
							inputParams : parametersList,
							filters :  $scope.component.filters &&
								$scope.component.filters['builder'] ? $scope.component.filters['builder'][$scope.dataSet.dataSet.dataSetName]
								: {}
						},function (data) {
							console.log(data);
		        				 var response = data.data;
		        				 data.data.records = response.records.map(function (rec) {
		        					 var field = originalColumn.id;
		        					 var fieldCount = originalColumn.id+"_count";
		        					 if(params.type === "select"){
		        						 fieldCount = 'count';
		        			        }
		        					 var newRec = {
		        							 	label:rec[0],
		        							 	value:rec[0]
		        					 };
		        					 newRec[field] = rec[0];
		        					 newRec[fieldCount] = rec[2];
		        					 if(cellExpression){
		        						 var label = $scope.getFormattedValue(newRec['label'], cellExpression,newRec,originalColumn);
		        						 if(label){
		        							 newRec['label'] = label;//$sce.trustAsHtml(label);
		        							 newRec['label_tooltip'] = label.replace($scope.removeHtmlRegex, '');
			        					 }
		        					 }
		                             return newRec;
		                         });
		        			 console.log(data);
		        			 resolve(data);
		                 });
				 });

			}else{
				var valueColumn = angular.copy(columnsById[colId],{});
				aggrType = !aggrType ? "CountDistinct" : aggrType;
				var component = angular.copy($scope.component,{});
				component.type="TABLE";
				component.id = component.id;
	        	component.pageSize = params.pageSize || -1;
	        	component.pageOffset = params.offset || 0;
	        	component.allColumns = false;
	        	var aggrColumn = angular.copy(valueColumn,{});
	        	aggrColumn.aggrType = aggrType;
	        	aggrColumn.id = aggrColumn.id+"_count";
	        	aggrColumn.countNullsAsBlank = true;
	        	component.skipSameColumnFilters = skipSameColumnFilters || false;
	        	component.applyParentFilters = true;
	        	component.selectColumn =  colId;
	        	component.formatObject = true;
	        	component.sorting = [{columnId: 'value', direction: 'Asc'}];
	        	if(isGroupBy){
	        		component.sorting = [{columnId: aggrColumn.id, direction: 'Desc'}];
	        	}
	        	if(params.searchText){
	        		component.searchText = params.searchText
	        	}
	        	if(params.type === "select"){
	        		valueColumn.id = 'value';
	        		aggrColumn.id = 'count';
	        	}
	        	var cellExpression = originalColumn.cellExpression || $scope.component.allCellExpression;
	        	component.columns = [valueColumn,aggrColumn];
	        	 return new Promise(function (resolve, reject) {
	        		 $scope.getData(undefined, undefined, !$scope.component.isComponentLoading, component).then(function (data) {
	        				 var response = data.data;
	        				 data.data.records = response.records.map(function (rec) {
	        					 rec[originalColumn.id] = rec[valueColumn.id];
	        					 rec['label'] = rec[valueColumn.id];
	        					 rec['label'] = rec[valueColumn.id] === "" ? "Blank" : rec[valueColumn.id];
	        					 if(cellExpression){
		        					 var label = $scope.getFormattedValue(rec[valueColumn.id], cellExpression, rec,originalColumn);
		        					 if(label){
		        						 rec['label'] = label;//$sce.trustAsHtml(label);
		        					 }
		        					 rec['label_tooltip'] = rec['label'].replace($scope.removeHtmlRegex, '');
	        					 }
	        					 return rec;
	                         });

	            		 resolve(data);
	                 }).catch(function (err) {
	                	 reject(err)
	                 });
	             });
			}

		}

		$scope.enableSearch = function(){
			if(!$scope.searchEnabled){
				$scope.searchEnabled = true;
				document.getElementById($scope.component.id + "-search-input").focus();
			}
		}

		var promise = '';
		$scope.handleSearch = function(clear){
			$scope.searchApplied = true;
			if(clear){
				$scope.searchApplied = false;
				$scope.searchEnabled = false;
				$scope.globalSearch = '';
			}
			if ($scope.dataSet.endpoint !== "DATACUBE" || $scope.useCREApiForSolr) {
				$timeout(function() {
					$scope.addParameter($scope.component.id + ".filter.*", $scope.globalSearch, false);
					kendoDataSource.read();
				});
			} else {
				$scope.addFilters("globalSearch",$scope.globalSearch,$scope.component,false,false,[],false,'viewer','',true,$scope.dataSet,undefined,undefined,true);
			}

		}

		$scope.applyFilter = function(filter){
			var filterText = "." + filter.type +".";
			//var value = e.filter.filters.length > 1 ? JSON.stringify(_.map(e.filter.filters, 'value')) : operator ? operator + value : value;
			var value = filter.value;
			if ($scope.dataSet.endpoint !== "DATACUBE" || $scope.useCREApiForSolr) {
				if('select' && $.isArray(value) ){
					value = value.length > 0 ? JSON.stringify(value) : "";
				}
				$scope.addParameter($scope.component.id + filterText + filter.field, value, false);
				$scope.kendoGrid.dataSource.query({page: 1,pageSize: $scope.component.pageSize});
			} else {
				if(filter.type === 'filter'){
					let advancedFilter = "";
					if(filter.value !== "")
					 	advancedFilter = customReportSvc.getDefaultAdvancedFilter(filter.field, value);
					$scope.addFilters(filter.field,advancedFilter,$scope.component,false,false,[],true,'viewer','include',true,$scope.dataSet,undefined,undefined,true);
				}else{
					if(value === "$all$")
						value = "";

					const selectionType = filter.selectionType ? filter.selectionType : "include";
					let field = customReportSvc.getDataSetField($scope.dataSet,filter.field);
					const isMultiple = filter.type === "rowSelect" || field.type === "String";
					$scope.addFilters(filter.field,value,$scope.component,isMultiple,true,[],false,'viewer',selectionType,true,$scope.dataSet,undefined,undefined,true);
				}
			}
			if(filter.type === "select" && filter.value){
				addResetFilterMenuOption(filter.field,null,true);
			}

		}

		$scope.clearFilter = function(filter) {
			if ($scope.dataSet.endpoint === "DATACUBE" && !$scope.useCREApiForSolr) {
				let field = customReportSvc.getDataSetField($scope.dataSet,filter.field);
				const isMultiple = filter.type === "rowSelect" || field.type === "String";
				$scope.addFilters(filter.field,"",$scope.component,isMultiple,true,[],filter.type === 'filter','viewer','include',true,$scope.dataSet,undefined,undefined,true);
			}
		}


		var addResetFilterMenuOption = function(colName,menu,close){
			if(!menu){
				menu = $('.'+$scope.component.id+'.select-filter-'+colName).find(".k-menu").data("kendoMenu");
			}
			var popup =  $('.'+$scope.component.id+'.select-filter-'+colName).find(".k-popup").data('kendoPopup');
			if(menu.element.children('.reset-filter').length === 0){
				menu.insertBefore({attr:{'dataId':'reset-filter'},text : 'Reset Filter',spriteCssClass : "k-i-filter-clear",cssClass : 'reset-filter ' + colName},menu.element.children('.k-filter-item'));
			}

			// this will close the pop up container.
			if(popup){
				popup.close()
			}

			// this will close the column menu container.
			if(menu && close){
				menu.element.parent().parent().hide();
			}

		}

		function getFilterForColumn(column){
			var colName = column.id;
			var filter = {
					extra:false,
					cell : {
						showOperators : false,
						template : function(args) {
                            var filterCell = args.element.parents(".k-filtercell");
                            filterCell.empty();
                            var th = filterCell.parent();
                            $(th).attr('data-field',colName);
                            var id = $scope.component.id + "_field_" + colName,
                            filterValue = "",
                            urlFilterVal = $scope.requestParms[$scope.component.id + ".filter." + colName];
                            if(urlFilterVal)
                            	filterValue = urlFilterVal;
                            else if(!$.isEmptyObject($scope.dataSet) && $scope.dataSet.endpoint === 'DATACUBE' && !$.isEmptyObject($scope.pageFilters) &&
								!$.isEmptyObject($scope.pageFilters["viewer"]))  {
                            	let dataSetName = $scope.dataSet.dataSet.dataSetName,
								filters = $scope.pageFilters["viewer"];
								if(!$.isEmptyObject(filters[dataSetName]) && !$.isEmptyObject(filters[dataSetName][colName])
									&& !$.isEmptyObject(filters[dataSetName][colName]["tableFilters"])
										&& !$.isEmptyObject(filters[dataSetName][colName]["tableFilters"]["advancedFilters"])) {
									filterValue = filters[dataSetName][colName]["tableFilters"]["advancedFilters"][0].filters[0].value;
								}
                            }
                            if(filterValue && $scope.reportMode === "viewer"){
                            	$scope.component.showFilterByDefault = true;
                            }
                            var column = columnsById[colName];
                            var template = '<cell-filter field="'+colName+'" field-displayName="'+column.displayName+'" filter-value="'+filterValue+'"></cell-filter>';
                            template = angular.element(template);
                            $compile(template)($scope);
                            filterCell.html(template);
                        }
					}
				}

				filter.ui = function(element){
					var urlFilter =  $scope.requestParms[$scope.component.id+".select."+colName];
					 var filterCell = element.parents(".k-filterable");
                     var id = $scope.component.id + "_field_" + colName;
                     var filterValue = "",
                     urlFilterVal = $scope.requestParms[$scope.component.id + ".select." + colName];
                     //For data cube we store all url parameters in the page filter so taking value directly from page filters
                     if(!$.isEmptyObject($scope.dataSet) && $scope.dataSet.endpoint === 'DATACUBE' && !$.isEmptyObject($scope.pageFilters) &&
								!$.isEmptyObject($scope.pageFilters["viewer"]))  {
                     		let dataSetName = $scope.dataSet.dataSet.dataSetName,
							filters = $scope.pageFilters["viewer"];
							if(!$.isEmptyObject(filters[dataSetName]) && !$.isEmptyObject(filters[dataSetName][colName])
									&& !$.isEmptyObject(filters[dataSetName][colName]["tableFilters"])) {
										if(!$.isEmptyObject(filters[dataSetName][colName]["tableFilters"]["include"]))
											filterValue = filters[dataSetName][colName]["tableFilters"]["include"];
										else if(!$.isEmptyObject(filters[dataSetName][colName]["tableFilters"]["daterange"])) {
											let dateRange = filters[dataSetName][colName]["tableFilters"]["daterange"];
											if(dateRange.to || dateRange.from)
												filterValue = encodeURIComponent(JSON.stringify(dateRange));
											else if(dateRange.relative)
												filterValue = dateRange.relative;
											else if(typeof dateRange === "string")
												filterValue = dateRange;

										}
									}
                     } else if(urlFilterVal) {
                     	filterValue = urlFilterVal;
                     }

                     var column = columnsById[colName];
                     var displayName = $scope.translatedColNames[colName];
                     if(filterValue && column.type === "String" && typeof filterValue === "string" &&  filterValue.startsWith("[")){
                    	 filterValue = JSON.parse(filterValue);
                     }

                     var filterType = cvKendoTypeMap[column.type];
                     var colSizeFormat = "";
                     let formatter = _.get(column,'cellExpression.type');
                     if(formatter === 'size'){
                    	 filterType = 'size';
                    	 colSizeFormat = _.get(column,'cellExpression.source');
                     }

                     var template = '<select-filter field="'+colName+'"  col-size-format="'+colSizeFormat+'" filter-value="'+filterValue+'" field-displayname="'+displayName+'" field-type="'+filterType+'" col-type="'+column.type+'" ></select-filter>';
                     template = angular.element(template);
                     $compile(template)($scope);
                     filterCell.html(template);
				}

			return filter;
		}

		$scope.isExportTwoStep = function(){
			var type = '';
			if ($scope.exportType) {
				type = $scope.exportType.toLowerCase();
			}
			if( (type == 'pdf' || type == 'html' || type == 'email_body') && $scope.dataSet.endpoint !== 'DATACUBE' && !$scope.isReportInsideDetailedReport ){
				return true;
			}
			return false;
		}

		$scope.getFormattedValue = function (value, cellExpression, row, col) {
            return customReportSvc.getFormattedValue(value, cellExpression, row, undefined, undefined, col, $scope.dataSet);
        };

        $scope.htmlRegex = /<([A-Za-z!][A-Za-z0-9!]*)\b[^>]*>(.*?)(<\/\1>)*/i;
		$scope.removeHtmlRegex = /((<style>)[^]*(<\/style>))+|((<script>)[^]*(<\/script>))+|<\/?[^>]+>/ig;

        $scope.getToolTip = function(data,column) {
			var columnId = column.id , FormatterType;
			if(column.cellExpression)
				FormatterType = column.cellExpression.type;
			var dataStr = (data[columnId+'_formatted'] === undefined || FormatterType === "boolean") ? data[columnId] :data[columnId+'_formatted'] ;
			if (dataStr && typeof dataStr === "string" && $scope.htmlRegex.test(dataStr)) {
				dataStr = dataStr.replace($scope.removeHtmlRegex, '');
			}
			return dataStr;
		}

        var applyCellExpr = function(resultData, row, rowIndex) {
			var rowStyleExpression = $scope.component.rowStyleExpression;
			if (rowStyleExpression)
				resultData['rowStyle'] = customReportSvc.evalExpression(rowStyleExpression,
						row,
						rowIndex);
			for (var j = 0; j < $scope.component.columns.length; j++) {
				var col = $scope.component.columns[j];
				var cellExpression = col.cellExpression || $scope.component.allCellExpression;
				var tagAttributes = col.cellAttributes;
				if(col.components && col.components.length > 0){
					if(!tagAttributes){
						tagAttributes = {};
					}
					tagAttributes['cv-column-actions']="true";
				}

				var cellData = resultData[col.id];
				var columnIndex = j;
				if(!cellExpression && (col.type === "TimeStamp" || col.type === "Date")){
					cellExpression = "=rpt.formatDateByColType(cellData,col)";
				}
				if (cellExpression){
					resultData[col.id+"_formatted"] = customReportSvc.getFormattedValue(cellData,
							cellExpression,
							row,
							rowIndex,
							columnIndex,
							col, $scope.dataSet);

//					if (col.type === 'FileList' || typeof resultData[col.id+"_formatted"] === "string"){
//					resultData[col.id+"_formatted"] = $sce.trustAsHtml(resultData[col.id+"_formatted"])
//					}

				}else{
					if(resultData[col.id] === 0 || resultData[col.id] === false){
						resultData[col.id+"_formatted"] = ""+resultData[col.id];
					}
				}
				if (tagAttributes) {
					for ( var key in tagAttributes) {
						var objKey = col.id + "tagAttributes";
						if (!resultData[objKey])
							resultData[objKey] = {};
						if (tagAttributes[key]) {
							resultData[objKey][key] = customReportSvc
									.evalExpression(tagAttributes[key],
											row,
											col,
											rowIndex,
											cellData,
											columnIndex);
						}
					}
				}

				if (col.hasOwnProperty("splitByCharacter") && col.splitByCharacter != "") {
					var currData = resultData[col.id + "_formatted"] !== undefined ? resultData[col.id + "_formatted"] : resultData[col.id];
					if (cellData != null) {
						cellData = currData.toString();
						if (cellData.indexOf(col.splitByCharacter) != -1) {
							currData = cellData.split(col.splitByCharacter)
									.join("<br/>");
						} else {
							currData = cellData;
						}
					}
					if (resultData[col.id + "_formatted"]) {
						resultData[col.id + "_formatted"] = currData;
					} else {
						resultData[col.id] = currData;
					}
				}
				if (resultData[col.id + "_formatted"] &&
						typeof resultData[col.id + "_formatted"] === 'object' &&
							Array.isArray(resultData[col.id + "_formatted"])) {
						resultData[col.id + "_formatted"] = resultData[col.id + "_formatted"].join("<br/>");
				}
				if (typeof resultData[col.id] === 'object' &&
							Array.isArray(resultData[col.id])) {
						resultData[col.id] = resultData[col.id].join("<br/>");
				}

				if(col.components && col.components.length > 0){
					var params = {row:row,col:col,rowIndex:rowIndex,cellData:cellData,columnIndex:columnIndex};
					resultData[col.id+"_components"] = {};
					var finalActionsHtml = '<ul class="column-components">';
					for(var t=0;t<col.components.length;t++){
						var ccomp = col.components[t];
						resultData[col.id+"_components"][ccomp.id] = rpt.getColumCompHtml(ccomp,params);
						finalActionsHtml = finalActionsHtml + "<li class='column-item'>" +resultData[col.id+"_components"][ccomp.id]+"</li>";
					}
					finalActionsHtml = finalActionsHtml + "</ul>"
					resultData[col.id+ "_formatted"] = finalActionsHtml;//$sce.trustAsHtml(finalActionsHtml);
				}

				if(resultData[col.id+"_formatted"] === 0 || resultData[col.id+"_formatted"] === false){
					resultData[col.id+"_formatted"] = ""+resultData[col.id+"_formatted"];
				}
			}

			if($scope.component.showAsSearchResults && $scope.component.rowTemplate){
				resultData['rowTemplate'] = customReportSvc.evalExpression($scope.component.rowTemplate,resultData,rowIndex);
			}

			if($scope.component.enableRowSelection){
				if(typeof $scope.component.disableRowSelectionWhen !== "undefined"){
					resultData['disableRowSelection'] = customReportSvc.evalExpression($scope.component.disableRowSelectionWhen,row,rowIndex);
				}else{
					resultData['disableRowSelection'] = false;
				}

				if(typeof $scope.component.hideRowSelectionWhen !== "undefined"){
					resultData['hideRowSelection'] = customReportSvc.evalExpression($scope.component.hideRowSelectionWhen,row,rowIndex);
				}else{
					resultData['hideRowSelection'] = false;
				}

			}

			return resultData;
		}

       	function isValidVarName (name) {
            try {
                // Update, previoulsy it was
                // eval('(function() { var ' + name + '; })()');
                Function('var ' + name);
            } catch( e ) {
                return false;
            }
            return true;
        }
		function getKendoColumn (column) {
			var colName = column.id;
			var fieldId = isValidVarName(column.id) ? column.id : "pvc"+column.id; // kendo grid enforces field name should be a valid javascript identifier be number. For pivoted columns fields will be number.
			kendoFieldModel[fieldId] = {type:cvKendoModelTypeMap[column.type]};
			var translatedname = rpt.evalExpression({expression:customReportSvc.checkExpressionToLocalize(column.displayName)});
			var tooltip = translatedname.replace($scope.removeHtmlRegex, '');
			$scope.translatedColNames[column.id] = translatedname;
			var col  = {
					field : fieldId, // field name cannot be number. For pivoted columns fields will be number.
					headerTemplate : translatedname,
					hidden : column.hidden || !column.visible ? true : false,
					visible : column.visible || false,
				    menu: column.hidden ? false : true,
					filterable : getFilterForColumn(column),
					headerAttributes: {
					   title: tooltip
					}
			}
			if($scope.hiddenColumns.indexOf(column.id) !== -1){
				col.hidden = true;
			}

			if($scope.visibleColumns.indexOf(column.id) !== -1){
				col.hidden = false;
			}

			if(typeof column.width !== "undefined"){
				col.width = column.width+"px";
			}
			return col;
		}

		//Check for determining whether we need to process columns. If the columns are undefined or if the columns defined do not have a type we to fetch the information again and merge the columns
		var isColumnProcessingRequired = function() {
			if ($scope.dataSet && $scope.dataSet.endpoint === 'DATACUBE') {
				return false;
			}
			if (!$scope.component.columns) {
				$scope.noColumndefintions = true;
				return true;
			} else {
				if($scope.component.columns.length === 0 && $scope.reportMode === "viewer"){
                    $scope.noColumndefintions = true;
                    return true;
				}
				for (var i = 0; i < $scope.component.columns.length; i++) {
					if (!$scope.component.columns[i].type)
						return true;
				}
			}

			return false;
		};



		kendoColumns = $scope.component.allColumns || isColumnProcessingRequired() ? [] :$scope.component.columns.map(function(column, i) {
			column.id = clearSpecialCharecters(column.id); // to clear any special characters in the old report.
			columnsByDataField[column.dataField.toLowerCase()] = column;
			columnsById[column.id] = column;
			colIndexByIds[column.id] = i;
			if($scope.hiddenColumns.indexOf(column.id) !== -1){
				column.visible = false;
			}

			if($scope.visibleColumns.indexOf(column.id) !== -1){
				column.visible = true;
			}
			return getKendoColumn(column);
		});

		var addOfflineBehavior = function(record){
			offlineBehaviorAdded = true;
			var privateIndex = colIndexByIds["IsPrivate"];
			var cvIndex = colIndexByIds["CommcellVersion"];
			var isPrivate;
			if(record){
				isPrivate = record[privateIndex];
			}
			var cIdx = colIndexByIds["CommcellName"];
			if (isPrivate) {
				if (cIdx){
					$scope.component.columns[cIdx].cellExpression = "='<a target=\"_top\" href=\"../survey/reports/dashboard.jsp?commUniId=' + row['CommServUniqueId'] + '\">' + row['CommcellName'] + '</a>'";
				}
			}else{
				var cName = colIndexByIds["CustomerName"];
				if (cName) {
					$scope.component.columns[cName].cellExpression = "='<a target=\"_top\" href=\"../survey/reports/dashboard.jsp?commUniId=' + row['CommServUniqueId'] + '\">' + row['CustomerName'] + '</a>'";
					$scope.component.columns[cName].hidden = false;
					$scope.component.columns[cName].displayName = "Customer";
					$scope.component.columns[cIdx].hidden = true;
					$scope.translatedColNames["CustomerName"] = "Customer";
				}
				kendoColumns[cName] = getKendoColumn($scope.component.columns[cName]); // update the kendo column with the changes.
				kendoColumns[cIdx] = getKendoColumn($scope.component.columns[cIdx]); // update the kendo column with the changes.
			}
			$scope.component.columns.splice(2,0,$scope.component.columns.splice(cvIndex,1)[0]);
			kendoColumns.splice(2,0,kendoColumns.splice(cvIndex,1)[0]);

			// update column indexes
			colIndexByIds = {};
			$scope.component.columns.map(function(column,i){
				colIndexByIds[column.id] = i;
			});
		}
		function addColumn(col, j) {
			var column = getColumnInfo(col);
			if(!column){
				column = {
					dataField : col.name,
					displayName : col.name,
					id : generateColumnId(col.name),
					type : col.type,
					origType : col.hasOwnProperty("origType") ? col.origType : "",
					visible : col.visible !== undefined ? col.visible : true,
					hidden : col.name.indexOf("!") == 0 || col.name.indexOf("ActualHidden") != -1 ? true : false,
					aggrType : 'None',
					mobileOptions : {
						visible : true,
						viewOnList : true,
						viewOnDetail : true
					}
				};

				if(col.dataField.indexOf("<") !== -1 && col.dataField.indexOf(">") !== -1){
					// add cell expression to the column by adding teh formatter
					let fmt = col.dataField.substring(col.dataField.indexOf("<"),col.dataField.length);
					let formatters = fmt.split("><");
					formatters.map(formatter => {
						formatter = formatter.replace(/[<>]/g, '');
						if(formatter === "HIDDEN" || formatter === "SORTCOLUMN"){
							column.visible = false;
						}

						if(formatter === "DONOTSHOW" ){
							column.hidden = true;
						}

						if(formatter === "SORTCOLUMN"){//To Do: Sort based on this column
							column.hidden = true;
							if(column.displayName.indexOf("<SORTCOLUMN>") !== -1){
								var re = /<SORTCOLUMN>/gi;
								column.displayName = column.displayName.replace(re, '_SORTCOLUMN');
							}
						}
					});

					column.cellExpression = {
							type:"Metrics",
							fmt:fmt.split("><")
					}

				}

				if(column.dataField === "CommServ UniqueId"){
					column.hidden = true;
				}

				// hide data source column if it is a new column.
				if(column.dataField.toLowerCase() === "data source" || column.dataField === "CommCell ID"){
					column.visible = false;
				}



			}else{
				column.id = clearSpecialCharecters(column.id);
				column.type = col.type;
			}

			if ($scope.reportMode === "preview" && $scope.component.columns.length > 9) {
				column.visible = false;
			}

			columnsById[column.id] = column;
			columnsByDataField[column.dataField.toLowerCase()] = column;

			if (column.dataField.toLowerCase() === $scope.SYS_ROWID && ($scope.component.allColumns || $scope.customReport.builderVersion < 2) ) {
				column.hidden = true; // marking this column hidden by default. Not adding this columns to the list is not processing results correctly, as the results include the value for this field.
			}

			if(column.dataField.toLowerCase() === "data source"){
				if(customReports.appName === 'adminconsole'){
					column.hidden = true;
				}else{
					// In case of single commcell mode hide the commcell column
					let commcellInput = _.find($scope.page.inputs,{type: "Commcell"});
					if(column.visible && commcellInput && commcellInput.hidden){
						column.visible = false;
					}

				}
			}

			if ($scope.component.noOfColumnsToDisplay && j > $scope.component.noOfColumnsToDisplay + 1) { // when allColumns set to true and want to limit the number of visible columns in the gui.
				$scope.component.columns[j].visible = false;
			}

			var length = $scope.component.columns.push(column);
			kendoColumns.push(getKendoColumn(column));
			if($scope.hiddenColumns.indexOf(column.id) !== -1){
				$scope.component.columns[j].visible = false;
			}

			if($scope.visibleColumns.indexOf(column.id) !== -1){
				$scope.component.columns[j].visible = true;
			}

			colIndexByIds[column.id] = length - 1;
			return column;
		}

		var initializeColumns = function(columns) {
			// reset columns
			if(resetColumns){
				columnsById = {};
				columnsByDataField = {}; // temp storage for faster retrieval by dataField.
				$scope.translatedColNames = {}; // temp storage for faster retrieval by id.
				colIndexByIds = {}; // temp storage for faster retrieval by id.
				kendoFieldModel = {};
				kendoColumns = [];
				rowSelectionEnabled = false;
				colsCopy = angular.copy($scope.component.columns); // holds the column preferences in case of allColumns feature.
				$scope.component.columns = [];
				initVisibleColumsFromUrl();
			}

			columns.map(function(col, j) {
				var column = columnsById[col.name] || columnsByDataField[col.dataField.toLowerCase()] ||
						undefined;
				if (column) {
					column.type = col.type;
				} else if(!column && $scope.component.allColumns){
					// if column does not exist in the current copy then push the new column
					column = addColumn({
						name : col.name,
						dataField : col.dataField,
						type : col.type
					}, j);
				}
				// app studio add cell expression at run time for file preview.
				if (column && column.type === 'FileList') {
					column.cellExpression = '=convertFilesToLinks(cellData, col, row)';
					column.shareId = $scope.dataSet.fields[j].shareId;
					column.fieldGuid = $scope.dataSet.fields[j].fieldGuid;
				}
				// offline line report , add cell expression for customer or commcell link.

				if($scope.customReport.isMetrics && column && column.dataField === "CommCell ID"){
					column.cellExpression = {
							type:"Metrics",
							fmt:['commcellID']
					}
				}

				if($scope.customReport.isMetrics && column && column.dataField === "CommCell Name"){
					column.cellExpression = {
							type:"Metrics",
							fmt:['commcellName']
					}
				}

				// TODO
			});

			// by default enable auto scrolling when there are more than 15 columns. User can set an additional setting to control the number of columns. If the value is do not auto add scroll.
			if ($scope.cv && !$.isEmptyObject($scope.cv.additionalSettings) && $scope.cv.additionalSettings.Console && $scope.cv.additionalSettings.Console.enableAutoScroll) {
				if($scope.cv.additionalSettings.Console.enableAutoScroll !== 0){
					$scope.component.enableHorizontalScroll =  columns.length > $scope.cv.additionalSettings.Console.enableAutoScroll;
				}
			}else{
				var visibleColumns = $scope.component.columns.filter(x => (x.visible && !x.hidden));
				// this should be done only if the enableHorizontalScroll is not set to true.
				if(typeof $scope.component.enableHorizontalScroll === "undefined"){
					$scope.component.enableHorizontalScroll =  visibleColumns.length > 15;
				}
			}

			// We may not need this since the user has enabled it. When there are fewer columns than they can fit , the table looks bad when the enableHorizontalScroll mode is true.
			if($scope.component.enableHorizontalScroll && visibleColumns.length < 5 && $('#Kendo_'+$scope.component.id+' table').width() > $('#Kendo_'+$scope.component.id+' tbody').width()){
				$scope.component.enableHorizontalScroll =  false;
			}

			// the columns are hidden in pdf which is not showing enough information. in html the scroll bar is added.
			if($scope.exportType && $scope.exportType === "pdf"){
				$scope.component.enableHorizontalScroll =  false;
			}

			if($scope.exportType){
				$scope.component.autoHeight = "on";
			}

			var colOrder = $scope.mergedParams[$scope.component.id+".colOrder"] || $scope.component.colOrder;

			if(colOrder){
				colOrder.split(",").map(a=>{
					var k = a.split(':');
					var toPosition = parseInt(k[1]);
					$scope.colOrder[k[0]] = toPosition;
					var fromPosition = colIndexByIds[k[0]];
					reorderColumns(fromPosition,toPosition);
				});
			}

			enableDisableRowSelection(); // add header column for the row selection.
		}

		var getTableData = function(isAutoRefresh){
			if ($scope.dataSet.endpoint === 'DATACUBE' && !$scope.useCREApiForSolr) {
				var def = $q.defer();
				if ($scope.component.type === "PIVOT_TABLE") {
					var dimensionDataField = [], measureDataField = [];
					var pRow = $scope.component.pivotRow.column;
					var pCol = $scope.component.pivotColumn.column;
					dimensionDataField.push({
						column : pRow
					});
					dimensionDataField.push({
						column : pCol
					});
					measureDataField.push({
						column : $scope.component.pivotCell.column,
						aggrType : $scope.component.pivotCell.aggrType,
						sortOrder : "desc"
					});

					$dataSource
					.getDataSource($scope.dataSet.endpoint)
					.getChartData({
						dataSet : $scope.dataSet,
						componentType : $scope.component.type,
						measureDataField : measureDataField,
						dimensionDataField : dimensionDataField,
						sortOptions : $scope.component.sorting ? $scope.component.sorting[0]
								: undefined,
						filters : $scope.component.filters &&
								$scope.component.filters['builder'] ? $scope.component.filters['builder'][$scope.dataSet.dataSet.dataSetName]
								: {},
						inputParams : customReportSvc
							.applyInputsToDataSet($scope.dataSet,
									$scope.page.inputs)
					},
							function(response) {
								var records = response.data.records;
								var columns = [];
								records.map(function(record,index) {
									columns = _.union(columns,Object.keys(record));
								});
								var dataRecords = [];
								records.map(function(record,index) {
									var dataRecord = {};
									columns.map(function(column,index){
										if(record[column]){
											dataRecord[column] = record[column];
										}else{
											dataRecord[column] = "";
										}
										dataRecords.push(dataRecord);
									});
								});
								columns = columns.map(function(column,index){
									var col = {dataField : column,name : column,id : column, type : index === 0 ? 'String' : 'Integer'};
									return col;
								});
								var resp = {
									data : {
										//currently no pagination support for now
										recordsCount : dataRecords.length,
										totalRecordCount : records.length,
										records : dataRecords,
										columns : columns
									}
								};
								def.resolve(resp);
//								//TODO:check for the alternative component for pivot table; ngTable is not fit for it
//								if (!$.isEmptyObject(response.data.moreInfo) &&
//										response.data.moreInfo.hasOwnProperty(pCol)) {
//									$.each(response.data.moreInfo[pCol].keyMap,
//											function(k, v) {
//												resp.data.columns.push({
//													dataField : k,
//													name : k,
//													id : v,
//													type : "" //not sure what should be the type
//												});
//											});
//								}
								//successCallback(resp, $defer, params);
							});

				}else{
					var urlOptions = customReportSvc.getUrlOptions($scope.component.id,$scope.requestParms);
					var tableParams = {
						columns : $scope.component.allColumns && ($scope.allColumnsDropped || $scope.component.columns.length === 0) ? $scope.dataSet.fields
								: customReportSvc.getSelectedColumnsDefn($scope.dataSet.fields, $scope.component.columns),

						offset : $scope.offset,
						limit : $scope.component.pageSize,
						sort : $.extend(true, $scope.component.sorting, urlOptions.sorting),
						customFilterQuery: $scope.component.filters ? $scope.component.filters.customFilterQuery: undefined,
						excludeTableRowFilters : $scope.component.filterReportForRowSelection && $scope.component.filterColumn !== undefined
					};
					$dataSource.getDataSource($scope.dataSet.endpoint).getTableData({
						dataSet : $scope.dataSet,
						componentType : $scope.component.type,
						tableParams : tableParams,
						filters : $scope.component.filters &&
								$scope.component.filters['builder'] ? $scope.component.filters['builder'][$scope.dataSet.dataSet.dataSetName]
								: {},
						inputParams : customReportSvc
									.applyInputsToDataSet($scope.dataSet,
											$scope.page.inputs)
					}, function(resp, reqObj) {
						//console.log(reqObj.params);
						$scope.tempComponent.latestSearchParams = [reqObj.params];
						def.resolve({
							data : resp
						});
					});
				}
				return def.promise;

			}else{
				return $scope.getData(undefined, false, isAutoRefresh);
			}
		}

		// will open the alarm dialog by passing in the current columns.
		var openAlarmsDialog = function() {
			$uibModal.open({
				templateUrl : customReports.contextPath + "/reportsplus/alarms/alarmsModal.jsp",
				controller : 'alarmsCtrl',
				windowClass : 'reportsPlusAlarm',
				scope:$scope,
				backdrop: 'static',
				resolve : {
					columns : function() {
						return $scope.component.columns;
					}
				}
			});
		};

		var initAlarmDialog = function (){
			if($scope.alarmDetails && !$scope.alarmDetails.error && $scope.alarmDetails.componentName == $scope.component.id){
        		openAlarmsDialog();
			}
    	}

		var hanldeEditAlarmsDialogue = function(){
			if(!$scope.requestParms){
            	$scope.requestParms = customReportSvc.getUrlParams();
            }
			 if($scope.requestParms.alarmId && $scope.requestParms.alarmId > 0){
	            	var param = {};
	            	param.alarmId = $scope.requestParms.alarmId;
	            	var alarmDetails ;
	            	if(!$scope.alarmDetails){
	            		reportService.getAlarmDetails(param).then(function (data) {
	            			data = data.data;
		        			if (data && data.length) {
		            			alarmDetails = data[0];
		        				if(alarmDetails.error){
		        					var errorMessage = "Unable to find alert details for alarmId ["+alarmDetails.alarmId+"], Error Message :" + alarmDetails.error;
		                			console.error(errorMessage);
		                     		$scope.alarmDetails = {};
		                    		$scope.alarmDetails.error = errorMessage;
		                			customReportSvc.errorToast(alarmDetails.error);
		        				}else{
		                			var alarmURL = decodeURIComponent(alarmDetails.alarmURL);
		                			var alarmDataSetName = customReportSvc.getParameter("alarmDataSetName", alarmURL);
		                			var componentName = customReportSvc.getParameter("componentName", alarmURL);
		                			alarmDataSetName = parseInt(alarmDataSetName,0);
		        					alarmDetails.alarmDataSetName = alarmDataSetName;
		        					alarmDetails.componentName = componentName;
		        					alarmDetails.editCriteriaSet = true;
		        					$scope.alarmDetails = alarmDetails;
		        					initAlarmDialog();
		        				}

		        			}

		        		},function(e){
		        				e=e.data;
		        				var errorMessage = "Unable to find alert details for alarmId ["+param.alarmId+"], Error Message :" + e;
		                		console.error(errorMessage);
		                		$scope.alarmDetails = {};
	                    		$scope.alarmDetails.error = errorMessage;
		                		customReportSvc.errorToast(alarmDetails.error);
		        		});
	            	}else if(!$scope.alarmDetails.error){
	            		initAlarmDialog();
	            	}
			 }
		}

		var getDefaultSort = function(){
			var sort = $scope.requestParms[$scope.component.id + ".sort"];
			if(sort){
				var id = sort.indexOf("-") == 0 ? sort.substring(1, sort.length) : sort;
				var direction = sort.indexOf("-") == 0 ? "desc" : "asc";
				return {field:id,dir:direction};
			}
		}

		var kendoDataSource = new kendo.data.DataSource({
			pageSize : $scope.component.pageSize,
			serverPaging : true,
			serverFiltering : true,
			serverSorting : true,
			serverGrouping : true,
			sort: getDefaultSort(),
			transport : {
				read : function(params) {
					if(typeof $scope.kendoGrid !== "undefined" && params.data.isAutoRefresh)
						$scope.kendoGrid.element.find("div.k-loading-mask").remove();
					$scope.component.pageSize = params.data.pageSize;
					$scope.offset = params.data.skip;
					if (!$scope.component.group || ($scope.component.group && $scope.component.group.length === 0)) {
						getTableData(params.data.isAutoRefresh).then(function(data) {
								var columns = data.data.columns;
								if (!$scope.gridInitialized) {
									// prepare column information
									// during the first initialization of the grid we may need to process the columns
									initializeColumns(columns);
									if(resetColumns){
										if ($scope.reportMode == "viewer" && $scope.component.allColumns && $scope.dataSet && $scope.dataSet.queryPlan && $scope.dataSet.queryPlan.offline && !$scope.isPreviewEnabled) {
											addOfflineBehavior(data.data.records[0]);
										}

										if(typeof $scope.kendoGrid !== "undefined"){

											// Kendo grid throws exception when the url has a filter and resetting the columns on reload of the component. This is a work around fix for it.
											if(typeof $scope.kendoGrid.dataSource._group === 'undefined'){
												$scope.kendoGrid.dataSource._group = [];
											}
											$scope.kendoGrid.setOptions({columns: kendoColumns});
										}
										resetColumns = false;
									}

									hanldeEditAlarmsDialogue();
								}

								var colDefToLookFor = $scope.component.allColumns ? columnsByDataField : columnsById; // TODO : Make this data field always when receiving the data from the back end and use the id's only in the front end. Need to evaluate the regression here for exports before making this change.
								data.data.records = data.data.records.map(function(record,index) {
									var updateRecord = {};
									if ($scope.dataSet.endpoint !== 'DATACUBE' || $scope.useCREApiForSolr) {
										data.data.columns.map(function(col, i) {
											var colDef = $scope.component.allColumns ? col.name.toLowerCase() : col.name;
											if(colDefToLookFor[colDef]){
												updateRecord[colDefToLookFor[colDef].id] =  record[i];
											}
										});
									}else{
										const cols = Object.keys(record);
										cols.forEach(col => {
											const recordVal = record[col];
											updateRecord[col] =  typeof recordVal === "string" ? $sanitize(recordVal) : recordVal;
										});
									}
									applyCellExpr(updateRecord,updateRecord,index);
									// on pagination selected rows if any on this page will have to be initialized
									if($scope.component.selectedValues && $scope.component.selectedValues.length > 0 && $scope.component.selectedValues.indexOf(updateRecord[$scope.SYS_ROWID]) !== -1){
										//add to selected Rows to initialize the row selection.
										if ($scope.component.enableMultiRowSelection) {
											$scope.selectedRows[updateRecord[$scope.SYS_ROWID]] = updateRecord;
											$scope.checkboxes[updateRecord[$scope.SYS_ROWID]] = true;
										}else{
											$scope.selectedRows[0] = updateRecord;
											$scope.singleSelectValue = updateRecord[$scope.SYS_ROWID];
										}
										$scope.showSelectedRowsLabel = true;
									}
									return updateRecord;
								});

								//we are already getting the records as key value pairs(array of objects), so need of conversion
								if (!$scope.avoidClientScripts && ($scope.dataSet.endpoint === 'DATACUBE' && !$scope.useCREApiForSolr)) {
									angular.forEach($scope.component.columns, function(col, index) {
											var cellExpression = col.cellExpression || $scope.component.allCellExpression;
											if(cellExpression && cellExpression.type === "date" && $scope.tempComponent && $scope.tempComponent.latestSearchParams) {
												var searchParams = JSON.parse($scope.tempComponent.latestSearchParams).searchParams;
												const date = $dataSource.getDataSource($scope.dataSet.endpoint).getDateFormatAndTimeZone(cellExpression);			
												searchParams.push(date.format);
												searchParams.push(date.timeZone);
												var tempObj = {};
												tempObj["searchParams"] = searchParams;
												$scope.tempComponent.latestSearchParams = JSON.stringify(tempObj);
												return;
											}
									});

									angular.forEach(data.data.records, function(obj, index) {
										if(obj.hasOwnProperty("contentid"))
											obj.sys_rowid = obj.contentid;
										applyCellExpr(obj, obj, index);
									});
								}

								var newData = {
									records : data.data.records,
									columns : kendoColumns,
									recordsCount : data.data.recordsCount,
									totalRecordCount : data.data.totalRecordCount
								};
								$scope.totalServerItems = data.data.totalRecordCount;
								params.success(newData);

								$timeout(function() {
									$scope.componentLoaded = true;
									$scope.component.isComponentLoading = false;
									if(!$scope.gridInitialized){
										if($scope.component.showFilterByDefault){
											// show/hide the filter
											$scope.toggleFilterVisibility()
										}
									}

									$scope.gridInitialized = true;
									$scope.resizeGridComponent();

									if( $scope.isExportTwoStep() )
									{
										if(angular.isUndefined(window.reportMetaData))
											window.reportMetaData={
												"tableMetaData" :{}
										};

										// For exports, displayName should be set to column ID
										// as the data-colId is used as key in the nashorn engine.
										var cols = $scope.component.columns.map(function(c) {
											var newCol = _.cloneDeep(c);
											newCol.displayName = newCol.id;
											return newCol;
										});

										//Setting values for final Export Size
										var loadLimit=10000;
										$scope.dataSetParams.limit=loadLimit;
										var tempComponent=$scope.component;
										tempComponent.pageSize=loadLimit;

										window.reportMetaData.tableMetaData[$scope.component.id]={
										"allCellExpression": $scope.component.allCellExpression,
										//"requestParams": resultData.config.data,
										"dataURL": dataSetUtility.getUrlForDataComponent(tempComponent,$scope.dataSet, $scope.page, $scope.dataSetParams,$scope.mergedParams),
										"customJsCode" :$scope.page.body.customJsCode,
										"tableWrapperDivID": "table_"+$scope.component.id,
										"rowSelector" : "tbody tr.kendo-row",
										"jsFilesList"  : exportConstants.customReportJSFileList,
										"rowStyleExpression": $scope.component.rowStyleExpression,
										"class" :{
												"odd" : "odd",
											    "even": "even",
											    "generic": "" },
										"columns": cols,
										"currentURL" : window.location.href,
										"customReports" : customReports,
										"timeZoneHeader" : moment().format("Z")
										};
										$scope.dataSetParams.limit=$scope.component.pageSize;
									}

									$scope.handleErrorsOrWarnings(data.data.failures, false);

									if ($scope.reportMode === 'preview') {
										$scope.handleErrorsOrWarnings(data.data.warnings, true);
										if ($scope.component.id === 'PreviewTable') {

	                                        if (typeof data.data.rawData === "object") {
	                                            $scope.processRawData(data.data.rawData);
	                                        }
	                                    }
									}

									if ($scope.exportType){
										window.pendingRequests -= 1;
										$scope.setAllComponentsIntialized($scope.component);
									}

								});
						},function(error){
							$scope.kendoGrid.element.find("div.k-loading-mask").remove();
						});

					}else{
						var colId = $scope.component.group[0].field;
						// adding to params just to matching the structure for the select filtering data load.
						params.pageSize = params.data.pageSize;
						params.offset = params.data.skip;
						$scope.loadDistinctdataForColumn(colId,params,"Count",false,true).then(function(data){
							params.success(data.data);
                            $scope.resizeGridComponent();
						});
					}



				}
			},
			schema : {
				model:{
					fields:kendoFieldModel
				},
				data : function(data) {
					return data.records;
				},
				total : function(response) {
					var totalRecordCount = 0;
					if (response.hasOwnProperty("totalRecordCount")) {
						return response.totalRecordCount;
					}
				}
			},
		});

		$scope.getColumnById = function(columnId){
			return columnsById[columnId];
		}

		$scope.toggleColVisibility = function(column) {
			var visibleColumns = $scope.component.columns.filter(x => (x.visible && !x.hidden));
			if(visibleColumns.length === 1 && visibleColumns[0].id === column.id){
				return;
			}
			toggleColumnVisibility(column.id,true);
		};

		$scope.toggleFilterVisibility = function() {
			if ($scope.component.showFilterByDefault) {
				 $('#'+ $scope.component.id +' table .k-filter-row').show();
            } else {
            	$('#'+ $scope.component.id +' table .k-filter-row').hide();
            }
			$scope.resizeGridComponent();
		};



		var updateColGroup = function(){
			var headerTable = $('#'+ $scope.component.id +' table');
			var colGroup = headerTable.find('colgroup');
			colGroup.empty();
			if ($scope.component.enableRowSelection) {
				var col = $("<col>");
				col.css({"width":"45px"});
				colGroup.append(col);
			}

			$scope.component.columns.map(function(column, i) {
				if(!column.hidden && column.visible){
					var col = $("<col>");
					if(column.width){
						col.css({"width":column.width+"px"});
					}
					colGroup.append(col);
				}
			});
		}

		var toggleColumnVisibility = function(columnId, colSelection) {
			var index = colIndexByIds[columnId];
			var column = $scope.component.columns[index];
			var field = isValidVarName(columnId) ?  columnId : "pvc" + columnId;
			column.visible = !column.visible;
			if(colSelection){
				if (column.visible) {
					var hidIndex = $scope.hiddenColumns.indexOf(columnId);
					if (hidIndex !== -1)
						$scope.hiddenColumns.splice(hidIndex, 1);
					$scope.visibleColumns.push(column.id);
				} else {
					var showIndex = $scope.visibleColumns.indexOf(columnId);
					if (showIndex !== -1)
						$scope.visibleColumns.splice(showIndex, 1);

					$scope.hiddenColumns.push(column.id);
				}
				var hiddenColumnString = $scope.hiddenColumns.join(",");
				var visibleColumnString = $scope.visibleColumns.join(",");
				$scope.addParameter($scope.component.id + ".hide", hiddenColumnString);
				$scope.addParameter($scope.component.id + ".show", visibleColumnString);
			}
			var th = $('#'+ $scope.component.id +' table th[data-field="'+field+'"]');

			if ($scope.component.columns[index].visible) {
				th.show();
			} else {
				th.hide();
			}

			// Since the table is fixed mode , update the colgroup to set the  widths properly.
			$timeout(function() {
				updateColGroup();
				var kendoGridData = $('#'+ $scope.component.id + ' [kendo-grid="kendoGrid"]')
				if( kendoGridData.length > 0 && kendoGridData.data("kendoGrid") ){
					kendoGridData.data("kendoGrid").refresh();
				}
			},10);
		}

		// will set the column menu icon in active state.
		var toggleColumnMenuVisibility = function (column,active) {
			column = isValidVarName(column) ? column : "pvc"+column; // for number column
            var elem = $scope.kendoGrid.element.find('th[data-field=' + column + '] a.k-header-column-menu');
            if ($scope.grouped || active) {
                elem.addClass('grouped');
                if(active){
                	elem.addClass('filtered');
                }
            } else {
                elem.removeClass('grouped');
                elem.removeClass('filtered');
            }
        }

		var reorderColumns = function(fromPostion,toPosition){
			var column = $scope.component.columns[fromPostion]; //reference to element
			$scope.component.columns.splice(fromPostion, 1);
			$scope.component.columns.splice(toPosition, 0, column);
			var fromKendoColumn = kendoColumns[fromPostion];
			kendoColumns.splice(fromPostion, 1);
			kendoColumns.splice(toPosition, 0, fromKendoColumn);
			colIndexByIds = {};
			$scope.component.columns.map(function(column, i) {
				colIndexByIds[column.id] = i;
			});
		}

		//will toggle the group by menu item text on the column Menu
		var customizeMenu = function(field,menu){
			menu.remove('.ungroup-by-column');
			menu.remove('.group-by-column');
			var colItem = menu.element.children('.k-columns-item');
			if ($scope.grouped && $scope.component.group[0].field === field) {
				if(colItem.length === 1){
					menu.insertBefore({attr:{'dataId':'ungroup-by'},text: 'Ungroup', spriteCssClass: 'k-i-filter-add-group', cssClass: 'ungroup-by-column '+field},colItem);
				}else{
					menu.append({attr:{'dataId':'ungroup-by'},text: 'Ungroup', spriteCssClass: 'k-i-filter-add-group', cssClass: 'ungroup-by-column '+field});
				}

			}else{
				if(colItem.length === 1){
					menu.insertBefore({attr:{'dataId':'group-by'},text: 'Group By',spriteCssClass: 'k-i-filter-add-group',cssClass: 'group-by-column '+field},colItem);
				}else{
					menu.append({attr:{'dataId':'group-by'},text: 'Group By',spriteCssClass: 'k-i-filter-add-group',cssClass: 'group-by-column '+field});
				}

			}
		}

		// will add the groupby definition to option to component and set the row templates accordingly
		var groupByColumn = function(field,menu) {
			if ($scope.grouped && $scope.component.group[0].field !== field) {
				$scope.toast('Only one level of grouping allowed.');
				return;
			}
			if (!defaultRowTemplate) {
				defaultRowTemplate = $scope.kendoGrid.rowTemplate;
				defaultAltRowTemplate = $scope.kendoGrid.altRowTemplate;
			}

			if ($scope.grouped) {
				$scope.component.group = [];
				$scope.grouped = false;
				$scope.kendoGrid.rowTemplate = defaultRowTemplate;
				$scope.kendoGrid.altRowTemplate = defaultAltRowTemplate;

			} else {
				if (field === undefined) {
					return;
				}
				$scope.component.group = [ {
					field : field
				}];
				var colSpan = $scope.component.columns.length;
				$scope.kendoGrid.rowTemplate = kendo
						.template('<tr class="k-master-row">' +
								'<td class="k-hierarchy-cell"><a class="k-icon k-i-expand" href="\\#" aria-label="Expand" tabindex="-1"></a></td>' +
								'<td class="master-data-cell" colspan="' + colSpan + '">#= data.label' +
								'# (#: data.' + field + '_count #)</td>' + '</tr>',
								{
									useWithBlock : false
								});
				$scope.kendoGrid.altRowTemplate = kendo
						.template('<tr class="k-master-row k-alt">' +
								'<td class="k-hierarchy-cell"><a class="k-icon k-i-expand" href="\\#" aria-label="Expand" tabindex="-1"></a></td>' +
								'<td class="master-data-cell" colspan="' + colSpan + '">#= data.label'+
								'# (#: data.' + field + '_count #)</td>' + '</tr>',
								{
									useWithBlock : false
								});
				$scope.grouped = true;

			}
			if(menu){
				customizeMenu(field,menu);
			}
			toggleColumnMenuVisibility(field);
			kendoDataSource.read();
		}

		var getColumnIdFromField = function(field){
			return field.startsWith("pvc") ? field.substring(3) : field;
		}

		// customize the column menu items
		function grid_columnMenuInit(e) {
			var field = getColumnIdFromField(e.field);
			var column = columnsById[field];
				e.container.addClass('reports-column-menu '+$scope.component.id);
				var menu = e.container.find(".k-menu").data("kendoMenu");
				var colMenu = e.container.find(".k-column-menu");

				e.container.find(".k-menu").addClass('reports-col-filter');
				colMenu.prevObject.addClass('select-filter-'+field);
				var popup = e.container.data('kendoPopup');
				var clearButton = e.container.find(".k-filter-menu").find("button[type='reset']");
				e.container.find(".k-menu").children('.k-columns-item').children('.k-menu-group').empty();

				var template = '<column-list data-columns="component.columns" data-callbackfn="toggleColVisibility"></column-list>';
				template = angular.element(template);
				$compile(template)($scope);
				e.container.find(".k-menu").children('.k-columns-item').children('.k-menu-group').html(template);
				var colMenuItem = e.container.find(".k-menu").children('.k-columns-item');
				colMenuItem.remove();
				menu.append({
					attr:{'dataId':'quick-analysis'},
					text : 'Chart',
					spriteCssClass : "chart-svg-icon",
					cssClass : "quick-analysis"
				});
				if($scope.component.type !== "PIVOT_TABLE" && cvKendoTypeMap[column.type] !== "date"){
					customizeMenu(field,menu); // add group by option only for date columns.
				}

				// need to reinitialize filters when an input or global filter changes.
				if(cvKendoTypeMap[column.type] === "string"){
					popup.bind("open", function (e) {
						customReportSvc.triggerCallback("reinitalizeStringFilter",field); // there is no smart way to figure out what changed out of the components and when.for now we are re-initializing the filter, every time the popup opens up.
					});
				}
				e.container.find(".k-menu").append(colMenuItem);
				menu.bind("select", function (e) {
					var menuText = $(e.item).text();
					var itemAction = $(e.item).attr('dataid');
					if(itemAction === "reset-filter"){
						customReportSvc.triggerCallback("clearColumnFilter",field);
						isAdvancedfilter = true;
						var selectFilter = {field: field,value: "",type:"select"};
						$scope.applyFilter(selectFilter);
						toggleColumnMenuVisibility(field,false); // remove the column menu icon once the filter is cleared.
						e.item.remove();
					}else if(itemAction === "hide-column"){
						toggleColumnVisibility(field);
					}else if(itemAction === "group-by"){
						$scope.addParameter($scope.component.id + ".grouped", field);
						groupByColumn(field,menu);
					}else if(itemAction === "ungroup-by"){
						$scope.addParameter($scope.component.id + ".grouped", undefined);
						groupByColumn(field,menu);
					}else if(itemAction === "quick-analysis"){
						var data = {
								id:$scope.component.id+"quickChart",
								field:field
						}
						$scope.showQuickAnalysis(null,data);
	//					 customReportSvc.triggerCallback("updateChartFields",data);
	//					 $scope.quickAnalysisMode = true;
					}
					if(itemAction){
						popup.close();
					}
				});

				$(clearButton).click(function(e){
					toggleColumnMenuVisibility(field,false); // remove the column menu icon once the filter is cleared.
					$('.reset-filter.'+field).remove(); // remove the reset filter option.
				})

				var urlFilter =  $scope.requestParms[$scope.component.id+".select."+field];
				if(!urlFilter && !$.isEmptyObject($scope.dataSet) && $scope.dataSet.endpoint === 'DATACUBE' && !$.isEmptyObject($scope.pageFilters) &&
					!$.isEmptyObject($scope.pageFilters["viewer"])) {
						let dataSetName = $scope.dataSet.dataSet.dataSetName,
						filters = $scope.pageFilters["viewer"];
						if(!$.isEmptyObject(filters[dataSetName]) && !$.isEmptyObject(filters[dataSetName][field])
						&& !$.isEmptyObject(filters[dataSetName][field]["tableFilters"]) &&
						(!$.isEmptyObject(filters[dataSetName][field]["tableFilters"]["include"]) ||
						!$.isEmptyObject(filters[dataSetName][field]["tableFilters"]["daterange"]))) {
							urlFilter = filters[dataSetName][field];
						}

				}

				if(urlFilter){
					addResetFilterMenuOption(field,menu);
				}
		};

		var createKendoGrid = function(){
			$scope.kendoGridOptions = {
					dataSource : kendoDataSource,
					resizable : true,
					columnResize: function(e) {
						updateColumnWidth(e.column.field,e.newWidth,true);
					},
					reorderable : true,
					scrollable : false,
					columnMenu : {
						filterable : true,
						columns : true,
						sortable : false,
					},
					columnMenuInit : grid_columnMenuInit,
					dataBound: function (e) {
						if(!initialDataBound){
						  this.pager.element.addClass('cv-outer-pager');  // adding cv-outer-pager class to the pager to handle the page size change event on the outer grid.
						  if($scope.exportType || isReadMe){
							  this.pager.element.children(':not(.k-pager-info)').addClass("hideOnExportFriendly");
							  this.pager.element.addClass('cv-outer-pager-export');
						  }

						  // hide pager elements when there are less than 5 elements
						  if(this.dataSource._total <= 1 || $scope.component.hideFooter){
							  this.pager.element.children().hide();
							  isFooterHidden = true;
						  }else if(this.dataSource._total <= 5){
							  this.pager.element.children(':not(.k-pager-info)').addClass("hide-page-elements");

						  }

						  initialDataBound = true;
						  var groupField = customReportSvc.getParameterByName($scope.component.id+".grouped");
						  if(!groupField && $scope.component.group && $scope.component.group.length > 0){
							  groupField = $scope.component.group[0].field;
						  }
						  if(!$scope.isExportTwoStep() && groupField){
							  groupByColumn(groupField);	// apply group by on a column if it is part of url
						  }

						  // wait for the data bound to hide unused columns.
						  if(offlineBehaviorAdded){
							  toggleColumnVisibility("Lastcollectiontime");
							  //toggleColumnVisibility("CommCellID");
						  }

						  if($scope.isExportTwoStep()){
							  this.pager.options.messages.display = " {0} - {2} of {2} items";
						  }


						}

						// on page load highlight the column menu icon in case the url has filter value.
						Object.keys($scope.requestParms).map(function(key){
						  let column  = key.substring(key.indexOf('.select.')+8 , key.length);
						  if(key.indexOf($scope.component.id) === 0 && key.indexOf('.select.') !== -1 && column !== "*"){
							  toggleColumnMenuVisibility(column ,true);
						  }
						});


						// add click handler to highlight the column properties in builder instead of sorting.
						if ($scope.reportMode === 'builder') {
							$("#table_" + $scope.component.id +" th[role='columnheader']").on('click', function(event){
	                        	var colName = event.currentTarget.dataset.field;
	                        	var column = columnsById[colName];
	                            if (!column) {
	                                return;
	                            }
	                            column.componentId = $scope.component.id;
	                            $scope.setActiveComponent(column);
	                            angular.element("table td").removeClass('selectedCol'); //remove the selectedCol class for the current selection of the column.
	                            $("#"+ $scope.component.id +" table td[data-colId='"+colName+"']").addClass('selectedCol')
	                            event.preventDefault();
	                            event.stopPropagation();
							});
	                  }

					 // resizing of the columns is not working when the below elements exist in the DOM. The elements are needed for row grouping so removing when there is no grouping and adding them back when grouping is enabled.
					  if($scope.grouped){
						  if( $('#Kendo_' + $scope.component.id + ' colgroup .k-hierarchy-col').length === 0){
							  $('#Kendo_' + $scope.component.id + ' colgroup').prepend($('<col class="k-hierarchy-col">'));
							  $('#Kendo_' + $scope.component.id + ' .k-grid-header tr[role="row"]').prepend($('<th class="k-hierarchy-cell k-header ng-scope" scope="col"></th>'));
							  $('#Kendo_' + $scope.component.id + ' .k-grid-header tr.k-filter-row').prepend($('<th class="k-hierarchy-cell ng-scope" scope="col">&nbsp;</th>'));
						  }
					  }else {
						  $('#Kendo_' + $scope.component.id + ' colgroup .k-hierarchy-col').remove();
						  $('#Kendo_' + $scope.component.id + ' .k-grid-header tr[role="row"] .k-hierarchy-cell').remove();
						  $('#Kendo_' + $scope.component.id + ' .k-grid-header tr.k-filter-row .k-hierarchy-cell').remove();
					  }


					  $scope.resizeGridComponent();
		            },
					filterable : {
						mode : 'menu,row'
					},
					sort : function(param) {
						var sort = param.sort;
						var value = "";
						if (sort && sort.dir) {
							value = sort.dir == "desc" ? "-" : "";
							value = value + getColumnIdFromField(sort.field);
						}
						$scope.addParameter($scope.component.id + ".sort", value);
					},
					filter : function(e) {
						var field = e.field;
						var value = e.filter && e.filter.filters.length > 0 ? JSON.stringify(_.map(e.filter.filters, 'value')) : "";
						var selectFilter = {
								field : field,
								type : "select",
								value : value
							}
						$scope.applyFilter(selectFilter);
					},
					sortable : $scope.reportMode === 'viewer' ? {
						mode : "single",
						allowUnsort : true
					} : false,
					pageable : {
						alwaysVisible : true,
						refresh : true,
						pageSizes : isReadMe ? [ 5 ] : [ 5, 10, 20, 50, 100, 200, 500 ],
						buttonCount : 5
					},
					columns : kendoColumns,
					noRecords: {
					   template: $scope.component.emptyGridMessage ? $scope.component.emptyGridMessage : localMsg["No_Data_Available"]
					},
		            detailExpand: function (e) {
		            	$scope.resizeGridComponent();
		            	$(e.detailRow).attr('style', 'display: table-row !important;');
		            },
		            detailCollapse: function (e) {
		                $scope.resizeGridComponent();
		            },
		            columnReorder: function (e) {
		                var column = columnsById[e.column.field]
		                var toPosition = e.newIndex;
		                var fromPosition = colIndexByIds[e.column.field];
		                reorderColumns(fromPosition,toPosition);
		                $scope.colOrder[e.column.field] = toPosition;
		    			var colOrderString = "";
		    			for(var i in $scope.colOrder){
		    				colOrderString = colOrderString + i + ":" + $scope.colOrder[i]+","
		    			}
		    			colOrderString=colOrderString.substring(0,colOrderString.length-1);
		    			$scope.addParameter($scope.component.id + ".colOrder", colOrderString);

		    			if($scope.reportMode == 'builder' && $scope.component.allColumns){
		    				$scope.component.colOrder = colOrderString; // preserve only the columns that are changes when all columns is enabled. When it is not all columns the column definition is updated and this is not needed.
		    			}
		    			kendoDataSource.read();
		            }
				};

			if ($scope.exportType){
				// for some reason $scope.kendoGrid is undefined and datasource.read is not called in export mode. Need to figure this out.
				kendoDataSource.read();
			}
		}

		$scope.showNoResultMsg = function() {
			return angular.element("li[comp=" + $scope.component.id + "] .colList").children().not( ".noResultInfo" ).length === 0;
    	}


		$scope.openColumnSettingModal = function() {
    		 var modalInstance = $uibModal.open({
               templateUrl:  customReportSvc.getContextPath() +"/reportsplus/modal/views/columnSettingModal.jsp",
               controller: "columnSettingCtrl",
               windowClass: 'colSettingModalWindow reportModal',
               resolve: {
               		columns : function() {
               			var fields = $scope.dataSet.fields,columns=[];
               			angular.forEach($scope.component.columns,function(column) {
               				columns.push({
               							 	dataField : column.dataField,
               							  	displayName : column.displayName,
               							  	visible : column.visible,
               							  	hidden : column.hidden
               							});

               			});
               			return columns;
               		},
               		dataSet : function() {
               			return $scope.dataSet;
               		},
               		Title : function() {
               			return localMsg["ColumnSettings"];
               		}
               }
            });

    		modalInstance.result.then(function (selectedCols) {
    				angular.forEach($scope.component.columns,function(column,index) {
			      		var isColPresent = selectedCols.filter(function(col) {
							return col.dataField === column.dataField;
						}).length > 0;
						if(!isColPresent) {
							column.visible =  false;
							//column.hidden = true;
						} else {
							column.visible =  true;
							//column.hidden = false;
						}
			      	});
					var colsToBeAdded = selectedCols.filter(function(col) {
						return $scope.component.columns.filter(function(column) {
							return col.dataField === column.dataField
						}).length === 0;
					});
					if(colsToBeAdded.length > 0) {
						angular.forEach(colsToBeAdded,function(col) {
    						col = addColumn(col);
    						colsCopy.push(col);
    					});
					}
					$scope.reloadComponent();

			   });

    	}
		$scope.showColMenu = function($event, id) {
			$('#col_menu_' + id + '.fadeOutSection').toggle();
			$scope.colMenuVisible = !$scope.colMenuVisible;
			$event.stopPropagation();
		};


		// A generic function that will handle the column component actions.
		var triggerButtonComponent = function (target) {
            var expression = $(target).data('action');
            var data = angular.element(target).scope().dataItem;
            var rowIndexVal = $(target).data('rowindex');
            var colIndexVal = $(target).data('colindex');
            var params = {row: data, cellData: $(target).data('celldata'), rowIndex: rowIndexVal, colIndex: colIndexVal}
            if (expression && typeof expression === "string" &&
                expression.substring(0, 1) !== "=" && expression.substring(0, 2) !== ":=") {
                expression = "=" + expression;
            }
            rpt.evalExpression($.extend({}, {expression: expression}, params));
        }

		//turn off the events in case previously added . Need this to be executed in SPA environments like adminconsole.

		var selector = '#table_'+$scope.component.id;
		$('body').off('click', selector+' .column-action-component');
		//event handler to handle the column level action components.
		$('body').on('click', selector + ' .column-action-component', function (event) {
            triggerButtonComponent(event.target);
            event.stopPropagation();
			event.preventDefault();
        });

		$('body').off('click', selector+' .customIcon.column-action-component > *');
		$('body').on('click', selector+' .customIcon.column-action-component > *', function (event) {
			handleClickEvent(event.target.parentElement);
			event.stopPropagation();
			event.preventDefault();
		});

		//event handler to handle the column level action component of menu drop down
		$('body').off('click', selector + ' .page-action-button.menu');
		$('body').on('click', selector + ' .page-action-button.menu', function (event) {
			var targetElement = event.target.parentElement;
			var menuSelector = $(targetElement).find('.dropdown-selector-menu');
			if ($(menuSelector).hasClass('show')) {
				$(menuSelector).removeClass('show').addClass('hide');
			} else {
				$(menuSelector).removeClass('hide').addClass('show');

				$(targetElement).find('[data-toggle="dropdown-selector"]').focusout(function() {
					setTimeout(function() {
						$(menuSelector).removeClass('show').addClass('hide');
					}, 500);
				});
			}

			event.stopPropagation();
			event.preventDefault();
		});

//		$('body').off('click',' .select-filter-criterion-link');
//		$('body').on('click',' .select-filter-criterion-link', function (event) {
//			var field = $(event.currentTarget).data('column');
//			var value = $(event.currentTarget).data('item');
//			var selectFilter = {field: field,value:value,type:"select"};
//			$scope.applyFilter(selectFilter);
//			//event.stopPropagation()
//		})

		angular.element("html").on("click", function(e) {
			//acMenuActions.hideMenu();
			if (angular.element(e.target).closest("#col_menu_" + $scope.component.id + ".fadeOutSection").length > 0) {
				return false;
			}
			angular.element("li[comp=" + $scope.component.id + "] .reportColums_container").slideUp();
			$("li[comp=" + $scope.component.id + "]").removeClass("visible-overflow");
		});

		//kendo grid does not have an event for the page size change. Handling the event to push the page size to url for bookmarkability feature.
		$('body').off('change', selector + ' .k-pager-wrap.cv-outer-pager .k-pager-sizes select');
		$('body').on('change', selector + ' .k-pager-wrap.cv-outer-pager .k-pager-sizes select', function (event) {
			$scope.component.pageSize = event.target.value;
			$scope.addParameter($scope.component.id + ".limit", $scope.component.pageSize);
		});

		//kendo grid does not have an event for the reload.
		$('body').off('click', selector + ' .k-pager-wrap .k-pager-refresh');
		$('body').on('click', selector + ' .k-pager-wrap .k-pager-refresh', function (event) {
			$scope.clearAndResetCacheId();
		});

		$scope.detailGridOptions = function(dataItem){
			var groupItem =  dataItem;
			let detailDataSource =  new kendo.data.DataSource({
                pageSize: $scope.component.pageSize,
                serverPaging: true,
                serverFiltering: true,
                serverSorting: true,
                serverGrouping: true,
                serverAggregates: false,
                reorderable: false,
                transport: {
                    read: function (params) {
                   	 var groupFilters = [{columnId: $scope.component.group[0].field, fValue: groupItem[$scope.component.group[0].field]}];
                        var sort = params ? params.data.sort : [];
                        var pageNo = params.data.page - 1; // solr start = 0
                        var pageSize = params.data.pageSize;
                        var skip = params.data.skip; // 0 for pageNo 1
                        var group = params ? params.data.group : null;
                        var filter = params ? params.data.filter : null;

                        var colFiltered = columnsById[groupFilters[0].columnId]
                        var customComponent = $.extend({}, $scope.component);
                        customComponent.pageOffset = skip;
                        customComponent.pageSize = pageSize;
                        customComponent.title.text = '';
                        customComponent.id = customComponent.id + '_group_of_' + groupFilters[0].fValue;
                        customComponent.parentId = $scope.component.id;
                        customComponent.group[0].dataField = colFiltered.dataField;
                        customComponent.group[0].value = groupFilters[0].fValue;
                        customComponent.group[0].type = colFiltered.type;

                        if(sort && sort.length > 0){
                       	 customComponent.sorting = [{columnId: sort[0].field, direction: sort[0].dir}];
                        }

                        if ($scope.dataSet.endpoint !== 'DATACUBE' || $scope.useCREApiForSolr) {
                            $scope.getData(undefined, undefined, !$scope.component.isComponentLoading, customComponent, true).then(function (resp) {
                             var colDefToLookFor = $scope.component.allColumns ? columnsByDataField : columnsById; // TODO : Make this data field always when receiving the data from the back end and use the id's only in the front end. Need to evaluate the regression here for exports before making this change.
                           	 resp.data.records = resp.data.records.map(function(record,index) {
									var updateRecord = {};
									resp.data.columns.map(function(col, i) {
										var colDef = $scope.component.allColumns ? col.name.toLowerCase() : col.name;
										updateRecord[colDefToLookFor[colDef].id] = record[i];
									});
									applyCellExpr(updateRecord,updateRecord,index);
									return updateRecord;
								});
                                var newData = {
                                    records: resp.data.records,
                                    columns: resp.data.columns,
                                    recordsCount: resp.data.recordsCount,
                                    totalRecordCount: resp.data.totalRecordCount
                                }
                                params.success(newData);
                                $timeout(function() {
									$scope.componentLoaded = true;
									$scope.component.isComponentLoading = false;
									$scope.resizeGridComponent();
								});
                            })
                        }else{
                        	if(sort && sort.length > 0){
                              	var sorting = [];
								for (var i = 0; i < sort.length; i++) {
									var sortObj = {};
									sortObj.columnId = sort[i].field;
									sortObj.direction = sort[i].dir;
									sortObj.sortAxis = 'XAxis';
									sorting.push(sortObj);
								}
                             }

                        	var tableFilters = [{columnId:colFiltered.dataField,fValue:groupFilters[0].fValue}]

                        	var options = {};
							options.dataSet = $scope.dataSet;
							options.tableParams = {
								columns : $scope.component.columns,
								offset : skip,
								limit : pageSize,
								sort : sorting,
								filters : tableFilters,
								group : group,
								measures : []
							};
							options.inputParams = customReportSvc.applyInputsToDataSet($scope.dataSet,
									$scope.page.inputs)
								$dataSource.getDataSource($scope.dataSet.endpoint).getTableData(options, function(resp) {
									$scope.rowIndex = 0;
									$scope.prevRowUID = undefined;
									angular.forEach(resp.records, function(obj, index) {
										applyCellExpr(obj, obj, index);
									});
									params.success(resp);
									$timeout(function() {
										$scope.componentLoaded = true;
										$scope.component.isComponentLoading = false;
										$scope.resizeGridComponent();
									});
								});


                        }
                    }
                },
                schema: {
               	 model:{
                   		fields:kendoFieldModel
    				 },
                    data: function (data) {
                        return data.records;
                    },
                    total: 'totalRecordCount',
                    aggregates: function (response) {
                        return response.stats;
                    },
                    selectable: "row"
                },
                aggregate: []
            });
			var detailGrid =  {
                dataSource:detailDataSource,
                reorderable: true,
                resizable: true,
                columnMenu: false,
                scrollable: false,
                sortable: {
                    mode: "single",
                    allowUnsort: true
                },
                pageable: {
                    alwaysVisible: true,
                    refresh: true,
                    pageSizes: [5, 10, 20, 50, 100, 200, 500],
                    buttonCount: 5
                },
                columns: kendoColumns
            }
			$scope.kendoGrid.dataSource.groupDataSources = {};
			if($scope.grouped && $scope.component.group[0].field) {
				$scope.kendoGrid.dataSource.groupDataSources[$scope.component.group[0].field] = detailDataSource;
			}

			return detailGrid;
		}
         // this will add the first column which can be a check box or radio button to select a row.
         var enableDisableRowSelection = function(){
        	 if ($scope.component.enableRowSelection && $scope.component.enableButtonPanel) {
	        	 var headerTemplate;
	             var cellTemplate;
	             if ($scope.component.enableMultiRowSelection) {
	                 headerTemplate = '<input data-ng-model="allRows.selected" id="{{component.id}}_allRows" type="checkbox" data-ng-change="allRowsChanged()"><label for="{{component.id}}_allRows" class="checkbox-label">&nbsp;</label>';
	             } else {
	                 headerTemplate = '';
	             }
	             var selectColumn = {
	                 headerTemplate: headerTemplate,
	                 headerAttributes: {
	                     "class": "column-selector"
	                 },
	                 menu:false,
	                 width:45+"px",
	                 title: 'Selector'
	             };
	             if(rowSelectionEnabled){
	            	 kendoColumns.shift();  // this to remove the already added column definition.
	             }
	             rowSelectionEnabled = true;
	             kendoColumns.unshift(selectColumn);
        	 }else if ((!$scope.component.enableRowSelection || !$scope.component.enableButtonPanel)&& rowSelectionEnabled ) {
        		 rowSelectionEnabled = false;
                 kendoColumns.shift();
        	 }
         }

         $scope.resizeGridComponent = function () {
             $timeout(function () {
                 if ($scope.quickAnalysisMode) {
                	 var tableHeight = $($("li[comp=" + $scope.component.id + "]").find(".component-body")[1]).outerHeight(true) +  $("#"+$scope.component.id+"-component-title").outerHeight(true)+60;
					 if(tableHeight <  400){
                		 tableHeight = 400;
                	 }
                     var tableWidth = $("li[comp=" + $scope.component.id + "]").find(".datagridContainer").width();
                     var gridsterCurColWidth = $("#reportContentWrapper").length > 0 ? $("#reportContentWrapper").width() / 12 : $scope.gridster.curColWidth;
                     $scope.gridsterItem.sizeY = Math.ceil(tableHeight / $scope.gridster.rowHeight);
                 } else {
                	 if($scope.component.autoHeight && $scope.component.autoHeight === "Off") {
                      var panelHeight = $("li[comp=" + $scope.component.id + "]").find(".component-body").outerHeight(true) + 11;//table is taking extra 11 px                        var headerHeight = 30;
                     // var footerHeight =  40;
                      var headerHeight = 30;
                      var tbodyHeight = panelHeight + headerHeight;
                      $("li[comp=" + $scope.component.id + "]").find(".table-scroll tbody").css('min-height', tbodyHeight+'px');
                     }else{
	                     var tableHeight = $("#Kendo_"+$scope.component.id + " table").outerHeight(true) +  $("#"+$scope.component.id+"-component-title").outerHeight(true) + 25;

	                     if($scope.component.enableButtonPanel){
	                    	 tableHeight += 25;// $("li[comp=" + $scope.component.id + "]").find('.buttonPanel').outerHeight(true);
						 }

	                     if ($scope.component.showFilterByDefault) {
							//tableHeight += $("#Kendo_"+$scope.component.id + " table").find(".k-filter-row").outerHeight(true);
	                    	 tableHeight += 10;
						 }

	                     if(isFooterHidden){
	                    	 tableHeight -= 25;
	                     }

	                     if($scope.reportMode == 'builder' && $scope.component.type == "PIVOT_TABLE"){
	                    	 tableHeight += 50;
	                     }

	                     if($scope.totalServerItems === 0){
                    		 tableHeight +=  Math.round($("#Kendo_"+$scope.component.id + " .k-grid-norecords").outerHeight(true));
	                     }

	                     if(customReports.appName === 'adminconsole'){
	                    	 tableHeight += 20;
	                     }
	                      if($scope.component.enableButtonPanel) {
	                     	tableHeight += $("li[comp=" + $scope.component.id + "] .buttonPanel").outerHeight(true);
	                     }
	                     var tableWidth = $("li[comp=" + $scope.component.id + "]").find(".datagridContainer").width();
	                     var gridsterCurColWidth = $("#reportContentWrapper").length > 0 ? $("#reportContentWrapper").width() / 12 : $scope.gridster.curColWidth;
	                     if ($scope.gridsterItem && $scope.gridsterItem.$element && !$scope.component.collapsed &&
	                         tableWidth > 0 && gridsterCurColWidth > 0) {
	                         $scope.gridsterItem.sizeY = Math.ceil(tableHeight / $scope.gridster.rowHeight);
	                     }
                     }
                 }

                 // adjust tab height of the parent .
                 $rootScope.$broadcast('justifyParentTabHeight',true);
             }, 1);
         };

         $scope.$on("ngTableAfterReloadData", function(event, redraw) {
        	 $scope.resizeGridComponent();
         });

         $scope.$on('resize',function(sizes, gridster) {
        	 $scope.resizeGridComponent();
		 });

         $scope.$watch('component.autoHeight', function(newVal,oldVal) {
        	 if(typeof newVal !== "undefined"){
        		 $scope.resizeGridComponent();
        	 }
		 });

         // call backs and event handlers
         $scope.registerLocalCallBack = function (name, callback, sourceId) {
             if ($scope.reportMode !== 'preview') {
                 customReportSvc.registerCallback(name, callback, sourceId);
             }
         };

         var updateColumnWidth = function(columnId,width,updateColDefinition){
        	 var index = colIndexByIds[columnId];
        	 //kendoColumns[index].width = width+"px";
        	 //$scope.kendoGrid.setOptions({columns: kendoColumns});
        	 if(updateColDefinition){
        		 $scope.component.columns[index].width = width;
        	 }
         }

        // this gets triggered when data Set changes.
		// this gets triggered when data Set changes.

		$scope.updateComponentFields = function(dataSet) {
			//if(dataSet.dataSet.originalDataSetName && $scope.component.dataSet.dataSetName && dataSet.dataSet.originalDataSetName === $scope.component.dataSet.dataSetName)
			//check for the name of the dataset. Data Set name might have changed, so check with old dataset name.
			if ($scope.component.dataSet &&
					dataSet.dataSet.originalDataSetName === $scope.component.dataSet.dataSetName) {
				var isRefreshRequired = false;
				// set the new name
				$scope.component.dataSet.dataSetName = dataSet.dataSet.dataSetName;
				$scope.dataSet = dataSet;
				angular.forEach($scope.dataSet.fields, function(field) {
					angular.forEach($scope.component.columns, function(column) {
						if (column.dataField === field.originalName &&
								field.originalName !== field.name) {
							column.dataField = field.name;
							isRefreshRequired = true;
						}
					});
				});
				if (isRefreshRequired)
					$scope.reloadComponent();
			}
		}

         $scope.registerLocalCallBack("resizeComponent", function (componentId) {
             if (componentId === $scope.component.id) {
            	 $scope.resizeGridComponent();
             }
         });

         $scope.registerLocalCallBack("columnPropertyUpdated", function (data) {
             if (data.column.componentId === $scope.component.id) {
            	 var compareField = data.property === 'id' ? data.oldValue : data.column.id;
            	 var fieldId = isValidVarName(compareField) ? compareField : "pvc"+compareField;
            	 var idx = kendoColumns.findIndex(x => x.field == fieldId);
            	 var kendoColumn = getKendoColumn(data.column);
            	 kendoColumns[idx] = kendoColumn;

            	 if( data.property === 'id'){
            		 delete columnsById[data.oldValue];
            		 columnsById[data.column.id] =  data.column;
            		 colsCopy.map( col => {
            			 if(col.id === data.oldValue){
            				 col.id = data.column.id;
            			 }
            		 });
            		 $scope.reloadComponent();
            	 }else{
            		 $scope.kendoGrid.setOptions({columns: kendoColumns});
            	 }

             }
         });

         $scope.registerLocalCallBack("redrawAllComponents", function (componentId, isAutoRefresh) {
             if (!$scope.componentLoaded || $scope.processing) {
                 return;
             }
             $scope.reloadComponent(true, isAutoRefresh); // cache is already reset in this case.
         });

         $scope.reloadComponent = function(doNotRfreshCache, isAutoRefresh){
        	 if(!doNotRfreshCache){
        		 $scope.clearAndResetCacheId();
        	 }
        	 if($scope.component.allColumns){
        		 resetColumns = true;
        	 }
        	 $scope.gridInitialized = false;
        	 kendoDataSource.read({isAutoRefresh});
         }

         $scope.registerLocalCallBack("columnRemoved", function (col) {
             if ($scope.component.id === col.componentId) {
                 col.componentId = undefined;

                 var columnIndex = _.findIndex($scope.component.columns, function(o) { return o.id == col.id; });

                 if ($scope.component.allColumns) {
                	 $scope.component.columns[columnIndex].hidden = true;
                     kendoColumns[columnIndex].hidden = true;
                 } else {
                     $scope.component.columns.splice(columnIndex, 1);
                     kendoColumns.splice(columnIndex, 1);
                 }

                 $scope.kendoGrid.setOptions({columns: kendoColumns});
             }
         });

         $scope.registerLocalCallBack("refreshTableData", function (name) {
             if ($scope.component.id === name) {
            	 $scope.reloadComponent();
             }
         });

         $scope.registerLocalCallBack("refreshComponent", function (componentId) {
             if ($scope.component.id === componentId) {
            	 $scope.reloadComponent();
             }
         },$scope.component.id);

         $scope.resetSelectedRows = function(){
				$scope.selectedRows = {};
				$scope.checkboxes = {};
				$scope.singleSelectValue="";
		 }

         $scope.checkAllSelected = function(value, rowNumber) {
 			if (!value) {
 				$scope.selectedObj.allRowsSelected = false;
                 $scope.child.showSelectedRowsLabel = false;
 			} else if (value && $scope.component.enableMultiRowSelection) {
 				$scope.child.showSelectedRowsLabel = true;
 			} else if (value && !$scope.component.enableMultiRowSelection) {
                 $scope.child.showSelectedRowsLabel = true;
 			}
 		};

         $scope.registerLocalCallBack('enableRowSelection', function (data) {
        	 if ($scope.component.id === data.compId) {
        		 enableDisableRowSelection();
        		 if(data.column){
        			 // add sys_rowid to the kendo columns
        			 columnsById[data.column.id] = data.column;
        		 }
			 }
         });

         $scope.registerLocalCallBack('enableMultiRowSelection', function (value) {
        	 $scope.resetSelectedRows();
        	 enableDisableRowSelection();
         });

         $scope.deleteColumn = function(type) {
				$scope.resetTable = true;
				$scope.component[type] = undefined;
				//$scope.reloadComponent();
				if (!$scope.component['pivotRow'] && !$scope.component['pivotColumn'] &&
						!$scope.component['pivotCell']) {
					$scope.component.dataSet = undefined;
				}
			}

         $scope.dropped = function (dragEl, dropEl) {
             if ($scope.reportMode == "viewer") {
                 return;
             }

             if (!$scope.component.isSelected) {
                 customReportSvc.errorToast('Select the component to add a column.');
                 return;
             }
             var dest = document.getElementById(dropEl);
             var src = document.getElementById(dragEl);

             var drag = angular.element(src);
             var drop = angular.element(dest);

             var columnName = drag.attr("data-name");
             var columnType = drag.attr("data-type");
             var origType = drag.attr("data-origtype");
             var dataField = drag.attr("data-datafield");
             var dataSetEntity = drag.data("datasetentity");
             var dataSetName = dataSetEntity.dataSetName;

             if (!$scope.component.dataSet || !$scope.component.dataSet.dataSetName) {
                 $scope.associateDataSetToComponent(dataSetEntity);
             } else if ($scope.component.dataSet.dataSetName != dataSetName) {
                 alert("Mismatched data Sets");
                 return;
             }
             if ($scope.component.type == 'TABLE') {
	             if (columnName == "allColumns") {
	            	 $scope.component.allColumns = true;
					 $scope.allColumnsDropped = true;
					 // add columns so that metrics formatters are saved.
					 $scope.dataSet.fields.map(field=>{
						 addColumn({
	                         name: field.name,
	                         dataField: field.dataField,
	                         type: field.type,
	                         origType: field.type
	                     });
					});

	             } else {
	                 if (!$scope.component.allColumns) {
	                     addColumn({
	                         name: columnName,
	                         dataField: dataField,
	                         type: columnType,
	                         origType: origType
	                     });
	                 }
	             }

	             if($scope.showDropColumnsMessage){
	            	 $scope.showDropColumnsMessage = false;
	            	 createKendoGrid();
	             }else{
	            	 $scope.kendoGrid.setOptions({columns: kendoColumns});
	             }

	             $scope.$apply();
              }else if ($scope.component.type == 'PIVOT_TABLE') {

					if (drop.data('droptype') == "pivotRow") {
						$scope.component.pivotRow = {
							title : {
								text : columnName
							},
							column : columnName
						};
						$scope.$apply();
					} else if (drop.data('droptype') == "pivotColumn") {
						$scope.component.pivotColumn = {
							column : columnName
						};
						var showNumberOps = false;
						if ($scope.numberArray.indexOf(columnType) != -1)
							showNumberOps = true;
						$scope.$apply();
					} else if (drop.data('droptype') == "pivotCell") {
						var showNumberOps = false;
						if ($scope.numberArray.indexOf(columnType) != -1)
							showNumberOps = true;
						$scope.component.pivotCell = {
							column : columnName,
							aggrType : "Count",
							showNumberOps : showNumberOps
						};
					} else {
						alert('Drop the column in the designated fields above');
						return;
					}

					if ($scope.component.pivotRow.column && $scope.component.pivotColumn) {
						if (!$scope.component.pivotCell || !$scope.component.pivotCell.column) {
							$scope.component.pivotCell = {
								column : columnName,
								aggrType : "Count",
								showNumberOps : showNumberOps
							};
						}
						//$scope.component.allColumns = true;
						createKendoGrid();
					}

				}
         };

         if(!$.isEmptyObject($scope.component.dataSet) && ($scope.component.allColumns || $scope.component.columns.length > 0)){
        	 if(isColumnProcessingRequired()){
        		$scope.component.isComponentLoading = true;
      			window.pendingRequests += 1; // To make sure export waits till the below timeout is called.
      			$timeout(function() {
      				window.pendingRequests -= 1;
      				$scope.getFieldsForDataSet($scope.dataSet).then(function(data) {
      					if ($scope.reportMode === 'viewer') {
      						$scope.dataSet.fields = data.data.columns; // chart interactivity
      					}
      					initializeColumns(data.data.columns);
      					resetColumns = false;
      					createKendoGrid();
      				}, function(error) {
      					$scope.errorFunc(error.data,error.status);
      				});
      			},1000)
      		}else{
      			createKendoGrid();
      		}
         }else if($scope.reportMode == 'builder' && $scope.component.type == "TABLE"){
        	 $scope.showDropColumnsMessage = true;
         }


       //Button Panel changes

			$scope.registerLocalCallBack("resetSelectedRows", function(componentId) {
				if ($scope.component.id === componentId) {
					$scope.resetSelectedRows();
				}
			});

			$scope.resetSelectedRows = function(){
				$scope.selectedRows = {};
				$scope.checkboxes = {};
				$scope.singleSelectValue="";
			}

			$scope.checkAllRowsEnabled = function(){
				var allrows = true;
				angular.forEach($scope.kendoGrid.dataSource.view(),function(dataObj,index){
					if(!$scope.checkboxes[dataObj[$scope.SYS_ROWID]] && (typeof dataObj['disableRowSelection'] === "undefined" || !dataObj['disableRowSelection'])){
						allrows = false;
					}
				});

				$scope.allRows.selected = allrows;
			}

			var additionalKeys = ["_formatted","tagAttributes"];
			// this will clean up any additional data added by kendo grid.
			var getTempObject = function(dataItem){
				var temp = {};
				var colsToCheck = $scope.component.columns;
				angular.forEach(colsToCheck,function(column,index){
					temp[column.id] = dataItem[column.id];
					for(var key of additionalKeys){
						key = column.id+key;
						if(typeof dataItem[key] !== "undefined"){
							temp[key] = dataItem[key];
						}
					}
				});
				return temp;
			}

			$scope.handleRowClickEvent = function($event){
                let groupName;
                var rowIndex = $event.currentTarget.rowIndex;
                if($scope.grouped && $scope.component.group[0].field){
                  groupName = $scope.component.group[0].field;
                  --rowIndex;
                }else{
                	rowIndex -= 2;
                }
                $scope.handleTableRowSelection($event,rowIndex,groupName);
			}

			$scope.rowChanged = function(dataItem,dataIndex){
				var key = $scope.component.enableMultiRowSelection ? dataItem[$scope.SYS_ROWID] : "0";
				if ($scope.component.enableMultiRowSelection) {
					if($scope.component.filterReportForRowSelection && $scope.component.filterColumn) {
						const filter = {
							field: $scope.component.filterColumn,
							type: "rowSelect",
							value: dataItem[$scope.component.filterColumn],
							selectionType: $scope.isExcludeFilter ? "exclude" : "include"
						};
						$scope.applyFilter(filter);
					}

					if ($scope.checkboxes[key]) {
						var temp = getTempObject(dataItem);//cloning the object , so that any changes to the selectedRows will not be reflected in the table
						$scope.selectedRows[key] = temp;
						$scope.checkAllRowsEnabled();
					} else {
						delete $scope.selectedRows[key];
						if ($scope.allRows.selected) {
							$scope.allRows.selected = false;
						}
					}
				}else{
					$scope.selectedRows[key] = getTempObject(dataItem);
					$scope.singleSelectValue = $scope.selectedRows[key][$scope.SYS_ROWID];
				}
				if(Object.keys($scope.selectedRows).length > 0){
					$scope.showSelectedRowsLabel = true;
				}else{
					$scope.showSelectedRowsLabel = false;
				}
				$scope.evalButtonStates();
			}

			$scope.allRowsChanged = function(){
				//	$scope.selectedRows = $scope.kendoGrid.dataSource.view();
					if($scope.allRows.selected){
						angular.forEach($scope.kendoGrid.dataSource.view(),function(dataObj,index){
							if(typeof dataObj['disableRowSelection'] === "undefined" || !dataObj['disableRowSelection']){
								var temp = getTempObject(dataObj);//cloning the object , so that any changes to the selectedRows will not be reflected in the table
								$scope.selectedRows[dataObj[$scope.SYS_ROWID]] = temp;
								$scope.checkboxes[dataObj[$scope.SYS_ROWID]] = true;
							}
						});
						$scope.isExcludeFilter = true;
					}else{
						$scope.isExcludeFilter = false;
						$scope.selectedRows = {};
						$scope.checkboxes = {};
					}
					$scope.evalButtonStates();

					if($scope.component.enableMultiRowSelection && $scope.component.filterReportForRowSelection
					 && $scope.component.filterColumn) {
					 	const filter = {
							field: $scope.component.filterColumn,
							type: "rowSelect",
							value: ""
						};
						$scope.clearFilter(filter);
					}
			}

			$scope.toggleSelectedRows = false;

			$scope.showSelectedRows = function(toggle){
				if(!$scope.orginalData){ // keep a copy of the orginal computed data to switch between.
					$scope.orginalData=$scope.kendoGrid.dataSource.view();
				}
				$scope.showSelectedRowsOperation = true;
				//$scope.toggleSelectedRows = !$scope.toggleSelectedRows;

				if(toggle){
					$scope.datToDefer=$scope.cleanUpObject($scope.selectedRows);
				}else{
					$scope.datToDefer=$scope.orginalData;
				}

				$scope.kendoGrid.dataSource.data($scope.datToDefer);
				$scope.resizeGridComponent();
				//$scope.tableParams.reload();
			}

			$scope.evalRowSelection = function(row,rowIndex){
				let disabled = false;
				if(typeof $scope.component.disableRowSelectionWhen !== "undefined"){
					disabled = customReportSvc.evalExpression($scope.component.disableRowSelectionWhen,row,rowIndex);
				}
				return disabled;
			}

			$scope.clearRowSelection = () => {
				$scope.isExcludeFilter = false;
				$scope.child.showSelectedRowsLabel = false;
				$scope.selectedRows = {};
				$scope.checkboxes = {};
				const filter = {
					field: $scope.component.filterColumn,
					type: "rowSelect",
					value: ""
				};
				$scope.clearFilter(filter);
			}
	}

})();
