<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.ReportsPlusMessages">

	<ul class="secondary-header secondary-background-color">
        <li class="sub-header" title="General" data-ng-class="{'sub-header-active': selectedPropertyCategory==='general'}" data-ng-click="selectedPropertyCategory='general'">
            <span class="ico ico-cog"></span>
        </li>
        <li class="sub-header" title="Fields" data-ng-class="{'sub-header-active': selectedPropertyCategory==='fields'}" data-ng-click="selectedPropertyCategory='fields'">
            <span class="ico ico-form-field"></span>
        </li>
        <li class="sub-header" title="Custom Code" data-ng-class="{'sub-header-active': selectedPropertyCategory==='customcode'}" data-ng-click="selectedPropertyCategory='customcode'">
            <span class="ico ico-code"></span>
        </li>
        <li class="sub-header" title="Mobile" data-ng-show="propData.mobile.visible === 'On' && cv.additionalSettings.Console.enableMobileOptions" data-ng-class="{'sub-header-active': selectedPropertyCategory==='mobile'}" data-ng-click="selectedPropertyCategory='mobile'">
            <span class="ico ico-mobile"></span>
        </li>
        <li class="sub-header" title="Filters" data-ng-show="ds && ds.endpoint === 'DATACUBE'" data-ng-class="{'sub-header-active': selectedPropertyCategory==='filters'}" data-ng-click="selectedPropertyCategory='filters'">
            <span class="ico ico-funnel"></span>
        </li>
	</ul>
	<div data-ng-include="'${pageContext.request.contextPath}/reportsplus/properties/miscProperties.jsp'"></div>
	<!-- Begin "General" group -->
	<div data-ng-show="selectedPropertyCategory==='general'">
		<div class="row noLftRghtMargin">
			<div class="col-xs-12">
				<div class="form-group">
					<label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.Title"/>'>
                        <fmt:message key="CustomReport.Properties.Title" />
                    </label>
					<div class="col-sm-8 noLftRghtPadding">
						<input class="form-control input-sm" type="text"
							placeholder="<fmt:message key="CustomReport.Properties.TableName"/>"
							data-ng-model="propData.title.text">
					</div>
				</div>
			</div>
		</div>

		<div class="row noLftRghtMargin">
			<div class="col-xs-12">
				<div class="form-group">
					<label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"  title='<fmt:message key="CustomReport.Properties.ID"/>'><fmt:message
							key="CustomReport.Properties.ID" /></label>
					<div class="col-sm-8 noLftRghtPadding">
						<input class="form-control input-sm" type="text"
							data-ng-model="propData.id"
							data-ng-pattern="/^[A-Za-z0-9_]{1,}$/"
							data-ng-blur="validateComponentId()"
                            data-ng-class="{'pattern-invalid': !propData.id}">
                            <!-- localize -->
                            <span class="inline-validation-error" data-ng-show="!propData.id">
                                *ID should contain characters,digits and underscore only.
                            </span>
					</div>
				</div>
			</div>
		</div>

		<div class="row noLftRghtMargin">
			<div class="col-xs-12">
				<div class="form-group">
					<label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.DataSet"/>'>
                        <fmt:message key="CustomReport.Properties.DataSet" />
                    </label>
					<div class="col-sm-8 noLftRghtPadding">
						<input class="form-control input-sm" type="text"
							placeholder="<fmt:message key="CustomReport.Properties.DataSetName"/>"
							readonly="true" data-ng-model="propData.dataSet.dataSetName">
					</div>
				</div>
			</div>
		</div>

		<div class="row noLftRghtMargin">
            <div class="col-xs-12">
                <div class="form-group">
                    <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.IncludeAllColumns"/>'>
                        <fmt:message key="CustomReport.Properties.IncludeAllColumns"/>
                    </label>
                    <div class="col-sm-3 noLftRghtPadding">
                        <input cv-toggle-switch data-ng-model="propData.allColumns" data-ng-disabled="!propData.dataSet.dataSetName"
                            type="checkbox" data-ng-change="reInitializeTable()" class="checkbox-toggle" id="allcolumns">
                        <!-- <label for="allcolumns"></label> -->
                    </div>
                </div>
            </div>
        </div>

        <div class="row noLftRghtMargin">
            <div class="col-xs-12" >
                <div class="form-group">
                    <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.HideAlert"/>'>
                        <fmt:message key="CustomReport.Properties.HideAlert"/>
                    </label>
                    <div class="col-sm-3 noLftRghtPadding">                        
                        <input type="checkbox" cv-toggle-switch data-ng-model="propData.hideAlarmOption" id="hidealalarmoption">
                    </div>
                </div>
            </div>
        </div>

        <div class="row noLftRghtMargin" data-ng-show="propData.type !== 'PIVOT_TABLE'">
            <div class="col-xs-12">
                <div class="form-group">
                    <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.EnableButtonPanel"/>'>
                        <fmt:message key="CustomReport.Properties.EnableButtonPanel"/>
                    </label>
                    <div class="col-sm-3 noLftRghtPadding">                  
                        <input type="checkbox" cv-toggle-switch data-ng-model="propData.enableButtonPanel" id="enableButtonPanel">
                    </div>
                </div>
            </div>
        </div>

        <div class="row noLftRghtMargin" data-ng-show="propData.type !== 'PIVOT_TABLE' && propData.enableButtonPanel">
            <div class="col-xs-12">
                <div class="form-group">
                    <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.EnableColumnSelection"/>'>
                        <fmt:message key="CustomReport.Properties.EnableColumnSelection"/>
                    </label>
                    <div class="col-sm-3 noLftRghtPadding">                  
                        <input type="checkbox" cv-toggle-switch data-ng-model="propData.enableRowSelection" id="enableRowSelection" data-ng-change="enableRowSelection()">
                    </div>
                </div>
            </div>
        </div>
         
        <div class="row noLftRghtMargin" data-ng-show="propData.type !== 'PIVOT_TABLE' && propData.enableButtonPanel && propData.enableRowSelection">
            <div class="col-xs-12">
                <div class="form-group">
                    <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.EnableMultipleRowSelection"/>'>
                        <fmt:message key="CustomReport.Properties.EnableMultipleRowSelection"/>
                    </label>
                    <div class="col-sm-3 noLftRghtPadding">
                        <input type="checkbox" cv-toggle-switch data-ng-model="propData.enableMultiRowSelection" id="enableMultiRowSelection">
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xs-12">
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.HideHeader"/>'>
                    <fmt:message key="CustomReport.Properties.HideHeader"/>
                </label>
                <div class="col-sm-3 noLftRghtPadding">                    
                    <input type="checkbox" cv-toggle-switch data-ng-model="propData.hideHeader" id="hideheader">                        
                </div>
            </div>            
        </div>

        <div class="col-xs-12">
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-8 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.AutoHeight"/>'>
                    <fmt:message key="CustomReport.Properties.AutoHeight"/>
                </label>
                <div class="col-sm-4 noLftRghtPadding">                    
                    <select class="form-control input-sm" data-ng-model="propData.autoHeight">
                        <option value="On"><fmt:message key="CustomReport.Properties.On"/></option>
                        <option value="Off"><fmt:message key="CustomReport.Properties.Off"/></option>
                    </select>                    
                </div>
            </div>            
        </div>

        <div class="col-xs-12">
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.CustomRowTemplateHelp"/>'>
                    <fmt:message key="CustomReport.Properties.CustomRowTemplate"/>
                </label>
                <div class="col-sm-3 noLftRghtPadding">                    
                    <input type="checkbox" cv-toggle-switch data-ng-model="propData.showAsSearchResults" id="showAsSearchResults">                        
                </div>
            </div>            
        </div>
        
        <!-- Localize -->
        <!-- <div class="col-xs-12">
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.CustomRowTemplateHelp"/>'>
                    <fmt:message key="CustomReport.Properties.CustomRowTemplate"/>Enable Grouping
                </label>
                <div class="col-sm-3 noLftRghtPadding">                    
                    <input type="checkbox" cv-toggle-switch data-ng-model="propData.showAsSearchResults" id="showAsSearchResults">                        
                </div>
            </div>            
        </div> -->

    <!-- Mobile Visible Option -->
        <div class="col-xs-12" data-ng-if="cv.additionalSettings.Console.enableMobileOptions">
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-8 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.Mobile.Visible"/>'><fmt:message key="CustomReport.Properties.Mobile.Visible"/></label>
                <div class="col-sm-4 noLftRghtPadding">                    
                        <select class="form-control input-sm"
                            data-ng-model="propData.mobile.visible">
                            <option value="On"><fmt:message key="CustomReport.Yes"/></option>
                            <option value="Off"><fmt:message key="CustomReport.No"/></option>
                        </select>                    
                </div>
            </div>            
        </div>
	</div>

	<div data-ng-show="selectedPropertyCategory==='fields'">
        <div class="row noLftRghtMargin secondary-header property-header" data-ng-click="collapsed['sorting']=!collapsed['sorting']">
            <div class="col-xs-12 noLftRghtPadding">
                <span class="ico" data-ng-class="{'ico-chevron-down':!collapsed['sorting'], 'ico-chevron-right':collapsed['sorting']}" style="margin-right:5px"></span>
                <span><fmt:message key="CustomReport.Properties.Sorting"/></span>
                <!-- <span class="pull-right ico ico-plus-circle" title="Add Sorting" data-ng-click="collapsed['sorting']=true;addSort()"></span> -->
            </div>
        </div>
        <div data-ng-class="{'collapsed': collapsed['sorting']}">
            <div class="row ng-scope noLftRghtMargin" data-ng-repeat="sort in propData.sorting">
                <div class="col-xs-12">
                    {{sort}}
                    <select data-ng-model="sort.columnId"
                        data-ng-options="col.id as col.displayName for col in propData.columns | excludeFrom:sort.columnId:propData.sorting"
                        data-ng-change="refreshTableData()" class="col-lg-7 noLftRghtPadding" style="margin-right: 5px;"></select>
                    <select data-ng-model="sort.direction" data-ng-change="refreshTableData()" class="col-lg-3 noLftRghtPadding" style="margin-right: 5px;">
                        <option value="Asc">Asc</option>
                        <option value="Desc">Desc</option>
                    </select>					  			
                    <span class="ico ico-trash2 pro-dlt-btn" data-ng-click="deleteSort($index)"> </span>
                </div>
            </div>
        </div>
        <div class="row noLftRghtMargin secondary-header property-header" data-ng-click="collapsed['columns']=!collapsed['columns']" data-ng-init="collapsed['columns']=true">
            <div class="col-xs-12 noLftRghtPadding">
                <span class="ico" data-ng-class="{'ico-chevron-down':!collapsed['columns'], 'ico-chevron-right':collapsed['columns']}" style="margin-right:5px"></span>
                <span>Columns</span> <!-- TODO: localize -->
            </div>
        </div>
        <div data-ng-class="{'collapsed': collapsed['columns']}">
            <div data-ng-repeat="column in propData.columns" data-ng-init="collapsed['column'+$index] = true">
                <div class="row noLftRghtMargin fieldPanel secondary-header inner-panel" >
                    <div class="fieldHeader"  data-ng-click="collapsed['column'+$index]=!collapsed['column'+$index]">                
                        <label class="col-lg-9 noLftRghtPadding">
                            <span cv-report-customization cv-expression="{{column.displayName}}" cv-localize="true" ></span>
                        </label>
                        <span class="pull-right">
                            <span class="ico inner-panel-expand-icon" data-ng-class="{'ico-chevron-down':!collapsed['column'+$index], 'ico-chevron-right':collapsed['column'+$index]}" style="margin-right:5px"></span>
                        </span>                                     
                    </div>                     
                    <div data-ng-class="{'collapsed': collapsed['column'+$index]}">
                        <!-- Column Thingy. -->
                        <div cv-columns data-column="column"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Begin "Custom" group -->
    <div data-ng-show="selectedPropertyCategory==='customcode'">
        <div class="row noLftRghtMargin">
            <div class="col-xs-12">
    <!-- FIXME: Localize -->
                <label  class="col-xs-12 noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.AllCellExpression"/>'>
                    <fmt:message key="CustomReport.Properties.AllCellExpression"/><br>
                </label>
                <span class="input-group-sm col-xs-12 noLftRghtPadding">
                    <textarea  data-ng-model="propData.allCellExpression" rows="5" ></textarea>
                </span>
            </div>
            <div class="col-xs-12">
    <!-- FIXME: Localize -->
                <label class="col-xs-12 noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.RowStyles"/>'>
                    <fmt:message key="CustomReport.Properties.RowStyles"/><br>
                </label>
                <span class="input-group-sm col-xs-12 noLftRghtPadding">
                    <textarea  data-ng-model="propData.rowStyleExpression" rows="5" ></textarea>
                </span>
            </div>
        </div>
    </div>

    <!-- Begin "Mobile" group -->
    <div data-ng-show="selectedPropertyCategory==='mobile'">
        <div class="row noLftRghtMargin">
            <event-properties event-type="onClick" event-model="propData.mobile.listItemClick" is-mobile="true"></event-properties>
        </div>
        <div class="row noLftRghtMargin">
            <div class="col-xs-12">
            <!-- FIXME: Localize -->
                <label  class="col-xs-12 noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.Mobile.CustomLayout"/>'>
                    <fmt:message key="CustomReport.Properties.Mobile.CustomLayout"/><br>
                </label>
                <span class="input-group-sm col-xs-12 noLftRghtPadding">
                    <textarea data-ng-model="propData.mobile.customListLayout" rows="5" ></textarea>
                </span>
            </div>
        </div>
    </div>


</fmt:bundle>
