<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.ReportsPlusMessages">

	<ul class="secondary-header secondary-background-color">
		<li class="sub-header" title="General"
			data-ng-class="{'sub-header-active': selectedPropertyCategory==='general'}"
			data-ng-click="selectedPropertyCategory='general'"><span
			class="ico ico-cog"></span></li>
		<li class="sub-header" title="Fields"
			data-ng-class="{'sub-header-active': selectedPropertyCategory==='fields'}"
			data-ng-click="selectedPropertyCategory='fields'"><span
			class="ico ico-form-field"></span></li>
        <li data-ng-show="propData.enableRowSelection" class="sub-header" title="Custom Code" data-ng-class="{'sub-header-active': selectedPropertyCategory==='customcode'}" data-ng-click="selectedPropertyCategory='customcode'">
            <span class="ico ico-code"></span>
        </li>
        <li class="sub-header" title="Filters" data-ng-show="ds && ds.endpoint === 'DATACUBE'" data-ng-class="{'sub-header-active': selectedPropertyCategory==='filters'}" data-ng-click="selectedPropertyCategory='filters'">
            <span class="ico ico-funnel"></span>
        </li>
	</ul>
	<div data-ng-include="'${pageContext.request.contextPath}/reportsplus/properties/miscProperties.jsp'"></div>
	<!-- Begin "General" group -->
	<div data-ng-show="selectedPropertyCategory==='general'">
		<div class="row noLftRghtMargin">
			<div class="col-xs-12">
				<!-- FIXME: Localize -->
				<div class="form-group">
					<label
						class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"><fmt:message
							key="CustomReport.Properties.Title" /></label>
					<div class="col-sm-8 noLftRghtPadding">
						<input class="form-control input-sm" type="text"
							placeholder="<fmt:message key="CustomReport.Properties.TableName"/>"
							data-ng-model="propData.title.text">
					</div>
				</div>
			</div>
		</div>

		<div class="row noLftRghtMargin">
			<div class="col-xs-12">
				<!-- FIXME: Localize -->
				<div class="form-group">
					<label
						class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"><fmt:message
							key="CustomReport.Properties.ID" /></label>
					<div class="col-sm-8 noLftRghtPadding">
						<input class="form-control input-sm" type="text"
							data-ng-model="propData.id"
							data-ng-pattern="/^[A-Za-z0-9_]{1,}$/"
							data-ng-blur="validateComponentId()"
							data-ng-class="{'pattern-invalid': !propData.id}"> <span
							class="inline-validation-error" data-ng-show="!propData.id">*ID
							should contain characters,digits and underscore only.</span>
						<!-- localize -->
					</div>
				</div>
			</div>
		</div>

		<div class="row noLftRghtMargin">
			<div class="col-xs-12">
				<!-- FIXME: Localize -->
				<div class="form-group">
					<label
						class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"><fmt:message
							key="CustomReport.Properties.DataSet" /></label>
					<div class="col-sm-8 noLftRghtPadding">
						<input class="form-control input-sm" type="text"
							placeholder="<fmt:message key="CustomReport.Properties.DataSetName"/>"
							readonly="true" data-ng-model="propData.dataSet.dataSetName">
					</div>
				</div>
			</div>
		</div>

		<div class="row noLftRghtMargin">
        <div class="col-xs-12">
<!-- FIXME: Localize -->
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding"><fmt:message key="CustomReport.Properties.IncludeAllColumns"/></label>
                <div class="col-sm-3 noLftRghtPadding">
                    <input data-ng-model="propData.allColumns" data-ng-disabled="!propData.dataSet.dataSetName"
                     type="checkbox" data-ng-change="reInitializeTable()" class="checkbox-toggle" id="allcolumns">
                    <label for="allcolumns"></label>
                </div>
            </div>
        </div>
    </div>
    <!-- div class="row noLftRghtMargin">
        <div class="col-xs-12">
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding">Show Column Filters</label>
                <div class="col-sm-3 noLftRghtPadding">
                    <input data-ng-model="propData.showColumnFilters" data-ng-disabled="!propData.dataSet.dataSetName"
                     type="checkbox"  data-ng-change="reInitializeTable()" class="checkbox-toggle" id="showColumnFilters">
                    <label for="showColumnFilters"></label>
	</div>
            </div>
        </div>
    </div -->
    <div class="row noLftRghtMargin">
        <div class="col-xs-12">
<!-- FIXME: Localize -->
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding">Show Grouping Header</label>
                <div class="col-sm-3 noLftRghtPadding">
                    <input data-ng-model="propData.showGroupingHeader" data-ng-disabled="!propData.dataSet.dataSetName"
                     type="checkbox" class="checkbox-toggle" id="showGroupingHeader">
                    <label for="showGroupingHeader"></label>
                </div>
            </div>
        </div>
    </div>

    <div class="row noLftRghtMargin">
        <div class="col-xs-12">
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.EnableColumnSelection"/>'><fmt:message key="CustomReport.Properties.EnableColumnSelection"/></label>
                <div class="col-sm-3 noLftRghtPadding">
                    <input type="checkbox" data-ng-model="propData.enableRowSelection" data-ng-change="redrawComponent(propData.id)" id="enableRowSelection">
                </div>
            </div>
        </div>
    </div>

    <!-- Mobile Visible Option -->
    <div class="col-xs-12" data-ng-if="cv.additionalSettings.Console.enableMobileOptions">
        <div class="form-group">
            <label class="col-xs-12 col-sm-12 col-md-12 col-lg-8 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.Mobile.Visible"/>'><fmt:message key="CustomReport.Properties.Mobile.Visible"/></label>
            <div class="col-sm-4 noLftRghtPadding">                    
                    <select class="form-control input-sm"
                        data-ng-model="propData.mobile.visible">
                        <option value="On"><fmt:message key="CustomReport.Yes"/></option>
                        <option value="Off"><fmt:message key="CustomReport.No"/></option>
                    </select>                    
            </div>
        </div>            
    </div>
	<entity-security data-item="propData"></entity-security>
	</div>

	<div data-ng-show="selectedPropertyCategory==='fields'">
		<div class="row noLftRghtMargin secondary-header property-header"
			data-ng-click="collapsed['columns']=!collapsed['columns']"
			data-ng-init="collapsed['columns']=false">
			<div class="col-xs-12 noLftRghtPadding">
				<span class="ico"
					data-ng-class="{'ico-chevron-down':!collapsed['columns'], 'ico-chevron-right':collapsed['columns']}"
					style="margin-right: 5px"></span> <span>Columns</span>
				<!-- TODO: localize -->
			</div>
		</div>
<div data-ng-class="{'collapsed': collapsed['columns']}">
    <div data-ng-repeat="column in propData.columns" data-ng-init="collapsed['column'+$index] = true">
        <div class="row noLftRghtMargin fieldPanel secondary-header inner-panel" >
        	<div class="fieldHeaderContainer">
        		<div class="fieldHeader dataGridFieldHeader" data-ng-click="collapsed['column'+$index]=!collapsed['column'+$index]">
                  <label class="col-lg-9 noLftRghtPadding">
                      <span cv-report-customization cv-expression="{{column.displayName}}"></span>
                  </label>
                   <span class="pull-right">
                        <span class="ico inner-panel-expand-icon" data-ng-class="{'ico-chevron-down':!collapsed['column'+$index], 'ico-chevron-right':collapsed['column'+$index]}" style="margin-right:5px"></span>

                    </span>
             </div>
             <div class="removeColumnInHeader">
             	<span class="pull-right">
             		 <span class="ico ico-trashcan" title="<fmt:message key='CustomReport.Properties.DeleteColumn'/>" data-ng-click="removeColumn(column)"></span>
             	</span>
             </div>
        	</div>

     <div data-ng-class="{'collapsed': collapsed['column'+$index]}">
       <div class="row noLftRghtMargin">
          <div class="col-xs-12 noLftRghtPadding">
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.DisplayName"/>'><fmt:message key="CustomReport.Properties.DisplayName"/></label>
                <div class="col-sm-8 noLftRghtPadding">
                    <input class="form-control input-sm" type="text" placeholder="<fmt:message key='CustomReport.Properties.DisplayName'/>" data-ng-model="column.displayName">
                </div>
            </div>
          </div>
        </div>

         <div class="row noLftRghtMargin">
              <div class="col-xs-12 noLftRghtPadding">
        <!-- FIXME: Localize -->
                  <div class="form-group">
                      <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.ID"/>'><fmt:message key="CustomReport.Properties.ID"/></label>
                      <div class="col-sm-8 noLftRghtPadding">
                          <input class="form-control input-sm" type="text" data-ng-model="column.id">
                      </div>
                  </div>
              </div>
          </div>

         <!--  <div class="row noLftRghtMargin">
              <div class="col-xs-12 noLftRghtPadding">
                <div class="form-group">
                    <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.Width"/>'><fmt:message key="CustomReport.Properties.Width"/></label>
                    <div class="col-sm-8 noLftRghtPadding">
                        <input class="form-control input-sm" type="text" value="column.width" data-ng-model="column.width">
                    </div>
                </div>
              </div>
          </div> -->

         <!--  <div class="row noLftRghtMargin">
            <div class="col-xs-12 noLftRghtPadding" >
                <div class="form-group">
                    <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.ExcludeFromCSVExportTitle"/>'><fmt:message key="CustomReport.Properties.ExcludeFromCSVExport"/></label>
                    <div class="col-sm-3 noLftRghtPadding">
                        <div class="on-off-switch">
                            <input type="checkbox" name="on-off-switch" data-ng-model="columnData.excludeFromCSVExport" class="on-off-switch-checkbox" id="excludefromcsv{{$index}}">
                            <label class="on-off-switch-label" for="excludefromcsv{{$index}}">
                                <span class="on-off-switch-inner"></span>
                                <span class="on-off-switch-switch"></span>
                            </label>
                        </div>
                    </div>
                </div>
            </div>
        </div> -->
        <div class="row formatter-option">
            <div class="col-xs-12">
                <div class="form-group">
                    <label class="col-xs-12 col-sm-12 col-md-12 col-lg-7 control-label noLftRghtPadding" title='Formatter'>
                        Formatter
                    </label>
                    <div class="col-sm-5 noLftRghtPadding">
                        <span class="pull-right">
                            <span class="label label-info cursor-pointer" data-ng-click="showFormatterOptions(column,'cellExpression')">{{getFormatterType(column.cellExpression)}}</span>
                        </span>
                    </div>
                </div>
            </div>
        </div>

        	<div class="row">
              <div class="col-xs-12">
                  <div class="form-group">
                    <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.WrapTextTitle"/>'><fmt:message key="CustomReport.Properties.WrapText"/></label>
                    <div class="col-sm-3 noLftRghtPadding">
                        <div class="on-off-switch">
                            <input type="checkbox" name="on-off-switch" data-ng-model="column.wrapText" class="on-off-switch-checkbox" id="wraptext{{column.id}}">
                            <label class="on-off-switch-label" for="wraptext{{column.id}}">
                                <span class="on-off-switch-inner"></span>
                                <span class="on-off-switch-switch"></span>
                            </label>
                        </div>
                    </div>
                </div>
              </div>
            </div>
            
            <div class="row">
              <div class="col-xs-12">
                <div class="form-group">
                    <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.SplitBy"/>'><fmt:message key="CustomReport.Properties.SplitBy"/></label>
                    <div class="col-sm-8 noLftRghtPadding">
                        <input type="text" class="form-control" value="column.splitByCharacter"
                          data-ng-model="column.splitByCharacter" data-ng-change="updateComponent(componentId)">
                    </div>
                </div>
              </div>
          </div>

          <div class="row noLftRghtMargin">
              <div class="col-xs-12 noLftRghtPadding">
                  <div class="form-group">
                      <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.Hidden"/>'><fmt:message key="CustomReport.Properties.Hidden"/></label>
                      <div class="col-sm-8 noLftRghtPadding">
                         <select  class="form-control input-sm" data-ng-model="column.hidden" data-ng-options="o.v as o.n for o in [{ n: 'False', v: false }, { n: 'True', v: true }]" data-ng-change="hideFilterColumn($index)"></select>
                      </div>
                  </div>
              </div>
         </div>
         <div class="row noLftRghtMargin">
             <div class="col-xs-12 noLftRghtPadding">
                 <div class="form-group">
                     <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='Hide From Inner Grid'>Hide From Inner Grid</label>
                     <div class="col-sm-3 noLftRghtPadding">
                         <div class="on-off-switch">
                             <input type="checkbox" name="on-off-switch" data-ng-change="redrawComponent(componentId)" data-ng-model="column.hideFromInnerGrid" class="on-off-switch-checkbox" id="hideFromInnerGrid{{column.id}}">
                             <label class="on-off-switch-label" for="hideFromInnerGrid{{column.id}}">
                                 <span class="on-off-switch-inner"></span>
                                 <span class="on-off-switch-switch"></span>
                  			</label>
                         </div>
                     </div>
                 </div>
             </div>
        </div>
         <div class="row noLftRghtMargin">
             <div class="col-xs-12 noLftRghtPadding">
                 <div class="form-group">
                     <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='Hide From Outer Grid'>Hide From Outer Grid</label>
                     <div class="col-sm-3 noLftRghtPadding">
                         <div class="on-off-switch">
                             <input type="checkbox" name="on-off-switch" data-ng-change="redrawComponent(componentId)" data-ng-model="column.hideFromOuterGrid" class="on-off-switch-checkbox" id="hideFromOuterGrid{{column.id}}">
                             <label class="on-off-switch-label" for="hideFromOuterGrid{{column.id}}">
                                 <span class="on-off-switch-inner"></span>
                                 <span class="on-off-switch-switch"></span>
                             </label>
                         </div>
                     </div>
                 </div>
              </div>
         </div>
         <div class="row noLftRghtMargin" data-ng-class="{hide:!column.showMinCount}">
              <div class="col-xs-12 noLftRghtPadding">
                  <div class="form-group">
                      <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='Mincount'>Mincount</label>
                      <div class="col-sm-8 noLftRghtPadding">
                         <input type="number" class="form-control" value="column.minCount"
                          data-ng-model="column.minCount" min="1" data-ng-blur="updateComponent(componentId)">
                      </div>
                  </div>
                  <label>


                  </label>
              </div>
         </div>         
         <div class="row noLftRghtMargin">
          <div class="form-group">
              <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" cv-label-title>Map Field</label>
              <div class="col-sm-8 noLftRghtPadding">
                <select class="form-control input-sm"
                data-ng-model="column.mapping"      
                data-ng-change="updateComponent(componentId)"                
                data-ng-options="field.fieldName as field.fieldName for field in ds.fields | orderBy:'fieldName'">
                  <option value="">Select Field</option>
                </select>
              </div>
         </div>
         </div>
      </div>
    </div>
    </div>
    <!-- End Column properties -->
	</div>
</div>
<div data-ng-show="selectedPropertyCategory==='customcode'">
    <div data-ng-init="collapseProp=true" data-ng-if="propData.enableRowSelection">
      <div class="row noLftRghtMargin noLftRghtPadding secondary-header property-header" data-ng-click="collapseProp=!collapseProp">
         <div class="col-xs-12">
             <span class="ico col-xs-2 margin-right-5 noLftRghtPadding" data-ng-class="{'ico-chevron-down':!collapseProp, 'ico-chevron-right':collapseProp}"></span>
             <label class="col-xs-10 noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.RowFormatter"/>'>
              <fmt:message key="CustomReport.Properties.RowFormatter"/><br>
            </label>
             
         </div>
      </div>
      <div data-ng-if="!collapseProp">    
        <event-properties event-type="onClick" event-model="propData.rowFormatter" comp-type="'row'" columns="propData.columns"></event-properties>
      </div>
  </div>

</div>

<div data-ng-show="ds && ds.endpoint === 'DATACUBE' && selectedPropertyCategory==='filters'">
    <div class="row noLftRghtMargin" data-ng-show="ds && ds.endpoint === 'DATACUBE'">
        <div class="col-xs-12">
            <label class="col-xs-12 noLftRghtPadding">
                <fmt:message key="CustomReport.properties.OuterGridFilter"/><br>
            </label>
            <span class="col-xs-12 noLftRghtPadding">
                <textarea  data-ng-model="propData.outerGridFilterQuery" data-ng-blur="refreshTableData()"></textarea>
            </span>
        </div>
    </div>
    <div class="row noLftRghtMargin" data-ng-show="ds && ds.endpoint === 'DATACUBE'">
        <div class="col-xs-12">
            <label class="col-xs-12 noLftRghtPadding">
                <fmt:message key="CustomReport.properties.InnerGridFilter"/><br>
            </label>
            <span class="col-xs-12 noLftRghtPadding">
                <textarea  data-ng-model="propData.innerGridFilterQuery" data-ng-blur="refreshTableData()"></textarea>
            </span>
        </div>
    </div>
</div>

</fmt:bundle>
