(function() {
	'use strict';

	angular.module("reports").controller('dateRangeCtrl', dateRangeCtrl);

	dateRangeCtrl.$inject = [ '$scope', 'reportService', 'customReportSvc', 'dataSource' ];

	function dateRangeCtrl($scope, reportService, customReportSvc, $dataSource) {
		var dates = [ "TimeStamp", "Date", "Integer" ];
		var defaultUnits = [ "m", "h", "d", "M", "y" ];

		$scope.getValue = function(value) {
			if ($scope.component.rangeType === 'absolute') {
				if (value.from && value.to) {
					value = ">=" + value.from.toISOString().split('.')[0] + 'Z' + " AND <=" +
							value.to.toISOString().split('.')[0] + 'Z';
				} else {
					value = "";
				}
			}

			return value;
		}
		$scope.init = function() {
			if (!$scope.component.rangeType) {
				$scope.component.rangeType = "absolute";
			}
			if ($scope.dataSet && $scope.dataSet.endpoint !== "DATACUBE") {
				var key = $scope.component.id + ".filter." + $scope.component.dateRangeField;
				//temp code to apply filters on page load. Ideally this should be a component level filter which can be cleared. 
				if ($scope.requestParms[key]) {
					var value = $scope.requestParms[key];
					if (value.indexOf(">-") === 0) {
						$scope.component.rangeType = 'relative';
						$scope.component.dateRange.relative = value;
					} else if (value.indexOf("AND") !== -1) {
						$scope.component.rangeType = 'absolute';
						var times = value.split("AND");
						$scope.component.dateRange.absolute = {
							from : new Date(times[0].substring(2, times[0].length - 1).trim()),
							to : new Date(times[1].substring(3, times[0].length).trim())
						}
					}

				}
			}

			if ($.isEmptyObject($scope.component.dateRange)) {
				$scope.component.dateRange = {
					absolute : {
						from : "",
						to : ""
					},
					relative : ""
				};
			}
			if (!$scope.component.relativeTimes || typeof $scope.component.relativeTimes === 'string') { // for existing reports replace it with default object
				$scope.component.relativeTimes = [ {
					'label' : 'Last 15 Minutes',
					'value' : ">-15m"
				}, {
					'label' : 'Last 1 hour',
					'value' : ">-1h"
				}, {
					'label' : 'Last 12 hours',
					'value' : ">-12h"
				}, {
					'label' : 'Last 24 hours',
					'value' : ">-24h"
				}, {
					'label' : 'Last 7 days',
					'value' : ">-7d"
				}, {
					'label' : 'Last 1 month',
					'value' : ">-1M"
				}, {
					'label' : 'Last 1 year',
					'value' : ">-1y"
				}, ];
				// $scope.component.relativeTimes = "<15m,<1h,<12h,<24h,<7d,<1M,<1y";
			}
			// $scope.relativeTimes = ($scope.component.relativeTimes || "").split(",");

			if ($scope.exportType) {
				$scope.setAllComponentsIntialized($scope.component);
			}
		};
		$scope.init();

		$scope.doRangeQuery = function() {
			if ($scope.component.rangeType == 'absolute' && $.isEmptyObject($scope.component.dateRange.absolute)) {
				customReportSvc("Please select a date range");
				return;
			}
			if ($scope.component.rangeType == 'relative' && $.isEmptyObject($scope.component.dateRange.relative)) {
				customReportSvc("Please select a relative time");
				return;
			}
			var options = {
				dataSet : $scope.dataSet,
				componentType : $scope.component.type,
				field : $scope.component.dateRangeField,
				rangeType : $scope.component.rangeType,
				range :  _.clone($scope.component.dateRange[$scope.component.rangeType]),
			}

			if ($scope.dataSet.endpoint === "DATACUBE") {
				//ideally we should call addFilters as this is filter operation not data operation
				// $dataSource.getDataSource($scope.dataSet.endpoint).applyDateRange(options, function(isSuccess) {
				// 	// TODO: put a error check in case of failure
				// 	if (isSuccess) {
				// 		customReportSvc.triggerCallback("redrawAllComponents");
				// 	}
				// });
				$scope.addFilters(options.field,
						options.range,
						$scope.component,
						false,
						true,
						undefined,
						false,
						'viewer',
						'include',
						true);
			} else {
				var key = $scope.component.id + ".filter." + $scope.component.dateRangeField;
				var value = $scope.getValue($scope.component.dateRange[$scope.component.rangeType]);
				if (value === $scope.requestParms[key]) {
					return;
				}
				if (value) {
					$scope.addFilters($scope.component.dateRangeField,
							value,
							$scope.component,
							false,
							true,
							undefined,
							undefined,
							"viewer",
							"include",
							true);
				}

			}

		};

		$scope.dropped = function(dragEl, dropEl) {
			// Because the handler jumps "outside" of angular, updates must be
			// made in an $applied scope

			var dest = document.getElementById(dropEl);
			var src = document.getElementById(dragEl);

			var drag = angular.element(src);
			var drop = angular.element(dest);
			var columnName = drag.attr("data-name");
			var type = drag.attr("data-type");
			var dataSetEntity = drag.data("datasetentity");
			var dataSetName = drag.parent().parent().data("datasetname");
			if (!$scope.component.dataSet || !$scope.component.dataSet.dataSetName) {
				$scope.associateDataSetToComponent(dataSetEntity);
			} else if ($scope.component.dataSet.dataSetName != dataSetName) {
				alert("Mismatched data Sets");
				return;
			}
			if (dates.indexOf(drag.attr("data-type")) == -1) {
				customReportSvc.errorToast("Only field of type TimeStamp, Date or Integer(Unix Time) can be dropped.");
				return;
			}

			$scope.component.dateRangeField = columnName;
			$scope.component.dateRangeType = type; // type need to distinguish between date and time stamp
			$scope.$apply();
		};
		$scope.registerLocalCallBack = function(name, callback, sourceId) {
			customReportSvc.registerCallback(name, callback, sourceId);
		};

		$scope.registerLocalCallBack("validateRelativeTime", function() {
			$scope.validateRelativeTime();
		});

		$scope
				.registerLocalCallBack("dateRangeUpdated",
						function() {
							if ($scope.component.rangeType === 'absolute' &&
									($.isEmptyObject($scope.component.dateRange.absolute) ||
											!$scope.component.dateRange.absolute.from || !$scope.component.dateRange.absolute.to)) {
								return;
							}
							if ($scope.component.rangeType === 'relative' && !$scope.component.dateRange.relative) {
								return;
							}
							$scope.doRangeQuery();
						},
						$scope.component.id);

		$scope.registerLocalCallBack("clearDateRange", function(componentId) {
			if ($scope.component.id === componentId) {
				$scope.doRangeQuery();
				$("li[comp=" + $scope.component.id + "] .dateRangeInput").val("");
			}
		});

		$scope.validateRelativeTime = function() {
			var isValid = true;
			if (!$scope.component.relativeTimes) {
				return;
			}
			customReportSvc.triggerCallback('relativeRangeUpdated', $scope.component.id);
		};

		$scope.showCalender = function (e) {
			var dateRangePicker = $(".dateRangeInput",e.currentTarget.parentElement);
			dateRangePicker.data("daterangepicker").show();
		};
	}
})();
