(function() {
	'use strict';

	//angular.module("reports").controller('gglotCtrl', gglotCtrl);

	//gglotCtrl.$inject = [ '$scope', 'reportService', 'customReportSvc', 'dataSource', '$timeout' ];

	//function gglotCtrl($scope, customReportSvc,reportService, $dataSource, $timeout) {

	var app = angular.module("reports");

	app.controller("gglotCtrl", [
			"$scope",
			"reportService",
			"customReportSvc",
			"dataSource",
			"$timeout",
			function($scope, reportService, customReportSvc, $dataSource, $timeout) {

				customReportSvc.registerCallback("redrawAllComponents", function(data) {
					$scope.fetchDetailsAndLoadImage();
				});

				var maskDOM = function($selector, content) {
					$selector.mask(content);
				}

				var getHeightOfBuilderPage = function(compId) {
					var pageHeight = $("ul li[comp = " + compId + "]").height();

					var toggleBut = $("ul li[comp = " + compId + "]").find(".toggleButton").height();
					var submitBut = $("ul li[comp = " + compId + "]").find(".submitButton").height();

					if($.isNumeric(toggleBut) && $.isNumeric(submitBut)) {
						pageHeight = pageHeight - (toggleBut - submitBut);
					}
					
					return pageHeight - 70;

					/*
					 * if ((pageHeight - 50) > 0) { return pageHeight - 70; } else { return 500; // by default }
					 */
				}

				var getWidthOfBuilderPage = function(compId) {
					var width = $("ul li[comp = " + compId + "]").width();
					if (width - 50 > 0) {
						return width - 50;
					} else {
						return 500;
					}
				}

				var updateImageProperties = function(compId) {

					if ($.isEmptyObject(compId) == true) {
						return;
					}

					var height = getHeightOfBuilderPage(compId);
					//var width = getWidthOfBuilderPage(compId);
					var width = "100%";
					var selector;
					if ($("ul li[comp = " + compId + "]").find("#rImage").is(":visible") == true) {
						selector = "#rImage img";
					} else {
						selector = ".inputArea .scriptArea";

					}

					$("ul li[comp = " + compId + "]").find(selector).css("width", width);
					$("ul li[comp = " + compId + "]").find(selector).css("height", height);
				}

				var loadImageWithPOST = function(url, params, $compId, $selector) {

					var inputParams = {};
					var $chart = $("ul li[comp = " + $scope.component.id + "]");
					//maskDOM($chart, "Fetching Image");
					cvUtil.loadPageWithPOST(url, params, $scope.successFn, $scope.errorFn);
				}//func;

				var updateGGPlotList = function(rScript) {
					var i = 0;
					var curElement;
					var alreadyAvailable = false;
					for (i = 0; i < $scope.dataSet.computedColumns.ggPlotScriptList.length; i++) {
						curElement = $scope.dataSet.computedColumns.ggPlotScriptList[i];

						if (curElement.name == $scope.component.id) {
							$scope.dataSet.computedColumns.ggPlotScriptList[i].value = rScript;
							alreadyAvailable = true;
							break;
						}
					}//for

					if (alreadyAvailable == false) {
						var curGGPlot = {
							name : $scope.component.id,
							value : rScript
						}
						$scope.dataSet.computedColumns.ggPlotScriptList.push(curGGPlot);
					}

				}//func

				$scope.getRDataSets = function() {
					var rDataSets = [];
					var dataSetGuid;
					var curRDataSet, curDataSet;
					var rDataList = $scope.component.rDataSetList.rDataSets;
					var isDataSetAdded;
					var deletedDataSets = [];

					for (var i = 0; i < rDataList.length; i++) {
						curRDataSet = rDataList[i];
						isDataSetAdded = false;

						for (var j = 0; j < $scope.dataSets.length; j++) {
							curDataSet = $scope.dataSets[j];

							dataSetGuid = curDataSet.dataSet.dataSetGuid;

							if (dataSetGuid == curRDataSet.dataSet.dataSetGuid) {
								rDataSets.push(curDataSet)
								isDataSetAdded = true;
								break;
							}
						}//inner

						if (isDataSetAdded == false) {
							//if this occurs , then that data set must be deleted.
							deletedDataSets.push(i);
						}

					}//outer

					var curIndex;
					for (var i = 0; i < deletedDataSets.length; i++) {
						curIndex = deletedDataSets[i];
						$scope.component.rDataSetList.rDataSets.splice(curIndex, 1);
					}

					return rDataSets;
				}//func;

				$scope.fetchDetailsAndLoadImage = function() {

					var $chart = $("ul li[comp = " + $scope.component.id + "]");
					//maskDOM($chart, "Fetching Image");

					if ($scope.reportMode == "viewer") {
						$chart.find(".reportstabletitle").removeClass("ng-hide");
					}

					$scope.getData().then(function(data) {

						$scope.successFn(data);
						$scope.component.isComponentLoading = false;

						if ($scope.exportType) {
							$scope.setAllComponentsIntialized($scope.component);
						}

					}, function(data) {
						$scope.errorFn(data);
						$scope.component.isComponentLoading = false;
					});
				}

				$scope.isDataSetAssociated = function() {
					if ($.isEmptyObject($scope.component) || $.isEmptyObject($scope.component.rDataSetList) ||
							$.isEmptyObject($scope.component.rDataSetList.rDataSets)) {
						alert("No dataSet associated with component");
						return 0;
					}
					return 1;
				}

				$scope.handleSubmitClick = function() {

					if ($scope.isDataSetAssociated()) {

						var rScript = $("ul li[comp = " + $scope.component.id + "]").find(".scriptArea").val();

						if ($.isEmptyObject(rScript) || rScript.trim() == "") {
							alert("Script is empty");
							return;
						}

						$scope.component.rDataSetList.rScript = rScript

						$scope.fetchDetailsAndLoadImage();
					}
				}

				$scope.dropped = function(dragEl, dropEl) {
					var dest = document.getElementById(dropEl);
					var src = document.getElementById(dragEl);

					var drag = angular.element(src);
					var drop = angular.element(dest);
					var columnName = drag.attr("data-name");
					var dataSetEntity = drag.data("datasetentity");
					var dataSetName = dataSetEntity.dataSetName;

					if (!$scope.component.dataSet || !$scope.component.dataSet.dataSetName) {
						$scope.associateDataSetToComponent(dataSetEntity);
					} else if ($scope.component.dataSet.dataSetName != dataSetName) {
						alert("Mismatched data Sets");
						return;
					}

					//$(".drop_" + $scope.component.id).hide();

					if ($scope.dataSet.endpoint != "R") {
						alert("Please drop a valid dataset or column");
						return;
					}

					$scope.fetchDetailsAndLoadImage();
				}//dropped

				$scope.successFn = function(response) {
					var $chart = $("ul li[comp = " + $scope.component.id + "]");
					var width, height;
					if ($scope.reportMode == "viewer") {
						width = $chart.width();
						height = $chart.height() - 50;
						$chart.find(".reportstabletitle").removeClass("ng-hide");

					} else {
						width = getWidthOfBuilderPage($scope.component.id);
						height = getHeightOfBuilderPage($scope.component.id);
					}

					var $selector = $("ul li[comp = " + $scope.component.id + "]").find("#rImage");

					if ($.isEmptyObject(response) == true || $.isEmptyObject(response.data) == true ||
							$.isEmptyObject(response.data.imgData) == true || response.data.isError == undefined) {
						alert("something went wrong. Please check logs.");
						$chart.unmask();
						return;
					}

					if (response.data.isError == 0) {

						var img = new Image();
						img.src = "data:image/png;base64, " + response.data.imgData;
						img.width = width;
						img.height = height;
						showToggleArea();
						showImageArea();
						$selector.html(img);

					} else {
						alert(response.data.imgData);
						$selector.html("");
					}

					$chart.unmask();
				}

				$scope.errorFn = function(data) {

					var message = "Failed";

					if ($.isEmptyObject(data) == false && $.isEmptyObject(data.data) == false &&
							data.data.errorCode != 0) {
						if ($.isEmptyObject(data.data.errorMessage) == false) {
							message = data.data.errorMessage;
						}
					}

					//clearing image in case of failure.
					var $selector = $("ul li[comp = " + $scope.component.id + "]").find("#rImage");
					$selector.html("");

					alert(message);

					$("ul li[comp = " + $scope.component.id + "]").unmask();
				}

				var showToggleArea = function() {
					if ($scope.reportMode != "viewer") {
						$("ul li[comp = " + $scope.component.id + "]").find(".toggleButton").show();
					}
				}

				var showImageArea = function() {
					$("ul li[comp = " + $scope.component.id + "]").find(".inputArea").hide();
					$("ul li[comp = " + $scope.component.id + "]").find("#rImage").show();
					var $selector = $("ul li[comp = " + $scope.component.id + "]").find("#rImage");
					var height = getHeightOfBuilderPage($scope.component.id);
					$selector.css("height", height);
				}

				var showInputArea = function() {
					$("ul li[comp = " + $scope.component.id + "]").find(".inputArea").show();
					$("ul li[comp = " + $scope.component.id + "]").find("#rImage").hide();
					var $selector = $("ul li[comp = " + $scope.component.id + "]").find(".inputArea .scriptArea");
					var height = getHeightOfBuilderPage($scope.component.id);
					$selector.css("height", height);
					$selector.css("width", "100%");
				}

				var reloadDOMValues = function() {
					var i;
					var curElement;

					if ($.isEmptyObject($scope.component) == true ||
							$.isEmptyObject($scope.component.rDataSetList) == true ||
							$.isEmptyObject($scope.component.rDataSetList.rScript) == true) {
						alert("Missing datasource or script")
						return;
					}

					showInputArea();
					$("ul li[comp = " + $scope.component.id + "]").find(".scriptArea")
							.val($scope.component.rDataSetList.rScript);
				}

				$scope.init = function() {
					if (!$scope.component.captionPosition) {
						$scope.component.captionPosition = 'top';
					}
					if ($.isEmptyObject($scope.component.color)) {
						$scope.component.color = {
							'captionColor' : '#000',
							'countColor' : '#000',
						};
					}
					if (!$scope.component.alignment) {
						$scope.component.alignment = 'center';
					}
					if (typeof $scope.component.hideHeader === 'undefined') {
						$scope.component.hideHeader = true;
					}

					if ($scope.reportMode == "viewer") {

						$("ul li[comp = " + $scope.component.id + "]").find("#dropDOM").hide();

					} else {
						//$("#R-ScriptArea_" + $scope.component.id).hide();
						//reloadDOMValues();
						$("ul li[comp = " + $scope.component.id + "]").find("#dropDOM").show();
					}

					if ($.isEmptyObject($scope.dataSet) == false) { // To avoid initial call for a component.	
						$scope.fetchDetailsAndLoadImage();
					}
				};
				$scope.init();

				$scope.handleClick = function() {
					//$("ul li[comp = " + $scope.component.id + "]").find(".inputArea").toggle();
					var $selector;
					if ($("ul li[comp = " + $scope.component.id + "]").find(".inputArea").is(":visible") == true) {
						//show image
						showImageArea();

					} else {
						//show text
						showInputArea();
					}

					//updateImageProperties($scope.component.id);
				}

				$scope.$on('resize', function(sizes, gridster) {
					if (gridster && gridster.length > 1) {
						var componentResizedScope = angular.element(gridster[1]).scope();
						var component = componentResizedScope.$parent.component;
						var currentCompId = component.id;

						updateImageProperties(currentCompId);
					}
				});

			} ]);

})();