<!-- FIXME: Localize -->
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>

<fmt:bundle basename="localization.ReportsPlusMessages">
<label class="radio-inline"><input type="radio" data-ng-model="dataSet.allColumns" data-ng-value="true"><fmt:message key="DataSet.Preview.Fields.AllFields"/></label>
<label class="radio-inline"><input type="radio" data-ng-model="dataSet.allColumns" data-ng-value="false" data-ng-change="showSpecificColumns()"><fmt:message key="DataSet.Preview.Fields.ShowSpecificFields"/></label>

<div class="pull-right" id="fieldButtonWrapper" data-ng-hide="dataSet.allColumns == true">
     <a class="btn btn-default btn-sm" data-ng-click="addField()">
        <span class="sprite icon-plus v-middle"></span>&nbsp;&nbsp;<fmt:message key="CustomReport.Add"/>
    </a>
    <a class="btn btn-default btn-sm" data-ng-click="deleteCurrentField()" data-ng-disabled="currentFieldIndex < 0"><fmt:message key="CustomReport.Delete"/></a>
    <a class="btn btn-default btn-sm" data-ng-click="moveField('down')" title="Move field down" data-ng-disabled="currentFieldIndex < 0">&#8595;</a>
    <a class="btn btn-default btn-sm" data-ng-click="moveField('up')" title="Move field up" data-ng-disabled="currentFieldIndex < 0">&#8593;</a>
</div>

<br>
<br>

<div class="row sectionHeader text-center" data-ng-show="dataSet.endpoint === 'DATABASE' && !dataSet.allColumns">
	<div class="col-xs-6"><fmt:message key="DataSet.Preview.Fields.FieldSource"/></div>
	<div class="col-xs-6"><fmt:message key="DataSet.Preview.Fields.FieldName"/></div>
</div>
<div class="row sectionWrapper" id="fieldsView" data-ng-show="dataSet.endpoint === 'DATABASE' && !dataSet.allColumns" >
	<div class="row movableRow" data-ng-class="{ current : isCurrentField($index) }" data-ng-repeat="field in dataSet.fields" data-ng-hide="field.name.indexOf('!') == 0" data-ng-click="setCurrentField($index)">
		<div class="col-xs-6">
			<input class="form-control input-sm" type="text" data-ng-readonly="field.name == 'sys_rowid' ? false : true" data-ng-model="field.dataField">
		</div>
		<div class="col-xs-6">
			<input class="form-control input-sm" type="text" data-ng-readonly="field.name == 'sys_rowid' ? true : false" data-ng-init="field.originalName = field.name" data-ng-model="field.name" data-ng-blur="fieldNameChanged()">
		</div>
	</div>
</div>
<div class="row sectionHeader text-center" data-ng-show="dataSet.endpoint === 'HTTP' && !dataSet.allColumns">
	<div class="col-xs-6">{{ dataSet.GetOperation.headers[0].value === "application/xml" ? "XPath" : "JSONPath" }} &nbsp;<fmt:message key="DataSet.Preview.Fields.Expression"/></div>
	<div class="col-xs-3"><fmt:message key="DataSet.Preview.Fields.FieldName"/></div>
	<div class="col-xs-3"><fmt:message key="DataSet.Preview.Fields.FieldType"/></div>
</div>
<div class="row sectionWrapper" id="fieldsView" data-ng-show="dataSet.endpoint === 'HTTP' && !dataSet.allColumns">
	<div class="row movableRow" data-ng-class="{ current : isCurrentField($index) }" data-ng-repeat="field in dataSet.fields">
		<div class="col-xs-6">
			<input class="form-control input-sm" type="text" data-ng-model="field.dataField" data-ng-focus="setCurrentField($index)">
		</div>
		<div class="col-xs-3">
			<input class="form-control input-sm field" type="text" data-ng-init="field.originalName = field.name" data-ng-model="field.name" data-ng-focus="setCurrentField($index)" data-ng-blur="fieldNameChanged()">
		</div>
		<div class="col-xs-3">
			<select class="form-control input-sm" data-ng-model="field.type" data-ng-focus="setCurrentField($index)" data-ng-options="fieldType for fieldType in fieldTypes" ></select>
		</div>
	</div>
</div>
</fmt:bundle>