(function() {
	'use strict';

	var reports = angular.module("reports");

	reports.controller('rDataSetCtrl', [
			'$scope',
			'customReportSvc',
			'reportService',
			function($scope, customReportSvc, reportService) {

				$scope.showOnlySelected = false;
				$scope.operation = "Add";
				$scope.rDataSetList = [];
				$scope.curRdataSet = undefined;

				$scope.addDataSetList = function() {
					//Iterate rDataSetList to find only selected dataSets and fields.

					var selectedFields;
					var curRObj, selectedFields, selectedDataSets = [];

					angular.forEach($scope.rDataSetList, function(rDataSet) {
						if (rDataSet.includeThisDataSet == true) {
							selectedFields = [];

							if (rDataSet.includeAllColumns == false) {
								angular.forEach(rDataSet.fields, function(field) {
									if (field.isIncluded == true) {
										selectedFields.push(field.field);
									}
								});
							}

							curRObj = {
								includeThisDataSet : true,
								includeAllColumns : rDataSet.includeAllColumns,
								dataSet : rDataSet.dataSet,
								fields : selectedFields
							}

							selectedDataSets.push(curRObj);
						}
					});

					if ($.isEmptyObject($scope.dataSet.GetOperation.rDataSetListInfo)) {
						var rDataSetListInfoObj = {
							rDataSets : selectedDataSets,
							rScript : ""
						}

						$scope.dataSet.GetOperation.rDataSetListInfo = rDataSetListInfoObj;
					} else {
						$scope.dataSet.GetOperation.rDataSetListInfo.rDataSets = selectedDataSets;
					}

					$scope.$close('close');

				}

				$scope.dismissrDataSet = function() {
					$scope.$dismiss('cancel');
				}

				$scope.includeDataSet = function(rDataSet) {
					angular.forEach(rDataSet.fields, function(field) {
						field.isIncluded = rDataSet.includeThisDataSet;
					});
					rDataSet.includeAllColumns = rDataSet.includeThisDataSet;
					$scope.showFields(rDataSet);
				}

				$scope.showFields = function(rDataSet) {
					$scope.curRdataSet = rDataSet;
					$("li").removeClass("current");
					$("." + rDataSet.dataSet.dataSetGuid).addClass("current");
				}

				$scope.updateAllFields = function(rDataSet) {
					angular.forEach(rDataSet.fields, function(field) {
						field.isIncluded = rDataSet.includeAllColumns;
					});
				}

				$scope.updateIncludeAllColumns = function(curRdataSet, isFieldIncluded) {
					if (isFieldIncluded == false && curRdataSet.includeAllColumns == true) {
						//if particular field is unchecked , then AllFields column should be false.
						curRdataSet.includeAllColumns = false;
					} else if (isFieldIncluded == true) {
						//checking if all fields are true , then making includeAllColumns to true.
						var isAllFieldsInclude = true;
						for (var i = 0; i < curRdataSet.fields.length; i++) {
							if (curRdataSet.fields[i].isIncluded == false) {
								isAllFieldsInclude = false;
								break;
							}
						}//for

						curRdataSet.includeAllColumns = isAllFieldsInclude;
					}
				}

				$scope.init = function() {
					var defaultSelectedDataSet = undefined;
					var rDataSets = [], fields = [];
					var dataSetGuid = "", includeThisDataSet, includeAllColumns;
					//Check if this edit operation.
					if (!$.isEmptyObject($scope.dataSet) && !$.isEmptyObject($scope.dataSet.GetOperation) &&
							!$.isEmptyObject($scope.dataSet.GetOperation.rDataSetListInfo) &&
							!$.isEmptyObject($scope.dataSet.GetOperation.rDataSetListInfo.rDataSets)) {
						$scope.showOnlySelected = true;
						$scope.operation = "Edit";
						rDataSets = $scope.dataSet.GetOperation.rDataSetListInfo.rDataSets;
					}

					for (var index = 0; index < $scope.dataSets.length; index++) {
						var dataSet = $scope.dataSets[index];

						if (dataSet.endpoint == "R") {
							continue;
						}

						dataSetGuid = dataSet.dataSet.dataSetGuid;
						includeThisDataSet = false;
						includeAllColumns = false;
						var rFields = [];
						var fieldList = [];

						for (var i = 0; i < rDataSets.length; i++) {
							var rDataSet = rDataSets[i];
							if (rDataSet.dataSet.dataSetGuid == dataSetGuid) {

								if (defaultSelectedDataSet == undefined) {
									//First time when comes here , make it as a default selected dataset, to show fields of it by default.
									defaultSelectedDataSet = true;
								}

								if (rDataSet.includeThisDataSet == true) {
									includeThisDataSet = true;
								}

								if (rDataSet.includeAllColumns == true) {
									includeAllColumns = true;
								} else {
									rFields = rDataSet.fields;
								}

								break;
							}
						}//inner

						for (var i = 0; i < dataSet.fields.length; i++) {
							var curField = dataSet.fields[i];
							var isIncluded = false;

							if (includeAllColumns == false) {
								for (var j = 0; j < rFields.length; j++) {
									if (rFields[j].name == curField.name) {
										isIncluded = true;
										break;
									}
								}
							} else {
								isIncluded = true;
							}

							var curFieldObj = {
								isIncluded : isIncluded,
								field : curField
							}

							fieldList.push(curFieldObj);
						}//outer

						var curRDataSet = {
							dataSet : dataSet.dataSet,
							fields : fieldList,
							includeThisDataSet : includeThisDataSet,
							includeAllColumns : includeAllColumns,
							defaultDataSet : (defaultSelectedDataSet == true) ? true : false
						}

						if (defaultSelectedDataSet == true) {
							defaultSelectedDataSet = false;
							//To avoid next data set to be default selected dataset.
						}

						$scope.rDataSetList.push(curRDataSet);
					}

					if (defaultSelectedDataSet == undefined && !$.isEmptyObject($scope.rDataSetList) &&
							$scope.rDataSetList.length > 0) {
						$scope.rDataSetList[0].defaultDataSet = true;
					}

				}//init

				$scope.init();

			} ]);

}());