<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>

<c:set var="isDcubeEnabledInCustomReports" value="${cvConfig.isDcubeEnabledInCustomReports()}"/>
<c:set var="isComputedColumnEnabled" value="${cvConfig.isComputedColumnEnabled()}"/>
<span data-ng-if="includeBootStrap">
	<link rel="stylesheet" title="bsStyle" href="${pageContext.request.contextPath}/common/bootstrap/css/bootstrap.min.css?${applicationScope.BUILD_TS}">
</span>
<fmt:bundle basename="localization.ReportsPlusMessages">
<div id="reportArea">
<div id="addDataSetModal" cv-draggable drag-handler=".modal-header" drag-parent=".modal-dialog">
<!-- FIXME: Localize -->
    <!-- Modal header -->
	<div class="modal-header">
		<h3 class="modal-title"><span data-ng-if="mode === 'Add'"><fmt:message key="CustomReport.Add"/>&nbsp;</span><span data-ng-if="mode === 'Edit'"><fmt:message key="CustomReport.Edit"/>&nbsp;</span><fmt:message key="CustomReport.Properties.DataSet"/>
			<div class="btn-group pull-right">
				<button class="btn btn-default dropdown-toggle" type="button" id="dropdownMenu1" data-toggle="dropdown">
				{{ endPointLabel}}&emsp;<span class="caret"></span>
				</button>
				<ul class="dropdown-menu">
					<li data-ng-class="{ active: endpoint === 'DATABASE' }"><a data-ng-click="updateEndpoint('DATABASE')"><fmt:message key="DataSet.Preview.Database"/></a></li>
					<li data-ng-class="{ active: endpoint === 'HTTP' }"><a data-ng-click="updateEndpoint('HTTP')"><fmt:message key="DataSet.Preview.HTTP"/></a></li>
				    	<c:if test="${isDcubeEnabledInCustomReports eq true}" >
					    <li data-ng-class="{ active: endpoint === 'DATACUBE' }"><a data-ng-click="updateEndpoint('DATACUBE')"><fmt:message key="DataSet.Preview.Datacube"/></a></li>
					</c:if>
					<li data-ng-class="{ active: endpoint === 'MONITORING_POLICY' }"><a data-ng-click="updateEndpoint('MONITORING_POLICY')"><fmt:message key="DataSet.Preview.MonitoringPolicy"/></a></li>
					<li data-ng-class="{ active: endpoint === 'DATASET' }"><a data-ng-click="updateEndpoint('DATASET')"><fmt:message key="DataSet.Preview.JoinDataset"/></a></li>
					<li data-ng-class="{ active: endpoint === 'SCRIPT' }"><a data-ng-click="updateEndpoint('SCRIPT')"><fmt:message key="DataSet.Preview.Script"/></a></li>
					<li data-ng-class="{ active: endpoint === 'SHARED' }"><a data-ng-click="updateEndpoint('SHARED')"><fmt:message key="DataSet.Preview.Shared"/></a></li>
					<li data-ng-class="{ active: endpoint === 'R' }"><a data-ng-click="updateEndpoint('R')"><fmt:message key="DataSet.Preview.R"/></a></li>
					<c:if test="${isComputedColumnEnabled eq true}" >
						<li data-ng-class="{ active: endpoint === 'PYTHON3' }"><a data-ng-click="updateEndpoint('PYTHON3')"><fmt:message key="DataSet.Preview.PYTHON3"/></a></li>
					</c:if>

				</ul>
			</div>
			<div class="guid-label" data-ng-hide="dataSet.endpoint === 'DATACUBE' || (!dataSet.shared &amp;&amp; !customReport.guid)"><label>Id &nbsp;</label><a class="ng-binding" title="Click to copy" data-ng-click="copyRestApiUrlToClipboard()">{{getDataSetGuid()}}</a></div>
		</h3>
	</div>

	<!-- End modal header -->

    <!-- Modal body -->
    <div id="addDataSetModalBodyWrapper">
        <div id="addDataSetLeftPane" class="col-xs-2">
            <ul class="noSelect">
                <li data-ng-class="{ current: isCurrentTab('query') }"
                    data-ng-click="setCurrentTab('query')">
                    <fmt:message key="DataSet.Preview.Query"/>
                </li>
                <li data-ng-hide="endpoint === 'DATACUBE' || endpoint === 'MONITORING_POLICY'"  data-ng-class="{ current: isCurrentTab('fields') }"
                    data-ng-click="setCurrentTab('fields')">
                    <fmt:message key="DataSet.Preview.Fields"/>
                </li>

                <li data-ng-class="{ current: isCurrentTab('parameters') }"
                    data-ng-click="setCurrentTab('parameters')">
                    <fmt:message key="DataSet.Preview.Parameters"/>
                </li>

                <li data-ng-hide="endpoint === 'DATACUBE' || endpoint === 'MONITORING_POLICY'"  data-ng-class="{ current: isCurrentTab('advanced') }"
                    data-ng-click="setCurrentTab('advanced')">
                    <fmt:message key="DataSet.Preview.Advanced"/>
                </li>

				<li data-ng-hide="endpoint !== 'DATABASE'" data-ng-class="{ current: isCurrentTab('computed columns') }"
					data-ng-click="setCurrentTab('computed columns')">
					Computed Columns
				</li>
			
			</ul>
        </div>

        <!-- Right pane of modal -->
        <div id="addDataSetRightPane" class="col-xs-10">
            <!-- Query tab view -->
            <div id="queryView"
                 data-ng-show="isCurrentTab('query')"
                 data-ng-include="'${pageContext.request.contextPath}/reportsplus/addDataSetModal/views/query.jsp'"
                 data-ng-controller="queryViewCtrl"></div>
            <!-- End query tab view -->

            <!-- Fields tab view -->
            <div id="fieldsView"
                 data-ng-show="isCurrentTab('fields')"
                 data-ng-include="'${pageContext.request.contextPath}/reportsplus/addDataSetModal/views/fields.jsp'"
                 data-ng-controller="fieldsViewCtrl"></div>
            <!-- End fields tab view -->

            <!-- Parameters tab view -->
            <div id="parametersView"
                 data-ng-show="isCurrentTab('parameters')"
                 data-ng-include="'${pageContext.request.contextPath}/reportsplus/addDataSetModal/views/parameters.jsp'"
                 data-ng-controller="parametersViewCtrl"></div>
            <!-- End parameters tab view -->

            <!-- Advanced tab view -->
            <div id="advancedView"
                 data-ng-show="isCurrentTab('advanced')"
                 data-ng-include="'${pageContext.request.contextPath}/reportsplus/addDataSetModal/views/advanced.jsp'"
                 data-ng-controller="advancedViewCtrl"></div>
            <!-- End Advanced tab view -->

            <div id="fieldsView"
                 data-ng-show="isCurrentTab('computed columns')"
                 data-ng-include="'${pageContext.request.contextPath}/reportsplus/addDataSetModal/views/computedColumn.jsp'"
                 data-ng-controller="fieldsViewCtrl">
			</div>

        </div>
        <!-- <div class="rowIdExpression" data-ng-show="isCurrentTab('fields')">
	            <span  class="ngLabel">Row Id</span>
	            	<input type="text" id="rowExpressionEdit" data-ng-model="dataSet.rowId">
	            	<select id="rowExpressionSelect" data-ng-model="dataSet.rowId">
		            	<option value=""></option>
		            	<option data-ng-repeat="field in dataSet.fields" value="row['{{field.name}}']">{{field.name}}</option>
	            	</select>
		</div> -->
        <!-- End right pane of modal -->
        <div class="previewButtonPanel">
	            <a class="btn btn-default" data-ng-click="previewData()"><fmt:message key="DataSet.Preview.Preview"/></a>
	            <span  class="ngLabel"><fmt:message key="DataSet.Preview.SelectTop"/></span>
	            <select data-ng-model="dataSet.previewRowSize" class="previewSelect" data-ng-change="previewData(true)" data-ng-options="pValue.value as pValue.label for pValue in previewRows"> </select>
		</div>
    </div>

 <div data-ng-if="showPreviewTable">
	<ul class="nav nav-tabs" data-ng-show="dataSet.endpoint === 'HTTP'">
		<li class="active"><a data-toggle="tab" href="#previewDataTable"><fmt:message key="DataSet.Preview.Table"/></a></li>
		<li><a data-toggle="tab" href="#previewRawData"><fmt:message key="DataSet.Preview.RawData"/></a></li>
	</ul>

	<div class="tab-content">
		<div class="tab-pane active" id="previewDataTable">
			<ul>
				<li comp="{{component.id}}">
					<div data-ng-include="'${pageContext.request.contextPath}/reportsplus/templates/reportComponents/component.jsp'"></div>
				</li>
			</ul>
		</div>
		<div class="tab-pane" id="previewRawData">
		<div class="tableMaskLayer tableContainer" data-ng-class="{'isMasked':rawDataLoading}">
						<label class='maskLayerLabel' data-ng-show="rawDataLoading">Loading...</label>
			<div data-ng-repeat="rawDataMember in rawData" data-ng-show="rawData">
				<h4>
					<strong><fmt:message key="DataSet.Preview.DataSource"/>: {{ rawDataMember.dataSource }}</strong>
				</h4>
				<pre>{{ rawDataMember.data }}</pre>
				<br>
			</div>
			</div>
			<div class="tab-pane" id="previewRawData" data-ng-show="!rawData">
				<p>
					<br> <br> <strong><fmt:message key="CustomReport.NoDataAvailable"/></strong>
				</p>
			</div>
		</div>
	</div>
</div>

    <!-- End modal body -->

    <!-- Modal footer -->
    <div class="modal-footer">
        <!-- <a class="btn btn-default btn-sm pull-left">Help</a> -->
        <a class="btn btn-primary btn-sm pull-right" data-ng-click="addDataSet()"><span data-ng-if="!sharedMode"><fmt:message key="CustomReport.Done"/>&nbsp;</span><span data-ng-if="sharedMode"><fmt:message key="CustomReport.Save"/>&nbsp;</span></a>
        <a class="btn btn-primary btn-sm pull-right" data-ng-if="sharedMode" data-ng-click="saveAndDeploy()"><fmt:message key="CustomReport.SaveAndDeploy"/></a>
        <a class="btn btn-default btn-sm pull-right" data-ng-click="dismissDataSet()"><fmt:message key="CustomReport.Cancel"/></a>
    </div>
    <!-- End modal footer -->
</div>
</div>
</fmt:bundle>
