var Bytes = 1;
var KB = 1024;
var MB = KB * 1024;
var GB = MB * 1024;
var TB = GB * 1024;
var PB = TB * 1024;
var EB = PB * 1024;
var THOUSAND = 1000;
var MILLION = THOUSAND * THOUSAND;
var BILLION = MILLION * THOUSAND;
var TRILLION = BILLION * THOUSAND;

var capacity = capacity || {};
capacity.units = {
	'Bytes' : Bytes,
	'KB' : KB,
	'MB' : MB,
	'GB' : GB,
	'TB' : TB,
	'PB' : PB,
	'EB' : EB
};
capacity.unitsMB = {
	'MB' : Bytes,
	'GB' : KB,
	'TB' : MB,
	'PB' : GB,
	'EB' : TB
};

var reportsUtil = {};
reportsUtil.jobStatus = {};
reportsUtil.jobStatus.POOL_TIME = 20000;
reportsUtil.jobStatus.JOBS_COOKIE_NAME = "jobList";
reportsUtil.jobStatus.NOTIFICATIONS_MAX_ENTRIES = 15;
reportsUtil.jobStatus.NOTIFICATIONS_MAX_SIZE = 2000;
reportsUtil.UUID = cvUtil.generateUUID();
window.urlParamDelimiter = "-";

function autoConvert(val) {
	if (isNaN(val)) {
		return val;
	}
	if (val < 0) {
		return "N/A";
	}
	if (val < KB) {
		return val + " Bytes";
	}
	if (val < MB) {
		return convert(val / KB) + " KB";
	}
	if (val < GB) {
		return convert(val / MB) + " MB";
	}
	if (val < TB) {
		return convert(val / GB) + " GB";
	}
	if (val < PB) {
		return convert(val / TB) + " TB";
	}
	if (val < EB) {
		return convert(val / PB) + " PB";
	}
	return convert(val / EB) + " EB";
}

function autoConvertNumber(val) {
	if (isNaN(val)) {
		return val;
	}

	if (val < 0) {
		return "N/A";
	}

	if (val < THOUSAND) {
		return val;
	}
	if (val < MILLION) {
		return convert(val / THOUSAND) + "K";
	}

	if (val < BILLION) {
		return convert(val / MILLION) + "M";
	}

	if (val < TRILLION) {
		return convert(val / BILLION) + "B";
	}

	return convert(val / TRILLION) + "T";
}

function autoConvertFromMB(val, acceptNegative) {
	var vNeg = false;
	var retval = '';
	if (acceptNegative && val < 0) {
		vNeg = true;
		val = -val;
	}
	if (val < 0) {
		retval = "N/A";
	} else if (val == 0) {
		retval = "0 Bytes";
	} else if (val < KB) {
		retval = val + " MB";
	} else if (val < MB) {
		retval = convert(val / KB) + " GB";
	} else if (val < GB) {
		retval = convert(val / MB) + " TB";
	} else if (val < TB) {
		retval = convert(val / GB) + " PB";
	} else {
		retval = convert(val / TB) + " EB";
	}
	if (vNeg) {
		retval = '-' + retval;
	}
	return retval;
}

function convertLicenseCapacity(val, acceptNegative) {
	var vNeg = false;
	var retval = '';
	if (acceptNegative && val < 0) {
		vNeg = true;
		val = -val;
	}
	if (val < 0) {
		retval = "N/A";
	} else if (val == 0) {
		retval = "0 GB";
	} else if (val < 10500) {
		retval = convert(val / KB) + " GB";
	} else {
		retval = convert(val / MB) + " TB";
	}
	if (vNeg) {
		retval = '-' + retval;
	}
	return retval;
}

function autoConvertToMB(val) {
	if (isNaN(val) == false) {
		return val;
	}

	var num = val.replace(/[^.0-9]+/g, '');
	var unit = val.replace(/[^a-z]+/g, '');

	var r = new RegExp(/^MB$/i);
	if (r.test(unit)) {
		return val;
	}

	r = new RegExp(/^bytes$/i);
	if (r.test(unit)) {
		return num / MB;
	}

	r = new RegExp(/^KB$/i);
	if (r.test(unit)) {
		return num / KB;
	}

	r = new RegExp(/^GB$/i);
	if (r.test(unit)) {
		return num * KB;
	}

	r = new RegExp(/^TB$/i);
	if (r.test(unit)) {
		return num * MB;
	}

	r = new RegExp(/^PB$/i);
	if (r.test(unit)) {
		return num * GB;
	}

	r = new RegExp(/^EB$/i);
	if (r.test(unit)) {
		return num * TB;
	}

	return val;
}

function convert(value) {
	var valueStr = value.toString();

	if (valueStr.toLowerCase().indexOf('e') != -1) {
		valueStr = value.toFixed(20);
	} else if (valueStr.indexOf(".") != -1) {
		valueStr = roundNumber(value, 2);
	}

	return valueStr;
}

function getPercentValue(val) {
	if (val < 0) {
		return "N/A";
	} else if (val > 100) {
		return "100";
	} else {
		return val;
	}

}

function roundNumber(num, dec) {
	var result = Math.round(num * Math.pow(10, dec)) / Math.pow(10, dec);
	return result;
}

function endsWith(str, suf) {
	var string = '' + str;
	var suffix = '' + suf;
	if (string.length < suffix.length) {
		return false;
	}
	return string.indexOf(suffix, string.length - suffix.length) !== -1;
}

function validateEmail(notRequired, emails) {
	var field = "#emails";
	var shouldMarkField = false;
	if (emails == undefined || emails == null) {
		emails = $(field).val();
		shouldMarkField = true;
	}
	emails = $.trim(emails);
	if (!emails) {
		if (shouldMarkField) {
			if (!notRequired) {
				return markField(field, cvUtil.cvLocalize("errors.email_is_empty"));
			} else {
				return markField(field, "");
			}
		} else {
			return {
				"error" : true,
				"errorMsg" : cvUtil.cvLocalize("errors.email_is_empty")
			};
		}
	}
	emails = emails.replace(/[\s,;]+/g, ';'); //replace all whitespaces, comma and semicolons with a single semicolon
	var emailList = emails.split(';');
	if (emailList == null) {
		emailList = emails;
	}
	var emailPattern = /^[^@;,\s]+@[^@;,\s]+\.[^@;,\s]+$/; //basic validation - restrict @, comma, semicolon and any white space
	var oneGood = false;
	var oneBad = false;
	$.each(emailList, function(index, value) {
		if (value) {
			value = $.trim(value);
			if (value.match(emailPattern)) {
				oneGood = true;
			} else {
				oneBad = true;
				return;
			}
		}
	});

	if (shouldMarkField) {
		if (oneBad) {
			return markField(field, cvUtil.cvLocalize("errors.invalid_email"));
		}
		if (!oneGood) {
			return markField(field, cvUtil.cvLocalize("errors.email_is_empty"));
		}
		$(field).val(emails);
		return markField(field, "");
	} else {
		if (oneBad) {
			return {
				"error" : true,
				"errorMsg" : cvUtil.cvLocalize("errors.invalid_email")
			};
		}
		if (!oneGood) {
			return {
				"error" : true,
				"errorMsg" : cvUtil.cvLocalize("errors.email_is_empty")
			};
		}
		return {};
	}
}

function markField(fieldId, errorMessage) {
	if (!errorMessage || errorMessage == '') {
		clearHighlight(fieldId);
		return true;
	}
	highlightField(fieldId, errorMessage);
	return false;
}

function clearHighlight(fieldId) {
	$(fieldId).removeClass("errorField").parents(".form-group").removeClass("has-error");
	$(fieldId).attr('title', '');
}
function highlightField(fieldSelector, errorMessage) {
	$(fieldSelector).addClass("errorField").parents(".form-group").addClass("has-error");
	$(fieldSelector).attr('title', errorMessage);
	if (!$(fieldSelector).is(":focus")) {
		$(fieldSelector).focus();
	}
}
function attachEmailHandler(opts) {
	var options = opts || {};
	var defaultHeight = 170;
	$("#exportEmail").click(function() {
		var filePrefix = options.exportFileNamePrefix || report.getExportFilePrefix();
		var target = options.targetUrl ? options.targetUrl : cvUtil.getContextPath() + "/reports/";
		target += "newReportEmail.do?" + cvUtil.createParamString('filePrefix', filePrefix) + "&";
		if (window.reportEnum) {
			target += cvUtil.createParamString('reportEnum', window.reportEnum) + "&";
		}

		if (typeof customReport !== "undefined" && customReport && customReport.reportId) {
			target += cvUtil.createParamString('reportUniqId', customReport.reportId);
		} else if (window.reportUniqId) {
			if (window.reportEnum != null && window.reportEnum == 'CustomReports' && options.reportId) {
				target += cvUtil.createParamString('reportUniqId', options.reportId);
			} else {
				target += cvUtil.createParamString('reportUniqId', window.reportUniqId);
			}
		}

		if (options.hasDataCubeDataSets) {
			if (options.format) {
				options.format = _.filter(options.format.split(','), function(o) {
					return o.toLowerCase().trim() != 'email_body' && o.toLowerCase().trim() !== 'csv';
				}).join(',');
			} else {
				options.format = 'PDF,HTML';
			}
		}

		if (options.format) {
			target += "&";
			target += cvUtil.createParamString('format', options.format);
		}

		if (options.exportComponents && options.exportComponents.length > 1) {
			target += "&";
			target += cvUtil.createParamString('components', JSON.stringify(options.exportComponents));
			defaultHeight = defaultHeight + 30;
		}

		cvUtil.showModal({
			width : 550,
			height : defaultHeight,
			title : cvUtil.cvLocalize('Email_Report'),
			href : target,
			iframe : true
		});
	});
}

reportsUtil.scheduleReport = function(opts) {
	var options = opts || {};
	var defaultHeight = 640;

	//	if (!window.networkShareEnabled) {
	//		defaultHeight = 580;
	//	}

	$("#exportSchedule").click(function() {
		var target = options.targetUrl ? options.targetUrl : cvUtil.getContextPath() + "/reports/";
		target += "newReportSchedule.do?" +
				cvUtil.createParamString('filePrefix', options.exportFileNamePrefix || report.getExportFilePrefix()) +
				"&";
		if (window.reportEnum) {
			target += cvUtil.createParamString('reportEnum', window.reportEnum) + "&";
		}

		if (typeof customReport !== "undefined" && customReport && customReport.reportId) {
			target += cvUtil.createParamString('reportUniqId', customReport.reportId);
		} else if (window.reportUniqId) {
			if (window.reportEnum != null && window.reportEnum == 'CustomReports' && options.reportId) {
				target += cvUtil.createParamString('reportUniqId', options.reportId);
			} else {
				target += cvUtil.createParamString('reportUniqId', window.reportUniqId);
			}
		}

		if (options.hasDataCubeDataSets) {
			if (options.format) {
				options.format = _.filter(options.format.split(','), function(o) {
					return o.toLowerCase().trim() != 'email_body' && o.toLowerCase().trim() !== 'csv';
				}).join(',');
			} else {
				options.format = 'PDF,HTML';
			}
		}

		if (options.format) {
			target += "&";
			target += cvUtil.createParamString('format', options.format);
		}
		if (window.showPPT) {
			target += "&";
			target += cvUtil.createParamString('showPPT', window.showPPT);
		}
		if (window.showExecutivePPT) {
			target += "&";
			target += cvUtil.createParamString('showExecutivePPT', window.showExecutivePPT);
		}
		if (window.location.href.indexOf("reports/dashboard.jsp") > -1) {
			target += "&";
			if (cvUtil.getParameter('commUniId') != "") {
				target += cvUtil.createParamString('showCustomDocuments', 1);
			} else if (cvUtil.getParameter('ccGroupId') != "") {
				target += cvUtil.createParamString('showCustomDocuments', 2);
			} else if (cvUtil.getParameter('companyId') != "") {
				target += cvUtil.createParamString('showCustomDocuments', 3);
			} else {
				target += cvUtil.createParamString('showCustomDocuments', 4);
			}
		}
		var pageParam = cvUtil.getTopWindow().cvUtil.getParameter('page');
		if (!!pageParam && window.location.href.indexOf("reports/index.jsp") > -1 && pageParam == 'Dashboard') {
			target += "&";
			target += cvUtil.createParamString('showCustomDocuments', 4);
		}

		if (options.exportComponents && options.exportComponents.length > 1) {
			target += "&";
			target += cvUtil.createParamString('components', JSON.stringify(options.exportComponents));
			defaultHeight = 670;
		}

		cvUtil.showModal({
			width : 440,
			height : defaultHeight,
			title : cvUtil.cvLocalize('AddSchedule'),
			href : target,
			iframe : true
		}, null, function(returnData) {
			if (returnData && returnData.cancel) {
				return;
			}
			if (returnData && returnData.isError) {
				cvUtil.errorToast(returnData.message, null, null, false);
			} else {
				cvUtil.toast(returnData.message, null, null, false);
			}
		});
		$('.ui-dialog-content').mask("");
	});
};

function decimalToHex(d, padding) {
	var hex = Number(d).toString(16);
	if (hex == -1) {
		return "FFFFFFFF";
	}
	padding = typeof (padding) === "undefined" || padding === null ? padding = 2 : padding;
	while (hex.length < padding) {
		hex = "0" + hex;
	}
	return hex.toUpperCase();
}

function urlToRequest(input, requestString) {
	if ($.trim(input).length == 0) {
		return requestString;
	}
	if (input.indexOf("?") == 0) {
		input = input.substring(1);
	}
	var u = input.split('&');

	$.each(u, function(index, token) {
		var nameValue = token.split('=');
		var name = nameValue[0];
		var hierarchy = name.split(urlParamDelimiter);
		var current = requestString;
		var value = decodeURIComponent(nameValue[1]);
		for (index = 0; index < hierarchy.length; index++) {
			var step = hierarchy[index];
			if (index == hierarchy.length - 1) {
				current[step] = value;
			} else {
				if (isNaN(hierarchy[index + 1])) {
					if (!(current[step] instanceof Object)) {
						current[step] = {};
					}
				} else if (!(current[step] instanceof Array)) {
					current[step] = [];
				}
				current = current[step];
			}
		}
	});
}

function requestToUrl(a1) {
	function objectToUrl(a1, prefix) {
		var u = [];
		var x;
		if (prefix) {
			prefix = prefix + urlParamDelimiter;
		} else {
			prefix = "";
		}
		for (x in a1) {
			if (x == 'invisible') {
				continue;
			}
			var curr = a1[x];
			if (curr === undefined || curr === '') {
				continue;
			}
			if (curr instanceof Array) {
				u = u.concat(arrayToUrl(curr, prefix + x));
			} else if (curr instanceof Object) {
				u = u.concat(objectToUrl(curr, prefix + x));
			} else {
				u.push(prefix + x + "=" + encodeURIComponent(curr));
			}
		}
		return u;
	}
	function arrayToUrl(curr, prefix) {
		var u = [];
		var index = 0;
		if (prefix) {
			prefix = prefix + urlParamDelimiter;
		}
		for (index = 0; index < curr.length; index++) {
			if (curr[index] instanceof Object) {
				u = u.concat(objectToUrl(curr[index], prefix + index));
			} else if (curr[index] instanceof Array) {
				u = u.concat(arrayToUrl(curr[index], prefix + index));
			} else {
				u.push(prefix + index + "=" + encodeURIComponent(curr[index]));
			}
		}
		return u;
	}
	return objectToUrl(a1).join("&");
}

function getDate(unix, pattern) {
	if (pattern) {
		return moment.unix(parseFloat(unix) + getTimezoneOffset(unix)).format(pattern);
	} else {
		return moment.unix(parseFloat(unix) + getTimezoneOffset(unix));
	}
}

function getTimezoneOffset(unix) {
	if (unix) {
		return (new Date(parseFloat(unix) * 1000).getTimezoneOffset() * 60);
	}
	return (new Date().getTimezoneOffset() * 60);
}

function addCommas(nStr) {
	nStr += '';
	x = nStr.split('.');
	x1 = x[0];
	x2 = x.length > 1 ? '.' + x[1] : '';
	//var rgx = /(\d+)(\d{3})/;
	var rgx = /(\d+)(\d{3}),?/;
	while (rgx.test(x1)) {
		x1 = x1.replace(rgx, '$1' + ',' + '$2');
	}
	return x1 + x2;
}

function registrationCode(GUID) {
	GUID = GUID.slice(-10);
	GUID = GUID.slice(0, 3) + "-" + GUID.slice(3, 6) + "-" + GUID.slice(6);
	return GUID;
}

reportsUtil.jobStatus.getjobList = function() {
	var jobList = JSON.parse($.cookie(reportsUtil.jobStatus.JOBS_COOKIE_NAME));
	if (jobList === null) {
		jobList = [];
	}
	return jobList;
};

reportsUtil.jobStatus.setCookie = function(value) {
	if (typeof value === "undefined") {
		value = null;
	}
	$.cookie(reportsUtil.jobStatus.JOBS_COOKIE_NAME, value, {
		path : cvUtil.getContextPath()
	});
};
reportsUtil.jobStatus.updateJobList = function(jobId, status) {
	var jobList = reportsUtil.jobStatus.getjobList();
	if (!!jobId && $.isArray(jobId)) {
		for (var i = 0; i < jobId.length; i++) {
			jobList.push('' + jobId[i]);
		}
	}
	var temp = JSON.stringify(jobList);
	reportsUtil.jobStatus.setCookie(temp);
	cvUtil.getTopWindow().JobManager.displayStatus = false;
	reportsUtil.jobStatus.pollData(jobList);

};
reportsUtil.jobStatus.pollData = function(jobids) {
	if (jobids.length == 0) {
		return;
	}
	cvUtil.getTopWindow().JobManager.displayStatus = false;
	cvUtil.getTopWindow().JobManager.polljob(jobids, function(jobsummaryarray) {
		if (jobsummaryarray == null || jobsummaryarray == undefined || jobsummaryarray.length == 0) {
			var job = [];
			var temp = JSON.stringify(job);
			reportsUtil.jobStatus.setCookie(temp);
		}
		$.each(jobsummaryarray, function(index, val) {
			var jobid = val["jobId"];
			var status = val["jobStatus"];
			if (status === "Completed" || status === "Failed" || status === "suspended") {
				var jobList = reportsUtil.jobStatus.getjobList();
				var index = jobList.indexOf(jobid.toString());
				if (index > -1) {
					jobList.splice(index, 1);
				}
				var temp = JSON.stringify(jobList);
				reportsUtil.jobStatus.setCookie(temp);
				var message = "";
				if (status === "Completed") {
					message = localMsg['Email_Request_Completed_Notification'];
					if (!!message) {
						message = message.replace('{0}', jobid);
						cvUtil.getTopWindow().cvUtil.toast(message, null, null, true);
					}
				} else {
					message = localMsg['Email_Request_Failed_Notification'];
					if (!!message) {
						message = message.replace('{0}', jobid);
						cvUtil.getTopWindow().cvUtil.errorToast(message, null, null, true);
					}
				}
			}
		});
	});
};
if (typeof document !== "undefined") {
	$(document).ready(function() {
		reportsUtil.jobStatus.pollData(reportsUtil.jobStatus.getjobList());
	});
}

reportsUtil.getTableCols = function(gridid, getHidden) {
	var tableColumns = [];
	var el = $('#' + gridid + '_table');
	var dataTabl = el.hasClass('initialized');
	if (dataTabl) {
		var oTable = el.dataTable();
		var oSettings = oTable.fnSettings();
		if (oSettings != null) {
			for (var j = 0; j < oSettings.aoColumns.length; j++) {
				if (!!getHidden) {
					if (!oSettings.aoColumns[j].bVisible) {
						tableColumns.push(oSettings.aoColumns[j].mDataProp);
					}
				} else if (oSettings.aoColumns[j].bVisible) {
					tableColumns.push(oSettings.aoColumns[j].mDataProp);
				}
			}
		}
	}
	return tableColumns;
};

reportsUtil.columnVisibilityFromUrl = function(reqObj, gridid, aoColumns) {
	if (reqObj[gridid] && reqObj[gridid]["tableColumns"]) {
		var visibleColumns = reqObj[gridid]["tableColumns"];
		var updateTableColumns = false; //update from url
		for (k in visibleColumns) {
			updateTableColumns = true; //if atleast one columns is in url then override else we'll show default columns
			break;
		}
		if (updateTableColumns) {
			for (var j = 0; j < aoColumns.length; j++) {
				aoColumns[j].bVisible = $.inArray(aoColumns[j].mDataProp, visibleColumns) > -1;
				//aoColumns[j].bHidden = !aoColumns[j].bVisible;
			}
		}
	}
};

reportsUtil.getTruncatedName = function(ccname) {
	var len = 50;
	if (ccname && ccname.length > len) {
		ccname = ccname.substr(0, len - 3) + '...';
	}
	return ccname;
};

reportsUtil.getFormattedNumberNA = function(val) {
	var opts = {};
	opts.format = true;
	var formattedNumber = Reports.Renderers.FORMATNUMBERNA("", val, "");
	return formattedNumber;
};

reportsUtil.getColumnFilter = function(search, type, columName) {
	var whereClause = "";
	if (search.indexOf("&&") != -1 || search.indexOf("||") != -1) {
		while (search.indexOf("&&") != -1 || search.indexOf("||") != -1) {
			var operand = "and";
			var andIndex = search.indexOf('&&');
			var orIndex = search.indexOf('||');
			var index = andIndex;
			if (andIndex == -1 || (andIndex > orIndex && orIndex != -1)) {
				index = orIndex;
				operand = "or";
			}
			var filter = search.substring(0, index).trim();
			;
			whereClause = whereClause + columName + reportsUtil.parseColumnFilter(filter, type) + " " + operand + " ";
			search = search.substring(index + 2, search.length);
		}
		search = search.trim();
		if (search != "") {
			whereClause = whereClause + columName + reportsUtil.parseColumnFilter(search, type) + " and ";
		}
	} else {
		var searchClause = reportsUtil.parseColumnFilter(search, type);
		whereClause = whereClause + columName + searchClause + " and ";
	}

	return whereClause;
};

reportsUtil.parseColumnFilter = function(search, type) {
	var operator = 'LIKE';
	search = $.trim(search);
	search = search.replace(/'/g, "''");
	if (search.indexOf('>=') == 0 || search.indexOf('<=') == 0 || search.indexOf('!=') == 0) {
		operator = search.substr(0, 2);
		search = search.substring(2);
		if (type == 'String' || isNaN(search)) {
			search = $.trim(search);
			search = "'" + search + "'"
		}
	} else if (search.indexOf('>') == 0 || search.indexOf('<') == 0 || search.indexOf('=') == 0) {
		operator = search.substr(0, 1);
		search = search.substring(1);
		if (type == 'String' || isNaN(search)) {
			search = $.trim(search);
			search = "'" + search + "'"
		}
	} else if (search.toLowerCase().indexOf("notlike") == 0) {
		operator = "NOT LIKE";
		search = search.substring(7).trim();
		search = "'%25" + search + "%25'";
	} else if (search.toLowerCase().indexOf("not like") == 0) {
		operator = "NOT LIKE";
		search = search.substring(8).trim();
		search = "'%25" + search + "%25'";
	}

	if (operator == "LIKE") {
		search = "'%25" + search + "%25'";
	}
	return operator + " " + search;
};

reportsUtil.showProfileDialog = function(id, opts, obj, callback) {

	var target = cvUtil.getContextPath() + opts.target;
	cvUtil.showModal({
		width : opts.width,
		height : opts.height,
		title : opts.title,
		href : target,
		iframe : true
	}, null, function(resp) {
		if (resp) {
			if (resp.cancel) {
				return;
			}
			if (resp.isError) {
				cvUtil.errorToast(resp.message, null, null, true);
			} else {
				if (resp.message != null) {
					cvUtil.toast(resp.message, null, null, true);
				}
				if (callback != null) {
					callback(resp);
				}
			}
		}
	}, obj);
};

reportsUtil.attachTaskHandler = function() {
	$("#createTask").click(function() {
		reportsUtil.showTaskDialog(0, null);
	});
};

reportsUtil.validateEmail = function(emails) {
	return validateEmail(false, emails);
}

reportsUtil.convertCREtoTable = function(creData) {
	var tableData = creData;//JSON.parse(creData.tableData);
	tableData.useReportRenderers = true;
	tableData.aaSorting = [ "0", "asc" ];
	$.each(tableData.aoColumns, function(i, val) {
		var col = val;
		var re = /<(.*)>$/i;
		var name = val.mDataProp;
		col.sOriginalName = name;
		if (re.test(name)) {
			col.rendererType = re.exec(name)[1];
			name = name.replace(re, '');

			if (typeof col.rendererType != 'undefined') {
				if ($.inArray(col.rendererType, [ 'Task', 'URL', 'TaskStatus' ]) > -1) {
					col.bFilterRendered = false;
				}
				if (!(col.rendererType == 'TaskStatus')) {
					col.bUseRendered = false;
				}
				if (col.rendererType == 'DONOTSHOW') {
					col.doNotShow = true;
					col.bVisible = false;
				}
			}
		}
		if (col.sTitle == 'Commcell Name') {
			col.doNotShow = true;
			col.bVisible = false;
		}
		tableData.aoColumns[i] = col;
	});

	return tableData;

};

reportsUtil.trimTrailingComma = function(str) {
	if (str) {
		var lastChar = str.slice(-1);
		if (lastChar == ',') {
			str = str.slice(0, -1);
		}
	}
	return str;
};

reportsUtil.exportToExcel = function(gridId, title) {
	/*
	 * if(report.scaleReport){ return Reports.exportToExcelScale(gridId); }
	 */

	var dataTable = $('#' + gridId + CVTable.table).dataTable();
	var contents = "";
	var oSettings = dataTable.fnSettings();

	function isCSVInjectionDetected(val) {
		return (val.indexOf("+") == 0) || (val.indexOf("-") == 0) || (val.indexOf("=") == 0) || (val.indexOf("@") == 0);
	}

	for (var j = 0; j < oSettings.aoColumns.length; j++) {
		if (oSettings.aoColumns[j].bVisible) {
			var colName = oSettings.aoColumns[j].sTitle;
			if (colName.indexOf("\"") != -1) {
				colName = colName.replace(/\"/gi, "\"\"");
			}
			if (oSettings.aoColumns[j].rendererType == "capacityMB" ||
					oSettings.aoColumns[j].rendererType == "capacityMB_Neg") {
				colName = colName + '(MB)';
			}
			colName = "\"" + colName + "\"";

			contents = contents + colName + ",";//"\t";
		}
	}
	contents = reportsUtil.trimTrailingComma(contents) + "\n";
	var filteredData = Reports.fnGetFilteredData(oSettings);
	$.each(filteredData, function(index, value) {
		var indxs = 0;
		var cloumnIndex = [];
		$.each(value,
				function(columnTitle, columnValue) {
					for (var ci = 0; ci < oSettings.aoColumns.length; ci++) {
						if (columnTitle === oSettings.aoColumns[ci].mDataProp) {
							indxs = ci;
							break;
						}
					}
					if (oSettings.aoColumns[indxs].bVisible) {
						var colVal = columnValue;

						if (colVal === 0) {
							// Cast to string
							colVal += "";
						}

						if (!colVal) {
							colVal = " ";
						}
						if (typeof colVal === "string" && isNaN(colVal)) {
							colVal = colVal.replace(/\\n\\n/gi, "\n\n");
							colVal = colVal.replace(/<br>/gi, "\n");
							if (window.checkCSVInjection && isCSVInjectionDetected(colVal)) {
								colVal = "'" + colVal;
							}
						}
						for (var ci = 0; ci < oSettings.aoColumns.length; ci++) {
							if (columnTitle === oSettings.aoColumns[ci].mDataProp) {
								if (oSettings.aoColumns[ci].rendererType == "dateTimeRenderer" &&
										typeof moment !== 'undefined') {
									if (colVal == "0" || colVal == "-1" || colVal == "") {
										colVal = "";
									} else if (!isNaN(parseInt(colVal))) {
										var dval = moment.unix(parseInt(colVal) + new Date().getTimezoneOffset() * 60);
										colVal = moment(dval).format("MMM D, YYYY hh:mm A");
									}
								} else if (oSettings.aoColumns[ci].rendererType == "installDate" &&
										typeof moment !== 'undefined') {
									colVal = moment(colVal).format("MMM YYYY");
								} else if (oSettings.aoColumns[ci].rendererType == "NumberNA" ||
										oSettings.aoColumns[ci].rendererType == "capacityMB") {
									if (colVal == -2) {
										colVal = "Never Protected";
									} else if (colVal < 0) {
										colVal = "N/A";
									}
								} else if (oSettings.aoColumns[ci].rendererType == "DAYS") {
									if (colVal == -1) {
										colVal = "Never";
									}
								} else if (oSettings.aoColumns[ci].rendererType == "DifferenceMB" ||
										oSettings.aoColumns[ci].rendererType == "DifferenceNA") {
									if (!colVal || colVal === ' ' || colVal === '') {
										colVal = "N/A";
									}
								} else if (oSettings.aoColumns[ci].rendererType == "HEALTH_STATUS") {
									colVal = colVal.replace(/[^a-zA-Z]/g, '');
								} else if (oSettings.aoColumns[ci].rendererType == "DOT_STATUS") {
									/// Statuses come in the form <1-4>_<StatusString>; anything else
									/// is unknown
									colVal = colVal.split("_")[1];
									if (colVal === "Info") {
										colVal = "";
									}
								} else if (oSettings.aoColumns[ci].rendererType == "HOURS") {
									if (colVal == -1) {
										colVal = "N/A";
									}
									var hh = ((parseInt(colVal))) / 60;
									var aa = hh >= 12 ? "PM" : "AM";
									hh = (hh > 12) ? hh - 12 : (hh == 0) ? 12 : hh;
									colVal = hh + ":00 " + aa;

								} else if (oSettings.aoColumns[ci].rendererType == "capacityMB_Neg") {
									//Do nothing for renderer capacityMB_Neg
									//This block is to restrict the flow from entring next block
								} else if (!!oSettings.aoColumns[ci].rendererType) {
									var renderer = oSettings.aoColumns[ci].rendererType;
									var filterRendered = oSettings.aoColumns[ci].bFilterRendered;
									filterRendered = filterRendered == undefined ? true : filterRendered;
									if (!!Reports.Renderers[renderer] && Reports.Renderers[renderer].length == 4 &&
											filterRendered) {
										colVal = Reports.Renderers[renderer]({
											oSettings : oSettings,
											iDataColumn : ci,
											iDataRow : index,
											aData : value
										}, colVal, null);
									}
								}
								break;
							}
						}

						if (typeof colVal === "string") {
							if (colVal.match(/^-?(\d*.\d*) (Bytes|KB|MB|GB|TB|PB)$/gi)) {
								var tokens = colVal.split(' ');
								colVal = reportsUtil.convertToBytes(tokens[0], tokens[1]);
							}
							if (typeof colVal === "string" && colVal.indexOf("\"") != -1) {
								colVal = colVal.replace(/\"/gi, "\"\"");
							}
							//Checking if the colVal is html content, then convert into normal text
							var plainColVal = $("<div/>").html(colVal).text();
							if (colVal !== plainColVal) {
								colVal = plainColVal;
							}
						}
						colVal = "\"" + colVal + "\"";
						cloumnIndex[indxs] = colVal;
					}
				});
		for (var count = 0; count < oSettings.aoColumns.length; count++) {
			if (cloumnIndex[count]) {
				contents = contents + cloumnIndex[count] + ",";
			}
		}
		contents = reportsUtil.trimTrailingComma(contents) + "\n";
	});
	document.exportform.csvBuffer.value = contents;
	var now = new Date();
	var month = now.getMonth() + 1;
	if (month < 10) {
		month = "0" + month;
	}
	document.exportform.fileName.value = title + "_" + now.getFullYear() + "_" + month + "_" + now.getDate() + "_" +
			now.getHours() + "" + now.getMinutes() + "" + now.getSeconds();
	document.exportform.reportName.value = report.getExportFilePrefix();
	$("form[name='exportform']").submit();
};

reportsUtil.setDataURLForGrid = function(gridId, url) {
	reportsUtil.apiMap = reportsUtil.apiMap || {};

	if (gridId && url) {
		reportsUtil.apiMap[gridId] = url;
	}
};

reportsUtil.displayDataURL = function(gridId) {
	var url = '';
	if (reportsUtil.apiMap && gridId) {
		var dataURL = reportsUtil.apiMap[gridId];
		if (dataURL) {
			url = window.location.origin + cvUtil.getContextPath() + dataURL;
		}
	}

	var target = cvUtil.getContextPath() + '/reports/restApiModal.jsp';
	cvUtil.showModal({
		width : 550,
		height : 250,
		title : cvUtil.cvLocalize('DataSet.Preview.RESTAPI'),
		href : target,
		iframe : true
	}, null, function(resp) {
		if (resp) {
			if (resp.cancel) {
				return;
			}
			if (resp.isError) {
				cvUtil.errorToast(resp.message, null, null, true);
			} else {
				if (resp.message != null) {
					cvUtil.toast(resp.message, null, null, true);
				}
				if (callback != null) {
					callback(resp);
				}
			}
		}
	}, {
		restApiUrl : url
	});

	return url;

};

reportsUtil.getTaskStatus = function(status) {
	status = parseInt(status);
	switch (status) {
	case 1:
		return cvUtil.cvLocalize('task.status.Open');
	case 2:
		return cvUtil.cvLocalize('task.status.Fixed_Monitoring');
	case 3:
		return cvUtil.cvLocalize('task.status.Closed');
	case 4:
		return cvUtil.cvLocalize('task.status.Killed');
	case 5:
		return cvUtil.cvLocalize('task.status.OnHold');
	}
	return "";
};

reportsUtil.getTaskType = function(type) {
	status = parseInt(type);
	switch (type) {
	case 0:
		return cvUtil.cvLocalize('task.type.task');
	case 1:
		return cvUtil.cvLocalize('task.type.report_problem');
	case 2:
		return cvUtil.cvLocalize('task.type.feedback');
	case 3:
		return cvUtil.cvLocalize('task.type.cv');
	case 4:
		return cvUtil.cvLocalize('task.type.customer');
	}
	return "";
};

/*
 * reportsUtil.checkValidateEmail = function(id, required){ var field = id; var email=$(id).val(); if(!email){
 * if(required){ return markField(field, "Email id is required."); }else{ return markField(id, ""); } }
 * email=email.replace(/[\s,;]+/g,';'); //replace all whitespaces, comma and semicolons with a single
 * semicolon var emailPattern = /^[^@;,\s]+@[^@;,\s]+\.[^@;,\s]+$/; //basic validation - restrict @, comma,
 * semicolon and any white space email=$.trim(email); if(!email.match(emailPattern)){ return markField(field,
 * "Improper email id specified"); } $(id).val(email); return markField(id, ""); };
 */

reportsUtil.checkValidPhoneNumber = function(id, required) {
	var field = id;
	var phoneno = $(id).val();
	if (!phoneno) {
		if (required) {
			return markField(field, "Phone number is required.");
		} else {
			return markField(id, "");
		}
	}
	var phonenoPattern = /^([0-9\(\)\/\+ \-]*)$/;
	if (!phoneno.match(phonenoPattern)) {
		return markField(field, "Improper phono number specified");
	}
	$(id).val(phoneno);
	return markField(id, "");
};

reportsUtil.showUserGroupsDialog = function(data, callback) {
	//var opts = {target:'/survey/reports/userGroups.jsp'};
	var target = cvUtil.getContextPath() + '/survey/reports/userGroups.jsp';
	cvUtil.showModal({
		width : 700,
		height : 380,
		title : data.entityName + ' - Security',
		href : target,
		iframe : true
	}, null, function(resp) {
		if (resp) {
			if (resp.cancel) {
				return;
			}
			if (resp.isError) {
				cvUtil.errorToast(resp.message, null, null, true);
			} else {
				if (resp.message != null) {
					cvUtil.toast(resp.message, null, null, true);
				}
				if (callback != null) {
					callback(resp);
				}
			}
		}
	}, data);
};
reportsUtil.convertToBytes = function(value, unit) {
	var kilobyte = 1024;
	var megabyte = kilobyte * 1024;
	var gigabyte = megabyte * 1024;
	var terabyte = gigabyte * 1024;
	var petabyte = terabyte * 1024;
	var bytes = 0;

	if (unit == 'Bytes') {
		bytes = value;
	} else if (unit == 'KB') {
		bytes = value * kilobyte;
	} else if (unit == 'MB') {
		bytes = value * megabyte;
	} else if (unit == 'GB') {
		bytes = value * gigabyte;
	} else if (unit == 'TB') {
		bytes = value * terabyte;
	} else if (unit == 'PB') {
		bytes = value * petabyte;
	}

	return bytes;
};

reportsUtil.getMinFactor = function(val) {
	if (val < KB) {
		return 1;
	}
	if (val < MB) {
		return KB;
	}
	if (val < GB) {
		return MB;
	}
	if (val < TB) {
		return GB;
	}
	if (val < PB) {
		return TB;
	}
	if (val < EB) {
		return PB;
	}
	return EB;

}

reportsUtil.getMinUnitString = function(byteValue) {
	if (byteValue < KB) {
		return "B";
	}
	if (byteValue < MB) {
		return "KB";
	}
	if (byteValue < GB) {
		return "MB";
	}
	if (byteValue < TB) {
		return "GB";
	}
	if (byteValue < PB) {
		return "TB";
	}
	if (byteValue < EB) {
		return "PB";
	}
	return "EB";
}

/**
 * Sets the target URL for the "Worldwide" link.
 * 
 * At the CommCell level, if the CommCell was reached via a CommCell group, the link will direct to the
 * group-wide level of the report. Otherwise, it will direct to the worldwide level of the report.
 * 
 * At the CommCell group and worldwide levels, the link will be hidden.
 * 
 * @param {Boolean}
 *            wwVisible if false, the link will be hidden from the page if it directs to the Worldwide version
 *            of the report
 * @param {Array
 *            <String>} list of parameter components to include (ex. "surveyId=1")
 */
reportsUtil.setWorldwideLink = function(wwVisible, params) {
	var url = window.location.pathname, text = cvUtil.cvLocalize("worldwide_link.worldwide"), ccId = Number(cvUtil
			.getParameter('commUniId', 0)), ccGroupId = Number(cvUtil.getParameter('ccGroupId', -1)), companyId = cvUtil
			.getParameterByName("companyId", 0), commcellLevel = ccId > 0, groupLevel = !commcellLevel && ccGroupId > 0;

	if (typeof params === "undefined") {
		params = [];
	}

	if (typeof wwVisible === "undefined") {
		wwVisible = true;
	}

	if (commcellLevel || groupLevel) {
		/// When a CommCell is accessed from within a group, provide a link
		/// to the group-level report instead of worldwide level
		if (ccGroupId > 0 && commcellLevel) {
			params.push("ccGroupId=" + ccGroupId);
			text = cvUtil.cvLocalize("worldwide_link.groupwide");
		} else if (!wwVisible) {
			$("#commcellUrl").hide();
		}
		if (url.indexOf("indcommcellsurvey.jsp") > -1) {
			url = url.replace("indcommcellsurvey.jsp", "CommCellSurvey.jsp");
			if (cvUtil.getParameter('tenant', '') != '') {
				params.push("tenant=" + encodeURIComponent(cvUtil.getParameter('tenant')));
			}
		} else if (url.indexOf("chargebackTrends.jsp") > -1 || url.indexOf("ChargebackTrends.do") > -1) {
			params.push("intervalType=" + Number(cvUtil.getParameter('intervalType', 3)));
			params.push("excludeDeSCs=" + Number(cvUtil.getParameter('excludeDeSCs', 0)));
			params.push("endDate=" + cvUtil.getParameter('endDate'));
			if (cvUtil.getParameter('entityType')) {
				params.push("entityType=" + cvUtil.getParameter('entityType'));
			}
			if (cvUtil.getParameter('chartType')) {
				params.push("chartType=" + cvUtil.getParameter('chartType'));
			}
			if (cvUtil.getParameter('aggregate')) {
				params.push("aggregate=" + cvUtil.getParameter('aggregate'));
			}
		}
		if (params.length > 0) {
			url += "?";
		}

		$("#commcellUrl").attr("href", url + params.join("&")).html(text);
	} else {
		$("#commcellUrl").hide();
	}
} /// end method setWorldwideLink

reportsUtil.getValueForUniqId = function(uid, token) {
	if (!!window.commcellSearchData) {
		var i = 0;
		var rows = window.commcellSearchData;
		for (i = 0; i < rows.length; i++) {
			var uniqId = rows[i].commUniId;
			if (uniqId == uid) {
				if (token === 'guid') {
					return rows[i].ccGuid;
				} else if (token === 'name') {
					return rows[i].ccName;
				} else if (token === 'ccId') {
					return rows[i].ccId;
				}
			}
		}
	}
	return null;
};

reportsUtil.truncateLongReportName = function(reportName) {
	if (reportName.length > 55) {
		var shortReportName = jQuery.trim(reportName).substring(0, 50);
		if (shortReportName.indexOf(" ") != -1) {
			return shortReportName.split(" ").slice(0, -1).join(" ") + "...";
		} else {
			return shortReportName + "...";
		}

	} else {
		return reportName;
	}
}

reportsUtil.getCCGroupProfileInfo = function(commUniId, cgId, companyId, callback, errorCallback) {
	var URL = "getCCGroupProfileInfo.do?";

	if (commUniId) {
		URL = URL + "commUniId=" + commUniId;
	}
	var ccGroupId = cgId ? cgId : cvUtil.getParameter('ccGroupId', -1);
	if (ccGroupId > 0) {
		URL = URL + "&ccGroupId=" + ccGroupId;
	}

	if (companyId > 0) {
		URL = URL + "&companyId=" + companyId;
	}

	cvUtil.loadPageWithPOST(URL, null, function(resp) {
		if (resp) {
			callback(resp);
		}
	}, function(errorMsg) {
		if (errorCallback) {
			errorCallback(errorMsg);
		}
	});
};

reportsUtil.getCCHealthStatus = function(commUniId, callback) {
	var request = {};
	request.dashboard = true;
	request.commUniId = commUniId;
	request.dToken = 7;
	var URL = cvUtil.getContextPath() + '/server/cloudsurvey.do?type=operations&json=' +
			window.encodeURIComponent(JSON.stringify(request));
	cvUtil.loadPageWithPOST(URL, null, function(output) {
		reportsUtil.processHealthStatus(output);
		if (callback) {
			callback(output);
		}
	});
};

reportsUtil.processHealthStatus = function(output) {
	if (output.summary7 == undefined) {
		$(".healthStatusIcon").addClass("sprite icon-dot-gray healthStatus_offline");
		//$(".health_icon").attr("title", "");
	} else {
		if (output.summary7.value == undefined) {
			return;
		}
		if (output.summary7.value.aaData[0]["Status"] == "4_Critical") {
			$(".healthStatusIcon").addClass("sprite icon-dot-red healthStatus");
			//$(".health_icon").attr("title", "");
		} else if (output.summary7.value.aaData[0]["Status"] == "3_Warning") {
			$(".healthStatusIcon").addClass("sprite icon-dot-yellow healthStatus");
			//$(".health_icon").attr("title", "");
		} else if ((output.summary7.value.aaData[0]["Status"] == "2_Info") ||
				(output.summary7.value.aaData[0]["Status"] == "1_Good")) {
			$(".healthStatusIcon").addClass("sprite icon-dot-green healthStatus");
			//$(".health_icon").attr("title", "");
		} else if (output.summary7.value.aaData[0]["Status"] == "disabled") {
			$(".healthStatusIcon").addClass("sprite icon-dot-gray healthStatus_offline");
			$(".health_icon").attr("title", "Health Disabled");
		}
	}
};

reportsUtil.getCommCellSerialNRegCode = function(GUID) {
	GUID = GUID.replace(/-/g, '');
	var serial = GUID.slice(0, -10);
	serial = serial.slice(0, 4) + '-' + serial.slice(4, 8) + '-' + serial.slice(8, 12) + '-' + serial.slice(12, 16) +
			'-' + serial.slice(16);
	var regd = GUID.slice(-10);
	regd = regd.slice(0, 3) + "-" + regd.slice(3, 6) + "-" + regd.slice(6);

	var resp = {};
	resp.serial = serial;
	resp.regd = regd;
	return resp;
};

reportsUtil.autoConvertFromTB = function(valInTB) {
	var obj = {};
	obj.value = valInTB;
	obj.units = " TB";
	if (valInTB > 1024) {
		if (valInTB > 1048576) {
			valInTB = valInTB / 1048576;
			obj.value = valInTB.toFixed(2);
			obj.units = " EB";
		} else {
			valInTB = valInTB / 1024;
			obj.value = valInTB.toFixed(2);
			obj.units = " PB";
		}
	}
	obj.value = (parseFloat(obj.value)).toFixed(2);
	return obj;
}

reportsUtil.autoConvertCount = function(value) {
	var unit;
	if (value > 1000 * 1000 * 1000 * 1000) {
		value = (value / (1000 * 1000 * 1000 * 1000)).toFixed(2);
		unit = 'T';
	} else if (value > 1000 * 1000 * 1000) {
		value = (value / (1000 * 1000 * 1000)).toFixed(2);
		unit = 'B';
	} else if (value > 1000 * 1000) {
		value = (value / (1000 * 1000)).toFixed(2);
		unit = 'M';
	}
	value = reportsUtil.getFormattedNumberNA(value);
	return {
		'value' : value,
		'unit' : unit
	};
};

reportsUtil.getYmax = function(yMax, chartDataType) {
	var toNearest = 100;
	if (chartDataType && chartDataType == 'PERCENTAGE') {
		return toNearest;
	}

	if (yMax == 0) {//if no chartable data
		return 5;
	}
	var done = false, isFloat = false;

	var arr1 = [ 0.0001, 0.0002, 0.0005, 0.001, 0.002, 0.005, 0.01, 0.02, 0.05, 0.1, 0.2, 0.5, 1, 2 ];
	var arr2 = [ 10, 100, 500, 1000, 5000, 10000, 50000, 100000, 500000, 1000000, 5000000, 10000000 ];

	if (yMax < arr1[arr1.length - 1]) {
		for (var i = 0; i < arr1.length; i++) {
			if (yMax < arr1[i]) {
				yMax = arr1[i];
				isFloat = true;
				done = true;
				break;
			}
		}
	} else if (yMax <= 5) {
		yMax++;
		done = true;
	} else if (yMax < arr2[arr2.length - 1]) {
		for (var i = 0; i < arr2.length; i++) {
			if (yMax < arr2[i]) {
				toNearest = arr2[i] / 10;
				break;
			}
		}
	}

	if (isFloat == false) {
		yMax = Math.ceil(yMax);
	}
	if (done == false) {
		var rest = yMax % toNearest;
		yMax = (yMax - rest) + (toNearest == 1 ? 0 : toNearest);
		while (yMax % 5 != 0) {
			yMax++;
		}
	}
	return yMax;
};

reportsUtil.getYStepCount = function(yMax) {
	var count = 5;
	if (yMax <= 1) {
		return count;
	} else if (yMax <= 2) {
		return count - 1;
	} else if (yMax <= 5) {
		return yMax;
	}
	var unit = (yMax <= 10) ? 2 : 5;
	for (; count > 0; count--) {
		if (Math.floor(yMax / count) % unit == 0) {
			return count;
		}
	}
	return 1;
};

reportsUtil.createPieChart = function(id, chartData) {
	// Build the chart
	// Highcharts.chart('testPieChart', {
	$("#" + id).highcharts({
		chart : {
			plotBackgroundColor : null,
			plotBorderWidth : null,
			plotShadow : false,
			type : 'pie',
			height : 250,
			reflow : false,
			width : chartData.width ? chartData.width : null
		},
		title : {
			text : ''
		},
		tooltip : {
			pointFormat : '<b>{point.percentage:.1f}%</b>'
		},
		legend : {
			align : 'right',
			verticalAlign : 'middle',
			floating : false,
			width : 175,
			itemWidth : 270,
			x : -90,
			itemStyle : {
				'font-size' : '12px',
				'font-family' : 'Arial, Helevetica, sans-serif',
				'font-weight' : 'normal'
			},
			symbolHeight : 7,
			symbolPadding : 5,
			maxHeight : 150,
			spaceHeight : 150,
			useHTML : true

		},
		plotOptions : {
			pie : {
				allowPointSelect : true,
				cursor : 'pointer',
				animation : false,
				dataLabels : {
					enabled : false
				},
				showInLegend : true,
				colors : [
						'#1976D2',
						'#4FC3F7',
						'#43A047',
						'#64DD17',
						'#FFD740',
						'#F57C00',
						'#BF360C',
						'#D1C4E9',
						'#7E57C2',
						'#3F51B5' ]
			}
		},
		series : [ {
			colorByPoint : true,
			data : chartData.series
		} ],
		credits : {
			enabled : false
		}
	});
}

reportsUtil.getCustomerFileShareFolderInfo = function(commUniId, ccGroupId, companyId, callback) {
	var request = {};
	request.ccGroupId = ccGroupId;
	request.commUniId = commUniId;
	request.companyId = companyId;
	var URL = cvUtil.getContextPath() + '/reports/customerShareFolderInfo.do';
	cvUtil.loadPageWithGET(URL, request, function(output) {
		if (callback) {
			callback(output);
		} else {
			return output;
		}
	});
};

reportsUtil.isNullOrEmpty = function(value) {
	if (!value || value == '' || value == undefined || value == null) {
		return true;
	}
}

reportsUtil.validateRepeatNHours = function(fieldId, onSaveClick) {
	var freqOption = $(fieldId).val();
	if (freqOption != 'DAILY' || !isChecked($("div[name=repeatEveryNHours]"))) {
		return true;
	}

	var hoursFieldId = "#everyNHoursSpinner";
	var minsFieldId = "#everyNMinsSpinner";

	var nHours = $(hoursFieldId).val();
	var nMins = $(minsFieldId).val();
	var hoursFieldMessage = "";
	var minsFieldMessage = "";

	if (reportsUtil.isNullOrEmpty(nHours)) {
		if (onSaveClick) {
			hoursFieldMessage = cvUtil.cvLocalize('schedule.repeat.required_hours');
		}
	}
	if (reportsUtil.isNullOrEmpty(nMins)) {
		if (onSaveClick) {
			minsFieldMessage = cvUtil.cvLocalize('schedule.repeat.required_mins');
		}
	}
	if (isNaN(nHours) || nHours > 24) {
		hoursFieldMessage = cvUtil.cvLocalize('schedule.repeat.invalid_hours');
	}

	if (isNaN(nMins) || nMins > 59) {
		minsFieldMessage = cvUtil.cvLocalize('schedule.repeat.invalid_mins');
	}

	if ((nHours == 0 && nMins == 0)) {
		minsFieldMessage = hoursFieldMessage = cvUtil.cvLocalize('schedule.repeat.invalid_hours_mins');
	}
	markField(hoursFieldId, hoursFieldMessage);
	return markField(minsFieldId, minsFieldMessage);
}

reportsUtil.enableDisableRepeatEveryElements = function(fieldId) {
	var form = $(fieldId);
	var e = !isChecked($("div[name=repeatEveryNHours]"));
	form.find("#everyNHoursSpinner").prop('disabled', e);
	form.find("#everyNMinsSpinner").prop('disabled', e);

	if (e) {
		form.find("#holdrepeatNHoursElementsData").addClass('disabled');
	} else {
		form.find("#holdrepeatNHoursElementsData").removeClass('disabled');
	}
}

reportsUtil.removeDuplicates = function(list) {
	if (!list) {
		return;
	}
	var newList = [];
	$.each(list, function(i, val) {
		if (newList.indexOf(val) == -1) {
			newList.push(val);
		}
	});

	return newList;
}

reportsUtil.getTileWorkflowHtmlContent = function(rows) {
	var html = "";
	var workflows = [];

	for ( var obj in rows) {
		var rowObj = rows[obj];
		for ( var prop in rowObj) {
			if (rowObj[prop]) {
				workflows.push(rowObj[prop]);
			}
		}
	}

	workflows = reportsUtil.removeDuplicates(workflows);

	if (workflows.length > 1) {
		html += '<div class=\"fixMenuButton\">';
		html += '<div class=\"fixActionMenuDiv\">';
		html += '<label class=\"fixItLabel fixItItem\">' + workflows[0] + '</label>';
		//		html += '<img src=\"../common/img/dropdown_triangle_icon.png\"/>';
		html += '<div class=\"fixActionMenuWrapper\">';
		html += '<select class=\"fixActionMenu\">';
		for ( var key in workflows) {
			html += '<option class=\"fixItLabel fixItItem\" value=\"' + workflows[key] + '\">' + workflows[key] +
					'</option>';
		}
		html += '</select>';

		html += '</div></div></div>';
	} else {
		for ( var key in workflows) {
			html += '<label class=\"fixItLabel fixItItem\">' + workflows[key] + '</label>';
		}
	}
	return html;

}

reportsUtil.getTileTextOutcomeHtmlContent = function(rows) {
	var html = '<div class=\"textOutcomes\">';

	for ( var obj in rows) {
		var rowObj = rows[obj];
		for ( var prop in rowObj) {
			html += '<p class=\"outcome\">' + rowObj[prop] + '</p>';
		}
	}
	html += '</div>';
	return html;
}

reportsUtil.getTileRemarksHtmlContent = function(rows) {
	var html = '<div class=\"tileRemarks\"> <label> Remarks </label>';
	for ( var obj in rows) {
		var rowObj = rows[obj];
		for ( var prop in rowObj) {
			html += '<p class=\"remark\">' + rowObj[prop] + '</p>';
		}
	}
	html += '</div>';
	return html;
}

reportsUtil.getHealthInfo = function(commUniId, ccGroupId, companyId, callback) {
	var request = {};
	var options = '&parameter.commUId=' + commUniId + '&parameter.CCGroupId=' + ccGroupId;
	//var URL = cvUtil.getContextPath() +
	//		'/proxy/cr/reportsplusengine/datasets/Tile Reports/data?cache=true&parameter.tileFlag=2&fields=CategoryId,CategoryName,TileStatus,count(*) as cnt&groupby=CategoryId,CategoryName,TileStatus&orderby=CategoryId,CategoryName' +
	//		options;
	request.ccGroupId = ccGroupId;
	request.commUniId = commUniId > 0 ? commUniId : 0;
	request.companyId = companyId;
	var URL = cvUtil.getContextPath() + '/reports/getHealthSummary.do';

	cvUtil.loadPageWithGET(URL, request, function(output) {
		if (output) {
			if (callback) {
				callback(output);
			} else {
				return output;
			}
		}
	}, function(err) {
		if (err.responseText) {
			var resp = JSON.parse(err.responseText);
			console.error('Health Info: ' + resp.errorMessage);
		} else {
			console.error('Health Info: ' + err);
		}
	});
};

reportsUtil.getServiceTilesData = function(days, commUniId, ccGroupId, companyId, tileType, callback) {
	var request = {};
	request.ccGroupId = ccGroupId;
	request.commUniId = commUniId;
	request.companyId = companyId;
	request.days = days || 90;
	request.tileType = tileType || 0;
	var URL = cvUtil.getContextPath() + '/reports/getServiceTilesData.do';

	cvUtil.loadPageWithGET(URL, request, function(output) {
		if (output) {
			if (callback) {
				callback(output, request.tileType);
			} else {
				return output;
			}
		}
	}, function(err) {
		if (err.responseText) {
			var resp = JSON.parse(err.responseText);
			console.error('getServiceTilesData Info: ' + resp.errorMessage);
		} else {
			console.error('getServiceTilesData Info: ' + err);
		}
	});
};

reportsUtil.getLatestCustomerSatisfacation = function(commUniId, ccGroupId, companyId, callback) {
	var request = {};
	request.ccGroupId = ccGroupId;
	request.commUniId = commUniId;
	request.companyId = companyId;
	var URL = cvUtil.getContextPath() + '/reports/getLatestCustomerSatisfacation.do';

	cvUtil.loadPageWithGET(URL, request, function(output) {
		if (output) {
			if (callback) {
				callback(output);
			} else {
				return output;
			}
		}
	}, function(err) {
		if (err.responseText) {
			var resp = JSON.parse(err.responseText);
			console.error('Customer Satisfaction Info: ' + resp.errorMessage);
		} else {
			console.error('Customer Satisfaction Info: ' + err);
		}
	});
};

reportsUtil.getCommCellsLocationSummary = function(continentSummary, commUniId, ccGroupId, companyId, callback) {
	var request = {};
	request.continentSummary = continentSummary;
	request.ccGroupId = ccGroupId;
	request.commUniId = commUniId;
	request.companyId = companyId;
	var URL = cvUtil.getContextPath() + '/reports/getCommCellsLocationSummary.do';

	cvUtil.loadPageWithGET(URL, request, function(output) {
		if (output) {
			if (callback) {
				callback(output);
			} else {
				return output;
			}
		}
	}, function(err) {
		if (err.responseText) {
			var resp = JSON.parse(err.responseText);
			console.error('Commcells location Info: ' + resp.errorMessage);
		} else {
			console.error('Commcells location Info: ' + err);
		}
	});
};

reportsUtil.getSLAData = function(callback) {
	var url = cvUtil.getContextPath() +
			'/proxy/cr/reportsplusengine/datasets/759275a4-7a25-4007-b973-a31e33ab73c4:16de3715-a53d-4c8d-9a2b-3ee7a0d0d5e4/data/?cacheId=&offset=0&fields=Avg(%5BMetSLAPerc%5D)%20AS%20%5BMetSLAPerc%5D%2C%5BThreshold%5D%20AS%20%5BThreshold%5D&groupby=%5BThreshold%5D&isExport=false&parameter.countFullJobsOnly=0&parameter.countScheduledJobs=0&rawData=false';

	cvUtil.loadPageWithGET(url, null, function(output) {
		if (output) {
			output = JSON.parse(output);
			var result = {};
			if (output.records && output.records[0]) {
				if (typeof output.records[0][0] == 'number') {
					result.sla = parseInt(output.records[0][0]);
				}
				if (typeof output.records[0][1] == 'number') {
					result.threshold = output.records[0][1];
				}

				if (callback) {
					callback(result);
				} else {
					console.log('No callback passed to getSLAData()');
				}
			}

		}
	}, function(err) {
		if (err.responseText) {
			console.error('SLA Data fetch error: ' + resp.errorMessage);
		} else {
			console.error('SLA Data fetch error: ' + err);
		}
	});
};

reportsUtil.getSecurityAPIInfo = function(limit, additionalUrlParams, callback) {

	var url = cvUtil.getContextPath() +
			"/api/cr/reportsplusengine/datasets/47d3afa6-1222-42ae-ad76-e767f5a481a9/data?orderby=%5BType%5D Desc,%5Bname%5D Asc&isExport=false&cacheId=" +
			reportsUtil.UUID; //Uses Security API Built in Custom Report
	if (additionalUrlParams) {
		url += additionalUrlParams;
	}
	if (limit) {
		url += "&limit=" + limit;
	}

	cvUtil.loadPageWithGET(url, null, function(output) {
		if (output) {
			if (callback) {
				callback(output);
			} else {
				console.log('No callback passed to getSecurityAPIInfo()');
			}
		}
	}, function(err) {
		if (err.responseText) {
			var resp = JSON.parse(err.responseText);
			console.error('Security API fetch error: ' + resp.errorMessage);
		} else {
			console.error('Security API fetch error: ' + err);
		}
	});
};

reportsUtil.getCustomReport = function(id, callback) {

	var url = cvUtil.getContextPath() + "/api/cr/reportsplusengine/reports/" + id
	cvUtil.loadPageWithGET(url, null, function(output) {
		if (output) {
			if (callback) {
				callback(output);
			}
		}
	}, function(err) {
		if (err.responseText) {
			var resp = JSON.parse(err.responseText);
			console.error('Error loading the report : ' + resp.errorMessage);
		} else {
			console.error('Error loading the report : ' + err);
		}
	});
};