// ============================================================================
//  Copyright (c) CommVault Systems,
//  All Rights Reserved
//
//  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems
//  The copyright notice above does not evidence any
//  actual or intended publication of such source code.
//
//  Author: Prince Raju
//
// This File should ONLY be used for Export using Java Nashorn Engine
// ============================================================================
if (typeof Reports == "undefined") {
	var Reports = {};
}

if (typeof exportRequest == "undefined") {
	var exportRequest = "pdf";
}

if (window == undefined) {
	var window = this;
};
if (window.location == undefined) {
	window.location = {}
};
if (window.location.href == undefined) {
	window.location.href = ""
};
if (window.location.search == undefined) {
	window.location.search = ""
};

function initializeWindowParams(currentURL) {

	var regex = /^(?:(?:(([^:\/#\?]+:)?(?:(?:\/\/)(?:(?:(?:([^:@\/#\?]+)(?:\:([^:@\/#\?]*))?)@)?(([^:\/#\?\]\[]+|\[[^\/\]@#?]+\])(?:\:([0-9]+))?))?)?)?((?:\/?(?:[^\/\?#]+\/+)*)(?:[^\?#]*)))?(\?[^#]+)?)(#.*)?/;

	var keys = [ "href", // http://user:pass@host.com:81/directory/file.ext?query=1#anchor
	"origin", // http://user:pass@host.com:81
	"protocol", // http:
	"username", // user
	"password", // pass
	"host", // host.com:81
	"hostname", // host.com
	"port", // 81
	"pathname", // /directory/file.ext
	"search", // ?query=1
	"hash" // #anchor
	];

	try {
		var entities = currentURL.match(regex);
		for (var i = 0; i < keys.length; i++) {
			if (entities[i] == undefined) {
				window.location[keys[i]] = "";
			} else {
				window.location[keys[i]] = entities[i];
			}
		}

		console.log("window.location Object created:" + JSON.stringify(window.location));

	} catch (e) {
		console.error("Error creating window.location object in Nashorn")
		console.error(e);
	}

	exportRequest = cvUtil.getParameter('exportType', "");
}

function getMetricsFormattedValue(cellData, element, col, colIndex, rowIndex, oObject) {
	var rendererFunction = null;
	rendererFunction = Reports.Renderers[element];
	if (rendererFunction == null) {
		return cellData;
	}

	if (!oObject) {
		console.error('ERROR: oObject is not defined. Rendering skipped.');
		return cellData;
	}

	oObject.iDataRow = parseInt(rowIndex).toString();
	oObject.iDataColumn = parseInt(colIndex).toString();
	oObject.mDataProp = cellData;

	cellData = rendererFunction(oObject, cellData);
	return cellData;
}

function createMockDataTableObject(columns, rowData) {
	//val = o.aData[o.oSettings.aoColumns[o.iDataColumn].mDataProp];
	var o = {};
	o.oSettings = {};
	o.oSettings.aoColumns = [];
	for (var i = 0; i < columns.length; i++) {
		o.oSettings.aoColumns[i] = {
			"mDataProp" : columns[i].displayName
		};
	}
	o.aData = new Object();

	for (var j = 0; j < columns.length; j++) {
		var col = columns[j];
		var columnIndex = j;
		var cellData = rowData[col.id];
		o.aData[col.displayName] = cellData;
	}
	return o;
}

//Console functions override
console = {}
console.log = function(a) {
	printToConsole('INFO: ' + a);
};
console.debug = function(a) {
	printToConsole('DEBUG: ' + a);
};
console.error = function(a) {
	printToConsole('ERROR: ' + a);
};

function printToConsole(a) {
	if (typeof print == 'function') {
		try {
			print(a);
		} catch (e) {
		}
	}
}

if (!window.customReports) {
	window.customReports = {};
}