<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.office365"></cv:cvMessages>
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
	<cv:cvEnum name="Ida.SharePointItemType"></cv:cvEnum>
	<cv:cvEnum name="Ida.SharePointItemClassification"></cv:cvEnum>
</script>
<div class="row margin-top-10">
	<div class="col-md-6">
		<cv-tile-component data-title='<cv:msg key="label.sp0365.tileHeading" bundle="office365" />' loader="office365SharepointSiteDetailsCtrl.userDetails">
			<ul class="list-style__row group" data-ng-if="office365SharepointSiteDetailsCtrl.hasUserData">
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.o365sp.name" bundle="office365" /> </span>
					<span class="pageDetailColumn" data-ng-bind="office365SharepointSiteDetailsCtrl.userDetails.userAccountInfo.displayName"></span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.o365sp.url" bundle="office365" /> </span>
					<span class="pageDetailColumn" > <a target="_blank" ng-href="{{office365SharepointSiteDetailsCtrl.userDetails.userAccountInfo.smtpAddress}}" >
						<span ng-bind="office365SharepointSiteDetailsCtrl.userDetails.userAccountInfo.smtpAddress"></span> <i class="fa fa-external-link" ></i> </a></span>
				</li>

				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.office365Plan" bundle="office365" /> </span>
					<span class="pageDetailColumn">
							<a href="#office365PlanDetails/{{office365SharepointSiteDetailsCtrl.userDetails.plan.planId}}" data-ng-bind="office365SharepointSiteDetailsCtrl.userDetails.plan.planName"></a></span>
					</span>
				</li>
				
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.o365sp.spWebType" bundle="office365" /> </span>
					<span class="pageDetailColumn" data-ng-bind="office365SharepointSiteDetailsCtrl.userDetails.userAccountInfo.spWebTypeText"></span>
				</li>
				
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.o365sp.spWebItemType" bundle="office365" /> </span>
					<span class="pageDetailColumn" data-ng-bind="office365SharepointSiteDetailsCtrl.userDetails.userAccountInfo.itemTypeText"></span>
				</li>
				
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.o365sp.status" bundle="office365" /> </span>
					<span class="pageDetailColumn" data-ng-bind="office365SharepointSiteDetailsCtrl.userDetails.accountStatusText"></span>
				</li>

				 <li class="group">
					<span class="pageDetailColumn"><cv:msg key="column.size" bundle="office365" /> </span>
					<span class="pageDetailColumn" data-ng-bind="office365SharepointSiteDetailsCtrl.userDetails.formattedAccountSize"></span>
				</li>

				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="info.lastbackuptime" bundle="office365" /> </span>
					<span class="pageDetailColumn" data-ng-class="office365SharepointSiteDetailsCtrl.userDetails.hasLastJob ? '' : 'italic' "  data-ng-bind="office365SharepointSiteDetailsCtrl.userDetails.formattedLastBackupJobRunTime"></span>
				</li> 

				<!-- <li class="group">
					<span class="pageDetailColumn"><cv:msg key="column.numberOfItems" bundle="office365" /> </span>
					<span class="pageDetailColumn" data-ng-bind="office365SharepointSiteDetailsCtrl.userDetails.userAccountInfo.numberOfItems"></span>
				</li>  -->
			</ul>
		</cv-tile-component>
	</div>
	<div class="col-md-6">
		<cv-backup-history entity="office365SharepointSiteDetailsCtrl.backupEntity" 
		show-legend="'true'" params="office365SharepointSiteDetailsCtrl.historyParams"  on-restore="office365SharepointSiteDetailsCtrl.performRestore(job, fromTimeStr, toTimeStr)" ng-if="office365SharepointSiteDetailsCtrl.backupEntity"></cv-backup-history>
	</div>
</div>
