<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.office365"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.sharepoint"></cv:cvMessages>
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
</script>
<div data-ng-if="!o365SharepointSettingsCtrl.associationsLoaded" class="ajax-loader-container">
	<span data-cv-loading-spinner data-ng-model="loader"></span>
</div>
<div data-ng-if="o365SharepointSettingsCtrl.associationsLoaded">
 	<div class="row">
		<div class="col-md-12">
			<span class="server-message {{o365SharepointSettingsCtrl.serverMessage.type}} text-center" data-ng-bind="o365SharepointSettingsCtrl.serverMessage.message"></span>
		</div>
	</div>
	<div class="row">
		<div class="col-md-6">
			<cv-tile-component data-title='<cv:msg key="header.general" bundle="exchange" />' >
				<ul class="list-style-secondary">
					<!--Cloud Region-->
					<li class="group">
						<span class="pageDetailColumn width-40-percentage"><cv:msg key="label.office365.cloudregion" bundle="exchange"/></span>
						<span class="pageDetailColumn width-60-percentage" data-ng-bind="o365SharepointSettingsCtrl.msCloudRegion"></span>
					</li>
					<!--Cloud Region-->

					<!--SharePoint Tenant URL-->
					<li class="group" data-ng-if="o365SharepointSettingsCtrl.showAzureTenantURL">
						<span class="pageDetailColumn width-40-percentage"> <span><cv:msg key="label.tenantURL" bundle="sharepoint"/></span></span>
						<span class="pageDetailColumn width-60-percentage">
							<span class="margin-right-5" title="{{o365SharepointSettingsCtrl.infraStructureSettings.tenantURL}}" data-ng-bind="o365SharepointSettingsCtrl.infraStructureSettings.tenantURL"></span>
							<span class="float-right tile-content-link" >
								<a data-ng-click="o365SharepointSettingsCtrl.editAzureTenantURL(true)">
									<cv:msg key="label.edit" bundle="clients" />
								</a>
							</span>
						</span>
					</li>
					<li class="group"  data-ng-if="!o365SharepointSettingsCtrl.showAzureTenantURL">
						<span class="pageDetailColumn width-40-percentage margin-top-10"><cv:msg key="label.tenantURL" bundle="sharepoint"/></span>
						<span class="pageDetailColumn width-60-percentage inline-editor">
							<div class="inline-editor-input">
								<input class="full-width"  type="text" id="sharePointTenantAdminUrl" name="sharePointTenantAdminUrl"
									data-ng-model="o365SharepointSettingsCtrl.inputTenantURL"
									placeholder='<cv:msg key="placeholder.tenantAdminSiteURL" bundle="office365"/>'
									required autofocus />
							</div>
							<span class="inline-editor-buttons">
								<a class="inline-editor-button" data-ng-class="{disabled: loading}"  ng-click="o365SharepointSettingsCtrl.updateAzureTenantURL()"><span class="k-icon k-i-check"></span></a>
								<a class="inline-editor-button" data-ng-class="{disabled: loading}"  ng-click="o365SharepointSettingsCtrl.editAzureTenantURL(false)"><span class="k-icon k-i-x"></span></a>
							</span>
						</span>
						<div class="help-block margin-top-10"
							data-ng-show="!o365SharepointSettingsCtrl.isAzureTenantURLValid">
							<cv:msg key="error.tenantAdminSiteURL" bundle="clients" />
						</div>
					</li>
					<!--SharePoint Tenant URL-->

					<!--Global Admin Account ... On Edit ..open small-window dialog-->
					<li class="group">
						<span class="pageDetailColumn width-40-percentage"><cv-help-text help-label="label.globalAdministrator" help-text="help.globalAdmin"/></span>
						<span class="pageDetailColumn width-60-percentage" data-ng-if="o365SharepointSettingsCtrl.infraStructureSettings.hasGlobalAdminAccount">
							<span data-ng-bind="o365SharepointSettingsCtrl.infraStructureSettings.globalAdminAccountDetails.userAccount.userName"></span>
							<span class="float-right tile-content-link" >
								<a data-ng-click="o365SharepointSettingsCtrl.openAddEditServiceAccountModal(o365SharepointSettingsCtrl.infraStructureSettings.globalAdminAccountDetails)"><cv:msg key="label.edit" bundle="clients" /></a>
								<a class="margin-left-10" data-ng-click="o365SharepointSettingsCtrl.deleteAccountConfirmation(o365SharepointSettingsCtrl.infraStructureSettings.globalAdminAccountDetails)"><cv:msg key="label.delete" bundle="ediscovery" /></a>
							</span>
						</span>
						<!--Add new Global Administrator-->
						<span class="pageDetailColumn width-60-percentage" data-ng-if="!o365SharepointSettingsCtrl.infraStructureSettings.hasGlobalAdminAccount">
							<label class="restore-help-text italic"><cv:msg key="label.app.not.configured" bundle="office365" /></label>			
							<a class="float-right tile-content-link" 
								data-ng-click="o365SharepointSettingsCtrl.openAddEditServiceAccountModal('',o365SharepointSettingsCtrl.exchangeConstants.ExchangeAccountTypes.EXCHANGE_GLOBAL_ADMIN)"><cv:msg key="label.add" bundle="exchange" /></a>
						</span>
					</li>

					<!--Azure Active Directory ID // Azure AD makes no sense-->
					<!-- <li class="group" data-ng-if="o365SharepointSettingsCtrl.showAzureDirectoryId && o365SharepointSettingsCtrl.infraStructureSettings.azureDirectoryId">
						<span class="pageDetailColumn width-40-percentage"><cv:msg key="label.azureDirectoryID" bundle="exchange" /></span>
						<span class="pageDetailColumn width-60-percentage">
							<span class="float-right tile-content-link" >
								<a data-ng-click="o365SharepointSettingsCtrl.editAzureDirectoryId(true)">
									<cv:msg key="label.edit" bundle="clients" />
								</a>
							</span>
							<span title="{{o365SharepointSettingsCtrl.infraStructureSettings.azureDirectoryId}}" data-ng-bind="o365SharepointSettingsCtrl.infraStructureSettings.azureDirectoryId"></span>
						</span>
					</li> -->
					<li class="group"  data-ng-if="!o365SharepointSettingsCtrl.showAzureDirectoryId">
						<span class="pageDetailColumn width-40-percentage margin-top-10"><cv:msg key="label.azureDirectoryID" bundle="exchange"/></span>
						<span class="pageDetailColumn  width-60-percentage inline-editor">
							<div class="inline-editor-input">
								<input class="full-width" type="text" id="azureDirectoryId" required data-ng-model="o365SharepointSettingsCtrl.inputAzureDirectoryId"/>
							</div>
							<span class="inline-editor-buttons">
								<a class="inline-editor-button" data-ng-class="{disabled: loading}"  ng-click="o365SharepointSettingsCtrl.updateAzureDirectoryId()"><span class="k-icon k-i-check"></span></a>
								<a class="inline-editor-button" data-ng-class="{disabled: loading}"  ng-click="o365SharepointSettingsCtrl.editAzureDirectoryId(false)"><span class="k-icon k-i-x"></span></a>
							</span>
						</span>
						<div class="help-block margin-top-10" data-ng-show="!o365SharepointSettingsCtrl.isAzureDirectoryValid">
							<cv:msg key="error.valid.azure.directory" bundle="office365" />
						</div>
					</li>
					<!--Azure Active Directory ID-->

					<!--Modern authentication-->	
					<li class="group">
						<span class="pageDetailColumn width-40-percentage"><cv-help-text help-label="label.useModernAuthentication" help-text="help.modernAuth"/></span>
						<span class="pageDetailColumn width-60-percentage">
							<toggle-control status="o365SharepointSettingsCtrl.infraStructureSettings.isModernAuthEnabled" data-ng-click="o365SharepointSettingsCtrl.modernAuthToggled()" title='<cv:msg key="label.useModernAuthentication" bundle="office365"/>'></toggle-control>
						</span>
					</li>
					<!--Modern authentication-->	
				</ul>
			</cv-tile-component>
			<cv-tile-component data-title='<cv:msg key="label.sharepointConnectionSettings" bundle="office365" />' loader="o365SharepointSettingsCtrl.infraStructureSettings" >
				<ul class="list-style-secondary">
					<li class="group">
						<cv-tabset-component control='o365SharepointSettingsCtrl.tabControls' element="cvtile" ng-if="o365SharepointSettingsCtrl.SPAzureServiceAccountsGridOptions">
							<cv-tab tabname='<cv:msg key="label.azureApps" bundle="office365" />'>
								<cv-kendo-grid data-cv-grid-options="o365SharepointSettingsCtrl.SPAzureAppsGridOptions"></cv-kendo-grid>
							</cv-tab>
							<cv-tab tabname='<cv:msg key="label.office365ServiceAccts" bundle="exchange" />'>
								<cv-kendo-grid data-cv-grid-options="o365SharepointSettingsCtrl.SPAzureServiceAccountsGridOptions"></cv-kendo-grid>
							</cv-tab>
						</cv-tabset-component>
					<li>
				</ul>
			</cv-tile-component>
			<cv-on-boarding-warning-msg backupset-id="o365SharepointSettingsCtrl.backupsetId"  client-id="o365SharepointSettingsCtrl.clientId" is-tile-view="true"></cv-on-boarding-warning-msg>
		</div>
		<div class="col-md-6">
			<cv-tile-component data-title='<cv:msg key="label.infrastructurePane" bundle="exchange" />'	loader="o365SharepointSettingsCtrl.infrastructureSettingsLoaded">
				<ul class="list-style-secondary">
					<!--Start --Infrastructure pool set-->
					<div data-ng-if="o365SharepointSettingsCtrl.infraStructureSettings.isInfrastructureConfigured || office365OneDriveSettingsCtrl.isOffice365SaaSTenant">
						<li class="group" data-ng-if="o365SharepointSettingsCtrl.showPlan">
							<span class="pageDetailColumn width-40-percentage"><cv:msg key="label.serverPlan" bundle="exchange"/></span>
							<span class="pageDetailColumn width-60-percentage">
								<span data-ng-bind="o365SharepointSettingsCtrl.planName"></span>
							</span>
						</li>

						<div class="text-muted pageDetailColumn width-60-percentage float-right tile-content-link">
							<cv:msg key="label.infrastructureInheritedFromPlan" bundle="exchange" />
						</div>
					</div>
					<!--End --Infrastructure pool set-->

					<!--Start --Infrastructure pool not set-->
					<div data-ng-if="!o365SharepointSettingsCtrl.infraStructureSettings.isInfrastructureConfigured && !office365OneDriveSettingsCtrl.isOffice365SaaSTenant">
						<!--CLIENT PLAN-->
						<li class="group" data-ng-if="o365SharepointSettingsCtrl.showPlan">
							<span class="pageDetailColumn width-40-percentage"><cv:msg key="label.serverPlan" bundle="exchange"/></span>
							<span class="pageDetailColumn width-60-percentage">
								<a data-ng-click="o365SharepointSettingsCtrl.gotoPlanDetails()">
									<span data-ng-bind="o365SharepointSettingsCtrl.planName"></span>
								</a>
								<span class="float-right tile-content-link" >
									<a data-ng-click="o365SharepointSettingsCtrl.editServerPlan(true)">
										<cv:msg key="label.edit" bundle="clients" />
									</a>
								</span>
							</span>
						</li>

						<li class="group"  data-ng-if="!o365SharepointSettingsCtrl.showPlan">
							<span class="pageDetailColumn width-40-percentage margin-top-10"><cv:msg key="label.serverPlan" bundle="exchange"/></span>
							<span class="pageDetailColumn width-60-percentage inline-editor">
								<cv-plan-summary-dropdown
									class="full-width"
									input-model="o365SharepointSettingsCtrl.serverPlanList"
									output-model="o365SharepointSettingsCtrl.selectedPlanList"
									button-label="'planName'"
									item-label="'planName'"
									tick-property="'selected'"
									selection-mode="'single'"
									directive-id="'plans'"
									max-labels="1"
									helper-elements="'filter'"
									translation="o365SharepointSettingsCtrl.localLang"
									disable-property="'disabled'">
								</cv-plan-summary-dropdown>

								<span class="inline-editor-buttons">
									<a class="inline-editor-button" data-ng-class="{disabled: loading}"  ng-click="o365SharepointSettingsCtrl.updateServerPlan()"><span class="k-icon k-i-check"></span></a>
									<a class="inline-editor-button" data-ng-class="{disabled: loading}"  ng-click="o365SharepointSettingsCtrl.editServerPlan(false)"><span class="k-icon k-i-x"></span></a>
								</span>
							</span>
						</li>
						<!--CLIENT PLAN-->

						<!--BACKUP STREAMS-->
						<li class="group" data-ng-if="o365SharepointSettingsCtrl.showBackupStreams">
							<span class="pageDetailColumn width-40-percentage"><cv:msg key="label.maxStream" bundle="exchange" /></span>
							<span class="pageDetailColumn width-60-percentage">
								<span data-ng-bind="o365SharepointSettingsCtrl.maxBackupStreams"> </span>
								<span class="float-right tile-content-link" >
									<a data-ng-click="o365SharepointSettingsCtrl.editBackupStreams(true)">
										<cv:msg key="label.edit" bundle="clients" />
									</a>
								</span>
							</span>
						</li>

						<li class="group"  data-ng-if="!o365SharepointSettingsCtrl.showBackupStreams">
							<span class="pageDetailColumn width-40-percentage argin-top-10"><cv:msg key="label.maxStream" bundle="exchange"/></span>
							<span class="pageDetailColumn width-60-percentage inline-editor">
								<div class="inline-editor-input">
									<input class="half-width" type="number" min=1 max="9999" id="maxStream" data-ng-model="o365SharepointSettingsCtrl.maxBackupStreams">
								</div> 
								<span class="inline-editor-buttons">
									<a class="inline-editor-button" data-ng-class="{disabled: loading}"  ng-click="o365SharepointSettingsCtrl.updateBackupStreams()"><span class="k-icon k-i-check"></span></a>
									<a class="inline-editor-button" data-ng-class="{disabled: loading}"  ng-click="o365SharepointSettingsCtrl.editBackupStreams(false)"><span class="k-icon k-i-x"></span></a>
								</span>
							</span>
							<div class="help-block margin-top-10" data-ng-show="o365SharepointSettingsCtrl.errorMaxStreams"> <cv:msg key="error.max.streams.that.can.be.used" bundle="exchange" /></div>
						</li>
						<!--BACKUP STREAMS-->

						<!-- Start Index Server -->
						<li class="group" data-ng-if="o365SharepointSettingsCtrl.showIndexServer">
							<cv-help-text class="pageDetailColumn width-40-percentage" help-label="label.indexServer" help-text="info.indexServer"/>
							<span class="pageDetailColumn width-60-percentage inline-editor">
								<span class="inline-editor-text" title="{{o365SharepointSettingsCtrl.infraStructureSettings.indexServer.mediaAgentName}}" data-ng-bind="o365SharepointSettingsCtrl.infraStructureSettings.indexServer.mediaAgentName"></span>
								<span class="float-right tile-content-link" >
									<a data-ng-click="o365SharepointSettingsCtrl.editIndexServer(true)">
										<cv:msg key="label.edit" bundle="clients" />
									</a>
								</span>
							</span>
						</li>

						<li class="group"  data-ng-if="!o365SharepointSettingsCtrl.showIndexServer">
							<cv-help-text class="pageDetailColumn width-40-percentage" help-label="label.indexServer" help-text="info.indexServer"/>
									<span class="pageDetailColumn width-60-percentage inline-editor">

									<isteven-multi-select id="indexServer" input-model="o365SharepointSettingsCtrl.indexServersList"
										output-model="o365SharepointSettingsCtrl.selectedIndexList" button-label="mediaAgentName"
										item-label="mediaAgentName" tick-property="selected" class="isteven-multi-select user-group-select"
										helper-elements="filter" selection-mode="single" translation="o365SharepointSettingsCtrl.localLang" on-item-click="o365SharepointSettingsCtrl.processIndexServerSelection(data)">
									</isteven-multi-select>

									<span class="inline-editor-buttons">
										<a class="inline-editor-button" data-ng-class="{disabled: loading}"  ng-click="o365SharepointSettingsCtrl.updateIndexServer()"><span class="k-icon k-i-check"></span></a>
										<a class="inline-editor-button" data-ng-class="{disabled: loading}"  ng-click="o365SharepointSettingsCtrl.editIndexServer(false)"><span class="k-icon k-i-x"></span></a>
									</span>
								</span>
						</li>
						<!-- End Index Server -->

						<!-- Start Access Nodes -->
						<li class="group">
							<cv-help-text class="pageDetailColumn  width-40-percentage" help-label="label.accessNodes" help-text="help.office365Accessnodes"/>
							<span class="pageDetailColumn width-60-percentage">
								<span class="float-right tile-content-link" >
									<a data-ng-click="o365SharepointSettingsCtrl.editAccessNodes()">
										<cv:msg key="label.edit" bundle="clients" />
									</a>
								</span>
								<div title="{{o365SharepointSettingsCtrl.infraStructureSettings.accessNode}}" data-ng-bind="o365SharepointSettingsCtrl.infraStructureSettings.accessNode"></div>
								<!--Local System Account ... On Edit ..open small-window dialog-->
								<span data-ng-if="o365SharepointSettingsCtrl.infraStructureSettings.hasLocalSysAccount" 
									class="restore-help-text crop crop margin-top-5" 
									data-toggle="tooltip"
									title='<cv:msg key="label.sharePathAccount" bundle="exchange"/>'>
									<i class="fa fa-user margin-right-10"></i>
									<label data-ng-bind="o365SharepointSettingsCtrl.infraStructureSettings.serviceAccountTypeSystem.userAccount.userName"></label>
								</span>
								<span data-ng-if="o365SharepointSettingsCtrl.infraStructureSettings.jobResulsDir.path"
									class="restore-help-text crop" 
									data-toggle="tooltip"
									title='<cv:msg key="label.jobResultsDirectory" bundle="exchange"/>'>
									<i class="fa fa-folder margin-right-10"></i>
									<label data-ng-bind="o365SharepointSettingsCtrl.infraStructureSettings.jobResulsDir.path"></label>
								</span>
							</span>
						</li>
						<!-- End Access Nodes -->
						
						<!--Azure Storage ... -->
						<li class="group">
							<span class="pageDetailColumn width-40-percentage"><cv:msg key="label.azureStorageAccount" bundle="office365" /></span>
							<span class="pageDetailColumn width-60-percentage" data-ng-if="o365SharepointSettingsCtrl.infraStructureSettings.hasAzureStorageAccount">
								<span data-ng-bind="o365SharepointSettingsCtrl.infraStructureSettings.azureStorageAccountDetails.userAccount.userName"></span>
								<span class="float-right tile-content-link" >
									<a data-ng-click="o365SharepointSettingsCtrl.openAddEditServiceAccountModal(o365SharepointSettingsCtrl.infraStructureSettings.azureStorageAccountDetails)"><cv:msg key="label.edit" bundle="clients" /></a>
									<a class="margin-left-10" data-ng-click="o365SharepointSettingsCtrl.deleteAccountConfirmation(o365SharepointSettingsCtrl.infraStructureSettings.azureStorageAccountDetails)"><cv:msg key="label.delete" bundle="ediscovery" /></a>
								</span>
							</span>
							<!--Add new Storage account-->
							<span class="pageDetailColumn width-60-percentage" data-ng-if="!o365SharepointSettingsCtrl.infraStructureSettings.hasAzureStorageAccount">
								<label class="restore-help-text italic"><cv:msg key="label.app.not.configured" bundle="office365" /></label>			
								<a class="float-right tile-content-link" 
									data-ng-click="o365SharepointSettingsCtrl.openAddEditServiceAccountModal('',o365SharepointSettingsCtrl.exchangeConstants.ExchangeAccountTypes.SHAREPOINT_AZURE_STORAGE)"><cv:msg key="label.add" bundle="exchange" /></a>
							</span>
						</li>

						<!--  Check Readiness -->
						<li class="group" data-ng-if="o365SharepointSettingsCtrl.associationsLoaded">
							<span class="pageDetailColumn width-40-percentage">
								<cv:msg key="label.clientReadiness" bundle="clients" />
							</span>
							<span class="pageDetailColumn width-60-percentage client-readiness">
								<span data-ng-if="o365SharepointSettingsCtrl.readinessStatus" >
									<span data-ng-bind="o365SharepointSettingsCtrl.readinessStatus"></span>
									<span data-ng-if="o365SharepointSettingsCtrl.clientReadinessLastCheckedText" class="parenthetical-text last-checked" data-ng-bind="o365SharepointSettingsCtrl.clientReadinessLastCheckedText"></span>
								</span>
								<span data-ng-if="!o365SharepointSettingsCtrl.readinessStatus">
									<cv:msg key="label.notAvailable" bundle="servers" />
								</span>	
								<span class="float-right tile-content-link" >
									<a data-ng-click="o365SharepointSettingsCtrl.onClickShowDetailedReport()" uib-tooltip="<cv:msg key='label.showDetailedClientReadinessReport' bundle='clients' />" tooltip-placement="top"><cv:msg key='label.showDetails' bundle='clients' /></a>
								</span>
							</span>
						</li>
						<!--  End Check Readiness -->
					</div>
				</ul>
			</cv-tile-component>
			<cv-activity-control-component data-ac-params="o365SharepointSettingsCtrl.backupset.acParams"></cv-activity-control-component>
			<cv-security-component
				directive-id="securityDir"
				entity-type='o365SharepointSettingsCtrl.securityEntityType'
				generic-entity = 'o365SharepointSettingsCtrl.genericEntity'
				associations='o365SharepointSettingsCtrl.clientSecurityAssociations'
				associations-loaded="o365SharepointSettingsCtrl.securityAssociationsLoaded"
				show-owners="true">
			</cv-security-component>
			
		</div>
	</div>
</div>
