<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.office365"></cv:cvMessages>
	<cv:cvEnum name="Ida.CloudAppDiscoverByType"></cv:cvEnum>
	<cv:cvEnum name="Ida.SharePointItemClassification"></cv:cvEnum>
</script>
<div class="setup-title">
	<h1>
		<cv:msg key="o365.sp.reAssociateWeb" bundle="office365"/>
	</h1>
</div>
<div class="wrapper-view bootstrap-wrapper">
	<p class="{{o365spReAssociateWebCtrl.reassociateMessage.type}} serverMessage" data-ng-bind="o365spReAssociateWebCtrl.reassociateMessage.message"></p>
	<form name="o365SPReAssociateWebForm" id="o365sp-reassocaite-web-form" novalidate autocomplete="off">	
		<div class="form-group row  margin-top-10 margin-left-0 margin-right-0">
			<label class="col-xs-12 col-md-4 col-lg-4" for="o365spReAssociateWebAssociation_isteven-select_#1"><cv:msg key="label.sp0365.office365Plan" bundle="office365" /></label>
			<div class="col-xs-12 col-md-8 col-lg-8">
				<div class="create-new-button-wrapper">
					<div class="input-group input-group-isteven-button">
						<isteven-multi-select 
							id="o365spReAssociateWebAssociation_isteven-select_#1"
							input-model="o365spReAssociateWebCtrl.office365PlanList"
							output-model="o365spReAssociateWebCtrl.selectedPlanList"
							ng-attr-title="{{o365spReAssociateWebCtrl.selectedPlanList[0].planName}}"
							button-label="planName"
							item-label="planName"
							selection-mode="single"
							helper-elements="filter"
							directive-id="office365PlanList_inline"
							max-labels="1"
							tick-property="selected"
							translation="o365spReAssociateWebCtrl.localLang">
						</isteven-multi-select>

						<span class="input-group-btn" data-ng-if="o365spReAssociateWebCtrl.createPlanCapablity">
							<button id="o365spReAssociateWebCeateNewPlanInline"
								type="button"
								class="icon-style cv-material-button browse"
								data-ng-click="o365spReAssociateWebCtrl.createO365PlanInline()">
								<div class="cv-material-button-icon cursor-pointer">
									<span class="k-icon k-i-plus create-new-button"></span>
								</div><div class="cv-material-button-tooltip"><cv:msg key="label.createNew" bundle="exchange" /></div>
							</button>
						</span>
					</div>
				</div>
			</div>
		</div>

		<div class="row">
			<!--Cache info-->
			<cv-on-boarding-warning-msg backupset-id="o365spReAssociateWebCtrl.backupsetId" client-id="o365spReAssociateWebCtrl.clientId" is-tile-view="false"></cv-on-boarding-warning-msg>
			<div class="margin-top-20">
				<div class="plain-accordion">
					<div class="cv-accordion-header">
						<span class="cv-accordion-text"> <cv:msg key="label.o365sp.allWebs" bundle="office365" /></span>
						<span class="restore-help-text"><i class="k-icon k-i-hyperlink-open margin-right-5"></i>
							<a data-ng-click="o365spReAssociateWebCtrl.launchDiscoveryContent()">
							<cv:msg key="info.sharepointFromCache" bundle="office365" /> <b><span data-ng-if="o365spReAssociateWebCtrl.cacheInfoLoaded" data-ng-bind="o365spReAssociateWebCtrl.lastDiscoverCacheUpdateTime"></span> </b>
							</a> <i data-ng-if="!o365spReAssociateWebCtrl.cacheInfoLoaded" class="fa fa-spinner fa-spin"></i>
						</span>
					</div>
				</div>
			</div> 
		</div>

		<div class="row">
			<div class="form-group">
              <cv-kendo-grid data-cv-grid-options="o365spReAssociateWebCtrl.nonAssocWebSitesGridOptions"></cv-kendo-grid>
            </div>
		</div>
		<div class="button-container">
			<button id="o365SPReAssociateWeb_button_#2774" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="o365spReAssociateWebCtrl.cancel()"><cv:msg key="action.cancel" bundle="office365"/></button> 
			<button id="o365SPReAssociateWeb_button_#5176" type="button" class="btn btn-primary cvBusyOnAjax" data-ng-click="o365spReAssociateWebCtrl.reassociateOnlySite()"><cv:msg key="action.reassociateOnlySite" bundle="office365"/></button> 
			<!-- <button id="o365SPReAssociateWeb_button_#9370" type="button" class="btn btn-primary cvBusyOnAjax" data-ng-click="o365spReAssociateWebCtrl.reassociateSubSitesWithin()"><cv:msg key="action.reassociateSubSiteWithin" bundle="office365"/></button> -->
		</div>
	</form>
</div>
