<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.office365"></cv:cvMessages>
	<cv:cvEnum name="Ida.CloudAppDiscoverByType"></cv:cvEnum>
</script>
<div class="setup-title">
	<h1 data-ng-bind="o365spEditAssociationCtrl.title"></h1>
</div>
<div class="bootstrap-wrapper modal-body">
	<p data-ng-show="o365spEditAssociationCtrl.editAssociationMessage.message" class="{{o365spEditAssociationCtrl.editAssociationMessage.type}} serverMessage" data-ng-bind="o365spEditAssociationCtrl.editAssociationMessage.message"></p>
	<form name="o365SPEditAssociationForm" id="o365sp-edit-association-form" data-cv-submit="o365spEditAssociationCtrl.updateAssociation()" novalidate autocomplete="off">

		<div class="word-break-rule margin-bottom-15" data-ng-if="!o365spEditAssociationCtrl.isMultiEdit && !o365spEditAssociationCtrl.isSetAssociation">
			<div>
				<div class="form-group row">
					<label class="col-xs-12 col-md-4"><cv:msg key="label.o365sp.name" bundle="office365" /></label>
					<label class="col-xs-12 col-md-8" data-ng-bind="o365spEditAssociationCtrl.displayName"></label>
				</div>
				<div class="form-group row" data-ng-show="o365spEditAssociationCtrl.displayURL">
					<label class="col-xs-12 col-md-4"><cv:msg key="label.o365sp.url" bundle="office365"/></label>
					<label class="col-xs-12 col-md-8" data-ng-bind="o365spEditAssociationCtrl.displayURL"></label>
				</div>
			</div>
		</div>

		<div class="form-horizontal margin-bottom-15">
			<div data-ng-show="o365spEditAssociationCtrl.flagChangeStatus" class="margin-bottom-15">
				<div data-ng-if="o365spEditAssociationCtrl.type !== 'ASSOCIATED_SHAREPOINT_WEB_SITES'">
					<div data-ng-if="o365spEditAssociationCtrl.accountStatusForDisplay==='DISABLED'">
						<div class="form-group">
						<label class="col-xs-12 col-md-12 col-lg-12" for="name"><cv:msg key="label.areYouSureYouWantToEnableAutoDiscovery" bundle="office365"/> {{o365spEditAssociationCtrl.typeName}}?</label>
						</div>
					</div>
					<div data-ng-if="o365spEditAssociationCtrl.accountStatusForDisplay==='NONE'">
						<div class="form-group">
						<label class="col-xs-12 col-md-12 col-lg-12" for="name"><cv:msg key="label.areYouSureYouWantToDisableAutoDiscovery" bundle="office365"/> {{o365spEditAssociationCtrl.typeName}}?</label>
						</div>
					</div>
				</div>
				<div data-ng-if="o365spEditAssociationCtrl.type === 'ASSOCIATED_SHAREPOINT_WEB_SITES'">
					<div data-ng-if="o365spEditAssociationCtrl.accountStatusForDisplay==='DISABLED'">
						<div class="form-group">
						<label class="col-xs-12 col-md-12 col-lg-12" for="name"><cv:msg key="label.areYouSureYouWantToEnableWeb" bundle="office365"/> {{o365spEditAssociationCtrl.typeName}}?</label>
						</div>
					</div>
					<div data-ng-if="o365spEditAssociationCtrl.accountStatusForDisplay==='NONE'">
						<div class="form-group">
						<label class="col-xs-12 col-md-12 col-lg-12" for="name"><cv:msg key="label.areYouSureYouWantToDisableWeb" bundle="office365"/> {{o365spEditAssociationCtrl.typeName}}?</label>
						</div>
					</div>
				</div>
			</div>

			<div class="margin-bottom-15" ng-if="o365spEditAssociationCtrl.isSetAssociation"> 
				<cv-on-boarding-warning-msg backupset-id="o365spEditAssociationCtrl.paramsForEditAssocController.backupsetId" client-id="o365spEditAssociationCtrl.clientId" is-tile-view="false" extra-classes="'margin-right-10 margin-left-5'"></cv-on-boarding-warning-msg>
			</div>
			<div class="form-group" data-ng-show="o365spEditAssociationCtrl.flagShowPlan">
				<div>
					<label class="col-xs-12 col-md-4 col-lg-4"
						for="o365spEditAssociationCtrl_isteven-select_#1"><cv:msg key="label.sp0365.office365Plan" bundle="office365" /></label>
					<div class="col-xs-12 col-md-8 col-lg-8">
						<div class="create-new-button-wrapper">
							<div class="input-group input-group-isteven-button">
								<isteven-multi-select 
									id="o365spEditAssociationCtrl_isteven-select_#1"
									input-model="o365spEditAssociationCtrl.office365PlanList"
									output-model="o365spEditAssociationCtrl.selectedPlanList"
									ng-attr-title="{{o365spEditAssociationCtrl.selectedPlanList[0].planName}}"
									button-label="planName"
									item-label="planName"
									selection-mode="single"
									helper-elements="filter"
									directive-id="office365PlanList_inline"
									max-labels="1"
									tick-property="selected"
									translation="o365spEditAssociationCtrl.localLang">
								</isteven-multi-select>

								<span class="input-group-btn" data-ng-if="o365spEditAssociationCtrl.createPlanCapablity">
									<button id="o365SPChangePlanAssoCreateNewPlanInline"
										type="button"
										class="icon-style cv-material-button browse"
										data-ng-click="o365spEditAssociationCtrl.createO365PlanInline()">
										<div class="cv-material-button-icon cursor-pointer">
											<span class="k-icon k-i-plus create-new-button"></span>
										</div><div class="cv-material-button-tooltip"><cv:msg key="label.createNew" bundle="exchange" /></div>
									</button>
								</span>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="button-container">
			<button id="o365SPEditAssociation_button_#2484" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="o365spEditAssociationCtrl.cancel()"><cv:msg key="action.cancel" bundle="office365"/></button> 
			<button id="o365SPEditAssociation_button_#7107" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="action.yes" bundle="office365"/></button> 
		</div>
	</form>
</div>
