<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.office365"></cv:cvMessages>
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
</script>
<div class="modal-header">
	<h1><cv-help-text help-label="header.discover.state" help-text="info.discoverStateDetails.sharepoint" use-icon="true"/></h1>
</div>
<!--End --Modal Header-->
<div class="modal-body-fixed">
	<div data-ng-show="!o365SPDiscoverCacheCtrl.infoLoaded" class="margin-top-20 horz-center grid-data-spinner">
		<img src="${pageContext.request.contextPath}/common/img/ajax-loader.gif">
	</div>

	<!--Discover Status --START-->
	<div data-ng-show="o365SPDiscoverCacheCtrl.infoLoaded">
		<div class="plain-accordion">
			<div class="cv-accordion-header">
				<span class="cv-accordion-text margin-left-5"><cv:msg key="label.summary" bundle="profiles" /></span>
					<a class="page-action-item padding-5 margin-right-10 margin-top-5 margin-bottom-5" 
						data-ng-click="o365SPDiscoverCacheCtrl._refreshCache()">
						<i class="k-icon k-i-refresh-sm"></i><cv:msg key="label.forceCacheRefresh" bundle="office365" />
					</a>
			</div>
		</div>

		<div data-ng-if="o365SPDiscoverCacheCtrl.errorCode" class="error">
			<span data-ng-bind="o365SPDiscoverCacheCtrl.errorMessage"></span> [<span data-ng-bind="o365SPDiscoverCacheCtrl.errorTimestampDisp"></span>]
		</div>

		<div class="vertical-label-style half-parts margin-top-20 padding-left-15 padding-right-15">
			<ul class="list-style-secondary groups-item margin-left-10 margin-top-5">

				<li class="group" data-ng-show="o365SPDiscoverCacheCtrl.errorCode">
					<span class="pageDetailColumn"><cv:msg key="Status" bundle="job" /></span>
					<span class="pageDetailColumn"><cv:msg key="Failed" bundle="messagesJs" /></span>
				</li>
				<li class="group" data-ng-show="o365SPDiscoverCacheCtrl.errorCode"> </li>
				<li class="group" data-ng-show="!o365SPDiscoverCacheCtrl.errorCode">
					<span class="pageDetailColumn"><cv:msg key="Status" bundle="job" /></span>
					<span class="pageDetailColumn" data-ng-bind="o365SPDiscoverCacheCtrl.discoveryStatusDisp"></span>
				</li>
				<li class="group" data-ng-show="!o365SPDiscoverCacheCtrl.errorCode">
					<span class="pageDetailColumn"><cv:msg key="Progress" bundle="job" /></span>
					<span class="pageDetailColumn pageProgress process">
							<div ng-style="{ 'width' : o365SPDiscoverCacheCtrl.discoveryProgress}" class="process-bar" data-ng-class="o365SPDiscoverCacheCtrl.progressBarColor"></div>
							<span class="spanPercentage process-index" data-ng-bind="o365SPDiscoverCacheCtrl.discoveryProgress"></span>
					</span>
				</li>
				<li class="group" data-ng-show="o365SPDiscoverCacheCtrl.discoveryStatus != o365SPDiscoverCacheCtrl.sharepointDiscoverStates.RUNNING">
					<span class="pageDetailColumn"><cv:msg key="count.lastCacheSiteCount" bundle="office365" /></span>
					<span class="pageDetailColumn" data-ng-bind="o365SPDiscoverCacheCtrl.lastCacheSiteCount"></span>
				</li>
				<li class="group" data-ng-show="o365SPDiscoverCacheCtrl.discoveryStatus != o365SPDiscoverCacheCtrl.sharepointDiscoverStates.RUNNING">
					<span class="pageDetailColumn"><cv:msg key="count.lastCacheSubsiteCount" bundle="office365" /></span>
					<span class="pageDetailColumn" data-ng-bind="o365SPDiscoverCacheCtrl.lastCacheSubsiteCount"></span>
				</li>
				<li class="group" data-ng-show="o365SPDiscoverCacheCtrl.discoveryStatus != o365SPDiscoverCacheCtrl.sharepointDiscoverStates.RUNNING">
					<span class="pageDetailColumn"><cv:msg key="label.cacheUpdateTime" bundle="office365" /></span>
					<span class="pageDetailColumn" data-ng-bind="o365SPDiscoverCacheCtrl.lastDiscoverCacheUpdateTime"></span>
				</li>

				<li class="group" data-ng-show="o365SPDiscoverCacheCtrl.discoveryStatus == o365SPDiscoverCacheCtrl.sharepointDiscoverStates.RUNNING">
					<span class="pageDetailColumn"><cv:msg key="count.progress.totalSitesDiscovered" bundle="office365" /></span>
					<span class="pageDetailColumn" data-ng-bind="o365SPDiscoverCacheCtrl.discoveredSites"></span>
				</li>
				<li class="group" data-ng-show="o365SPDiscoverCacheCtrl.discoveryStatus == o365SPDiscoverCacheCtrl.sharepointDiscoverStates.RUNNING">
					<span class="pageDetailColumn"><cv:msg key="count.progress.totalSubsitesDiscovered" bundle="office365" /></span>
					<span class="pageDetailColumn" data-ng-bind="o365SPDiscoverCacheCtrl.discoveredSubsites"></span>
				</li>
				<li class="group" data-ng-show="o365SPDiscoverCacheCtrl.discoveryStatus == o365SPDiscoverCacheCtrl.sharepointDiscoverStates.RUNNING">
					<span class="pageDetailColumn"><cv:msg key="count.totalSites" bundle="office365" /></span>
					<span class="pageDetailColumn" data-ng-bind="o365SPDiscoverCacheCtrl.totalSites"></span>
				</li>
				<li class="group" data-ng-show="o365SPDiscoverCacheCtrl.discoveryStatus == o365SPDiscoverCacheCtrl.sharepointDiscoverStates.RUNNING">
					<span class="pageDetailColumn"><cv:msg key="count.progress.totalDiscovered" bundle="office365" /></span>
					<span class="pageDetailColumn" data-ng-bind="o365SPDiscoverCacheCtrl.totalDiscovered"></span>
				</li>

			</ul>
		</div>
		<!--Discover Status --END--> 
	</div>

</div>
<!--End --Modal Body-->
<div class="modal-footer">
	<button id="office365OneDriveAddAssociation_button_#4017" class="btn btn-default" type="button" data-ng-click="o365SPDiscoverCacheCtrl.closeDialog()"> 
		<cv:msg key="label.close" bundle="messagesJs" />
	</button>
</div>
<!--End --Modal Footer-->
