<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.office365"></cv:cvMessages>
	<cv:cvMessages bundle="localization.sharepoint"></cv:cvMessages>
</script>
<div class="bootstrap-wrapper">
	<form name="addEditSPServieAccount" novalidate class="form-horizontal"
		data-cv-submit="addSPServiceAccountCtrl.add()" autocomplete="off">
		<div class="modal-header">
			<h1 data-ng-bind="addSPServiceAccountCtrl.title"></h1>		
		</div>
		<div class="modal-body no-padding">
			<div class="panel-body">

				<!-- For Other Service accounts  Start-->
				<div data-ng-if ="addSPServiceAccountCtrl.serviceAccount.serviceType !== 'SHAREPOINT_AZURE_STORAGE'">
					<div class="form-group">
						<cv-help-text class="col-xs-12 col-lg-4 margin-top-10" help-label="label.username" 
							help-text="help.sharePointAdminUser" data-ng-if="addSPServiceAccountCtrl.serviceAccount.serviceType == 'SHAREPOINT_ONLINE'"/>
						<cv-help-text class="col-xs-12 col-lg-4 margin-top-10" help-label="label.globalAdministrator" 
							help-text="help.globalAdmin" data-ng-if="addSPServiceAccountCtrl.serviceAccount.serviceType == 'EXCHANGE_GLOBAL_ADMIN'"/>
						<div class="col-xs-12 col-lg-8">
							<input type="email" name="userName" id="userName"
								data-ng-model="addSPServiceAccountCtrl.serviceAccount.userAccount.userName"
								data-ng-pattern="addSPServiceAccountCtrl.EMAIL"
								required
								placeholder="<cv:msg key="label.emailAddressPlaceholder" bundle="exchange"></cv:msg>" />
							<div class="help-block"
								data-ng-if="cv.addEditSPServieAccount.needsAttention(addEditSPServieAccount.userName)">
								<cv:msg key="error.noUserName" bundle="exchange" />
							</div>
						</div>
					</div>
					<div class="form-group">
						<label for="password" class="col-xs-12 col-lg-4"><cv:msg
								key="label.password" bundle="exchange" /></label>
						<div class="col-xs-12 col-lg-8">
							<input type="password" name="password" id="password"
								data-ng-model="addSPServiceAccountCtrl.serviceAccount.userAccount.password" required />
							<div class="help-block"
								data-ng-if="cv.addEditSPServieAccount.needsAttention(addEditSPServieAccount.password)">
								<cv:msg key="error.noPassword" bundle="exchange" />
							</div>
						</div>
					</div>
					<div class="form-group">
						<label for="confirmPassword" class="col-xs-12 col-md-4"><cv:msg
								key="label.confirmPassword" bundle="exchange" /></label>
						<div class="col-xs-12 col-md-8">
							<input type="password" name="confirmPassword" id="confirmPassword"
								data-ng-model="addSPServiceAccountCtrl.serviceAccount.userAccount.confirmPassword"
								data-cv-equals="{{addSPServiceAccountCtrl.serviceAccount.userAccount.password}}" required />
							<div class="help-block"
								data-ng-if="addEditSPServieAccount.confirmPassword.$error.required && cv.addEditSPServieAccount.needsAttention(addEditSPServieAccount.confirmPassword)">
								<cv:msg key="error.noConfirmPassword" bundle="exchange" />
							</div>
							<div class="help-block"
								data-ng-if="!addEditSPServieAccount.confirmPassword.$error.required && addEditSPServieAccount.confirmPassword.$error.cvEquals && cv.addEditSPServieAccount.needsAttention(addEditSPServieAccount.confirmPassword)">
								<cv:msg key="error.mismatchedPassword" bundle="exchange" />
							</div>
						</div>
					</div>
				</div>
				<!-- For Other Service accounts  End-->
				
				<!-- For Azure Storage  Start-->
				<div data-ng-if="addSPServiceAccountCtrl.serviceAccount.serviceType === 'SHAREPOINT_AZURE_STORAGE'">
					<div class="form-group">
						<label for="userName" class="col-xs-12 col-lg-4"><cv:msg
								key="label.azureStorageAccount" bundle="office365" /></label>
						<div class="col-xs-12 col-lg-8">
							<input type="text" name="userName" id="userName"
								data-ng-model="addSPServiceAccountCtrl.serviceAccount.userAccount.userName"
								required
								/>
							<div class="help-block"
								data-ng-if="cv.addEditSPServieAccount.needsAttention(addEditSPServieAccount.userName)">
								<cv:msg key="error.noUserName" bundle="exchange" />
							</div>
						</div>
					</div>
					<div class="form-group">
						<label for="password" class="col-xs-12 col-lg-4"><cv:msg
								key="label.sharePointAzureStorageKey" bundle="office365" /></label>
						<div class="col-xs-12 col-lg-8">
							<input type="password" name="password" id="password"
								data-ng-model="addSPServiceAccountCtrl.serviceAccount.userAccount.password" required />
							<div class="help-block"
								data-ng-if="cv.addEditSPServieAccount.needsAttention(addEditSPServieAccount.password)">
								<cv:msg key="error.noPassword" bundle="exchange" />
							</div>
						</div>
					</div>
				</div>
				<!-- For Azure Storage  Start-->
			</div>
       </div>
		<div class="modal-footer">
			<button id="addSPServiceAccounts_button_#2607" class="btn btn-default" type="button"
				data-ng-click="addSPServiceAccountCtrl.cancel()">
				<cv:msg key="Cancel" bundle="messages" />
			</button>
			<button id="addSPServiceAccounts_button_#0410" class="btn btn-primary" type="submit"
				ng-show="!addSPServiceAccountCtrl.isEdit">
				<cv:msg key="Add" bundle="messages" />
			</button>
			<button id="addSPServiceAccounts_button_#5308" class="btn btn-primary" type="submit"
				ng-show="addSPServiceAccountCtrl.isEdit">
				<cv:msg key="Save" bundle="messages" />
			</button>
		</div>
	</form>
</div>