<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
	<cv:cvMessages bundle="localization.settings"></cv:cvMessages>
	<cv:cvMessages bundle="localization.capps"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
</script>

<form
	class="bootstrap-wrapper form-horizontal"
	data-cv-submit="editCloudAppsInfrastructureCtrl.saveInfo()"
	name="editCloudAppsInfrastructureForm"
	id="editCloudAppsInfrastructureForm"
	novalidate
	autocomplete="off"
>
	<div class="modal-header">
		<h1 data-ng-bind="editCloudAppsInfrastructureCtrl.title"></h1>
	</div>
	<div class="modal-body no-padding">	
		<!--Edit Global Administrator -- Start -->
		<div
			data-ng-if="editCloudAppsInfrastructureCtrl.editMode === editCloudAppsInfrastructureCtrl.infrastructureEditModes.EDIT_GLOBAL_ADMINISTRATOR">
			<div class="form-group margin-left-10 margin-right-10 margin-top-10">
				<cv-help-text class="col-xs-12 col-lg-4 margin-top-10" help-label="label.globalAdministrator" help-text="help.globalAdmin"/>
				<div class="col-xs-12 col-lg-8">
					<input type="email" id="globalAdministrator" name="globalAdministrator" required
						data-ng-model="editCloudAppsInfrastructureCtrl.globalAdministratorServiceAccount.AdminSmtpAddress"
						data-ng-required="editCloudAppsInfrastructureCtrl.addNewGlobalAdministrator"
						placeholder='<cv:msg key="label.emailAddressPlaceholder" bundle="exchange"></cv:msg>' />
					<div class="help-block"
						data-ng-show="cv.editCloudAppsInfrastructureForm.needsAttention(editCloudAppsInfrastructureForm.globalAdministrator)">
						<cv:msg key="error.noEmail" bundle="exchange" />
					</div>
				</div>
			</div>
	
			<div class="form-group margin-left-10 margin-right-10">
				<label class="col-xs-12 col-lg-4" for="password">
					<cv:msg key="label.password" bundle="exchange" /></label>
				<div class="col-xs-12 col-lg-8">
					<input type="password" name="password" id="password"
					data-ng-model="editCloudAppsInfrastructureCtrl.globalAdministratorServiceAccount.userAccount.password"
					data-ng-required="true" />
					<div class="help-block"
						data-ng-show="cv.editCloudAppsInfrastructureForm.needsAttention(editCloudAppsInfrastructureForm.password)">
						<cv:msg key="error.noPassword" bundle="exchange" />
					</div>
				</div>
			</div>
	
			<div class="form-group margin-left-10 margin-right-10">
				<label class="col-xs-12 col-lg-4" for="confirmPassword">
					<cv:msg key="label.confirmPassword" bundle="exchange" /></label>
				<div class="col-xs-12 col-lg-8">
					<input type="password" name="confirmPassword" id="confirmPassword"
						data-ng-model="editCloudAppsInfrastructureCtrl.globalAdministratorServiceAccount.userAccount.confirmPassword"
						data-cv-equals="{{editCloudAppsInfrastructureCtrl.globalAdministratorServiceAccount.userAccount.password}}"
						data-ng-required="true" />
					<div class="help-block"
						data-ng-show="editCloudAppsInfrastructureForm.confirmPassword.$error.required && cv.editCloudAppsInfrastructureForm.needsAttention(editCloudAppsInfrastructureForm.confirmPassword)">
						<cv:msg key="error.noConfirmPassword" bundle="exchange" />
					</div>
					<div class="help-block"
						data-ng-show="!editCloudAppsInfrastructureForm.confirmPassword.$error.required && editCloudAppsInfrastructureForm.confirmPassword.$error.cvEquals && cv.editCloudAppsInfrastructureForm.needsAttention(editCloudAppsInfrastructureForm.confirmPassword)">
						<cv:msg key="error.mismatchedPassword" bundle="exchange" />
					</div>
				</div>
			</div>
		</div>
		<!--Edit Global Administrator -- End -->

		<!--Edit Access Nodes and LSA -- START -->
		<div data-ng-if="editCloudAppsInfrastructureCtrl.editMode ===  editCloudAppsInfrastructureCtrl.infrastructureEditModes.EDIT_ACCESS_NODES"> 
			<div class="form-group margin-left-10 margin-right-10 margin-top-10">
				<label class="col-xs-12 col-md-4"><cv:msg
						key="label.accessNodes" bundle="exchange" /></label>
				<div class="col-xs-12 col-md-8">
					<isteven-multi-select
						input-model="editCloudAppsInfrastructureCtrl.office365AccessNodesList"
						output-model="editCloudAppsInfrastructureCtrl.selectedAccessNodesList"
						button-label="displayName"
						item-label="displayName"
						tick-property="selected"
						class="isteven-multi-select user-group-select"
						id="accessNodes"
						name="accessNodes"
						helper-elements="reset filter"
						max-labels="3"
						translation="editCloudAppsInfrastructureCtrl.localLang"
						on-reset="editCloudAppsInfrastructureCtrl.processAccessNodeSelection()"
						on-item-click="editCloudAppsInfrastructureCtrl.processAccessNodeSelection()"
						group-property="msGroup">
					</isteven-multi-select>
					<span data-ng-if="editCloudAppsInfrastructureForm.$submitted" class="help-block"
						data-ng-show="!editCloudAppsInfrastructureCtrl.selectedAccessNodesList.length">
					<cv:msg key="error.selectNodes" bundle="exchange" />
					</span>
				</div>
			</div>
			<div data-ng-if="editCloudAppsInfrastructureCtrl.selectedAccessNodesList.length > 1 || 
							editCloudAppsInfrastructureCtrl.jobResultsDirectory.path || 
							editCloudAppsInfrastructureCtrl.isClientGroupSelected ||
							editCloudAppsInfrastructureCtrl.requiresJobResultsDirectory">		
				<div class="form-group margin-left-10 margin-right-10">
					<label class="col-xs-12 col-md-4"><cv:msg key="label.jobResultsDirectory" bundle="exchange" /></label>
					<div class="col-xs-12 col-md-8">
						<input type="text" id="jobResultsDirectory" name="jobResultsDirectory" required
								data-ng-pattern="editCloudAppsInfrastructureCtrl.REGEX.WINDOWS_NETWORK_PATH"
								data-ng-model="editCloudAppsInfrastructureCtrl.jobResultsDirectory.path" />
						<div class="help-block"
								data-ng-show="cv.editCloudAppsInfrastructureForm.needsAttention(editCloudAppsInfrastructureForm.jobResultsDirectory) &&  !editCloudAppsInfrastructureForm.jobResultsDirectory.$error.pattern">
							<cv:msg key="error.noJobResultsDirectory" bundle="exchange" />
						</div>
						<div class="help-block"
							data-ng-show="cv.editCloudAppsInfrastructureForm.needsAttention(editCloudAppsInfrastructureForm.jobResultsDirectory) &&  editCloudAppsInfrastructureForm.jobResultsDirectory.$error.pattern ">
							<cv:msg key="error.invalidNetworkPath" bundle="exchange" />
						</div>
					</div>
				</div>
				<div class="plain-accordion margin-top-10">
					<div class="cv-accordion-header">
						<span class="cv-accordion-text"><cv:msg key="label.sharePathAccount" bundle="exchange" /></span>
					</div>
				</div>
				<div class="form-group margin-top-10 margin-left-10 margin-right-10">
					<label class="col-xs-12 col-md-4"><cv:msg key="label.userName" bundle="exchange" /></label>
					<div class="col-xs-12 col-md-8">
						<input type="text" name="username" id="username" required
						data-ng-model="editCloudAppsInfrastructureCtrl.localSystemAdministratorServiceAccount.userAccount.userName"/>
						<div class="help-block"
							data-ng-show="cv.editCloudAppsInfrastructureForm.needsAttention(editCloudAppsInfrastructureForm.username)">
							<cv:msg key="error.userName" bundle="exchange" />
						</div>
					</div>
				</div>
				<div class="form-group margin-left-10 margin-right-10">
					<label class="col-xs-12 col-lg-4" for="password"><cv:msg key="label.password" bundle="exchange" /></label>
					<div class="col-xs-12 col-lg-8">
						<input type="password" name="password" id="password" 
						placeholder='{{!editCloudAppsInfrastructureCtrl.requirePassword?"<cv:msg key="label.passwordKeep" bundle="settings" />":""}}'
						data-ng-model="editCloudAppsInfrastructureCtrl.localSystemAdministratorServiceAccount.userAccount.password" 
						data-ng-required="editCloudAppsInfrastructureCtrl.requirePassword"/>
						<div class="help-block"
							data-ng-show="cv.editCloudAppsInfrastructureForm.needsAttention(editCloudAppsInfrastructureForm.password)">
							<cv:msg key="error.password" bundle="exchange" />
						</div>                            
					</div>
				</div>
				<div class="form-group margin-left-10 margin-right-10">
					<label class="col-xs-12 col-lg-4" for="confirmPassword"><cv:msg key="label.confirmPassword" bundle="exchange" /></label>
					<div class="col-xs-12 col-lg-8">
						<input type="password" name="confirmPassword" id="confirmPassword"
							placeholder='{{!editCloudAppsInfrastructureCtrl.requirePassword?"<cv:msg key="label.passwordKeep" bundle="settings" />":""}}'
							data-ng-model="editCloudAppsInfrastructureCtrl.localSystemAdministratorServiceAccount.userAccount.confirmPassword"
							data-cv-equals="{{editCloudAppsInfrastructureCtrl.localSystemAdministratorServiceAccount.userAccount.password}}"
							data-ng-required="editCloudAppsInfrastructureCtrl.requirePassword" />
						<div class="help-block"
							data-ng-show="editCloudAppsInfrastructureForm.confirmPassword.$error.cvEquals && cv.editCloudAppsInfrastructureForm.needsAttention(editCloudAppsInfrastructureForm.confirmPassword)">
							<cv:msg key="error.mismatchedPassword" bundle="exchange" />
						</div>
						<div class="help-block"
							data-ng-show="!editCloudAppsInfrastructureForm.confirmPassword.$error.cvEquals && cv.editCloudAppsInfrastructureForm.needsAttention(editCloudAppsInfrastructureForm.confirmPassword)">
							<cv:msg key="error.noConfirmPassword" bundle="exchange" />
						</div>
					</div>
				</div>
				<div class="form-group margin-top-10 margin-bottom-10 margin-left-10 margin-right-10">    
					<div class="col-xs-12 col-md-12">
						<!--Progress stepper--START-->
						<cv-progress-stepper
							data-ng-if="editCloudAppsInfrastructureCtrl.showStepper"
							input-model="editCloudAppsInfrastructureCtrl.progressStepperModel" 
							progress="editCloudAppsInfrastructureCtrl.progress">
						</cv-progress-stepper>
						<!--Progress stepper--END-->
						<div class="margin-left-20 margin-right-20">
							<div class="row" data-ng-if="editCloudAppsInfrastructureCtrl.moveJobResultsDirectoryError.length">
								<div class="help-block margin-top-20"> 
									<label data-ng-bind="editCloudAppsInfrastructureCtrl.moveJobResultsDirectoryError"></label> 
								</div>
							</div>

							<div data-ng-if="editCloudAppsInfrastructureCtrl.showJobResultsOverride" class="row margin-top-20 italic text-align-left">
								<cv:msg key="confirm.jobResultsOverride" bundle="office365" />
								<a class="margin-left-5" data-ng-click="editCloudAppsInfrastructureCtrl.overrideJobResultsStep(true)">
									<cv:msg key="button.yes" bundle="messages"></cv:msg>
								</a>
								<a class="margin-left-5" data-ng-click="editCloudAppsInfrastructureCtrl.overrideJobResultsStep(false)">
									<cv:msg key="button.no" bundle="messages"></cv:msg>
								</a>
							</div>
							<div data-ng-if="editCloudAppsInfrastructureCtrl.showJobResultsWarning" class="row plain-accordion float-left margin-top-10">
								<div class="cv-accordion-header input-group">
									<span class="padding-15 k-icon k-i-warning red-font fa-2x"></span>
									<div class="cv-accordion-header text-align-left">
										<cv:msg key="warning.jobResultsOverride" bundle="office365" />
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!--Edit Access Nodes and LSA -- END -->

		<!--Edit Azure App -- OneDrive Classic -- START -->
		<div data-ng-if="editCloudAppsInfrastructureCtrl.editMode ===  editCloudAppsInfrastructureCtrl.infrastructureEditModes.ADD_APP_CLASSIC_MODE"> 
			<!--Client ID -->
			<div class="form-group">
				<label class="col-xs-12 col-md-4" for="odClientId"><cv:msg key="label.onedrive.clientId" bundle="capps" /></label>
				<div class="col-xs-12 col-md-8">
					<input type="text" id="odClientId" name="odClientId" required data-ng-model="editCloudAppsInfrastructureCtrl.oneDriveClassicAppObj.clientId" required />
					<span class="help-block" data-ng-show="cv.editCloudAppsInfrastructureForm.needsAttention(editCloudAppsInfrastructureForm.odClientId)"><cv:msg key="error.onedrive.clientId" bundle="capps" /></span>							
				</div>
			</div>
			
			<!--Client Secret -->
			<div class="form-group">
				<label class="col-xs-12 col-md-4" for="clientSecret"><cv:msg key="label.onedrive.clientSecret" bundle="capps" /></label>
				<div class="col-xs-12 col-md-8">
					<input type="password" id="clientSecret" name="clientSecret" required data-ng-model="editCloudAppsInfrastructureCtrl.oneDriveClassicAppObj.clientSecret" required />
					<span class="help-block" data-ng-show="cv.editCloudAppsInfrastructureForm.needsAttention(editCloudAppsInfrastructureForm.clientSecret)"><cv:msg key="error.onedrive.clientSecret" bundle="capps" /></span>
				</div>
			</div>
		</div>
		<!--Edit Azure App -- OneDrive Classic -- END -->

		
	</div>

	<div class="modal-footer margin-top-30">
		<button id="closeBtn" type="button" class="btn btn-default cvBusyOnAjax"
			data-ng-if="editCloudAppsInfrastructureCtrl.showCloseButton"
			data-ng-disabled="!editCloudAppsInfrastructureCtrl.enableCloseButton"
			data-ng-click="editCloudAppsInfrastructureCtrl._closeModal()">
			<cv:msg key="label.close" bundle="messagesJs" />
		</button>
		<button id="cancelBtn" type="button" class="btn btn-default cvBusyOnAjax" 
			data-ng-if="!editCloudAppsInfrastructureCtrl.showCloseButton"
			data-ng-click="editCloudAppsInfrastructureCtrl.cancel()">
			<cv:msg key="action.cancel" bundle="profiles" />
		</button>
		<button id="submitBtn" type="submit" class="btn btn-primary cvBusyOnAjax"
			data-ng-if="!editCloudAppsInfrastructureCtrl.showCloseButton">
			<cv:msg key="action.save" bundle="profiles" />
		</button>
	</div>
</form>

