<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
    <cv:cvMessages bundle="localization.office365"></cv:cvMessages>
    <cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
    <cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
</script>
<form
	class="bootstrap-wrapper"
	data-cv-submit="discoverCacheDetailsCtrl.saveChanges()"
	name="discoverCacheInfoForm"
	id="discoverCacheInfoForm"
	novalidate
    cv-hide-api
	autocomplete="off"
>
	<div class="modal-header">
		<h1><cv-help-text help-label="header.discover.state" help-text="info.discoverStateDetails" use-icon="true"/></h1>
	</div>
	<!--End --Modal Header-->
	<div class="modal-body-fixed">		
        <div data-ng-show="!discoverCacheDetailsCtrl.infoLoaded" class="margin-top-20 horz-center grid-data-spinner">
            <img src="${pageContext.request.contextPath}/common/img/ajax-loader.gif">
        </div>   

        <!--Discover Status --START-->
        <div data-ng-show="discoverCacheDetailsCtrl.infoLoaded">
            <div class="plain-accordion">
                <div class="cv-accordion-header">
                    <span class="cv-accordion-text margin-left-5"><cv:msg key="label.summary" bundle="profiles" /></span>                   
                        <a class="page-action-item padding-5 margin-right-10 margin-top-5 margin-bottom-5" 
                            data-ng-click="discoverCacheDetailsCtrl._refreshCache()">
                            <i class="k-icon k-i-refresh-sm"></i><cv:msg key="label.forceCacheRefresh" bundle="office365" />
                        </a>
                </div>
            </div>
    
            <div class="vertical-label-style job-summary-section half-parts margin-top-20 padding-left-15 padding-right-15">
                <ul class="list-style-secondary groups-item margin-left-10 margin-top-5">
                    <li class="group">
                        <span class="pageDetailColumn"><cv:msg key="Status" bundle="job" /></span>
                        <span class="pageDetailColumn" data-ng-bind="discoverCacheDetailsCtrl.discoveryStatus"></span>
                    </li>
                    <!--Progress--START-->
                    <li class="group">
                        <span class="pageDetailColumn"><cv:msg key="Progress" bundle="job" /></span>
                        <span class="pageDetailColumn pageProgress process">
                                <div ng-style="{ 'width' : discoverCacheDetailsCtrl.discoveryProgress}" class="process-bar" data-ng-class="discoverCacheDetailsCtrl.progressBarColor"></div>
                                <span class="spanPercentage process-index" data-ng-bind="discoverCacheDetailsCtrl.discoveryProgress"></span>
                        </span>
                    </li>
                    <li class="group" data-ng-repeat="field in discoverCacheDetailsCtrl.cacheSummaryDetails track by $index">
                        <span class="pageDetailColumn">
                            <span data-ng-if="field.help"><cv-help-text help-label="{{field.label}}" help-text="field.help" help-direction="auto" ></cv-help-text></span>
                            <span data-ng-if="!field.help" data-ng-bind="field.label"></span>
                        </span>
                        <span class="pageDetailColumn" data-ng-bind-html="field.value"></span>
                    </li>
                </ul>
            </div>
            <!--Discover Status --END--> 
        </div>
                                  
	</div>
	<!--End --Modal Body-->
	<div class="modal-footer">
        <button id="office365OneDriveAddAssociation_button_#4017" class="btn btn-default" type="button" data-ng-click="discoverCacheDetailsCtrl.closeDialog()"> 
            <cv:msg key="label.close" bundle="messagesJs" />
        </button>       
    </div>		
	<!--End --Modal Footer-->
</form>
