<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
		<cv:cvMessages bundle="localization.sharepoint"></cv:cvMessages>
		<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
		<cv:cvMessages bundle="localization.office365"></cv:cvMessages>
		<cv:cvEnum name="App.SharePointVersion"></cv:cvEnum>
		<cv:cvEnum name="App.ClientType"></cv:cvEnum>
</script>

<form
	class="form-horizontal bootstrap-wrapper"
	data-cv-submit="manageSharePointSubclientCtrl.saveChanges()"
	name="manageSubclientForm"
	id="manage-subclient-form"
	novalidate
	autocomplete="off"
>
	<div class="modal-header">
		<h1 data-ng-bind="manageSharePointSubclientCtrl.title"></h1>
	</div>
	<!--End --Modal Header-->

	<div class="modal-body">
		<p
			class="{{ manageSharePointSubclientCtrl.updateSubclientMessage.type }} serverMessage"
			data-ng-bind="manageSharePointSubclientCtrl.updateSubclientMessage.message"
		></p>

		<div class="form-group row" data-ng-if="!manageSharePointSubclientCtrl.isDefaultSubclient">
			<label class="col-xs-12 col-sm-4" for="subclientName">
				<cv:msg key="label.o365.subclientName" bundle="office365"/></label>
			<div class="col-xs-12 col-sm-8">
				<input
					type="text"
					name="subclientName"
					id="subclientName"
					required				
					data-ng-model="manageSharePointSubclientCtrl.newSubclientName"
					autofocus/>
				<span class="help-block" data-ng-show="cv.manageSubclientForm.needsAttention(manageSubclientForm.subclientName)">
					<cv:msg key="label.validSubclientName" bundle="office365" />
				</span>
			</div>
		</div>

		<div class="form-group margin-left-0" data-ng-if="!manageSharePointSubclientCtrl.isOffice365SaaSTenant && (manageSharePointSubclientCtrl.isSubclientEdit && !manageSharePointSubclientCtrl.isPlanEntityDefined)">
			<cv-entity-plan-policy-select			
				data-cv-app-id="manageSharePointSubclientCtrl.APPTYPE"
				data-cv-client-id="manageSharePointSubclientCtrl.clientId"
				data-cv-subclient-id="manageSharePointSubclientCtrl.subclientId"
				data-cv-model="manageSharePointSubclientCtrl.planPolicyModel"
				data-cv-edit-policies="!manageSharePointSubclientCtrl.showPlanSelectionState"
				data-cv-is-associated="'true'"
				data-cv-plan-sub-type="'Server'"
				data-cv-wrapper-class="'form-group row'"
				data-cv-label-class="'col-xs-12 col-lg-4'"
				data-cv-select-class="'col-xs-12 col-lg-8'">
			</cv-entity-plan-policy-select>
		</div>

		<div class="form-group" data-ng-if="!manageSharePointSubclientCtrl.isOffice365SaaSTenant && (!manageSharePointSubclientCtrl.isSubclientEdit || manageSharePointSubclientCtrl.isPlanEntityDefined)">
			<label class="col-xs-12 col-sm-4" for="subclientPlan"> <cv:msg
					key="label.o365.serverPlan" bundle="office365"></cv:msg>
			</label>
			<div class="col-xs-12 col-sm-8">
				<cv-plan-summary-dropdown				
					input-model="manageSharePointSubclientCtrl.serverPlanList"
					output-model="manageSharePointSubclientCtrl.selectedPlanList"
					button-label="'planName'"
					item-label="'planName'"
					tick-property="'selected'"
					selection-mode="'single'"
					directive-id="'subclientPlan'"
					max-labels="1"
					helper-elements="'filter'"
					translation="manageSharePointSubclientCtrl.localLang"
					disable-property="'disabled'"
					on-item-clicked="manageSharePointSubclientCtrl.processServerPlanSelection()">
				</cv-plan-summary-dropdown>

				<div class="help-block"
					data-ng-if="manageSubclientForm.$submitted"
					data-ng-show="!manageSharePointSubclientCtrl.selectedPlanList.length">
					<cv:msg key="placeholder.plan" bundle="capps" />
				</div>
			</div>
		</div>
		<!-- In Metallic Saas dont show the max backup stream -->
		<div class="form-group row" data-ng-if="!manageSharePointSubclientCtrl.isOffice365SaaSTenant">
		  <label class="col-xs-12 col-lg-4" for="maxStream">
				<cv:msg key="label.maxStream" bundle="exchange"/></label>
		  <div class="col-xs-12 col-lg-8">
				<input type="number" min="1" max="9999" name="maxBackupStreams" id="maxStream" data-ng-change="manageSharePointSubclientCtrl.validateStreams(manageSharePointSubclientCtrl.maxBackupStreams)" data-ng-model="manageSharePointSubclientCtrl.maxBackupStreams">
				<span class="help-block" 
				    data-ng-show="manageSharePointSubclientCtrl.errorMaxStreams || cv.manageSubclientForm.needsAttention(manageSubclientForm.maxBackupStreams)">
					<cv:msg key="error.max.streams" bundle="sharepoint" />
				</span>
		  </div>
	   </div> 

       <p
			class="{{ manageSharePointSubclientCtrl.contentMessage.type }} serverMessage"
			data-ng-bind="manageSharePointSubclientCtrl.contentMessage.message"
		></p>
		
		<div class="form-group margin-left-0">
		    <!--	<cv-kendo-grid data-cv-grid-options="manageSharePointSubclientCtrl.gridOptions"></cv-kendo-grid> -->
		     <cv-sp-office365-content-browse-component
					data-subclient-entity="manageSharePointSubclientCtrl.subclientEntity"
					data-selected-sp-contents="manageSharePointSubclientCtrl.selectedContents"
					data-on-after-receiving-selected-sp-content=manageSharePointSubclientCtrl.selectedContentsFromCVSPBrowseDirective>
			  </cv-sp-office365-content-browse-component>
		</div>
	</div>
	<!--End --Modal Body-->

	<div class="modal-footer">
		<button class="btn btn-default" type="button" data-ng-click="manageSharePointSubclientCtrl.cancel()">
			<cv:msg key="Cancel" bundle="messages" />
		</button>
		<button class="btn btn-primary cvBusyOnAjax" type="submit" ng-show="!manageSharePointSubclientCtrl.editMode">
				<i data-ng-if="manageSharePointSubclientCtrl.processingRequest" class="fa fa-spinner fa-spin"></i>			
			<cv:msg key="Add" bundle="messages" />
		</button>
		<button class="btn btn-primary cvBusyOnAjax" type="submit"  ng-show="manageSharePointSubclientCtrl.editMode">
				<i data-ng-if="manageSharePointSubclientCtrl.processingRequest" class="fa fa-spinner fa-spin"></i>
			<cv:msg key="Save" bundle="messages" />
		</button>
	</div>
	<!--End --Modal Footer-->
</form>
