<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.office365"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
	<cv:cvMessages bundle="localization.capps"></cv:cvMessages>
</script>

	<div class="row">
		<div class="col-md-6">
			
			<!--General --START-->
			<cv-tile-component data-title='<cv:msg key="header.general" bundle="exchange" />' loader="oneDriveClassicSettingsCtrl.infrastructureSettingsLoaded">
			<ul class="list-style-secondary">
				<!--Cloud Region-->	
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.office365.cloudregion" bundle="exchange"/></span>
					<span class="pageDetailColumn" data-ng-bind="oneDriveClassicSettingsCtrl.msCloudRegion"></span>
				</li>
				<!--Cloud Region-->	
				<!--Global Administrator-->	
				<li class="group">
					<span class="pageDetailColumn"><cv-help-text help-label="label.globalAdministrator" help-text="help.globalAdmin"/></span>
					<span class="pageDetailColumn" data-ng-if="oneDriveClassicSettingsCtrl.hasGlobalAdminAccount">
						<span data-ng-bind="oneDriveClassicSettingsCtrl.globalAdministrator"></span>						
						<span class="float-right tile-content-link" >
							<a data-ng-click="oneDriveClassicSettingsCtrl.editInfraStructureSettings(oneDriveClassicSettingsCtrl.EDIT_GLOBAL_ADMINISTRATOR)"><cv:msg key="label.edit" bundle="clients" /></a>
							<a class="margin-left-10" data-ng-click="oneDriveClassicSettingsCtrl.confirmDeleteGlobalAdmin()"><cv:msg key="label.delete" bundle="ediscovery" /></a>		
						</span>						
					</span>					
					<!--Add new Global Administrator-->
					<span class="pageDetailColumn" data-ng-if="!oneDriveClassicSettingsCtrl.hasGlobalAdminAccount">
						<label class="restore-help-text italic"><cv:msg key="label.app.not.configured" bundle="office365" /></label>				
						<span class="float-right tile-content-link" >
							<a data-ng-click="oneDriveClassicSettingsCtrl.editInfraStructureSettings(oneDriveClassicSettingsCtrl.EDIT_GLOBAL_ADMINISTRATOR, true)">
								<cv:msg key="label.add" bundle="office365" />
							</a>
						</span>
					</span>
				</li>
				<!--Global Administrator-->
				<!--AZURE Directory--START-->
				<!-- <li class="group" data-ng-if="oneDriveClassicSettingsCtrl.showAzureDirectoryId">
					<span class="pageDetailColumn"><cv:msg key="label.azureDirectoryID" bundle="exchange" /></span>
					<span class="pageDetailColumn"><span data-ng-bind="oneDriveClassicSettingsCtrl.azureDirectoryId"></span>
						<span class="float-right tile-content-link" >
							<a data-ng-click="oneDriveClassicSettingsCtrl.editAzureDirectoryId(true)">
								<cv:msg key="label.edit" bundle="clients" />
							</a>
						</span>
					</span>
				</li>
				<li class="group"  data-ng-if="!oneDriveClassicSettingsCtrl.showAzureDirectoryId">
					<span class="pageDetailColumn margin-top-10"><cv:msg key="label.azureDirectoryID" bundle="exchange"/></span>
					<span class="pageDetailColumn inline-editor">
						<div class="inline-editor-input">
							<input class="full-width" 
								type="text" 
								id="azureDirectoryId"
								required
								data-ng-model="oneDriveClassicSettingsCtrl.newAzureDirectoryId"/>
						</div>
						<span class="inline-editor-buttons">
							<a class="inline-editor-button" data-ng-class="{disabled: loading}"  ng-click="oneDriveClassicSettingsCtrl.updateAzureDirectoryID()"><span class="k-icon k-i-check"></span></a>
							<a class="inline-editor-button" data-ng-class="{disabled: loading}"  ng-click="oneDriveClassicSettingsCtrl.editAzureDirectoryId(false)"><span class="k-icon k-i-x"></span></a>
						</span>
					</span>
					<div class="help-block margin-top-10"
						data-ng-show="!oneDriveClassicSettingsCtrl.isAzureDirectoryValid">
						<cv:msg key="error.valid.azure.directory" bundle="office365" />
					</div>
				</li> -->
				<!--Azure Directory--END-->

				<!-- Content Indexing --START -->
				<li class="group" data-ng-if="!oneDriveClassicSettingsCtrl.isOffice365SaaSTenant">
					<span class="pageDetailColumn"><cv:msg key="label.ContentIndex" bundle="capps"/></span>
					<span class="pageDetailColumn">
						<toggle-control class="{{oneDriveClassicSettingsCtrl.onlineContentIndex}}" status="oneDriveClassicSettingsCtrl.onlineContentIndex" data-ng-click="oneDriveClassicSettingsCtrl.manageContentIndexing()" title="Enable/disable <cv:msg key='label.ContentIndex' bundle='capps' />"></toggle-control>
					</span>
				</li>
				<!-- Content Indexing --END -->

				<!--Auto Discover Setting-->
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.data.autoDiscover" bundle="capps"/></span>
					<span class="pageDetailColumn"><span data-ng-bind="oneDriveClassicSettingsCtrl.autoDiscoverStatus"></span>
						<span class="float-right tile-content-link" >
							<a data-ng-click="oneDriveClassicSettingsCtrl.editAzureAppConnectionSettings()"><cv:msg key="label.edit" bundle="clients" /></a>
						</span>	
				</li>
				<!--Auto-Discover Setting-->

				<!--Automatic content management setting-->
				<li class="group" data-ng-if="oneDriveClassicSettingsCtrl.isAutoDiscoveryEnabled">
					<span class="pageDetailColumn"><cv-help-text help-label="label.onedriveclassic.autoManageContent" help-text="help.onedriveclassic.autoManageContent"/></span>
					<span class="pageDetailColumn">
						<toggle-control 
							class="{{oneDriveClassicSettingsCtrl.toggle_manageSubclientContentAutomatically}}" 
							status="oneDriveClassicSettingsCtrl.toggle_manageSubclientContentAutomatically" 
							data-ng-click="oneDriveClassicSettingsCtrl.manageContentAutomatically()" 
							title="Enable/disable <cv:msg key='label.onedriveclassic.autoManageContent' bundle='office365' />">
						</toggle-control>
					</span>
				</li>
				<!--Automatic content management setting-->	
			</ul>
		</cv-tile-component>
		<!--General --END-->

			<!--Connection Settings Tile-->
			<cv-tile-component data-title='<cv:msg key="label.onedriveConnectionSettings" bundle="office365"/>' loader="oneDriveClassicSettingsCtrl.infrastructureSettingsLoaded">
				<ul class="list-style-secondary">	
					<li class="group o365-app-grid">
						<cv-kendo-grid data-cv-grid-options="oneDriveClassicSettingsCtrl.azureAppsGridOptions"></cv-kendo-grid>						
					</li>
					<div class="page-details-box-links margin-top-30">
						<a data-ng-click="oneDriveClassicSettingsCtrl._addAzureApp()"><cv:msg key="dialog.azureapp.title" bundle="office365" /> </a>
						<a data-ng-click="oneDriveClassicSettingsCtrl._confirmDeleteAllAzureApps()" data-ng-if="oneDriveClassicSettingsCtrl.azureAppsList.length"><cv:msg key="dialog.delete.all.azureapp.title" bundle="office365" /> </a>
					</div>
			</cv-tile-component>
		</div>
		<div class="col-md-6">

			<!--Infrastructure Settings Tile-->
			<cv-tile-component data-title='<cv:msg key="label.infrastructurePane" bundle="exchange"/>' loader="oneDriveClassicSettingsCtrl.infrastructureSettingsLoaded">
				<ul class="list-style-secondary">
					<!--PLAN-->
					<li class="group" data-ng-if="oneDriveClassicSettingsCtrl.isSaaSConfigSet && oneDriveClassicSettingsCtrl.showPlan">
						<span class="pageDetailColumn"><cv:msg key="label.o365.serverPlan" bundle="office365"/></span>
						<span class="pageDetailColumn"><span data-ng-bind="oneDriveClassicSettingsCtrl.clientPlan.planName"></span>			
						<span data-ng-if="!oneDriveClassicSettingsCtrl.isOffice365SaaSTenant" class="float-right tile-content-link" >
							<a data-ng-click="oneDriveClassicSettingsCtrl.editClientPlan(true)">
								<cv:msg key="label.edit" bundle="clients" />
							</a>
						</span>																							
					</li>

					<li class="group no-horizontal-padding" data-ng-if="!oneDriveClassicSettingsCtrl.showPlan">
						<span class="pageDetailColumn margin-top-20"><cv:msg key="label.o365.serverPlan" bundle="office365"/></span>
						<span class="pageDetailColumn inline-editor margin-top-20">
							<div class="inline-editor-input">																										
								<cv-plan-summary-dropdown
									class="full-width"
									data-ng-if="oneDriveClassicSettingsCtrl.plansLoaded"
									input-model="oneDriveClassicSettingsCtrl.serverPlanList"
									output-model="oneDriveClassicSettingsCtrl.selectedPlanList"
									button-label="'planName'"
									item-label="'planName'"
									tick-property="'selected'"														                
									selection-mode="'single'"
									directive-id="'plans'"
									class="inline-editor-input"
									max-labels="1"
									translation="oneDriveClassicSettingsCtrl.localLang"
									disable-property="'disabled'"
									on-item-clicked="oneDriveClassicSettingsCtrl.processServerPlanSelection()">
								</cv-plan-summary-dropdown>
							</div>
																
							<span class="inline-editor-buttons">
								<a class="inline-editor-button" data-ng-class="{disabled: loading}"  ng-click="oneDriveClassicSettingsCtrl.updateClientPlan()"><span class="k-icon k-i-check"></span></a>
								<a class="inline-editor-button" data-ng-class="{disabled: loading}"  ng-click="oneDriveClassicSettingsCtrl.editClientPlan(false)"><span class="k-icon k-i-x"></span></a>
							</span>
						</span>
					</li>
				<!--PLAN-->

					<!--ACCESS NODE-->
					<div data-ng-if="!oneDriveClassicSettingsCtrl.isOffice365SaaSTenant">
						<li class="group" data-ng-if="oneDriveClassicSettingsCtrl.previewAccessNode">
								<span class="pageDetailColumn"><cv:msg key="label.backupClientAccNode" bundle="capps"/></span>
								<span class="pageDetailColumn"><span data-ng-bind="oneDriveClassicSettingsCtrl.instanceDetails.backupClient.clientName"></span>
								<span class="float-right tile-content-link" >
									<a data-ng-click="oneDriveClassicSettingsCtrl.editAccessNode(true)">
										<cv:msg key="label.edit" bundle="clients" />
									</a>
								</span>	
							</li>
							<li class="group"  data-ng-if="!oneDriveClassicSettingsCtrl.previewAccessNode">
								<span class="pageDetailColumn"><cv:msg key="label.accessNodes" bundle="exchange"/></span>
								<span class="pageDetailColumn inline-editor">
									<div class="inline-editor-input">
										<isteven-multi-select
											input-model="oneDriveClassicSettingsCtrl.accessNodesList"
											output-model="oneDriveClassicSettingsCtrl.selectedAccessNodeList"
											button-label="clientName"
											item-label="clientName"
											id="accessNodes"
											search-limit="10"
											search-property="clientName"
											selection-mode="single"
											tick-property="selected"
											class="isteven-multi-select user-group-select"
											helper-elements="filter"
											on-item-click="oneDriveClassicSettingsCtrl.processAccessNodeSelection()">
										</isteven-multi-select>
									</div>
									<span class="inline-editor-buttons">
										<a class="inline-editor-button" data-ng-class="{disabled: loading}"  ng-click="oneDriveClassicSettingsCtrl.updateInstanceConfig(false)"><span class="k-icon k-i-check"></span></a>
										<a class="inline-editor-button" data-ng-class="{disabled: loading}"  ng-click="oneDriveClassicSettingsCtrl.editAccessNode(false)"><span class="k-icon k-i-x"></span></a>
									</span>
								</span>
							</li>
						</div>
					<!--ACCESS NODE-->
					<cv-client-readiness-status data-ng-if="oneDriveClassicSettingsCtrl.associationsLoaded" client-id="{{oneDriveClassicSettingsCtrl.clientId}}"  client-readiness="oneDriveClassicSettingsCtrl.clientReadiness"></cv-client-readiness-status>
				</ul>
			</cv-tile-component>
			<!--Infrastructure Settings Tile-->

			<cv-activity-control-component data-ac-params="oneDriveClassicSettingsCtrl.activityControlParams"></cv-activity-control-component>

			<cv-security-component
				directive-id="securityDir"
				entity-type='oneDriveClassicSettingsCtrl.entityType'
				generic-entity = 'oneDriveClassicSettingsCtrl.genericEntity'
				associations='oneDriveClassicSettingsCtrl.formattedSecurityAssociations'
				associations-loaded="oneDriveClassicSettingsCtrl.securityAssociationsLoaded"
				show-owners='true'>
			</cv-security-component>
			
		</div>
	</div>
