<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
    <cv:cvMessages bundle="localization.office365"></cv:cvMessages>
    <cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
    <cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
</script>
<form
	class="bootstrap-wrapper"
	data-cv-submit="office365OneDriveDiscoverCacheDetailsCtrl.saveChanges()"
	name="discoverCacheInfoForm"
	id="discoverCacheInfoForm"
	novalidate
    cv-hide-api
	autocomplete="off"
>
	<div class="modal-header">
		<h1><cv-help-text help-label="header.discover.state" help-text="info.discoverStateDetails" use-icon="true"/></h1>
	</div>
	<!--End --Modal Header-->
	<div class="modal-body-fixed">		
        <div data-ng-show="!office365OneDriveDiscoverCacheDetailsCtrl.infoLoaded" class="margin-top-20 horz-center grid-data-spinner">
            <img src="${pageContext.request.contextPath}/common/img/ajax-loader.gif">
        </div>   

        <!--Discover Status --START-->
        <div data-ng-show="office365OneDriveDiscoverCacheDetailsCtrl.infoLoaded">
            <div class="plain-accordion">
                <div class="cv-accordion-header">
                    <span class="cv-accordion-text margin-left-5"><cv:msg key="label.summary" bundle="profiles" /></span>                   
                        <a class="page-action-item padding-5 margin-right-10 margin-top-5 margin-bottom-5" 
                            data-ng-click="office365OneDriveDiscoverCacheDetailsCtrl._refreshCache()">
                            <i class="k-icon k-i-refresh-sm"></i><cv:msg key="label.forceCacheRefresh" bundle="office365" />
                        </a>
                </div>
            </div>
    
            <div class="vertical-label-style job-summary-section half-parts margin-top-20 padding-left-15 padding-right-15">
                <ul class="list-style-secondary groups-item margin-left-10 margin-top-5">
                    <li class="group">
                        <span class="pageDetailColumn"><cv:msg key="Status" bundle="job" /></span>
                        <span class="pageDetailColumn" data-ng-bind="office365OneDriveDiscoverCacheDetailsCtrl.discoveryStatus"></span>
                    </li>
                    <!--Progress--START-->
                    <li class="group">
                        <span class="pageDetailColumn"><cv:msg key="Progress" bundle="job" /></span>
                        <span class="pageDetailColumn pageProgress process">
                                <div ng-style="{ 'width' : office365OneDriveDiscoverCacheDetailsCtrl.discoveryProgress}" class="process-bar" data-ng-class="office365OneDriveDiscoverCacheDetailsCtrl.progressBarColor"></div>
                                <span class="spanPercentage process-index" data-ng-bind="office365OneDriveDiscoverCacheDetailsCtrl.discoveryProgress"></span>
                        </span>
                    </li>
                    <li class="group">
                        <span class="pageDetailColumn"><cv:msg key="count.progress.totalUsersDiscovered" bundle="office365" /></span>
                        <span class="pageDetailColumn" data-ng-bind="office365OneDriveDiscoverCacheDetailsCtrl.totalDiscoveredUsers"></span>
                    </li>
                    <li class="group">
                        <span class="pageDetailColumn"><cv:msg key="count.progress.totalGroupsDiscovered" bundle="office365" /></span>
                        <span class="pageDetailColumn" data-ng-bind="office365OneDriveDiscoverCacheDetailsCtrl.totalDiscoveredGroups"></span>
                    </li>
                    <!--Progress--END-->
                    <li class="group">
                        <span class="pageDetailColumn"><cv:msg key="count.lastCacheUsersCount" bundle="office365" /></span>
                        <span class="pageDetailColumn" data-ng-bind="office365OneDriveDiscoverCacheDetailsCtrl.lastCacheUsersCount"></span>
                    </li>
                    <li class="group">
                        <span class="pageDetailColumn"><cv:msg key="count.lastCacheGroupsCount" bundle="office365" /></span>
                        <span class="pageDetailColumn" data-ng-bind="office365OneDriveDiscoverCacheDetailsCtrl.lastCacheGroupsCount"></span>
                    </li>
                    <li class="group">
                        <span class="pageDetailColumn"><cv:msg key="label.cacheUpdateTime" bundle="office365" /></span>
                        <span class="pageDetailColumn" data-ng-bind="office365OneDriveDiscoverCacheDetailsCtrl.lastDiscoverCacheUpdateTime"></span>
                    </li>
                </ul>
            </div>
            <!--Discover Status --END--> 
        </div>
                                  
	</div>
	<!--End --Modal Body-->
	<div class="modal-footer">
        <button id="office365OneDriveAddAssociation_button_#4017" class="btn btn-default" type="button" data-ng-click="office365OneDriveDiscoverCacheDetailsCtrl.closeDialog()"> 
            <cv:msg key="label.close" bundle="messagesJs" />
        </button>       
    </div>		
	<!--End --Modal Footer-->
</form>
