<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
<cv:cvMessages bundle="localization.office365"></cv:cvMessages>
<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
<cv:cvMessages bundle="localization.capps"></cv:cvMessages>
<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
<cv:cvMessages bundle="localization.search"></cv:cvMessages>
<cv:cvMessages bundle="localization.facets"></cv:cvMessages>
</script>


<div class="row col-xs-12 col-md-12">
	<h1 class="float-left ng-binding"><img src="img/onedrive.svg" class="office365-header-image"/><span class="margin-left-10" data-ng-bind="office365BrowseCtrl.pageTitle"></span></h1>
</div>

<div class="row" data-ng-if="office365BrowseCtrl.dataLoaded && 
	office365BrowseCtrl.showBrowseData">
	<div class="col-xs-12 col-sm-12 col-md-12 col-lg-9 col-lg-offset-3">
		<div class="col-md-6">
			<cv-actions-toolbar actions="office365BrowseCtrl.actionsToolbarModel"></cv-actions-toolbar>
		</div>
		<div class="col-md-6">
			<cv-search-filter app-type="office365BrowseCtrl.appType" on-search="office365BrowseCtrl.onSearch(searchTerm, searchFilters)"></cv-search-filter>
		</div>
	</div>
</div>

<!--Tree and Grid -->
<div class="bootstrap-wrapper">
	<div class="col-xs-12 col-sm-12 col-md-12 col-lg-3 margin-top-15">			
		<cv-browse-restore-facets 
			facet-data="office365BrowseCtrl.facetData"
			selected-facet-results="office365BrowseCtrl.selectedFacetResults"
			on-change="office365BrowseCtrl.onFacetChange(selectedFacets)">
		</cv-browse-restore-facets>

		<div class="cv-kendo-tree-top-border"
			data-ng-if="office365BrowseCtrl.treeOptions">		
			<cv-kendo-tree data-cv-tree-options="office365BrowseCtrl.treeOptions"></cv-kendo-tree>
		</div>
	</div>
	
	<div class="col-xs-12 col-sm-12 col-md-12 col-lg-9 margin-top-15"
		data-ng-if="office365BrowseCtrl.oneDriveBrowseGridOptions">		
		<cv-kendo-grid data-cv-grid-options="office365BrowseCtrl.oneDriveBrowseGridOptions"></cv-kendo-grid>
		
		<div class="margin-top-50 horz-center">
			<div data-ng-if="!office365BrowseCtrl.dataLoaded" class="grid-data-spinner">
				<img src="${pageContext.request.contextPath}/common/img/ajax-loader.gif">
			</div>
			<div data-ng-if="(office365BrowseCtrl.recievedBrowseResponseType === office365BrowseCtrl.browseResponseTypes.ERROR || 
				!office365BrowseCtrl.showBrowseData) && office365BrowseCtrl.dataLoaded">
				<p class="error margin-top-10" data-ng-bind="office365BrowseCtrl.browseResponseErrorMessage"></p>
			</div>
		</div>
	</div>
</div>