<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.office365"></cv:cvMessages>
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
</script>
<div class="row margin-top-10">
    <div class="col-md-6">
        <cv-tile-component data-title='<cv:msg key="label.userDetails" bundle="office365" />' loader="dynamics365RecordDetailsCtrl.userDetails">
            <ul class="list-style__row group" data-ng-if="dynamics365RecordDetailsCtrl.hasUserData">
                <li class="group">
                    <span class="pageDetailColumn"><cv:msg key="column.displayName" bundle="office365" /> </span>
                    <span class="pageDetailColumn" data-ng-bind="dynamics365RecordDetailsCtrl.userDetails.userAccountInfo.displayName"></span>
                </li>
                <li class="group">
                    <span class="pageDetailColumn"><cv:msg key="column.email" bundle="office365" /> </span>
                    <span class="pageDetailColumn" data-ng-bind="dynamics365RecordDetailsCtrl.userDetails.userAccountInfo.smtpAddress"></span>
                </li> 

                 <li class="group">
                    <span class="pageDetailColumn"><cv:msg key="column.size" bundle="office365" /> </span>
                    <span class="pageDetailColumn" 
                        data-ng-bind="dynamics365RecordDetailsCtrl.userDetails.formattedAccountSize"
                        data-ng-class= "dynamics365RecordDetailsCtrl.hasLastBackupSize ? '' : 'italic'">
                    </span>
                </li>

                <li class="group">
                    <span class="pageDetailColumn"><cv:msg key="info.lastbackuptime" bundle="office365" /> </span>
                    <span class="pageDetailColumn" 
                        data-ng-bind="dynamics365RecordDetailsCtrl.userDetails.formattedLastBackupJobRunTime"
                        data-ng-class= "dynamics365RecordDetailsCtrl.hasLastBackupTime ? '' : 'italic'">
                    </span>
                </li> 

                <li class="group">
                    <span class="pageDetailColumn"><cv:msg key="column.numberOfItems" bundle="office365" /> </span>
                    <span class="pageDetailColumn" 
                        data-ng-class= "dynamics365RecordDetailsCtrl.hasNumberOfItems ? '' : 'italic'"
                        data-ng-bind="dynamics365RecordDetailsCtrl.formattedNumberOfItems">
                    </span>
                </li> 

                <li class="group">
                    <span class="pageDetailColumn"><cv:msg key="label.office365Plan" bundle="office365" /> </span>
                    <span class="pageDetailColumn" 
                        data-ng-class= "dynamics365RecordDetailsCtrl.hasPlan ? '' : 'italic'" 
                        data-ng-bind="dynamics365RecordDetailsCtrl.formattedPlanName">
                    </span>
               </li>             
            </ul>                  
        </cv-tile-component>
    </div>
    <div class="col-md-6">
        <cv-backup-history entity="dynamics365RecordDetailsCtrl.backupEntity" 
        show-legend="'true'" params="dynamics365RecordDetailsCtrl.historyParams"  on-restore="dynamics365RecordDetailsCtrl.performRestore(job, fromTimeStr, toTimeStr)" ng-if="dynamics365RecordDetailsCtrl.backupEntity"></cv-backup-history>
    </div>
</div>
