<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.office365"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.sharepoint"></cv:cvMessages>
</script>
<div data-ng-class="{'col-md-offset-1': addOffice365.isSetup && !addOffice365.hideForm}">
		<!--Office365-Getting Started--Setup:Complete-->
	<div data-ng-show="addOffice365.hideForm" class="setup-content">
		<h1 class="page-header" ng-bind="addOffice365.setupHeaderTitle"></h1>
		<p class="serverMessage">
			<cv:msg key="info.cappsClientsPresent" bundle="capps" />
		</p>
		<a data-ng-click="addOffice365.showAppForm()">
			<cv:msg key="label.addNewCloudappApp" bundle="capps" /></a>
		<div class="button-container centered">
			<button id="createOffice365App_button_#8535" type="button" class="btn btn-default cvBusyOnAjax skip-btn--hidden" 
				data-ng-click="addOffice365.skip()">
				<cv:msg key="Continue" bundle="messages" /></button>
		</div>
	</div>
	<div class="row bootstrap-wrapper">
			<div class="col-xs-12 " ng-class="{'col-md-12': addOffice365App.isSetup, 'col-md-10 col-md-offset-1 col-lg-8 col-lg-offset-2 col-xl-6 col-xl-offset-3': !addOffice365App.isSetup}"
			data-ng-hide="addOffice365.hideForm">
			<!-- <div class="col-xs-12 col-md-10 col-md-offset-1"
			data-ng-class="{'col-lg-6 col-lg-offset-3': !addOffice365.isAvailableWidthMediumLarge, 'col-lg-8 col-lg-offset-2': addOffice365.isAvailableWidthMediumLarge}"
			data-ng-hide="addOffice365.hideForm"> -->
			<h1 data-ng-bind-html="addOffice365.pageHeaderTitle" data-ng-if="!addOffice365.isSetup" class="text-center"></h1>
			<form class="form-horizontal create-office365Attributes-form"
				data-cv-submit="addOffice365.submitDetails()" cv-hide-api 
				novalidate name="addOffice365Form" autocomplete="off">

				<!--Setup app selection--Start-->
				<div class="panel panel-default" data-ng-if="addOffice365.isSetup && !addOffice365.isDynamics365Setup">
					<div class="panel-body">
						<div class="form-group">
							<label class="col-xs-12 col-md-3" for="office365ServiceType"><cv:msg
									key="column.servicetype" bundle="office365" /></label>
							<div class="col-xs-12 col-md-9"
							data-ng-disabled="!addOffice365.office365Attributes.generalAttributes.addAppServiceAccountManually && addOffice365.office365Attributes.generalAttributes.isGlobalLogin === true &&
							addOffice365.office365Attributes.exchangeAttributes.onePassProp.azureApps.azureAppId.length > 0">
								<isteven-multi-select id="createOffice365App_isteven-multi-select_#4008"
									class="half-width"
									input-model="addOffice365.office365ServiceList"
									output-model="addOffice365.selectedOffice365ServiceFromList"
									button-label="service"
									item-label="service"
									selection-mode="single"
									helper-elements="filter"
									directive-id="'office365Service'"
									max-labels="1"
									tick-property="selected"
									on-item-click="addOffice365.processOffice365ServiceSelection()"
									translation="addOffice365.localLang">
								</isteven-multi-select>																		
							</div>
						</div>							
					</div>
				</div>
				<!--Setup app selection--End-->	
					
				<div ng-if="!addOffice365.isSetup || addOffice365.loadOldAgents">
					<div data-ng-if="!addOffice365.isOffice365SaaSTenant">
					<!-- Step 1: General -->
					<div class="panel panel-default">
						<div class="panel-body">
							<div class="form-group">
								<label class="col-xs-12 col-md-3" for="appName"><cv:msg
										key="label.name" bundle="exchange" /></label>
								<div class="col-xs-12 col-md-9">
									<input type="text" name="appName" id="appName"
										placeholder='<cv:msg key="label.exchAppNamePlaceholder" bundle="exchange"/>'
										data-ng-disabled="addOffice365.office365Attributes.disableClientName"
										data-ng-pattern="/^[a-zA-Z0-9_-]*$/"
										data-ng-model="addOffice365.office365AppName"
										required autofocus />
									<div class="help-block"
										data-ng-show="cv.addOffice365Form.needsAttention(addOffice365Form.appName)">
										<cv:msg key="error.noServerName" bundle="exchange" />
									</div>
								</div>
							</div>
							<div class="form-group">
								<label class="col-xs-12 col-md-3" for="serverPlan"><cv:msg
										key="label.serverPlan" bundle="exchange" /></label>
								<div class="col-xs-12 col-md-9">
									<cv-plan-summary-dropdown
										data-ng-if="addOffice365.plansLoaded"
										input-model="addOffice365.serverPlanList"
										output-model="addOffice365.selectedPlanList"
										button-label="'planName'"
										item-label="'planName'"
										tick-property="'selected'"
										selection-mode="'single'"
										directive-id="'plans'"
										max-labels="1"
										helper-elements="'filter'"
										translation="addOffice365.localLang"
										disable-property="'disabled'"
										on-item-clicked="addOffice365.processServerPlanSelection()">
									</cv-plan-summary-dropdown>
									<div class="help-block"
										data-ng-show="addOffice365Form.$submitted"
										data-ng-if="!addOffice365.selectedPlanList.length">
										<cv:msg key="error.selectPlan" bundle="exchange" />
									</div>
								</div>
							</div>
						</div>
					</div>
					</div>

					<!--SharePoint v1 --- Add backupset app --Start-->
					<!--Add SharePoint SAAS details-->
					<div data-ng-if="addOffice365.isSharePointV1">

						<div class="panel panel-default" data-ng-if="!addOffice365.isOffice365SaaSTenant">
							<div class="panel-body">
								<div class="form-group">
									<label class="col-xs-12 col-md-3" for="sharePointClients"><cv:msg
											key="header.proxy" bundle="exchange" /></label>
									<div class="col-xs-12 col-md-9">
										<isteven-multi-select id="createOffice365App_isteven-multi-select_#1119" 
												class="half-width"
												input-model="addOffice365.clientList"
												output-model="addOffice365.selectedClientList"
												button-label="clientName"
												item-label="clientName"
												selection-mode="single"
												helper-elements="filter"
												directive-id="'sharePointClients'"
												max-labels="1"
												tick-property="selected"
												on-item-click="addOffice365.processClientSelection()"
												translation="addOffice365.localLang">
											</isteven-multi-select>
										<span data-ng-show="addOffice365Form.$submitted" class="help-block"
											data-ng-if="addOffice365.selectedClientList.length === 0"><cv:msg
												key="error.selectNodes" bundle="exchange" /></span>
									</div>
								</div>							
							</div>
						</div>
						<!--Panel 2-->
						<div class="panel panel-default">
							<div class="panel-body">

								<!--SharePoint SaaS App -- Name-->
								<div data-ng-if="addOffice365.isOffice365SaaSTenant" data-ng-show="addOffice365.showAppNameInput"> 
									<div class="form-group">
										<label class="col-xs-12 col-md-4" for="appName"><cv:msg
												key="label.name" bundle="exchange" /></label>
										<div class="col-xs-12 col-md-8">
											<div class="input-group">
												<span class="input-group-addon" style="background-color:transparent; padding:0px; border:none;"
													data-ng-bind="addOffice365.office365AppPrefix"></span>
												<input type="text" name="appName" id="appName"
													placeholder='<cv:msg key="label.exchAppNamePlaceholder" bundle="exchange"/>'
													data-ng-disabled="addOffice365.office365Attributes.disableClientName"
													data-ng-pattern="/^[a-zA-Z0-9_-]*$/"
													data-ng-model="addOffice365.office365AppName"
													required autofocus />
											</div>
											<div class="help-block"
												data-ng-show="cv.addOffice365Form.needsAttention(addOffice365Form.appName)">
												<cv:msg key="error.noServerName" bundle="exchange" />
											</div>
										</div>
									</div>
								</div>

								<div class="form-group">
									<label class="col-xs-12 col-md-4" for="adminSiteURL"><cv:msg
											key="label.tenantURL" bundle="sharepoint" /></label>
									<div class="col-xs-12 col-md-8">
										<input type="text" name="adminSiteURL" id="adminSiteURL"
											placeholder='<cv:msg key="placeholder.tenantAdminSiteURL" bundle="office365"/>'
											data-ng-model="addOffice365.sharePointBackupSetModel.tenantUrlItem"
											required autofocus />
										<div class="help-block"
											data-ng-show="cv.addOffice365Form.needsAttention(addOffice365Form.adminSiteURL)">
											<cv:msg key="error.tenantAdminSiteURL" bundle="clients" />
										</div>
									</div>
								</div>

								<!--Modern Authentication Toggle (Sharepoint V1)-->
								<div class="form-group" data-ng-if="!addOffice365.isOffice365SaaSTenant">
									<cv-help-text class="col-xs-12 col-md-4" help-label="label.useModernAuthentication" help-text="help.modernAuth"/>
									<div class="col-xs-12 col-md-8">
										<cv-toggle
											toggle-name="modernAuthToggle"
											help-direction="right"
											value="addOffice365.sharePointBackupSetModel.isModernAuthEnabled"
											toggle-model="addOffice365.sharePointBackupSetModel.isModernAuthEnabled">
										</cv-toggle>
									</div>
								</div>
								<!--Modern Authentication Toggle (Sharepoint V1)-->

								<div data-ng-if="addOffice365.sharePointBackupSetModel.isModernAuthEnabled">
									<div class="form-group">
										<label class="col-xs-12 col-md-4" for="spV1ApplicationId"> <cv:msg
												key="label.applicationId" bundle="exchange"></cv:msg>
										</label>
										<div class="col-xs-12 col-md-8">
											<input type="text" id="spV1ApplicationId" name="spV1ApplicationId" data-ng-required="addOffice365.sharePointBackupSetModel.isModernAuthEnabled"
												placeholder='<cv:msg key="placeholder.azureAppId" bundle="office365"/>'
												data-ng-model="addOffice365.office365Attributes.exchangeAttributes.onePassProp.azureApps.azureAppId" />
											<div class="help-block"
													data-ng-show="cv.addOffice365Form.needsAttention(addOffice365Form.spV1ApplicationId)">
												<cv:msg key="label.appIdRequired" bundle="exchange" />
											</div>
										</div>		
									</div>
						
									<div class="form-group">
										<label class="col-xs-12 col-md-4" for="spV1SecretAccessKey"> <cv:msg
												key="label.azureAppSecret" bundle="office365"></cv:msg>
										</label>
										<div class="col-xs-12 col-md-8">
											<input type="password" id="spV1SecretAccessKey" name="spV1SecretAccessKey" data-ng-required="addOffice365.sharePointBackupSetModel.isModernAuthEnabled"
												placeholder='<cv:msg key="placeholder.azureAppSecret" bundle="office365" />'
												data-ng-model="addOffice365.office365Attributes.exchangeAttributes.onePassProp.azureApps.azureAppKeyValue" />
											<div class="help-block"
													data-ng-show="cv.addOffice365Form.needsAttention(addOffice365Form.spV1SecretAccessKey)">
												<cv:msg key="label.appSecretRequired" bundle="exchange" />
											</div>
										</div>		
									</div>
						
									<div class="form-group">
										<label class="col-xs-12 col-md-4" for="spV1TenantName"> <cv:msg
												key="label.azureDirectoryID" bundle="exchange"></cv:msg>
										</label>
										<div class="col-xs-12 col-md-8">
											<div>
												<input type="text" id="spV1TenantName" name="spV1TenantName" data-ng-required="addOffice365.sharePointBackupSetModel.isModernAuthEnabled"
													placeholder='<cv:msg key="label.help.azureDirectoryID" bundle="exchange"/>'                        
													data-ng-model="addOffice365.office365Attributes.exchangeAttributes.onePassProp.azureApps.azureDirectoryId" />
											</div>
											<div class="help-block"
													data-ng-show="cv.addOffice365Form.needsAttention(addOffice365Form.spV1TenantName)">
												<cv:msg key="label.azureTenantIdRequired" bundle="exchange" />
											</div>
										</div>
									</div>

								</div>
								<div>
									<div class="form-group">
										<cv-help-text class="col-xs-12 col-md-4 margin-top-10" help-label="label.sharePointAdminUser" help-text="help.sharePointAdminUser"/>
										<div class="col-xs-12 col-md-8">
											<input type="text" name="username" id="username"
												data-ng-model="addOffice365.sharePointBackupSetModel.office365Credentials.userName"
												required autofocus />
											<div class="help-block"
												data-ng-show="cv.addOffice365Form.needsAttention(addOffice365Form.username)">
												<cv:msg key="error.sharePointAdminUser" bundle="office365" />
											</div>
										</div>
									</div>
							
									<div class="form-group">
										<label class="col-xs-12 col-md-4" for="password"><cv:msg
												key="label.sharePointAdminPassword" bundle="office365" /></label>
										<div class="col-xs-12 col-md-8">
											<input type="password" name="password" id="password"
											data-ng-model="addOffice365.sharePointBackupSetModel.office365Credentials.password"
												required autofocus />
											<div class="help-block"
												data-ng-show="cv.addOffice365Form.needsAttention(addOffice365Form.password)">
												<cv:msg key="error.sharePointAdminPassword" bundle="office365" />
											</div>
										</div>
									</div>
								</div>
								
								<div data-ng-if="!addOffice365.isOffice365SaaSTenant">
									<div class="form-group">
										<cv-help-text class="col-xs-12 col-md-4 margin-top-10" help-label="label.sharepointAzureStorageUser" help-text="help.sharepointAzureStorageUser"/>
										<div class="col-xs-12 col-md-8">
											<input type="text" name="azureUserAccount" id="azureUserAccount"
											data-ng-model="addOffice365.sharePointBackupSetModel.azureUserAccount"
												required autofocus />
											<div class="help-block"
												data-ng-show="cv.addOffice365Form.needsAttention(addOffice365Form.azureUserAccount)">
												<cv:msg key="error.sharepointAzureStorageUser" bundle="office365"/>
											</div>
										</div>
									</div>
									<div class="form-group">
										<label class="col-xs-12 col-md-4" for="azurePassword"><cv:msg
												key="label.sharePointAzureStorageKey" bundle="office365" /></label>
										<div class="col-xs-12 col-md-8">
											<input type="password" name="azurePassword" id="azurePassword"
											data-ng-model="addOffice365.sharePointBackupSetModel.azureAccountKey"
												required autofocus />
											<div class="help-block"
												data-ng-show="cv.addOffice365Form.needsAttention(addOffice365Form.azurePassword)">
												<cv:msg key="error.sharePointAzureStorageKey" bundle="office365" />
											</div>
										</div>
									</div>
								</div>
													
							</div>
						</div>
					</div>
					<!--SharePoint v1 --- Add backupset app --End-->

					<!-- End Step 1 -->
					<div data-ng-if="!addOffice365.isOffice365SaaSTenant">
						<uib-accordion close-others="oneAtATime" data-ng-if="!addOffice365.isSharePointV1"> <!--Infrastructure Setting -->
						<!--OneDrive v1 Config-Start-->
						<!-- OneDrive-Infrastrcture-Setting -->
						<div uib-accordion-group class="panel-default"
							data-ng-if="addOffice365.office365Attributes.generalAttributes.isOneDriveClassicMode"
							data-is-open="addOffice365.infrastructureToggle"
							data-is-disabled="!addOffice365.showInfrastructureTab">
							<uib-accordion-heading class="panel-info">
							<cv:msg key="label.infrastructurePane" bundle="exchange" /><span data-ng-if="addOffice365.isInfrastructurePoolConfigured" class="restore-help-text margin-left-10"><cv:msg key="label.infrastructureInherited" bundle="exchange" /></span>
							<i class="float-right glyphicon"
								data-ng-class="{'glyphicon-chevron-down': addOffice365.infrastructureToggle, 'glyphicon-chevron-right': !addOffice365.infrastructureToggle}"></i>
							</uib-accordion-heading>
							<div data-ng-if="addOffice365.showInfrastructureTab">
							
								<!--OneDrive Access Node-->
								<div class="form-group">
									<cv-help-text class="col-xs-12 col-md-3 margin-top-10" help-label="label.O365accessNode" help-text="help.oneDriveAccessNode"/>
									<div class="col-xs-12 col-md-9">
										<isteven-multi-select id="createOffice365App_isteven-multi-select_#5072" 
												class="half-width"
												input-model="addOffice365.oneDriveAccessNodesList"
												output-model="addOffice365.selectedOneDriveAccessNodesList"
												button-label="clientName"
												item-label="clientName"
												selection-mode="single"
												helper-elements="filter"
												directive-id="'oneDriveAccessNodes'"
												max-labels="1"
												tick-property="selected"
												on-item-click="addOffice365.processOneDriveAccessNodeSelection()"
												translation="addOffice365.localLang">
											</isteven-multi-select>
										<span data-ng-show="addOffice365Form.$submitted" class="help-block"
											data-ng-if="addOffice365.selectedOneDriveAccessNodesList.length === 0"><cv:msg
												key="error.selectNodes" bundle="exchange" /></span>
									</div>
								</div>
							</div>
						</div>
						<!-- End:::OneDrive-Infrastrcture-Setting -->
						<!--  AutoDiscover - START -->
						<div uib-accordion-group class="panel-default"
							data-ng-if="addOffice365.office365Attributes.generalAttributes.isOneDriveClassicMode"
							data-is-open="addOffice365.oneDriveAutoDiscover">
							<uib-accordion-heading class="panel-info">
							<cv:msg key="label.autoDiscovery" bundle="exchange" />
							<i class="float-right glyphicon"
								data-ng-class="{'glyphicon-chevron-down': addOffice365.oneDriveAutoDiscover , 'glyphicon-chevron-right': !addOffice365.oneDriveAutoDiscover}"></i>
							</uib-accordion-heading>
							<div class="form-group">
									<div class="col-xs-12 col-md-3">
										<input id="enableAutoDiscovery" type="checkbox"
											data-ng-checked="addOffice365.office365Attributes.onedriveAttributes.instance.cloudAppsInstance.oneDriveInstance.isAutoDiscoveryEnabled"
											data-ng-model="addOffice365.office365Attributes.onedriveAttributes.instance.cloudAppsInstance.oneDriveInstance.isAutoDiscoveryEnabled"
											data-ng-change="addOffice365.oneDriveAutoDiscoveryChanged()" /> <label
											for="enableAutoDiscovery"><cv:msg key="label.enableODAutoDiscovery" bundle="exchange" /></label>
									</div>
								<div class="col-xs-12 col-md-9"
										data-ng-show="addOffice365.office365Attributes.onedriveAttributes.instance.cloudAppsInstance.oneDriveInstance.isAutoDiscoveryEnabled">
										<div>
											<label class="col-xs-12" for="typeOfAutoDiscoverRegex"><input
												type="radio" id="typeOfAutoDiscoverRegex"
												value="{{addOffice365.regexText}}" name="typeOfAutoDiscover"
												data-ng-model="addOffice365.office365Attributes.onedriveAttributes.instance.cloudAppsInstance.oneDriveInstance.autoDiscoveryMode" />
												<cv:msg key="label.autoDisc.match.user.regex" bundle="capps" /> </label>
										</div>
										<div>
											<label class="col-xs-12" for="typeOfAutoDiscoverGroup"> <input
												type="radio" id="typeOfAutoDiscoverGroup"
												data-ng-model="addOffice365.office365Attributes.onedriveAttributes.instance.cloudAppsInstance.oneDriveInstance.autoDiscoveryMode"
												value="{{addOffice365.userGrpText}}" name="typeOfAutoDiscover">
												<cv:msg key="label.autoDisc.azure.grp.affinity" bundle="capps" />
											</label>
										</div>
								</div>
							</div>
							<!--Auto-create subclients-->
							<div class="form-group" data-ng-if="addOffice365.office365Attributes.onedriveAttributes.instance.cloudAppsInstance.oneDriveInstance.isAutoDiscoveryEnabled &&
								addOffice365.office365Attributes.onedriveAttributes.instance.cloudAppsInstance.oneDriveInstance.autoDiscoveryMode === 'REGEX'">
								<div class="col-xs-12 col-md-3">
									<input id="enableCreateAdditionalSubclients" type="checkbox"
										data-ng-checked="addOffice365.office365Attributes.onedriveAttributes.instance.cloudAppsInstance.oneDriveInstance.createAdditionalSubclients"
										data-ng-model="addOffice365.office365Attributes.onedriveAttributes.instance.cloudAppsInstance.oneDriveInstance.createAdditionalSubclients"
										data-ng-change="addOffice365.createSubclientsChanged()" /> 
										<label for="enableCreateAdditionalSubclients"><cv-help-text help-label="label.createSubclients" help-text="help.createSubclients"/></label>
								</div>
							<div class="col-xs-12 col-md-9"
									data-ng-disabled="!addOffice365.office365Attributes.onedriveAttributes.instance.cloudAppsInstance.oneDriveInstance.createAdditionalSubclients">
									<label class="col-xs-12">
										<cv-radio-group  radio-name="subclientOptionsRd" radio-model="addOffice365.office365Attributes.onedriveAttributes.instance.cloudAppsInstance.oneDriveInstance.numberofAdditionalSubclients" radio-obj="addOffice365.subclientOptions"></cv-radio-group>
									</label>
							</div>
							</div>
						</div>
					<!--  AutoDiscover  - END -->
				<!--OneDrive v1 Config -- End-->
						<!--O365-->
						<div uib-accordion-group class="panel-default"
							data-ng-if="!addOffice365.office365Attributes.generalAttributes.isOneDriveClassicMode"
							data-is-open="addOffice365.infrastructureToggle"
							data-is-disabled="!addOffice365.showInfrastructureTab">
							<uib-accordion-heading class="panel-info">
							<cv:msg key="label.infrastructurePane" bundle="exchange" /><span data-ng-if="addOffice365.isInfrastructurePoolConfigured" class="restore-help-text margin-left-10"><cv:msg key="label.infrastructureInherited" bundle="exchange" /></span>
							<i class="float-right glyphicon"
								data-ng-class="{'glyphicon-chevron-down': addOffice365.infrastructureToggle, 'glyphicon-chevron-right': !addOffice365.infrastructureToggle}"></i>
							</uib-accordion-heading>
							<div data-ng-if="addOffice365.showInfrastructureTab">

							<div class="form-group">
								<!--  Index Server -->
								<cv-help-text class="col-xs-12 col-md-3 margin-top-10" help-label="label.indexServer" help-text="info.indexServer"/>
								<div class="col-xs-12 col-md-9">
									<div class="input-group">
										<isteven-multi-select id="createOffice365App_isteven-multi-select_#2568" 
											input-model="addOffice365.indexServerList"
											output-model="addOffice365.selectedIndexServerList"
											button-label="mediaAgentName"
											item-label="mediaAgentName"
											selection-mode="single"
											helper-elements="filter"
											directive-id="'indexServers'"
											max-labels="1"
											on-item-click="addOffice365.processIndexServerSelection()"
											tick-property="selected"
											translation="addOffice365.localLang">
										</isteven-multi-select>
										<div class="help-block"
											data-ng-show="addOffice365Form.$submitted"
											data-ng-if="addOffice365.selectedIndexServerList.length === 0 || addOffice365.selectedIndexServerList[0].mediaAgentName === '##Create New##'">
											<cv:msg key="error.selectIndexServer" bundle="exchange" />
										</div>
										<span class="input-group-btn">
											<button id="createIndexServer_button_#3718" type="button"
												data-ng-click="addOffice365.createNewIndexServer()"
												class="icon-style cv-material-button browse">
												<div class="cv-material-button-icon cursor-pointer">
													<svg height="20" id="cv_cc" viewBox="0 0 448 448" width="20" xmlns="http://www.w3.org/2000/svg">
														<path d="m408 184h-136c-4.417969 0-8-3.582031-8-8v-136c0-22.089844-17.910156-40-40-40s-40 17.910156-40 40v136c0 4.417969-3.582031 8-8 8h-136c-22.089844 0-40 17.910156-40 40s17.910156 40 40 40h136c4.417969 0 8 3.582031 8 8v136c0 22.089844 17.910156 40 40 40s40-17.910156 40-40v-136c0-4.417969 3.582031-8 8-8h136c22.089844 0 40-17.910156 40-40s-17.910156-40-40-40zm0 0"/>
													</svg>
												</div>
												<div class="cv-material-button-tooltip">
													<cv:msg key="label.newExchangeIndexServer" bundle="exchange" />
												</div>
											</button>
										</span>
									</div>
								</div>
							</div>
							<!--  Index Server -->
							<!--  Access Nodes -- Office 365-->
							<div class="form-group">
								<cv-help-text class="col-xs-12 col-md-3 margin-top-10" help-label="label.accessNodes" help-text="help.office365Accessnodes" />
								<div class="col-xs-12 col-md-9">
									<isteven-multi-select id="createOffice365App_isteven-multi-select_#5438" 
										input-model="addOffice365.nodeList"
										output-model="addOffice365.office365Attributes.exchangeAttributes.memberServers.memberServers"
										button-label="clientName"
										item-label="clientName"
										tick-property="selected"
										data-ng-required="true"
										class="isteven-multi-select user-group-select"
										directive-id="'accessNodes'"
										name="accessNodes"
										helper-elements="all none reset filter"
										max-labels="8"
										on-item-click="addOffice365.processAccessNodeSelection()"
										on-select-none="addOffice365.resetAccessNodeSelection()"
										on-select-all="addOffice365.processAccessNodeSelection()"
										on-reset="addOffice365.resetAccessNodeSelection()"
										required translation="addOffice365.localLang"
										group-property="msGroup">
									</isteven-multi-select>
									<span data-ng-show="addOffice365Form.$submitted" class="help-block"
										data-ng-if="addOffice365.office365Attributes.exchangeAttributes.memberServers.memberServers.length === 0"><cv:msg
											key="error.selectNodes" bundle="exchange" /></span>
								</div>
							</div>
							<!--  Access Nodes -->
							<!--  Shared Path -->
							<div class="form-group"
								data-ng-if="addOffice365.office365Attributes.exchangeAttributes.memberServers.memberServers.length > 1 || addOffice365.isClientGroupSelected">
								<cv-help-text class="col-xs-12 col-md-3 margin-top-10" help-label="label.jobResultsDirectory" help-text="info.jobResultsDir"/>
								<div class="col-xs-12 col-md-9">
									<input type="text" id="jobResultDirectory"
										name="jobResultDirectory" required
										placeholder='<cv:msg key="label.help.jobResultsDirectory" bundle="exchange" />'
										data-ng-model="addOffice365.office365Attributes.exchangeAttributes.jobResulsDir.path"
										data-ng-pattern="addOffice365.REGEX.WINDOWS_NETWORK_PATH" />
									<div class="help-block"
										data-ng-show="cv.addOffice365Form.needsAttention(addOffice365Form.jobResultDirectory) || addOffice365Form.jobResultDirectory.$error.pattern">
										<cv:msg key="error.validUNCPath" bundle="exchange" />
									</div>
								</div>
							</div>
							<!--  Shared Path -->
							<div class="form-group"
								data-ng-if="addOffice365.office365Attributes.exchangeAttributes.memberServers.memberServers.length > 1 || addOffice365.isClientGroupSelected">
								<label class="col-xs-12 col-md-3" for="serviceAccounts"><cv:msg
										key="label.sharePathAccount" bundle="exchange" /></label>
								<div class="margin-top-10 col-xs-12 col-md-9">
									<a id="addLocalAccount" name="addLocalAccount"
										data-ng-if="!addOffice365.office365Attributes.hasAccountType('SYSTEM_ACCOUNT')"
										data-ng-click="addOffice365.addAccountToAccessSharedPath()"
										class="float-left">
											<i class="fa fa-pencil margin-right-5"></i>
											<cv:msg key="label.add" bundle="exchange" />
										</a>
									<a class="float-left"
										data-ng-repeat="userAccount in addOffice365.office365Attributes.exchangeAttributes.onePassProp.accounts.adminAccounts"
										data-ng-if="addOffice365.office365Attributes.hasAccountType('SYSTEM_ACCOUNT') && addOffice365.office365Attributes.exchangeAttributes.onePassProp.accounts.adminAccounts[$index].serviceType === 'SYSTEM_ACCOUNT'"
										data-ng-click="addOffice365.addEditServiceAccount(addOffice365.selectedOffice365Mode, addOffice365.manualSubMode.SYSTEM_ACCOUNT, true, true, addOffice365.office365Attributes.exchangeAttributes.onePassProp.accounts.adminAccounts, addOffice365.office365Attributes.exchangeAttributes.onePassProp.azureApps, addOffice365.office365Attributes.sharepointAttributes.sharepointBackupSet.spOffice365BackupSetProp.tenantUrlItem)"
										ng-bind="addOffice365.office365Attributes.exchangeAttributes.onePassProp.accounts.adminAccounts[$index].userAccount.userName">
									</a>
									<div class="help-block" data-ng-show="addOffice365Form.$submitted"
										data-ng-if="(addOffice365.isClientGroupSelected || addOffice365.office365Attributes.exchangeAttributes.memberServers.memberServers.length > 1) && !addOffice365.office365Attributes.hasAccountType('SYSTEM_ACCOUNT')">
										<cv:msg key="error.addSharedPathAccount" bundle="exchange" />
									</div>
								</div>
							</div>

							<div class="form-group" data-ng-if="addOffice365.office365Attributes.generalAttributes.sharepointOnline">
								<span class="col-xs-12 col-md-3">
									<cv-help-text help-label="label.azureStorageAccount" help-text="help.sharepointAzureStorageUser"/> <span class="optional-text"><cv:msg
										key="Optional" bundle="messages"></cv:msg></span>
								</span>
								<div class="col-xs-12 col-md-9">
									<div data-ng-if="addOffice365.office365Attributes.exchangeAttributes.onePassProp.accounts.adminAccounts.length === 0 || !addOffice365.office365Attributes.hasAccountType('SHAREPOINT_AZURE_STORAGE')">
										<a
											data-ng-click="addOffice365.addEditServiceAccount(addOffice365.selectedOffice365Mode, addOffice365.manualSubMode.SHAREPOINT_AZURE_STORAGE, false, false, addOffice365.office365Attributes.exchangeAttributes.onePassProp.accounts.adminAccounts, undefined, addOffice365.office365Attributes.sharepointAttributes.sharepointBackupSet.spOffice365BackupSetProp.tenantUrlItem, false)">
											<i class="fa fa-pencil margin-right-5"></i>
											<cv:msg key="label.add.azureStorageAccount" bundle="office365" />
										</a>
									</div>
									<div data-ng-if="addOffice365.office365Attributes.exchangeAttributes.onePassProp.accounts.adminAccounts.length > 0 && addOffice365.office365Attributes.hasAccountType('SHAREPOINT_AZURE_STORAGE')">
										<a
											class="crop"
											data-ng-repeat="userAccount in addOffice365.office365Attributes.exchangeAttributes.onePassProp.accounts.adminAccounts"
											data-ng-if="addOffice365.office365Attributes.hasAccountType('SHAREPOINT_AZURE_STORAGE') && addOffice365.office365Attributes.exchangeAttributes.onePassProp.accounts.adminAccounts[$index].serviceType === 'SHAREPOINT_AZURE_STORAGE'"
											data-ng-click="addOffice365.addEditServiceAccount(addOffice365.selectedOffice365Mode, addOffice365.manualSubMode.SHAREPOINT_AZURE_STORAGE, true, false, addOffice365.office365Attributes.exchangeAttributes.onePassProp.accounts.adminAccounts, undefined, addOffice365.office365Attributes.sharepointAttributes.sharepointBackupSet.spOffice365BackupSetProp.tenantUrlItem, false)"
											ng-bind="addOffice365.office365Attributes.exchangeAttributes.onePassProp.accounts.adminAccounts[$index].userAccount.userName">
										</a>
									</div>
								</div>
							</div>

							</div>
						</div>
						</uib-accordion>
					</div>

					<!-- Connection Settings-->
					<div class="panel panel-default" data-ng-if="!addOffice365.isSharePointV1">
						<div class="panel-body">
							<h4 data-ng-if="!addOffice365.isOffice365SaaSTenant" data-ng-bind="addOffice365.connectionSettingsTitle"></h4>

							<!--Office 365 SAAS Config-->
							<div data-ng-if="addOffice365.isOffice365SaaSTenant"
									data-ng-show="addOffice365.showAppNameInput"> 
								<div class="form-group">
									<label class="col-xs-12 col-md-3" for="appName"><cv:msg
											key="label.name" bundle="exchange" /></label>
									<div class="col-xs-12 col-md-9">
										<div class="input-group">
											<span class="input-group-addon" style="background-color:transparent; padding:0px; border:none;"
												data-ng-bind="addOffice365.office365AppPrefix"></span>
											<input type="text" name="appName" id="appName"
												placeholder='<cv:msg key="label.exchAppNamePlaceholder" bundle="exchange"/>'
												data-ng-disabled="addOffice365.office365Attributes.disableClientName"
												data-ng-pattern="/^[a-zA-Z0-9_-]*$/"
												data-ng-model="addOffice365.office365AppName"
												required autofocus />
										</div>
										<div class="help-block"
											data-ng-show="cv.addOffice365Form.needsAttention(addOffice365Form.appName)">
											<cv:msg key="error.noServerName" bundle="exchange" />
										</div>
									</div>
								</div>
							</div>

							<div class="form-group margin-top-20">
								<label class="col-xs-12 col-md-3" for="region"><cv:msg
										key="label.office365.cloudregion" bundle="exchange" /></label>
								<div class="col-xs-12 col-md-9"
									data-ng-disabled="!addOffice365.office365Attributes.generalAttributes.addAppServiceAccountManually && addOffice365.office365Attributes.generalAttributes.isGlobalLogin === true &&
									addOffice365.office365Attributes.exchangeAttributes.onePassProp.azureApps.azureAppId.length > 0">
									<isteven-multi-select id="createOffice365App_isteven-multi-select_#1167" 
												input-model="addOffice365.msCloudRegions"
												output-model="addOffice365.selectedRegionList"
												button-label="region"
												item-label="region"
												directive-id="'cloudRegions'"
												selection-mode="single"
												helper-elements="filter"
												max-labels="1"
												on-item-click="addOffice365.processRegionSelection()"
												tick-property="selected"
												translation="addOffice365.localLang">
									</isteven-multi-select>
								</div>
							</div>

							<div class="margin-top-15"
								data-ng-if="!addOffice365.office365Attributes.generalAttributes.addAppServiceAccountManually && addOffice365.office365Attributes.generalAttributes.isGlobalLogin && addOffice365.office365Attributes.exchangeAttributes.onePassProp.azureApps.azureAppId.length > 0">
								<div class="form-group">
									<cv-help-text class="col-xs-12 col-md-3" help-label="label.globalAdministrator" help-text="help.globalAdmin"/>
									<div class="col-xs-12 col-md-9">
										<span id="globalAdminUsername" name="globalAdminUsername"
											class="float-left" ng-bind="addOffice365.office365Attributes.globalAdminAccount.adminCredential.userName"></span>
									</div>
								</div>
							</div>

							<div class="margin-top-15" data-ng-if="!addOffice365.office365Attributes.generalAttributes.addAppServiceAccountManually && addOffice365.office365Attributes.generalAttributes.isGlobalLogin && addOffice365.office365Attributes.generalAttributes.azureAppDisplayName.length > 0">
								<div class="form-group">
									<label class="col-xs-12 col-md-3" for="azureAppDetails"><cv:msg
										key="label.azureAppDetails" bundle="exchange" /></label>
									<div class="col-xs-12 col-md-9 margin-top-10">
										<span id="globalAppName" name="globalAppName" class="float-left" ng-bind="addOffice365.office365Attributes.generalAttributes.azureAppDisplayName"></span>
									</div>
								</div>
							</div>

							<div data-ng-if="!addOffice365.office365Attributes.generalAttributes.isGlobalLogin" class="margin-top-20">
								<div class="form-group">
									<cv-help-text class="col-xs-12 col-md-3 margin-top-10" help-label="label.office365.config.mode" help-text="label.office365.conn.config.header"/>
									<div class="col-xs-12 col-md-9">
										<cv-radio-group
											class="font-weight-bold" 
											radio-model="addOffice365.office365AccountCreationOptionVal" 
											radio-obj="addOffice365.office365AccountCreationOptions"
											is-disabled="addOffice365.azureAppCreationInProgress"
											on-click="addOffice365.office365AccountCreationOptionValChange(data)">
										</cv-radio-group>
										<!--Add Azure app / Svc Accounts manually --START-->
										<div class="margin-top-10 padding-left-20 margin-left-5" data-ng-if="!addOffice365.createAppSvcAccountUsingGlobalAdmin">

											<!--Download config helper files --START-->
											<div class="row margin-left-15 margin-right-15">                      
												<div class="form-group info-message message-background no-padding">                                                                                                    
													<span class="margin-left-5 message-width margin-right-5">
														<h5 class="line-height-2">
															<cv:msg key="label.download.o365.config.pdf.i" bundle="office365" />
															<a data-ng-click="addOffice365.downloadToolkit()"><cv:msg key="label.click.here" bundle="office365" />
																<i class="margin-left-5 fa fa-download"></i>
															</a>.&nbsp;
															<span data-ng-if="addOffice365.selectedOffice365Mode === addOffice365.ONEDRIVE_FOR_BUSINESS">
																<cv:msg key="label.download.o365.config.pdf.ii" bundle="office365" />
															</span>
															<span data-ng-if="addOffice365.selectedOffice365Mode !== addOffice365.ONEDRIVE_FOR_BUSINESS">
																<cv:msg key="label.download.o365.config.pdf.iii" bundle="office365" />
															</span>
														</h5>                                                      
													</span>                              
												</div>
											</div>
											<!--Download config helper files --END-->

											<!--Modern Authentication Toggle (Exchange)-->
											<div data-ng-if="addOffice365.office365Attributes.generalAttributes.exchangeOnline && addOffice365.showModernAuthInputOptions">
												<div class="form-group">
													<div class="margin-top-10 col-xs-12 col-md-12">
														<cv-toggle
															on-click="addOffice365.updateModernAuthFlag(data)"
															toggle-name="modernAuthToggle" 
															toggle-label="label.useModernAuthentication" 				
															value="addOffice365.office365Attributes.exchangeAttributes.onePassProp.isModernAuthEnabled"
															help-text="'help.modernAuth'" 
															help-direction="right"
															toggle-model="addOffice365.office365Attributes.exchangeAttributes.onePassProp.isModernAuthEnabled">
														</cv-toggle>
													</div>
												</div>
											</div>
											<!--Modern Authentication Toggle (Exchange)-->

											<!-- Azure AD App Details (Exchange)--Added Manually-- Start-->
											<div data-ng-if="addOffice365.office365Attributes.generalAttributes.exchangeOnline">
												<!--Add Azure app info header-->
												<label  
													class="font-weight-bold"> 
													<cv:msg key="dialog.azureapp.title" bundle="office365" />
												</label>
												<!--Add Azure app info header-->
												<div class="form-group margin-left-25">
													<label class="col-xs-12 col-md-4" for="mAzureApplicationId"><cv:msg
															key="label.azureAppDetails" bundle="exchange" /></label>
													<div class="margin-top-10 col-xs-12 col-md-8">
														<div data-ng-if="addOffice365.office365Attributes.exchangeAttributes.onePassProp.azureApps.azureAppId.length === 0">
															<a
																data-ng-click="addOffice365.addEditServiceAccount(addOffice365.selectedOffice365Mode, addOffice365.manualSubMode.AZURE_AD, false, false, addOffice365.office365Attributes.exchangeAttributes.onePassProp.accounts.adminAccounts, addOffice365.office365Attributes.exchangeAttributes.onePassProp.azureApps, undefined, true,addOffice365.office365Attributes.exchangeAttributes.onePassProp.isModernAuthEnabled)">
																<i class="fa fa-pencil margin-right-5"></i>
																<cv:msg key="label.option.addAzureAppManually" bundle="office365" />
															</a>
														</div>
														<div data-ng-if="addOffice365.office365Attributes.exchangeAttributes.onePassProp.azureApps.azureAppId.length > 0">
															<a id="mAzureApplicationId" name="mAzureApplicationId"
																data-ng-click="addOffice365.addEditServiceAccount(addOffice365.selectedOffice365Mode, addOffice365.manualSubMode.AZURE_AD, true, false, addOffice365.office365Attributes.exchangeAttributes.onePassProp.accounts.adminAccounts, addOffice365.office365Attributes.exchangeAttributes.onePassProp.azureApps, undefined, true, addOffice365.office365Attributes.exchangeAttributes.onePassProp.isModernAuthEnabled)"
																class="crop" ng-bind="addOffice365.office365Attributes.exchangeAttributes.onePassProp.azureApps.azureAppId">
															</a>
														</div>
														<div class="help-block" data-ng-show="addOffice365Form.$submitted"
															data-ng-if="addOffice365.office365Attributes.exchangeAttributes.onePassProp.azureApps.azureAppId.length === 0">
															<cv:msg key="error.addAzureAppManually" bundle="office365" />
														</div>
													</div>
												</div>
											</div>
											<!-- Azure AD App Details (Exchange)--Added Manually-- End-->

											<!-- Azure AD App Details (OneDrive)--Added Manually-- Start-->
											<div data-ng-if="addOffice365.office365Attributes.generalAttributes.oneDriveForBusiness">
												<!--Add Azure app info header-->
												<label  
													class="font-weight-bold"> 
													<cv:msg key="dialog.azureapp.title" bundle="office365" />
												</label>
												<!--Add Azure app info header-->
												<div class="margin-left-25">
													<div class="form-group">
														<label class="col-xs-12 col-md-4" for="applicationId"> <cv:msg
																key="label.applicationId" bundle="exchange"></cv:msg>
														</label>
														<div class="col-xs-12 col-md-8">
															<input type="text" id="applicationId" name="applicationId" required
																placeholder='<cv:msg key="placeholder.azureAppId" bundle="office365"/>'
																data-ng-model="addOffice365.office365Attributes.exchangeAttributes.onePassProp.azureApps.azureAppId" />
															<div class="help-block"
																	data-ng-show="cv.addOffice365Form.needsAttention(addOffice365Form.applicationId)">
																<cv:msg key="label.appIdRequired" bundle="exchange" />
															</div>
														</div>		
													</div>
										
													<div class="form-group">
														<label class="col-xs-12 col-md-4" for="secretAccessKey"> <cv:msg
																key="label.azureAppSecret" bundle="office365"></cv:msg>
														</label>
														<div class="col-xs-12 col-md-8">
															<input type="password" id="secretAccessKey" name="secretAccessKey" required
																placeholder='<cv:msg key="placeholder.azureAppSecret" bundle="office365" />'
																data-ng-model="addOffice365.office365Attributes.exchangeAttributes.onePassProp.azureApps.azureAppKeyValue" />
															<div class="help-block"
																	data-ng-show="cv.addOffice365Form.needsAttention(addOffice365Form.secretAccessKey)">
																<cv:msg key="label.appSecretRequired" bundle="exchange" />
															</div>
														</div>		
													</div>
										
													<div class="form-group">
														<label class="col-xs-12 col-md-4" for="tenantName"> <cv:msg
																key="label.azureDirectoryID" bundle="exchange"></cv:msg>
														</label>
														<div class="col-xs-12 col-md-8">
															<div>
																<input type="text" id="tenantName" name="tenantName" required
																	placeholder='<cv:msg key="label.help.azureDirectoryID" bundle="exchange"/>'                        
																	data-ng-model="addOffice365.office365Attributes.exchangeAttributes.onePassProp.azureApps.azureDirectoryId" />
															</div>
															<div class="help-block"
																	data-ng-show="cv.addOffice365Form.needsAttention(addOffice365Form.tenantName)">
																<cv:msg key="label.azureTenantIdRequired" bundle="exchange" />
															</div>
														</div>
													</div>
												</div>
											</div>
											<!-- Azure AD App Details (OneDrive)--Added Manually-- End-->

											<!-- Service Accounts --Added Manually For Exchange - Start-->
											<div data-ng-if="addOffice365.office365Attributes.generalAttributes.exchangeOnline">
												<!--Exchange Service Account --Inline info header-->
                                                <label  
                                                    class="font-weight-bold"> 
                                                    <cv:msg key="label.add.gen.svc.account" bundle="office365" />
                                                </label>
                                                <!--Exchange Service Account --Inline info header-->	
												<div class="form-group margin-left-25">
													<label class="col-xs-12 col-md-4" for="serviceAccounts"><cv:msg
															key="label.addO365ServiceAccount" bundle="exchange" /></label>
													<div class="margin-top-10 col-xs-12 col-md-8">
														<div data-ng-if="addOffice365.office365Attributes.exchangeAttributes.onePassProp.accounts.adminAccounts.length === 0 || !addOffice365.office365Attributes.hasAccountType('EXCHANGE_ONLINE')">
															<a
																data-ng-click="addOffice365.addEditServiceAccount(addOffice365.selectedOffice365Mode, addOffice365.manualSubMode.EXCHANGE_ONLINE, false, false, addOffice365.office365Attributes.exchangeAttributes.onePassProp.accounts.adminAccounts, addOffice365.office365Attributes.exchangeAttributes.onePassProp.azureApps, undefined, true, addOffice365.office365Attributes.exchangeAttributes.onePassProp.isModernAuthEnabled)">
																<i class="fa fa-pencil margin-right-5"></i>
																<cv:msg key="label.option.addServiceAccountManually" bundle="office365" />
															</a>
														</div>
														<div data-ng-if="addOffice365.office365Attributes.exchangeAttributes.onePassProp.accounts.adminAccounts.length > 0 && addOffice365.office365Attributes.hasAccountType('EXCHANGE_ONLINE')">
															<a
																class="crop"
																data-ng-repeat="userAccount in addOffice365.office365Attributes.exchangeAttributes.onePassProp.accounts.adminAccounts"
																data-ng-if="addOffice365.office365Attributes.hasAccountType('EXCHANGE_ONLINE') && addOffice365.office365Attributes.exchangeAttributes.onePassProp.accounts.adminAccounts[$index].serviceType === 'EXCHANGE_ONLINE'"
																data-ng-click="addOffice365.addEditServiceAccount(addOffice365.selectedOffice365Mode, addOffice365.manualSubMode.EXCHANGE_ONLINE, true, false, addOffice365.office365Attributes.exchangeAttributes.onePassProp.accounts.adminAccounts, addOffice365.office365Attributes.exchangeAttributes.onePassProp.azureApps, undefined, true, addOffice365.office365Attributes.exchangeAttributes.onePassProp.isModernAuthEnabled)"										
																ng-bind="addOffice365.office365Attributes.exchangeAttributes.onePassProp.accounts.adminAccounts[$index].exchangeAdminSmtpAddress">
															</a>
														</div>
														<div class="help-block" data-ng-show="addOffice365Form.$submitted"
															data-ng-if="!addOffice365.office365Attributes.hasAccountType('EXCHANGE_ONLINE')">
															<cv:msg key="dialog.header.serviceaccount.title" bundle="office365" />
														</div>
													</div>
												</div>
											</div>
											<!--  Service Accounts --Added Manually For Exchange - End-->

											<!-- Sharepoint connection setting manually -->
											<div data-ng-if="addOffice365.office365Attributes.generalAttributes.sharepointOnline">

												<!--Site URL info header-->
                                                <label  
                                                    class="font-weight-bold"> 
                                                    <cv:msg key="label.add.admin.site.url" bundle="office365" />
                                                </label>
                                                <!--Site URL info header-->

												<!--SharePoint SiteUrl - Start-->
												<div class="form-group margin-left-25">
													<label class="col-xs-12 col-md-4" for="sharePointTenantAdminUrl">
														<cv:msg key="label.sharepoint.siteUrl" bundle="office365" /></label>
													<div class="col-xs-12 col-md-8">
														<input type="text" id="sharePointTenantAdminUrl" name="sharePointTenantAdminUrl"
															data-ng-model="addOffice365.office365Attributes.sharepointAttributes.sharepointBackupSet.spOffice365BackupSetProp.tenantUrlItem"
															placeholder='<cv:msg key="placeholder.tenantAdminSiteURL" bundle="office365"/>'
															data-ng-required="addOffice365.office365Attributes.generalAttributes.sharepointOnline"
															required autofocus />
														<div class="help-block"
																data-ng-show="cv.addOffice365Form.needsAttention(addOffice365Form.sharePointTenantAdminUrl)">
															<cv:msg key="error.tenantAdminSiteURL" bundle="clients" />
														</div>
													</div>
												</div>
												<!--SharePoint SiteUrl - End-->

												<!--Modern Authentication Toggle (Sharepoint V2)-->
												<div class="form-group" data-ng-if="addOffice365.showModernAuthInputOptions">
													<div class="margin-top-10 col-xs-12 col-md-12">
														<cv-toggle
															toggle-name="modernAuthToggle" 
															toggle-label="label.useModernAuthentication"
															help-text="'help.modernAuth'" 
															help-direction="right"
															value="addOffice365.office365Attributes.sharepointAttributes.sharepointBackupSet.spOffice365BackupSetProp.isModernAuthEnabled"
															toggle-model="addOffice365.office365Attributes.sharepointAttributes.sharepointBackupSet.spOffice365BackupSetProp.isModernAuthEnabled">
														</cv-toggle>
													</div>
												</div>
												<!--Modern Authentication Toggle (Sharepoint V2)-->
												
												<!--SharePoint v2 Azure App --Inline info header-->
                                                <!--Add Azure app info header-->
                                                    <label  
                                                        class="font-weight-bold"> 
                                                        <cv:msg key="dialog.azureapp.title" bundle="office365" />
                                                    </label>
                                                    <!--Add Azure app info header-->
                                                <!--SharePoint v2 Azure App --Inline info header-->                           											

												<!-- Azure AD App Details (Sharepoint)--Added Manually-- Start-->
												<div data-ng-if="addOffice365.office365Attributes.sharepointAttributes.sharepointBackupSet.spOffice365BackupSetProp.isModernAuthEnabled">
													<div class="form-group margin-left-25">
														<label class="col-xs-12 col-md-4" for="mAzureApplicationId"><cv:msg
																key="label.azureAppDetails" bundle="exchange" /></label>
														<div class="margin-top-10 col-xs-12 col-md-8">
															<div data-ng-if="addOffice365.office365Attributes.exchangeAttributes.onePassProp.azureApps.azureAppId.length === 0">
																<a
																	data-ng-click="addOffice365.addEditServiceAccount(addOffice365.selectedOffice365Mode, addOffice365.manualSubMode.AZURE_AD, false, false, addOffice365.office365Attributes.exchangeAttributes.onePassProp.accounts.adminAccounts, addOffice365.office365Attributes.exchangeAttributes.onePassProp.azureApps, undefined, true)">
																	<i class="fa fa-pencil margin-right-5"></i>
																	<cv:msg key="label.option.addAzureAppManually" bundle="office365" />
																</a>
															</div>
															<div data-ng-if="addOffice365.office365Attributes.exchangeAttributes.onePassProp.azureApps.azureAppId.length > 0">
																<a id="mAzureApplicationId" name="mAzureApplicationId"
																	data-ng-click="addOffice365.addEditServiceAccount(addOffice365.selectedOffice365Mode, addOffice365.manualSubMode.AZURE_AD, true, false, addOffice365.office365Attributes.exchangeAttributes.onePassProp.accounts.adminAccounts, addOffice365.office365Attributes.exchangeAttributes.onePassProp.azureApps, undefined, true)"
																	class="crop" ng-bind="addOffice365.office365Attributes.exchangeAttributes.onePassProp.azureApps.azureAppId">
																</a>
															</div>
															<div class="help-block" data-ng-show="addOffice365Form.$submitted"
																data-ng-if="addOffice365.office365Attributes.exchangeAttributes.onePassProp.azureApps.azureAppId.length === 0">
																<cv:msg key="error.addAzureAppManually" bundle="office365" />
															</div>
														</div>
													</div>
												</div>
												<!-- Azure AD App Details (Sharepoint)--Added Manually-- End-->

												<!--SharePoint Service Account --Inline info header-->
                                                <label  
                                                    class="font-weight-bold"> 
                                                    <cv:msg key="label.add.sharePointServiceAccount" bundle="office365" />
                                                </label>
                                                <!--SharePoint Service Account --Inline info header-->										

												<!-- Service Accounts SharePoint - Start -->
												<div class="form-group margin-left-25" >
													<label class="col-xs-12 col-md-4" for="sharePointServiceAccount"><cv:msg
															key="label.addO365ServiceAccount" bundle="exchange" /></label>
													<div class="margin-top-10 col-xs-12 col-md-8">
														<div data-ng-if="addOffice365.office365Attributes.exchangeAttributes.onePassProp.accounts.adminAccounts.length === 0 || !addOffice365.office365Attributes.hasAccountType('SHAREPOINT_ONLINE')">
															<a
																data-ng-click="addOffice365.addEditServiceAccount(addOffice365.selectedOffice365Mode, addOffice365.manualSubMode.SHAREPOINT_ONLINE, false, false, addOffice365.office365Attributes.exchangeAttributes.onePassProp.accounts.adminAccounts, undefined, addOffice365.office365Attributes.sharepointAttributes.sharepointBackupSet.spOffice365BackupSetProp.tenantUrlItem, true)">
																<i class="fa fa-pencil margin-right-5"></i>
																<cv:msg key="label.add.sharePointServiceAccount" bundle="office365" />
															</a>
														</div>
														<div data-ng-if="addOffice365.office365Attributes.exchangeAttributes.onePassProp.accounts.adminAccounts.length > 0 && addOffice365.office365Attributes.hasAccountType('SHAREPOINT_ONLINE')">
															<a
																class="crop"
																data-ng-repeat="userAccount in addOffice365.office365Attributes.exchangeAttributes.onePassProp.accounts.adminAccounts"
																data-ng-if="addOffice365.office365Attributes.hasAccountType('SHAREPOINT_ONLINE') && addOffice365.office365Attributes.exchangeAttributes.onePassProp.accounts.adminAccounts[$index].serviceType === 'SHAREPOINT_ONLINE'"
																data-ng-click="addOffice365.addEditServiceAccount(addOffice365.selectedOffice365Mode, addOffice365.manualSubMode.SHAREPOINT_ONLINE, true, false, addOffice365.office365Attributes.exchangeAttributes.onePassProp.accounts.adminAccounts, undefined, addOffice365.office365Attributes.sharepointAttributes.sharepointBackupSet.spOffice365BackupSetProp.tenantUrlItem, true)"
																ng-bind="addOffice365.office365Attributes.exchangeAttributes.onePassProp.accounts.adminAccounts[$index].userAccount.userName">
															</a>
														</div>
														<div class="help-block" data-ng-show="addOffice365Form.$submitted"
															data-ng-if="addOffice365.office365Attributes.exchangeAttributes.onePassProp.accounts.adminAccounts.length === 0 || !addOffice365.office365Attributes.hasAccountType('SHAREPOINT_ONLINE')">
															<cv:msg key="dialog.header.serviceaccount.title" bundle="office365" />
														</div>
													</div>
												</div>
												<!-- Service Accounts SharePoint - End -->
												
											</div>
											<!-- Service Accounts --Added Manually For SharePoint - End-->
										
											<!--Check list for Custom Configuration -->
											<!--Connection info header-->
											<label  
												class="font-weight-bold" 
												data-ng-bind="addOffice365.connectionRequirementsHeader">
											</label>
											<!--Connection info header-->
											<!--Confirmation checkboxes -->
											<div class="form-group margin-left-25">
												<cv-checkbox-group 
													id="confirm-actions-checkbox-label"
													check-obj="addOffice365.confirmChkOptionsList" 
													output-model="addOffice365.confirmedChkOptions" 
													is-vertical="true"
													is-disabled="addOffice365.processingRequest" 
													on-click-checkbox="addOffice365.onClickConfirmationCheckbox(data)">
												</cv-checkbox-group>
												<div class="help-block margin-top-5"
													data-ng-show="addOffice365.azureAppNotSet"
													data-ng-bind-html="addOffice365.appCreationErrorResponse">
												</div>
											</div>
											<!--Confirmation checkboxes -->
											<!--Check list for Custom Configuration -->
										
										</div>
										<!--Add Azure app / Svc Accounts manually --END-->
										<!-- Global Admin Login --Start-->
										<div
											data-ng-if="!addOffice365.office365Attributes.generalAttributes.addAppServiceAccountManually && addOffice365.createAppSvcAccountUsingGlobalAdmin"
											class="margin-top-10 padding-left-20 margin-left-5">

											<!--Global Administrator Credentials--Header-->
                                            <label  
                                                class="font-weight-bold" 
                                                data-ng-bind="addOffice365.gaCredsTitleHeader">
                                            </label>
                                            <!--Global Administrator Credentials--Header-->
											
											<div class="form-group margin-left-10">
												<cv-call-out
													class="margin-top-10 col-xs-12 col-md-4"
													html-template="addOffice365.getGlobalAdminUserNameCallOut()"
													label='<cv:msg key="label.globalAdministrator" bundle="office365" />'
													placement="right"
													trigger="click"
												/>
												<div class="col-xs-12 col-md-8">
													<input type="email" id="globalUserName" name="globalUserName" 
														data-ng-disabled="addOffice365.azureAppCreationInProgress"
														data-ng-required="!addOffice365.office365Attributes.generalAttributes.addAppServiceAccountManually && addOffice365.createAppSvcAccountUsingGlobalAdmin"
														data-ng-model="addOffice365.office365Attributes.globalAdminAccount.adminCredential.userName"
														placeholder='<cv:msg key="label.gadmin.example" bundle="office365"/>' />
													<div class="help-block"
														data-ng-show="cv.addOffice365Form.needsAttention(addOffice365Form.globalUserName)">
														<cv:msg key="error.globalAppUsernameError" bundle="exchange" />
													</div>
												</div>
											</div>
											<div class="form-group margin-left-10">
												<label class="col-xs-12 col-md-4" for="globalPassword"><cv:msg
														key="label.password" bundle="exchange"></cv:msg></label>
												<div class="col-xs-12 col-md-8">
													<input type="password" id="globalPassword"
														name="globalPassword" data-ng-disabled="addOffice365.azureAppCreationInProgress"
														data-ng-required="!addOffice365.office365Attributes.generalAttributes.addAppServiceAccountManually && addOffice365.createAppSvcAccountUsingGlobalAdmin"
														data-ng-model="addOffice365.office365Attributes.globalAdminAccount.adminCredential.password"
														placeholder='<cv:msg key="label.password" bundle="exchange"/>' />
													<div class="help-block"
														data-ng-show="cv.addOffice365Form.needsAttention(addOffice365Form.globalPassword)">
														<cv:msg key="error.password" bundle="exchange" />
													</div>
												</div>
											</div>
											<!--Confirmation checkboxes -->
                                            <div class="form-group margin-left-25">
                                                <cv-checkbox-group 
                                                    id="confirm-actions-checkbox-label"
                                                    check-obj="addOffice365.confirmGAChkOptionsList" 
                                                    output-model="addOffice365.confirmedChkOptions"
													is-disabled="addOffice365.azureAppCreationInProgress"  
                                                    is-vertical="true" 
                                                    on-click-checkbox="addOffice365.onClickConfirmationCheckbox(data)">
                                                </cv-checkbox-group>
                                            </div>
                                            <!--Confirmation checkboxes -->
                                            <!--Connection info header-->
                                            <label  
                                                class="font-weight-bold" 
                                                data-ng-bind="addOffice365.connectionRequirementsHeader">
                                            </label>
                                            <!--Connection info header-->
                                            <!--Confirmation checkboxes -->
                                            <div class="form-group margin-left-25">
                                                <cv-checkbox-group 
                                                    id="confirm-actions-checkbox-label"
                                                    check-obj="addOffice365.confirmChkOptionsList" 
                                                    output-model="addOffice365.confirmedChkOptions" 
                                                    is-vertical="true"
													is-disabled="addOffice365.azureAppCreationInProgress"  
                                                    on-click-checkbox="addOffice365.onClickConfirmationCheckbox(data)">
                                                </cv-checkbox-group>
                                            </div>
                                            <!--Confirmation checkboxes -->
											<div class="form-group margin-left-25">
												<button id="createOffice365App_button_#6055" class="btn btn-default margin-top-10" type="button" 
													data-ng-disabled="addOffice365.azureAppCreationInProgress ||
														!addOffice365.confirmRequirementsModel.mfaDisabled ||
														addOffice365.office365Attributes.globalAdminAccount.adminCredential.userName.length < 1 ||
														addOffice365.office365Attributes.globalAdminAccount.adminCredential.password.length < 1"
													data-ng-click="addOffice365.createAzureAppFromGlobalLogin()">
													<cv:msg key="label.createApp" bundle="exchange" />
													<i data-ng-if="addOffice365.azureAppCreationInProgress"
														class="fa fa-spinner fa-spin"></i>
												</button>
												<div class="help-block margin-top-5"
													data-ng-show="addOffice365.globalLoginFailure || addOffice365.azureAppNotSet"
													ng-bind="addOffice365.appCreationErrorResponse">
												</div>												
											</div>
										</div>
										<!-- Global Admin Login --End-->
									</div>
								</div>
							</div>

							<!-- Azure AD App Details --Global Admin--Start-->
							<div
								data-ng-if="addOffice365.createAppSvcAccountUsingGlobalAdmin && !addOffice365.office365Attributes.generalAttributes.addAppServiceAccountManually"
								class="col-xs-12 col-md-12 margin-bottom-10 padding-left-20 padding-right-20">
								<div class="form-group">
									<div class="col-xs-12 col-md-12 margin-top-10">
										<cv-progress-stepper 
											input-model="addOffice365.azureAppStepperModel" 
											progress="addOffice365.appCreationProgress">
										</cv-progress-stepper>
									</div>
								</div>
								<!--Step details -->
								<div data-ng-if="addOffice365.office365Attributes.generalAttributes.isGlobalLogin" class="form-group">
									<div class="margin-top-30 col-xs-12 col-md-3">
										<a class="small italic float-left" data-ng-click="addOffice365.toggleAzureAppCreationDetails()" data-ng-bind="addOffice365.showHideAzureAppCreationDetails"></a>
									</div>
									<div class="margin-top-30 col-xs-12 col-md-9">
										<span class="float-right small italic" data-ng-if="addOffice365.authRetryCount >= 2 && !addOffice365.isAzureAppAuthorized">
											<cv:msg key="confirm.appAuthorized" bundle="office365" />
											<a class="margin-left-5" data-ng-click="addOffice365.appAuthorizedOverride()">
												<cv:msg key="button.yes" bundle="messages"></cv:msg>
											</a>
											<a class="margin-left-5" data-ng-click="addOffice365.authenticateAzureADApp()">
												<cv:msg key="button.no" bundle="messages"></cv:msg>
											</a>
										</span>
									</div>
								</div>
								<div class="form-group">
									<div data-ng-show="addOffice365.showAzureAppCreationDetails" class="col-xs-12 col-md-12 margin-top-20">
										<table class="table table-striped margin-top-10">
											<tbody>
												<!-- App Created --Start -->
												<tr>
													<td class="restore-help-text ">
														<cv:msg key="label.appCreatedSuccess" bundle="exchange" />
														<br>
														<span id="globalAppId" name="globalAppId" class="italic font-weight-bold" ng-bind="addOffice365.office365Attributes.generalAttributes.azureAppDisplayName"></span>
													</td>
													<td class="text-align-center">
														<i class="k-icon k-i-check green-font"></i>
													</td>
												</tr>
												<!-- App Created --End -->

												<!-- Modern Auth is now set by Default -->

												<!-- Exchange Online Service Account --Start -->
												<tr data-ng-if="addOffice365.office365Attributes.generalAttributes.exchangeOnline">
													<td class="restore-help-text">
														<cv:msg key="label.creatingServiceAccount" bundle="exchange" />
														<div data-ng-if="!addOffice365.exchangeServiceAccountFailed && !addOffice365.exchangeServiceAccountCreationInProgress && addOffice365.office365Attributes.generalAttributes.exchangeOnlineServiceAccount.length > 0">
															<span id="exchangeSvcAcct" name="exchangeSvcAcct" class="italic font-weight-bold" ng-bind="addOffice365.office365Attributes.generalAttributes.exchangeOnlineServiceAccount"></span>
														</div>
														<div data-ng-show="addOffice365.exchangeServiceAccountFailed">
															<span class="red-font" ng-bind="addOffice365.exchangeServiceAccountError"></span>
														</div>
													</td>
													<td class="text-align-center">
														<div data-ng-if="addOffice365.exchangeServiceAccountFailed">
															<button id="createOffice365App_button_#1632" class="btn btn-link btn-xs"
																type="button"
																data-ng-click="addOffice365.retryExchangeServiceAccountCreation()">
																<cv:msg key="label.retryServiceAccountCreation" bundle="exchange" />
															</button>
															<br>
															<cv:msg key="label.or" bundle="office365" />
															<br>
															<button id="createOffice365App_button_#1667" class="btn btn-link btn-xs"
																type="button"
																data-ng-click="addOffice365.configureExchangeServiceAccountManually()">
																<cv:msg key="label.addO365ServiceAccountManually" bundle="exchange" />
															</button>
														</div>
														<div data-ng-if="!addOffice365.exchangeServiceAccountFailed">
															<i data-ng-class="addOffice365.exchangeServiceAccountCreationInProgress ? 'fa fa-spinner fa-spin' : 'k-icon k-i-check green-font'"></i>
														</div>
													</td>
												</tr>
												<!-- Exchange Online Service Account --End -->
												
												<!-- Sharepoint online  Account --Start -->
												<tr data-ng-if="addOffice365.office365Attributes.generalAttributes.sharepointOnline">
													<td class="restore-help-text">
														<cv:msg key="label.creatingSharepointServiceAccount" bundle="office365" />
														<div data-ng-if="!addOffice365.exchangeServiceAccountFailed && !addOffice365.exchangeServiceAccountCreationInProgress && addOffice365.office365Attributes.generalAttributes.sharepointOnlineServiceAccount.length > 0">
															<span id="exchangeSvcAcct" name="exchangeSvcAcct" class="italic font-weight-bold" ng-bind="addOffice365.office365Attributes.generalAttributes.sharepointOnlineServiceAccount"></span>
														</div>
														<div data-ng-show="addOffice365.exchangeServiceAccountFailed">
															<span class="red-font" ng-bind="addOffice365.exchangeServiceAccountError"></span>
														</div>
													</td>
													<td class="text-align-center">
														<div data-ng-if="addOffice365.exchangeServiceAccountFailed">
															<button id="createOffice365App_button_#3000" class="btn btn-link btn-xs"
																type="button"
																data-ng-click="addOffice365.retryExchangeServiceAccountCreation()">
																<cv:msg key="label.retryServiceAccountCreation" bundle="exchange" />
															</button>
															<br>
															<cv:msg key="label.or" bundle="office365" />
															<br>
															<button id="createOffice365App_button_#3001" class="btn btn-link btn-xs"
																type="button"
																data-ng-click="addOffice365.addEditServiceAccount(addOffice365.selectedOffice365Mode, addOffice365.manualSubMode.SHAREPOINT_ONLINE, false, false, addOffice365.office365Attributes.exchangeAttributes.onePassProp.accounts.adminAccounts, undefined, undefined, false)">
																<cv:msg key="label.addO365ServiceAccountManually" bundle="exchange" />
															</button>
														</div>
														<div data-ng-if="!addOffice365.exchangeServiceAccountFailed">
															<i data-ng-class="addOffice365.exchangeServiceAccountCreationInProgress ? 'fa fa-spinner fa-spin' : 'k-icon k-i-check green-font'"></i>
														</div>
													</td>
												</tr>
												<!-- Sharepoint online Account --End -->

												<!-- Sync Azure AD App --Start -->
												<tr>
													<td class="restore-help-text">
														<cv:msg key="label.azureSync" bundle="exchange" />
														<div class="orange-font" data-ng-if="addOffice365.azureADAppSyncFailure">
															<br>
															<cv:msg key="label.syncFailureNote" bundle="exchange" />
														</div>
													</td>
													<td class="text-align-center">
														<div data-ng-if="!addOffice365.azureADAppSyncFailure">
															<i data-ng-class="(addOffice365.startAzureAppSync && (!addOffice365.azureADAppSyncFailure || addOffice365.isAzureAppAuthorized)) && addOffice365.isAzureAppSynced ? 'k-icon k-i-check green-font' : (!addOffice365.startAzureAppSync ? 'k-icon k-i-clock' : 'fa fa-spinner fa-spin')"></i>
														</div>
														<div data-ng-if="addOffice365.azureADAppSyncFailure">
															<i class="k-icon k-i-info"></i>
														</div>
													</td>
												</tr>
												<!-- Sync Azure AD App --End -->

												<!-- Authorize Azure AD App --Start -->
												<tr>
													<td class="restore-help-text ">
														<div data-ng-if="!addOffice365.isAzureAppAuthorized">
															<cv:msg key="label.appPermissions" bundle="exchange" />
														</div>
														<div data-ng-if="addOffice365.isAzureAppAuthorized">
															<cv:msg key="label.permissionsGranted" bundle="exchange" />
														</div>
													</td>
													<td class="text-align-center">
														<div
															data-ng-if="!addOffice365.isAzureAppSynced && !addOffice365.isAzureAppAuthorized && !addOffice365.azureADAppSyncFailure">
															<i class="k-icon k-i-clock"></i>
														</div>
														<div
															data-ng-if="addOffice365.isAzureAppSynced && addOffice365.isAzureAppAuthorized && !addOffice365.azureADAppSyncFailure">
															<i class="k-icon k-i-check green-font"></i>
														</div>
														<div data-ng-if="addOffice365.azureADAppSyncFailure">
															<button id="createOffice365App_button_#1670" class="btn btn-link btn-xs"
																type="button"
																data-ng-click="addOffice365.authenticateAzureADApp()">
																<cv:msg key="label.authorizeApp" bundle="exchange" />
															</button>
														</div>
														<div data-ng-if="addOffice365.isAzureAppSynced && !addOffice365.isAzureAppAuthorized">
															<button id="createOffice365App_button_#1691" class="btn btn-link btn-xs"
																type="button"
																data-ng-click="addOffice365.authenticateAzureADApp()">
																<cv:msg key="label.authorizeApp" bundle="exchange" />
															</button>
														</div>
													</td>
												</tr>
												<!-- Authorize Azure AD App --End -->

												<!-- sharepoint app create principle start -->
												<tr data-ng-if="addOffice365.office365Attributes.generalAttributes.sharepointOnline">
													<td class="restore-help-text ">
														<div data-ng-if="!addOffice365.isAzureAppPrincipleCreated">
															<cv:msg key="label.appPrncpl.appPriciple" bundle="office365" />
														</div>
														<div data-ng-if="addOffice365.isAzureAppPrincipleCreated">
															<cv:msg key="label.appPrncpl.appPricipleCreated" bundle="office365" />
														</div>
													</td>
													<td class="text-align-center">
														<div data-ng-if="!addOffice365.isAzureAppAuthorized && !addOffice365.isAzureAppPrincipleCreated">
															<i class="k-icon k-i-clock"></i>
														</div>
														<div data-ng-if="addOffice365.isAzureAppAuthorized && addOffice365.isAzureAppPrincipleCreated">
															<i class="k-icon k-i-check green-font"></i>
														</div>
														<div data-ng-if="addOffice365.isAzureAppAuthorized && !addOffice365.isAzureAppPrincipleCreated">
															<button id="createOffice365App_button_#9024" class="btn btn-link btn-xs"
																type="button"
																data-ng-click="addOffice365.sharepointAppPriniciple()">
																<cv:msg key="label.appPrncpl.createAppPriciple" bundle="office365" />
															</button>
														</div>
													</td>
												</tr>
												<!-- sharepoint app create principle end -->
											</tbody>
										</table>
									</div>
								</div>
								<div class="form-group">
									<div class="margin-top-10 col-xs-12 col-md-12">
										<div class="help-block" data-ng-show="addOffice365Form.$submitted"
										data-ng-if="(addOffice365.selectedOffice365Mode === addOffice365.EXCHANGE_ONLINE || addOffice365.selectedOffice365Mode === addOffice365.SHAREPOINT_ONLINE) && addOffice365.exchangeServiceAccountFailed && addOffice365.office365Attributes.generalAttributes.isGlobalLogin">
											<cv:msg key="dialog.header.serviceaccount.title" bundle="office365" />
										</div>
									</div>
								</div>
							</div>
							<!-- Azure AD App Details --Global Admin--End-->
						</div>
					</div>
					<span class="text-danger incomplete" data-ng-if="addOffice365.clientCreationFailed" ng-bind="addOffice365.clientCreationError"></span>
					<!-- Buttons -->
					<div class="button-container padding-0">
						<button id="createOffice365App_button_#7924" type="submit" 
							class="btn btn-primary margin-right-0 cvBusyOnAjax"
							data-ng-disabled="addOffice365.processingRequest || addOffice365.azureAppCreationInProgress">
							<cv:msg key="label.client.create" bundle="office365" />
							<i data-ng-if="addOffice365.processingRequest"
								class="fa fa-spinner fa-spin"></i>
						</button>
					</div>
				</div>
				<!-- To help include getting started dropdown and view for new agents -->
				<div data-ng-controller="createOffice365AppController as addOffice365App">
					<ng-include src="addOffice365.addNewAgentsTemplate" ng-if="addOffice365.isSetup && !addOffice365.loadOldAgents" ></ng-include>
				</div>
				<!-- Buttons -->
			</form>
		</div>
	</div>
	<script src="${pageContext.request.contextPath}/common/js/encoder.js"></script>
</div>
