<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.search"></cv:cvMessages>
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.office365"></cv:cvMessages>
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
</script>

<div class="cvSearchFilter">
	<div class="cvSearchFilter-icon">
		<i class="fa fa-search" aria-hidden="true"></i>
	</div>
	<input
		class="searchTerm"
		type="text"
		spellcheck="false"
		placeholder='<cv:msg key="label.search" bundle="search" />'
		data-ng-model="$ctrl.searchTerm"
		ng-keypress="$event.keyCode === 13 ? $ctrl.searchFilter() : null"
	/>
	<a
		class="cvSearchFilter-icon animated-toggle button"
		data-ng-click="$ctrl.toggleFilter()"
		data-ng-class="$ctrl.showFilters ? 'active morphed': ''"
	>
		<i class="fa fa-filter toggle-icon" aria-hidden="true"></i>
		<i class="k-icon k-i-saturation toggle-icon" aria-hidden="true"></i>
	</a>
	<a
		class="cvSearchFilter-icon button"
		data-ng-click="$ctrl.reset()"
		data-ng-show="$ctrl.showClearSearchBtn"
		data-title='<cv:msg key="label.clearSearch" bundle="office365" />'
	>
		<i class="fa fa-times fa-lg text-danger" aria-hidden="true"></i>
	</a>

	<form
		id="cvSearchFilterForm"
		name="cvSearchFilterForm"
		data-cv-submit="$ctrl.searchFilter()"
		class="bootstrap-wrapper padding-bottom-0 cvSearchFilter-form"
		data-ng-show="$ctrl.showFilters"
		novalidate
	>
		<div class="cvSearchFilter-overlay" data-ng-click="$ctrl.closeFilter()"></div>
		<div class="col-md-12 margin-top-10 margin-bottom-10" data-ng-if="$ctrl.exchangeOnline">
			<div class="row">
				<div class="cvSearchFilter-label col-md-3">
					<i class="icon fa fa-user" aria-hidden="true"></i>
					<cv:msg key="label.from" bundle="search" />
				</div>
				<div class="col-md-9">
					<input
						type="text"
						placeholder='<cv:msg key="label.from" bundle="search" />'
						data-ng-model="$ctrl.exchangeFilters.from"
						data-ng-change="$ctrl.formatSearchTerm()"
					/>
				</div>
			</div>
			<div class="row">
				<div class="cvSearchFilter-label col-md-3">
					<i class="icon fa fa-user" aria-hidden="true"></i>
					<cv:msg key="label.to" bundle="search" />
				</div>
				<div class="col-md-9">
					<input
						type="text"
						placeholder='<cv:msg key="label.to" bundle="search" />'
						data-ng-model="$ctrl.exchangeFilters.to"
						data-ng-change="$ctrl.formatSearchTerm()"
					/>
				</div>
			</div>
			<div class="row">
				<div class="cvSearchFilter-label col-md-3">
					<i class="icon fa fa-pencil-square" aria-hidden="true"></i>
					<cv:msg key="label.subject" bundle="search" />
				</div>
				<div class="col-md-9">
					<input
						type="text"
						placeholder='<cv:msg key="label.subject" bundle="search" />'
						data-ng-model="$ctrl.exchangeFilters.subject"
						data-ng-change="$ctrl.formatSearchTerm()"
					/>
				</div>
			</div>
			<div class="row">
				<div class="cvSearchFilter-label col-md-3">
					<i class="icon fa fa-archive" aria-hidden="true"></i>
					<cv:msg key="label.mailbox" bundle="exchange" />
				</div>
				<div class="col-md-9">
					<input
						type="text"
						placeholder='<cv:msg key="label.mailbox" bundle="exchange" />'
						data-ng-model="$ctrl.exchangeFilters.mailbox"
						data-ng-change="$ctrl.formatSearchTerm()"
					/>
				</div>
			</div>
			<div class="row">
				<div class="cvSearchFilter-label col-md-3">
					<i class="icon fa fa-plus-circle" aria-hidden="true"></i>
					<cv:msg key="label.contains" bundle="search" />
				</div>
				<div class="col-md-9">
					<input
						type="text"
						placeholder='<cv:msg key="label.contains" bundle="search" />'
						data-ng-model="$ctrl.commonFilters.contains"
						data-ng-change="$ctrl.formatSearchTerm()"
					/>
				</div>
			</div>
		</div>
		<div class="cvSearchFilter-advanced plain-accordion" data-ng-if="$ctrl.exchangeOnline">
			<cv-plain-accordion
				accordion-label='<cv:msg key="label.advancedOptions" bundle="exchange" />'
				collapsed="$ctrl.collapseExchangeAdvancedOptions"
			>
				<div class="col-md-12">
					<div class="row">
						<div class="cvSearchFilter-label col-md-3">
							<i class="icon fa fa-folder" aria-hidden="true"></i>
							<cv:msg key="label.folder" bundle="search" />
						</div>
						<div class="col-md-9">
							<input
								type="text"
								placeholder='<cv:msg key="label.folder" bundle="search" />'
								data-ng-model="$ctrl.commonFilters.folder"
								data-ng-change="$ctrl.formatSearchTerm()"
							/>
						</div>
					</div>
					<div class="row">
						<div class="cvSearchFilter-label col-md-3">
							<i class="icon fa fa-envelope" aria-hidden="true"></i>
							<cv:msg key="label.mailSize" bundle="search" />
						</div>
						<div class="col-md-9">
							<isteven-multi-select
								class="cvSearchFilter-isteven"
								input-model="$ctrl.sizeLimits"
								output-model="$ctrl.selectedSizeLimit"
								button-label="sizeLimit"
								item-label="sizeLimit"
								selection-mode="single"
								max-labels="1"
								on-item-click="$ctrl.processSizeLimitSelection()"
								tick-property="selected"
								translation="$ctrl.localLang"
								prevent-sort="true"
							></isteven-multi-select>
							<input
								class="cvSearchFilter-inlineInput"
								type="number"
								min="1"
								placeholder='<cv:msg key="label.mailSize" bundle="search" />'
								data-ng-model="$ctrl.commonFilters.size.sizeValue"
								data-ng-disabled="$ctrl.commonFilters.size.sizeLimit === 'ANY'"
								data-ng-change="$ctrl.formatSearchTerm()"
							/>
							<span data-ng-disabled="$ctrl.commonFilters.size.sizeLimit === 'ANY'">
								<isteven-multi-select
									class="cvSearchFilter-isteven"
									input-model="$ctrl.sizeUnits"
									output-model="$ctrl.selectedSizeUnit"
									button-label="sizeUnitLabel"
									item-label="sizeUnitLabel"
									selection-mode="single"
									max-labels="1"
									on-item-click="$ctrl.processSizeUnitSelection()"
									tick-property="selected"
									translation="$ctrl.localLang"
									prevent-sort="true"
								></isteven-multi-select>
							</span>
						</div>
					</div>
					<div class="row">
						<div class="cvSearchFilter-label col-md-3">
							<i class="icon fa fa-calendar" aria-hidden="true"></i>
							<cv:msg key="label.received" bundle="search" />
						</div>
						<div class="col-md-9 margin-top-5 cvSearchFilter-selectTime">
							<isteven-multi-select
								input-model="$ctrl.timeOptions"
								output-model="$ctrl.selectedTimeOption"
								button-label="timeOptionLabel"
								item-label="timeOptionLabel"
								selection-mode="single"
								max-labels="1"
								on-item-click="$ctrl.processTimeOptionChange()"
								tick-property="selected"
								translation="$ctrl.localLang"
								prevent-sort="true"
							></isteven-multi-select>
						</div>
					</div>
					<div class="margin-top-5" data-ng-if="$ctrl.showDateRangeInputs">
						<div class="row">
							<div class="cvSearchFilter-label col-md-3">
								<i class="icon fa fa-calendar" aria-hidden="true"></i>
								<cv:msg key="label.from" bundle="search" />
							</div>
							<div class="col-md-9 cvSearchFilter-date form-group">
								<div class="calendar-wrapper date-picker">
									<input
										type="text"
										data-ng-change="$ctrl.onFromDateChanged()"
										class="date-box cursor-pointer"
										data-datetime-picker="MM/dd/yyyy"
										placeholder='<cv:msg key="label.clickToSelectADate" bundle="search" />'
										data-ng-model="$ctrl.commonFilters.time.dateRange.from"
										data-datepicker-options="$ctrl.fromDateOptions"
										data-is-open="$ctrl.isFromTimeDatePickerOpen"
										data-ng-click="$ctrl.isFromTimeDatePickerOpen = true"
										data-enable-time="false"
										readonly
									/>
								</div>
							</div>
						</div>
						<div class="row">
							<div class="cvSearchFilter-label col-md-3">
								<i class="icon fa fa-calendar" aria-hidden="true"></i>
								<cv:msg key="label.to" bundle="search" />
							</div>
							<div class="col-md-9 cvSearchFilter-date form-group">
								<div class="calendar-wrapper date-picker">
									<input
										type="text"
										data-ng-change="$ctrl.onToDateChanged()"
										class="date-box cursor-pointer"
										data-datetime-picker="MM/dd/yyyy"
										placeholder='<cv:msg key="label.clickToSelectADate" bundle="search" />'
										data-ng-model="$ctrl.commonFilters.time.dateRange.to"
										data-datepicker-options="$ctrl.toDateOptions"
										data-is-open="$ctrl.isToTimeDatePickerOpen"
										data-ng-click="$ctrl.isToTimeDatePickerOpen = true"
										data-enable-time="false"
										readonly
									/>
								</div>
							</div>
						</div>
					</div>
					<div class="row margin-top-15">
						<div class="col-md-12">
							<input
								type="checkbox"
								id="hasAttachment"
								data-ng-model="$ctrl.exchangeFilters.hasAttachment"
								data-ng-change="$ctrl.formatSearchTerm()"
							/>
							<label class="cvSearchFilter-label" for="hasAttachment">
								<cv:msg key="label.hasAttachment" bundle="search" />
							</label>
						</div>
					</div>
				</div>
			</cv-plain-accordion>
		</div>
		<div class="col-md-12 margin-top-10" data-ng-if="$ctrl.sharePointOnline || $ctrl.oneDriveForBusiness || $ctrl.isCloudAppV2">
			<div class="row">
				<div class="cvSearchFilter-label col-md-3">
					<i class="icon fa fa-dot-circle-o" aria-hidden="true"></i>
					<cv:msg key="browse.facet.type" bundle="office365" />
				</div>
				<div class="col-md-9 margin-top-5 {{$ctrl.searchTypeCustomClass}}">
					<isteven-multi-select
						input-model="$ctrl.searchTypes"
						output-model="$ctrl.selectedSearchType"
						button-label="searchType"
						item-label="searchType"
						selection-mode="single"
						max-labels="1"
						html-template="true"
						on-item-click="$ctrl.processSearchTypeChange()"
						tick-property="selected"
						translation="$ctrl.localLang"
						prevent-sort="true"
					></isteven-multi-select>
					<div class="margin-top-5" data-ng-if="$ctrl.showFileExtensionInput">
						<div class="row">
							<div class="col-md-12">
								<input
									type="text"
									id="customFileExtension"
									name="customFileExtension"
									placeholder='<cv:msg key="browse.facet.fileExtension" bundle="office365" />'
									data-ng-model="$ctrl.commonFilters.customFileExtension"
									data-ng-change="$ctrl.formatSearchTerm()"
									required
								/>
								<div class="small red-font margin-left-5"
									data-ng-show="cv.cvSearchFilterForm.needsAttention(cvSearchFilterForm.customFileExtension)">
									<cv:msg key="error.valid.fileExtension" bundle="office365" />
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="row">
				<div class="cvSearchFilter-label col-md-3">
					<i class="icon fa fa-pencil" aria-hidden="true"></i>
					<cv:msg key="browse.facet.itemName" bundle="office365" />
				</div>
				<div class="col-md-9">
					<input
						type="text"
						placeholder='<cv:msg key="browse.facet.itemName" bundle="office365" />'
						data-ng-model="$ctrl.commonFilters.itemName"
						data-ng-change="$ctrl.formatSearchTerm()"
					/>
				</div>
			</div>
		</div>
		<div class="col-md-12" data-ng-if="$ctrl.oneDriveForBusiness">
			<div class="row">
				<div class="cvSearchFilter-label col-md-3">
					<i class="icon fa fa-user" aria-hidden="true"></i>
					<cv:msg key="browse.facet.custodian" bundle="office365" />
				</div>
				<div class="col-md-9 margin-top-5">
					<isteven-multi-select
						input-model="$ctrl.userNameOptions"
						output-model="$ctrl.selectedUserNameOption"
						button-label="userNameOption"
						item-label="userNameOption"
						selection-mode="single"
						max-labels="1"
						on-item-click="$ctrl.processUserNameOptionChange()"
						tick-property="selected"
						translation="$ctrl.localLang"
						prevent-sort="true"
					></isteven-multi-select>
					<div class="margin-top-5" data-ng-if="$ctrl.showUserNameInput">
						<div class="row">
							<div class="col-md-12">
								<input
									type="email"
									id="customUserName"
									name="customUserName"
									data-ng-pattern='$ctrl.REGEX.EMAIL'
									placeholder='<cv:msg key="label.emailAddressPlaceholder" bundle="exchange" />'
									data-ng-model="$ctrl.commonFilters.customUserName"
									data-ng-change="$ctrl.formatSearchTerm()"
									required
								/>
								<div class="small red-font margin-left-5"
									data-ng-show="cv.cvSearchFilterForm.needsAttention(cvSearchFilterForm.customUserName)">
									<cv:msg key="error.invalidSMTPAddress" bundle="exchange" />
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="row">
				<div class="cvSearchFilter-label col-md-3">
					<i class="icon fa fa-folder" aria-hidden="true"></i>
					<cv:msg key="browse.facet.location" bundle="office365" />
				</div>
				<div class="col-md-9 margin-top-5">
					<isteven-multi-select
						input-model="$ctrl.locationOptions"
						output-model="$ctrl.selectedLocationOption"
						button-label="locationOption"
						item-label="locationOption"
						selection-mode="single"
						max-labels="1"
						on-item-click="$ctrl.processLocationOptionChange()"
						tick-property="selected"
						translation="$ctrl.localLang"
						prevent-sort="true"
					></isteven-multi-select>
					<div class="margin-top-5" data-ng-if="$ctrl.showLocationInput">
						<div class="row">
							<div class="col-md-12">
								<input
									type="text"
									id="customLocation"
									name="customLocation"
									placeholder={{$ctrl.locationInputPlaceHolder}}
									data-ng-model="$ctrl.commonFilters.customLocation"
									data-ng-change="$ctrl.formatSearchTerm()"
									required
								/>
								<div class="small red-font margin-left-5"
									data-ng-show="cv.cvSearchFilterForm.needsAttention(cvSearchFilterForm.customLocation)">
									<cv:msg key="error.valid.location" bundle="office365" />
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="col-md-12 margin-bottom-10" data-ng-if="$ctrl.sharePointOnline || $ctrl.oneDriveForBusiness || $ctrl.isCloudAppV2">
			<div class="row">
				<div class="cvSearchFilter-label col-md-3">
					<i class="icon fa fa-calendar" aria-hidden="true"></i>
					<cv:msg key="label.modified" bundle="search" />
				</div>
				<div class="col-md-9 margin-top-5 cvSearchFilter-selectTime">
					<isteven-multi-select
						input-model="$ctrl.timeOptions"
						output-model="$ctrl.selectedTimeOption"
						button-label="timeOptionLabel"
						item-label="timeOptionLabel"
						selection-mode="single"
						max-labels="1"
						on-item-click="$ctrl.processTimeOptionChange()"
						tick-property="selected"
						translation="$ctrl.localLang"
						prevent-sort="true"
					></isteven-multi-select>
				</div>
			</div>
			<div class="margin-top-5" data-ng-if="$ctrl.showDateRangeInputs">
				<div class="row">
					<div class="cvSearchFilter-label col-md-3">
						<i class="icon fa fa-calendar" aria-hidden="true"></i>
						<cv:msg key="label.from" bundle="search" />
					</div>
					<div class="col-md-9 cvSearchFilter-date form-group">
						<div class="calendar-wrapper date-picker">
							<input
								type="text"
								data-ng-change="$ctrl.onFromDateChanged()"
								class="date-box cursor-pointer"
								data-datetime-picker="MM/dd/yyyy"
								placeholder='<cv:msg key="label.clickToSelectADate" bundle="search" />'
								data-ng-model="$ctrl.commonFilters.time.dateRange.from"
								data-datepicker-options="$ctrl.fromDateOptions"
								data-is-open="$ctrl.isFromTimeDatePickerOpen"
								data-ng-click="$ctrl.isFromTimeDatePickerOpen = true"
								data-enable-time="false"
								readonly
							/>
						</div>
					</div>
				</div>
				<div class="row">
					<div class="cvSearchFilter-label col-md-3">
						<i class="icon fa fa-calendar" aria-hidden="true"></i>
						<cv:msg key="label.to" bundle="search" />
					</div>
					<div class="col-md-9 cvSearchFilter-date form-group">
						<div class="calendar-wrapper date-picker">
							<input
								type="text"
								data-ng-change="$ctrl.onToDateChanged()"
								class="date-box cursor-pointer"
								data-datetime-picker="MM/dd/yyyy"
								placeholder='<cv:msg key="label.clickToSelectADate" bundle="search" />'
								data-ng-model="$ctrl.commonFilters.time.dateRange.to"
								data-datepicker-options="$ctrl.toDateOptions"
								data-is-open="$ctrl.isToTimeDatePickerOpen"
								data-ng-click="$ctrl.isToTimeDatePickerOpen = true"
								data-enable-time="false"
								readonly
							/>
						</div>
					</div>
				</div>
			</div>
			<div class="row">
				<div class="cvSearchFilter-label col-md-3">
					<i class="icon fa fa-file" aria-hidden="true"></i>
					<cv:msg key="label.header.size" bundle="messages" />
				</div>
				<div class="col-md-9">
					<isteven-multi-select
						class="cvSearchFilter-isteven"
						input-model="$ctrl.sizeLimits"
						output-model="$ctrl.selectedSizeLimit"
						button-label="sizeLimit"
						item-label="sizeLimit"
						selection-mode="single"
						max-labels="1"
						on-item-click="$ctrl.processSizeLimitSelection()"
						tick-property="selected"
						translation="$ctrl.localLang"
						prevent-sort="true"
					></isteven-multi-select>
					<input
						class="cvSearchFilter-inlineInput"
						type="number"
						min="1"
						placeholder='<cv:msg key="label.header.size" bundle="messages" />'
						data-ng-model="$ctrl.commonFilters.size.sizeValue"
						data-ng-disabled="$ctrl.commonFilters.size.sizeLimit === 'ANY'"
						data-ng-change="$ctrl.formatSearchTerm()"
					/>
					<span data-ng-disabled="$ctrl.commonFilters.size.sizeLimit === 'ANY'">
						<isteven-multi-select
							class="cvSearchFilter-isteven"
							input-model="$ctrl.sizeUnits"
							output-model="$ctrl.selectedSizeUnit"
							button-label="sizeUnit"
							item-label="sizeUnit"
							selection-mode="single"
							max-labels="1"
							on-item-click="$ctrl.processSizeUnitSelection()"
							tick-property="selected"
							translation="$ctrl.localLang"
							prevent-sort="true"
						 ></isteven-multi-select>
					</span>
				</div>
			</div>
		</div>

		<!-- <div class="col-md-12 margin-top-10" data-ng-if="$ctrl.isCloudAppV2">
			<div class="row">
				<div class="cvSearchFilter-label col-md-3">
					<i class="icon fa fa-dot-circle-o" aria-hidden="true"></i>
					<cv:msg key="browse.facet.itemType" bundle="office365" />
				</div>
				<div class="col-md-9 margin-top-5">
					<isteven-multi-select
						input-model="$ctrl.searchTypes"
						output-model="$ctrl.selectedSearchType"
						button-label="searchType"
						item-label="searchType"
						selection-mode="single"
						max-labels="1"
						html-template="true"
						on-item-click="$ctrl.processSearchTypeChange()"
						tick-property="selected"
						translation="$ctrl.localLang"
						prevent-sort="true"
					></isteven-multi-select>
				</div>
			</div>
			<div class="row">
				<div class="cvSearchFilter-label col-md-3">
					<i class="icon fa fa-pencil" aria-hidden="true"></i>
					<cv:msg key="browse.facet.itemName" bundle="office365" />
				</div>
				<div class="col-md-9">
					<input
						type="text"
						placeholder='<cv:msg key="browse.facet.itemName" bundle="office365" />'
						data-ng-model="$ctrl.commonFilters.itemName"
						data-ng-change="$ctrl.formatSearchTerm()"
					/>
				</div>
			</div>
			<div class="row">
				<div class="cvSearchFilter-label col-md-3">
					<i class="icon fa fa-calendar" aria-hidden="true"></i>
					<cv:msg key="label.modified" bundle="search" />
				</div>
				<div class="col-md-9 margin-top-5 cvSearchFilter-selectTime">
					<isteven-multi-select
						input-model="$ctrl.timeOptions"
						output-model="$ctrl.selectedTimeOption"
						button-label="timeOptionLabel"
						item-label="timeOptionLabel"
						selection-mode="single"
						max-labels="1"
						on-item-click="$ctrl.processTimeOptionChange()"
						tick-property="selected"
						translation="$ctrl.localLang"
						prevent-sort="true"
					></isteven-multi-select>
				</div>
			</div>
			<div class="margin-top-5" data-ng-if="$ctrl.showDateRangeInputs">
				<div class="row">
					<div class="cvSearchFilter-label col-md-3">
						<i class="icon fa fa-calendar" aria-hidden="true"></i>
						<cv:msg key="label.from" bundle="search" />
					</div>
					<div class="col-md-9 cvSearchFilter-date form-group">
						<div class="calendar-wrapper date-picker">
							<input
								type="text"
								data-ng-change="$ctrl.onFromDateChanged()"
								class="date-box cursor-pointer"
								data-datetime-picker="MM/dd/yyyy"
								placeholder='<cv:msg key="label.clickToSelectADate" bundle="search" />'
								data-ng-model="$ctrl.commonFilters.time.dateRange.from"
								data-datepicker-options="$ctrl.fromDateOptions"
								data-is-open="$ctrl.isFromTimeDatePickerOpen"
								data-ng-click="$ctrl.isFromTimeDatePickerOpen = true"
								data-enable-time="false"
								readonly
							/>
						</div>
					</div>
				</div>
				<div class="row">
					<div class="cvSearchFilter-label col-md-3">
						<i class="icon fa fa-calendar" aria-hidden="true"></i>
						<cv:msg key="label.to" bundle="search" />
					</div>
					<div class="col-md-9 cvSearchFilter-date form-group">
						<div class="calendar-wrapper date-picker">
							<input
								type="text"
								data-ng-change="$ctrl.onToDateChanged()"
								class="date-box cursor-pointer"
								data-datetime-picker="MM/dd/yyyy"
								placeholder='<cv:msg key="label.clickToSelectADate" bundle="search" />'
								data-ng-model="$ctrl.commonFilters.time.dateRange.to"
								data-datepicker-options="$ctrl.toDateOptions"
								data-is-open="$ctrl.isToTimeDatePickerOpen"
								data-ng-click="$ctrl.isToTimeDatePickerOpen = true"
								data-enable-time="false"
								readonly
							/>
						</div>
					</div>
				</div>
			</div>
			<div class="row">
				<div class="cvSearchFilter-label col-md-3">
					<i class="icon fa fa-file" aria-hidden="true"></i>
					<cv:msg key="label.header.size" bundle="messages" />
				</div>
				<div class="col-md-9">
					<isteven-multi-select
						class="cvSearchFilter-isteven"
						input-model="$ctrl.sizeLimits"
						output-model="$ctrl.selectedSizeLimit"
						button-label="sizeLimit"
						item-label="sizeLimit"
						selection-mode="single"
						max-labels="1"
						on-item-click="$ctrl.processSizeLimitSelection()"
						tick-property="selected"
						translation="$ctrl.localLang"
						prevent-sort="true"
					></isteven-multi-select>
					<input
						class="cvSearchFilter-inlineInput"
						type="number"
						min="1"
						placeholder='<cv:msg key="label.header.size" bundle="messages" />'
						data-ng-model="$ctrl.commonFilters.size.sizeValue"
						data-ng-disabled="$ctrl.commonFilters.size.sizeLimit === 'ANY'"
						data-ng-change="$ctrl.formatSearchTerm()"
					/>
					<span data-ng-disabled="$ctrl.commonFilters.size.sizeLimit === 'ANY'">
						<isteven-multi-select
							class="cvSearchFilter-isteven"
							input-model="$ctrl.sizeUnits"
							output-model="$ctrl.selectedSizeUnit"
							button-label="sizeUnit"
							item-label="sizeUnit"
							selection-mode="single"
							max-labels="1"
							on-item-click="$ctrl.processSizeUnitSelection()"
							tick-property="selected"
							translation="$ctrl.localLang"
							prevent-sort="true"
						 ></isteven-multi-select>
					</span>
				</div>
			</div>
		</div> -->
		
		<div class="col-md-12">
			<div class="cvSearchFilter-buttons">
				<a id="reset" class="reset" data-ng-click="$ctrl.reset()">
					<cv:msg key="label.reset" bundle="messages" />
				</a>
				<button id="submit" class="submit btn-primary cvBusyOnAjax"  data-ng-class="{'busy':loading}" type="submit">
					<cv:msg key="label.search" bundle="messages" />
				</button>
			</div>
		</div>
	</form>
</div>
