<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.office365"></cv:cvMessages>
</script>

<div class="onboarding-walkthrough-view">
	<div class='onboarding-walkthrough onboarding-walkthrough-show onboarding-walkthrough-reveal'>
		
		<div class="onboarding-walkthrough-close">
			<i data-ng-click="$ctrl.onClickClose()"class="close-icon k-icon k-i-close"></i>
		</div>

		<div class='onboarding-walkthrough-body'>
			<div class='screens animate'>
				<div ng-repeat="screen in $ctrl.onboardingStepsList">
					<div class='screen' data-ng-class="screen.active ? 'active' : '' ">
						<div class='media logo' data-ng-if='$first'>
							<img class='logo' src="{{screen.icon}}">
						</div>
						<h3>{{screen.heading}}</h3>
						<p>{{screen.details}}</p>
					</div>
				</div>
			</div>

			<button class='prev-screen' 
				data-ng-disabled="$ctrl.onboardingScreenIndex === 0" 
				data-ng-click="$ctrl.previousScreen()">
				<i class='k-icon k-i-arrow-chevron-left margin-right-10'></i>
			</button>
			<button class='next-screen' 
				data-ng-disabled="$ctrl.onboardingScreenIndex === $ctrl.onboardingStepsList.length - 1" 
				data-ng-click="$ctrl.nextScreen()">
				<i class='k-icon k-i-arrow-chevron-right margin-left-10'></i>
			</button>
		</div>

		<div class='onboarding-walkthrough-pagination'>
			<a class='dot' ng-repeat="item in $ctrl.onboardingStepsList" data-ng-class="item.active ? 'active' : '' "></a>
		</div>
		
		<div class='onboarding-walkthrough-footer'>
			<button class='button next-screen'
				data-ng-disabled="$ctrl.onboardingScreenIndex === $ctrl.onboardingStepsList.length - 1"
				data-ng-click="$ctrl.nextScreen()"><cv:msg key="onboarding.step.next" bundle="office365" />
			</button>			
			<button class='button finish'
				data-ng-disabled="$ctrl.onboardingScreenIndex !== $ctrl.onboardingStepsList.length - 1"
				data-ng-class="($ctrl.onboardingScreenIndex === $ctrl.onboardingStepsList.length - 1) ? 'active' : '' "
				data-ng-click="$ctrl.onClickClose()"><cv:msg key="onboarding.step.finish" bundle="office365" />
			</button>
		</div>
	</div>
</div>