<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
    <cv:cvMessages bundle="localization.office365"></cv:cvMessages>
        <cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
            <cv:cvMessages bundle="localization.job"></cv:cvMessages>
                <cv:cvMessages bundle="localization.fs"></cv:cvMessages>
</script>

<div class="row">
    <div class="col-md-6">

        <cv-entity-status data="office365OverviewCtrl.appStatusInfo"
            data-title='<cv:msg key="overview.stats" bundle="office365" />'></cv-entity-status>

        <cv-tile-component data-title='<cv:msg key="overview.summary" bundle="office365" />'' loader="office365OverviewCtrl.showSummary">
            <ul class="list-style__row group">

                <li class="group">
                    <span class="pageDetailColumn">
                        <cv:msg key="label.lastBackup" bundle="fs" /></span>
                    <span class="pageDetailColumn">
                        <span data-ng-if="office365OverviewCtrl.hasLastBackupJobTime"
                            data-ng-bind="office365OverviewCtrl.formattedBackuptime">
                        </span>
                        <!--Pending changes-->
                        <%-- <cv-call-out html-template="office365OverviewCtrl.lastBackupCallout"></cv-call-out> --%>
                    </span>
                    <span data-ng-if="!office365OverviewCtrl.hasLastBackupJobTime" class="pageDetailColumn italic">
                        <cv:msg key="label.neverBackedUp" bundle="serversJs" />
                    </span>
                </li>

                <!--Action Log Replay-->
                <li class="group" data-ng-if="office365OverviewCtrl.hasActionLogReplayStats">
                    <span class="pageDetailColumn">
                        <cv:msg key="overview.lastActionLogReplay" bundle="office365" /> </span>
                    <span class="pageDetailColumn" data-ng-class="{'italic': !office365OverviewCtrl.hasLastActionLogReplayTime}"
                        data-ng-bind="office365OverviewCtrl.formattedLastActionLogReplayTime"></span>
                </li>
                <!--Action Log Replay-->

                <!--Last Discovery-->
                <li class="group" data-ng-if="office365OverviewCtrl.hasDiscoveryStats">
                    <span class="pageDetailColumn">
                        <cv:msg key="overview.lastDiscovery" bundle="office365" /> </span>
                    <span class="pageDetailColumn" data-ng-class="{'italic': !office365OverviewCtrl.hasLastDiscoveryTime}"
                        data-ng-bind="office365OverviewCtrl.formattedLastDiscoveryTime"></span>
                </li>
                <!--Last Discovery-->

                <!--Last True up-->
                <li class="group" data-ng-if="office365OverviewCtrl.hasTrueUpStats">
                    <span class="pageDetailColumn">
                        <cv:msg key="overview.lastTrueUpLast" bundle="office365" /> </span>
                    <span class="pageDetailColumn" data-ng-class="{'italic': !office365OverviewCtrl.hasLastTrueUpTime}"
                        data-ng-bind="office365OverviewCtrl.formattedLastTrueUpTime"></span>
                </li>
                <!--Last True up-->

                <!--Index Collection Time-->
                <li class="group" data-ng-if="office365OverviewCtrl.hasIndexCollectionStats">
                    <span class="pageDetailColumn">
                        <cv:msg key="label.indexCollectionTime" bundle="exchange" /> </span>
                    <span class="pageDetailColumn" data-ng-class="{'italic': !office365OverviewCtrl.hasIndexCollectionTime}"
                        data-ng-bind="office365OverviewCtrl.formattedIndexCollectionTime"></span>
                </li>
                <!--Index Collection Time-->
            </ul>
        </cv-tile-component>
        <!--Summary--END-->

        <!--Alerts-->
         <cv-tile-component data-ng-if="office365OverviewCtrl.showOffice365Alerts" 
            data-title='<cv:msg key="overview.alerts" bundle="office365" />'' loader="office365OverviewCtrl.showOffice365Alerts">
            <ul class="list-style__row group">
                <!--Last Discovery-->
                <li class="group">
                    <span class="pageDetailColumn">
                        <cv:msg key="overview.alerts" bundle="office365" /> </span>
                    <span class="pageDetailColumn"
                        data-ng-bind="office365OverviewCtrl.formattedBackuptime"></span>
                </li>
                <!--Last Discovery-->
            </ul>
        </cv-tile-component>
        <!--Alerts-->
    </div>

    <!--Calender view--START-->
    <div class="col-md-6" data-ng-if="!office365OverviewCtrl.isExchangeApp && !office365OverviewCtrl.isSharepointV1">
        <cv-backup-history entity="office365OverviewCtrl.backupEntity" show-legend="' true'"
            params="office365OverviewCtrl.historyParams"
            on-restore="office365OverviewCtrl.performRestore(job, fromTimeStr, toTimeStr)"
            data-ng-if="office365OverviewCtrl.backupEntity">
            </cv-backup-history>
    </div>
    <!--Calender view--END-->
</div>