<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
    <cv:cvMessages bundle="localization.office365"></cv:cvMessages>
    <cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
    <cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>
</script>

<script type="text/ng-template" id="customPopupTemplate.html">
	<a class="custodianSuggestText">
		<span ng-bind-html="match.label | uibTypeaheadHighlight:query" class="crop"></span> 
	</a>
 </script>

<form
	class="bootstrap-wrapper"
	data-cv-submit="office365CloudAppsRestoreOptionsCtrl._validateInputsForRestoreJob()"
	name="office365RestoreOptionsForm"
	id="office365RestoreOptionsForm"
	novalidate
	cv-hide-api
	autocomplete="off"
>
	<div class="modal-header">
		<h1><cv:msg key="label.restoreOpts" bundle="restore"/></h1>
	</div>
	<!--End --Modal Header-->
	<!--User fixed height-->
	<div class="modal-body no-padding">		
       
        <div class="form-group row margin-top-10 margin-left-5 margin-right-5">
            <label class="col-xs-12 col-md-4" for="restoreDestination"><cv:msg
                    key="label.restoreoptions.restoreRestination" bundle="office365" /></label>
			<div class="col-xs-12 col-md-8" data-ng-disabled="office365CloudAppsRestoreOptionsCtrl.disableRestoreDestination">
                <isteven-multi-select
                    id="restoreDestinationSummaryDropdown"
                    name="restoreDestinationSummaryDropdown"
                    class="isteven-multi-select user-group-select isteven-summary-dropdown"
                    html-template="true"
                    input-model="office365CloudAppsRestoreOptionsCtrl.restoreDestinationList"
                    output-model="office365CloudAppsRestoreOptionsCtrl.selectedRestoreDestination"
                    item-label="template"
                    selection-mode="single"
                    disable-property="disabled"
                    button-label="destination"
                    max-labels="1"
					prevent-sort="true"
                    helper-elements="filter"
                    tick-property="selected"           
                    on-item-click="office365CloudAppsRestoreOptionsCtrl.processRestoreDestinationSelectionChange()"
                    translation="office365CloudAppsRestoreOptionsCtrl.localLang ">
                </isteven-multi-select>             	               
            </div>
        </div>
		<cv-on-boarding-warning-msg backupset-id="office365CloudAppsRestoreOptionsCtrl.restoreOptions.entity.backupsetId" client-id="office365CloudAppsRestoreOptionsCtrl.sourceClientId" is-tile-view="false" extra-classes="'margin-right-20 margin-left-20'" data-ng-if="office365CloudAppsRestoreOptionsCtrl.appConsts.showOnBoardingMessage"></cv-on-boarding-warning-msg>
        
        <!--Restore to User Account/Site/Web/Server--START-->
        <div class="plain-accordion margin-top-10">
            <div class="cv-accordion-header">
                <span class="cv-accordion-text" data-ng-bind="office365CloudAppsRestoreOptionsCtrl.restoreAccountMachineLabel"></span>
                <span class="availableTime-timelabel margin-top-0"><i class="k-icon k-i-information margin-right-5"></i>
                    <label data-ng-bind="office365CloudAppsRestoreOptionsCtrl.restoreAccountMachineHelpText"></label>                   
                </span>
            </div>
        </div>
        
        <!--Machine Browse and Selection --START-->
        <!--Destination member server client--START-->
        <div class="margin-left-5 margin-right-5 padding-left-15 padding-right-15" data-ng-if="office365CloudAppsRestoreOptionsCtrl.restoreToFileLocation">
            <div class="form-group row margin-top-10">
                <label class="col-xs-12 col-md-4 margin-top-10" for="restoreDestination"><cv:msg
                        key="label.restoreoptions.destinationServer" bundle="office365" /></label>
                <div class="col-xs-12 col-md-8">                                         
                    <isteven-multi-select
                        id="office365AccessNodesDropdown"
                        name="office365AccessNodesDropdown"
                        class="isteven-multi-select user-group-select isteven-summary-dropdown"
                        input-model="office365CloudAppsRestoreOptionsCtrl.office365AccessNodesList"
                        output-model="office365CloudAppsRestoreOptionsCtrl.selectedoffice365AccessNodesList"
                        item-label="clientName"
                        selection-mode="single"
                        button-label="clientName"
                        max-labels="1"
						prevent-sort="true"
                        helper-elements="filter"
                        tick-property="selected"           
                        on-item-click="office365CloudAppsRestoreOptionsCtrl._processOneDriveAccessNodeSelectionChange()"
                        translation="office365CloudAppsRestoreOptionsCtrl.localLang ">
                    </isteven-multi-select>         	               
                </div>
            </div>

            <!--Machine Browse --START-->
            <div class="form-group row margin-top-10 margin-bottom-10">             
                <label class="col-xs-12 col-md-4 margin-top-10" for="restoreDestination"><cv:msg
                    key="label.restoreoptions.machinePath" bundle="office365" /></label>

                <div class="col-xs-12 col-md-8" data-ng-disabled="!office365CloudAppsRestoreOptionsCtrl._enableMachineBrowse()">                	                           
                    <div class="input-group">
                        <input type="text"
                            placeholder='<cv:msg key="placeholder.browse.destinationPath" bundle="office365" />' 
                            data-ng-model="office365CloudAppsRestoreOptionsCtrl.destinationMachinePath">
                        <span class="input-group-btn">
                            <button type="button" id="office365_machineBrowse_btn" class="icon-style cv-material-button browse" data-ng-click="office365CloudAppsRestoreOptionsCtrl._performMachineBrowseOperation()"> 
                                <div class="cv-material-button-icon cursor-pointer">
                                    <svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path d="M0 0h24v24H0z" fill="none"/><path d="M19 4H5c-1.11 0-2 .9-2 2v12c0 1.1.89 2 2 2h4v-2H5V8h14v10h-4v2h4c1.1 0 2-.9 2-2V6c0-1.1-.89-2-2-2zm-7 6l-4 4h3v6h2v-6h3l-4-4z"/></svg>
                                </div><div class="cv-material-button-tooltip"><cv:msg key="Browse" bundle="storage" /></div>
                            </button>
                        </span>
                    </div>                        
                </div>
            </div>

        </div>
        <!--Machine Browse --END-->
        <!--Destination member server client--END-->
        <!--Machine Browse and Selection --END-->

        <div data-ng-if="!office365CloudAppsRestoreOptionsCtrl.restoreToFileLocation" 
            class="margin-left-5 margin-right-5 padding-left-15 padding-right-15">
            <!-- Restore inplace --out-of-place options --START-->
            <div class="margin-top-10">              
                <cv-radio-group 
                    is-vertical="true" 
                    radio-model="office365CloudAppsRestoreOptionsCtrl.restoreToOriginalLocationRadioVal" 
                    radio-obj="office365CloudAppsRestoreOptionsCtrl.restoreLocationOptions" 
                    on-click="office365CloudAppsRestoreOptionsCtrl._restoreToOriginalLocationRadioValChange(data)">
                </cv-radio-group>
            </div>
            <!-- Restore inplace --out-of-place options --END-->

            <!--Microsoft Teams/Dynamics 365--START-->
            <!--Team selection/Instance Selection--START-->
            <div class="form-group row margin-top-10 margin-left-10" 
				data-ng-if="!office365CloudAppsRestoreOptionsCtrl.restoreToOriginalLocation && office365CloudAppsRestoreOptionsCtrl.restoreToCloudApp">             

                <label  class="col-xs-12 col-md-4" for="userAccountInput" data-ng-if="office365CloudAppsRestoreOptionsCtrl.isMSTeamsApp">
                    <svg class="margin-right-5" version="1.1" id="cv_cc" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
						viewBox="0 0 511.999 511.999" height="16px" width="16px" 
						style="enable-background:new 0 0 511.999 511.999;vertical-align:text-top;" xml:space="preserve">
					<g>
						<g>
							<path fill="#4D55BD" d="M438.09,273.32h-39.596c4.036,11.05,6.241,22.975,6.241,35.404v149.65c0,5.182-0.902,10.156-2.543,14.782h65.461
								c24.453,0,44.346-19.894,44.346-44.346v-81.581C512,306.476,478.844,273.32,438.09,273.32z"/>
						</g>
					</g>
					<g>
						<g>
							<path fill="#4D55BD" d="M107.265,308.725c0-12.43,2.205-24.354,6.241-35.404H73.91c-40.754,0-73.91,33.156-73.91,73.91v81.581
								c0,24.452,19.893,44.346,44.346,44.346h65.462c-1.641-4.628-2.543-9.601-2.543-14.783V308.725z"/>
						</g>
					</g>
					<g>
						<g>
							<path fill="#4D55BD" d="M301.261,234.815h-90.522c-40.754,0-73.91,33.156-73.91,73.91v149.65c0,8.163,6.618,14.782,14.782,14.782h208.778
								c8.164,0,14.782-6.618,14.782-14.782v-149.65C375.171,267.971,342.015,234.815,301.261,234.815z"/>
						</g>
					</g>
					<g>
						<g>
							<path fill="#4D55BD" d="M256,38.84c-49.012,0-88.886,39.874-88.886,88.887c0,33.245,18.349,62.28,45.447,77.524
								c12.853,7.23,27.671,11.362,43.439,11.362c15.768,0,30.586-4.132,43.439-11.362c27.099-15.244,45.447-44.28,45.447-77.524
								C344.886,78.715,305.012,38.84,256,38.84z"/>
						</g>
					</g>
					<g>
						<g>
							<path fill="#4D55BD" d="M99.918,121.689c-36.655,0-66.475,29.82-66.475,66.475c0,36.655,29.82,66.475,66.475,66.475
								c9.298,0,18.152-1.926,26.195-5.388c13.906-5.987,25.372-16.585,32.467-29.86c4.98-9.317,7.813-19.946,7.813-31.227
								C166.393,151.51,136.573,121.689,99.918,121.689z"/>
						</g>
					</g>
					<g>
						<g>
							<path fill="#4D55BD" d="M412.082,121.689c-36.655,0-66.475,29.82-66.475,66.475c0,11.282,2.833,21.911,7.813,31.227
								c7.095,13.276,18.561,23.874,32.467,29.86c8.043,3.462,16.897,5.388,26.195,5.388c36.655,0,66.475-29.82,66.475-66.475
								C478.557,151.509,448.737,121.689,412.082,121.689z"/>
						</g>
					</g>
				</svg>
                    <cv:msg key="label.destination.team" bundle="office365" />
                </label>
                
                <label  class="col-xs-12 col-md-4" for="userAccountInput" data-ng-if="!office365CloudAppsRestoreOptionsCtrl.isMSTeamsApp">
                    <svg
                        class="margin-right-5" xmlns="http://www.w3.org/2000/svg" height="16px" width="16px" style="vertical-align: text-top;" viewBox="0 0 40 40">
                        <path d="M13.5 17h15a.5.5 0 0 0 .5-.5v-15a.5.5 0 0 0-.5-.5h-15a.5.5 0 0 0-.5.5v15a.5.5 0 0 0 .5.5z" fill="#2980b9"/>
                        <path d="M13.5 18h15a1.5 1.5 0 0 0 1.5-1.5v-15A1.5 1.5 0 0 0 28.5 0h-15A1.5 1.5 0 0 0 12 1.5v15a1.5 1.5 0 0 0 1.5 1.5zM13 1.5a.5.5 0 0 1 .5-.5h15a.5.5 0 0 1 .5.5v15a.5.5 0 0 1-.5.5h-15a.5.5 0 0 1-.5-.5v-15z" fill="#0b2e44"/>
                        <path d="M16.5 23h-15a.5.5 0 0 0-.5.5v15a.5.5 0 0 0 .5.5h15a.5.5 0 0 0 .5-.5v-15a.5.5 0 0 0-.5-.5z" fill="#98b7d6"/>
                        <path d="M16.5 22h-15A1.5 1.5 0 0 0 0 23.5v15A1.5 1.5 0 0 0 1.5 40h15a1.5 1.5 0 0 0 1.5-1.5v-15a1.5 1.5 0 0 0-1.5-1.5zm.5 16.5a.5.5 0 0 1-.5.5h-15a.5.5 0 0 1-.5-.5v-15a.5.5 0 0 1 .5-.5h15a.5.5 0 0 1 .5.5v15z" fill="#0b2e44"/>
                        <path d="M38.5 23h-15a.5.5 0 0 0-.5.5v15a.5.5 0 0 0 .5.5h15a.5.5 0 0 0 .5-.5v-15a.5.5 0 0 0-.5-.5z" fill="#9fe0f6"/>
                        <path d="M38.5 22h-15a1.5 1.5 0 0 0-1.5 1.5v15a1.5 1.5 0 0 0 1.5 1.5h15a1.5 1.5 0 0 0 1.5-1.5v-15a1.5 1.5 0 0 0-1.5-1.5zm.5 16.5a.5.5 0 0 1-.5.5h-15a.5.5 0 0 1-.5-.5v-15a.5.5 0 0 1 .5-.5h15a.5.5 0 0 1 .5.5v15z" fill="#0b2e44"/>
                    </svg>
                    <cv:msg key="label.destination.instance" bundle="office365" />
                </label>  
                
                <div class="col-xs-12 col-md-8"> 
                    <div class="input-group">
                        <!--Changes Pending
                        <input type="text"
                            id="userAccountInput"
                            name="userAccountInput"
                            required
                            placeholder="{{office365CloudAppsRestoreOptionsCtrl.primaryDestinationPlaceholder}}" 
                            ng-change="office365CloudAppsRestoreOptionsCtrl.onUserEmailInputChange($viewValue)" 
                            ng-model="office365CloudAppsRestoreOptionsCtrl.selectedPrimaryDestinationEntity"
                            typeahead-template-url="customPopupTemplate.html"
                            uib-typeahead="userEmailList.email for userEmailList in office365CloudAppsRestoreOptionsCtrl.userEmailList | limitTo:10">
                            -->

                        <label class="italic" for="destinationPlaceholder" data-ng-if="!office365CloudAppsRestoreOptionsCtrl.isPrimaryDestinationSet"
                            data-ng-bind="office365CloudAppsRestoreOptionsCtrl.primaryDestinationPlaceholder">
                        </label>

                        <label class="font-weight-bold" for="destinationPlaceholder" data-ng-if="office365CloudAppsRestoreOptionsCtrl.isPrimaryDestinationSet"
                            data-ng-bind="office365CloudAppsRestoreOptionsCtrl.selectedPrimaryDestinationEntity">
                        </label>

                        <span class="input-group-btn">
                            <button type="button" id="primaryDestinationBrowseBtn" class="icon-style cv-material-button browse" data-ng-click="office365CloudAppsRestoreOptionsCtrl.performPrimaryDestinationBrowse()"> 
                                <div class="cv-material-button-icon cursor-pointer">
                                    <svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path d="M0 0h24v24H0z" fill="none"/><path d="M19 4H5c-1.11 0-2 .9-2 2v12c0 1.1.89 2 2 2h4v-2H5V8h14v10h-4v2h4c1.1 0 2-.9 2-2V6c0-1.1-.89-2-2-2zm-7 6l-4 4h3v6h2v-6h3l-4-4z"/></svg>
                                </div><div class="cv-material-button-tooltip"><cv:msg key="Browse" bundle="storage" /></div>
                            </button>
                        </span>   
                    </div>
                    <div class="help-block"
                        data-ng-show="office365RestoreOptionsForm.$submitted || (office365CloudAppsRestoreOptionsCtrl.subEntityBrowseAttempted && !office365CloudAppsRestoreOptionsCtrl.isPrimaryDestinationSet)"
                        data-ng-if="!office365CloudAppsRestoreOptionsCtrl.selectedPrimaryDestinationEntity.length">
                        <span data-ng-bind="office365CloudAppsRestoreOptionsCtrl.primaryDestinationError"></span>
                    </div>                 
                </div>
            </div>
            <!--Microsoft Teams/Dynamics 365--END-->

             <!--SubEntity selection/Instance Selection--START-->
            <div class="form-group row margin-top-10 margin-left-10" 
				data-ng-if="!office365CloudAppsRestoreOptionsCtrl.restoreToOriginalLocation && 
                    office365CloudAppsRestoreOptionsCtrl.restoreToCloudApp && 
                    office365CloudAppsRestoreOptionsCtrl.isMSTeamsApp && office365CloudAppsRestoreOptionsCtrl.isSubEntityBrowseApplicable">             

                <!--HelpText changes ..-->
                <label  class="col-xs-12 col-md-4" for="subEntityDestination">
                    <svg
                        class="margin-right-5" xmlns="http://www.w3.org/2000/svg" height="16px" width="16px" style="vertical-align: text-top;" viewBox="0 0 40 40">
                        <path d="M13.5 17h15a.5.5 0 0 0 .5-.5v-15a.5.5 0 0 0-.5-.5h-15a.5.5 0 0 0-.5.5v15a.5.5 0 0 0 .5.5z" fill="#2980b9"/>
                        <path d="M13.5 18h15a1.5 1.5 0 0 0 1.5-1.5v-15A1.5 1.5 0 0 0 28.5 0h-15A1.5 1.5 0 0 0 12 1.5v15a1.5 1.5 0 0 0 1.5 1.5zM13 1.5a.5.5 0 0 1 .5-.5h15a.5.5 0 0 1 .5.5v15a.5.5 0 0 1-.5.5h-15a.5.5 0 0 1-.5-.5v-15z" fill="#0b2e44"/>
                        <path d="M16.5 23h-15a.5.5 0 0 0-.5.5v15a.5.5 0 0 0 .5.5h15a.5.5 0 0 0 .5-.5v-15a.5.5 0 0 0-.5-.5z" fill="#98b7d6"/>
                        <path d="M16.5 22h-15A1.5 1.5 0 0 0 0 23.5v15A1.5 1.5 0 0 0 1.5 40h15a1.5 1.5 0 0 0 1.5-1.5v-15a1.5 1.5 0 0 0-1.5-1.5zm.5 16.5a.5.5 0 0 1-.5.5h-15a.5.5 0 0 1-.5-.5v-15a.5.5 0 0 1 .5-.5h15a.5.5 0 0 1 .5.5v15z" fill="#0b2e44"/>
                        <path d="M38.5 23h-15a.5.5 0 0 0-.5.5v15a.5.5 0 0 0 .5.5h15a.5.5 0 0 0 .5-.5v-15a.5.5 0 0 0-.5-.5z" fill="#9fe0f6"/>
                        <path d="M38.5 22h-15a1.5 1.5 0 0 0-1.5 1.5v15a1.5 1.5 0 0 0 1.5 1.5h15a1.5 1.5 0 0 0 1.5-1.5v-15a1.5 1.5 0 0 0-1.5-1.5zm.5 16.5a.5.5 0 0 1-.5.5h-15a.5.5 0 0 1-.5-.5v-15a.5.5 0 0 1 .5-.5h15a.5.5 0 0 1 .5.5v15z" fill="#0b2e44"/>
                    </svg>
                    <span data-ng-bind="office365CloudAppsRestoreOptionsCtrl.destinationSubEntityTypeLabel"></span>
                    <br><span class="optional-text margin-left-20" data-ng-if="office365CloudAppsRestoreOptionsCtrl.isOptional"><cv:msg key="label.optional" bundle="office365" /></span>
                </label>              
                
                <div class="col-xs-12 col-md-8">    
                    <div class="input-group">               
                        <label class="italic" for="destinationPlaceholder" data-ng-if="!office365CloudAppsRestoreOptionsCtrl.isSecondaryDestinationSet"
                            data-ng-bind="office365CloudAppsRestoreOptionsCtrl.destinationSubEntityTypePlaceholder">
                        </label>

                        <label class="font-weight-bold" for="destinationPlaceholder" data-ng-if="office365CloudAppsRestoreOptionsCtrl.isSecondaryDestinationSet">
                            <span data-ng-bind="office365CloudAppsRestoreOptionsCtrl.selectedSecondaryDestinationEntity"></span>
                            <span data-ng-if="office365CloudAppsRestoreOptionsCtrl.showFolderTabPlaceHolder">
                                <br><br>
                                <span <span data-ng-if="office365CloudAppsRestoreOptionsCtrl.folderTabMode === 'WIKI_TAB'">
                                    <svg class="margin-right-5" xmlns="http://www.w3.org/2000/svg" height="16px" width="16px" style="vertical-align: text-top;" viewBox="0 0 192.000000 192.000000" preserveAspectRatio="xMidYMid meet">
                                        <g transform="translate(0.000000,192.000000) scale(0.100000,-0.100000)" fill="#008373" stroke="none">
                                            <path d="M0 960 l0 -960 960 0 960 0 0 960 0 960 -960 0 -960 0 0 -960z m1247 466 c24 -21 28 -32 31 -95 l4 -71 -36 0 -36 0 0 59 c0 44 -4 60 -16 65 -20 8 -548 8 -568 0 -14 -5 -16 -39 -16 -275 l0 -269 120 0 120 0 0 -155 0 -155 164 0 c90 0 171 3 180 6 14 5 16 31 16 185 l0 179 36 0 35 0 -3 -191 -3 -191 -28 -24 c-28 -24 -31 -24 -234 -24 l-206 0 -41 43 c-23 23 -83 91 -133 150 l-93 107 0 311 0 311 29 29 29 29 311 0 310 0 28 -24z m-89 -128 l-3 -33 -72 -3 c-64 -3 -75 -6 -93 -29 -18 -23 -20 -40 -20 -179 l0 -154 -155 0 -155 0 0 215 0 215 251 0 250 0 -3 -32z m216 -109 c24 -19 26 -26 26 -103 0 -117 -8 -126 -112 -126 l-81 0 -68 -66 c-60 -57 -71 -64 -89 -54 -19 10 -20 20 -20 168 0 86 4 162 8 168 18 27 53 33 178 34 118 0 134 -2 158 -21z m-216 -441 l-3 -33 -125 0 c-112 0 -125 2 -128 18 -9 44 1 47 133 47 l126 0 -3 -32z m0 -126 l3 -33 -128 3 c-114 3 -128 5 -131 21 -9 45 1 48 130 45 l123 -3 3 -33z"/>
                                            <path d="M682 709 c29 -34 63 -73 75 -88 l22 -26 1 88 0 87 -76 0 -76 0 54 -61z"/>
                                        </g>
                                    </svg>
                                    <span data-ng-bind="office365CloudAppsRestoreOptionsCtrl.destinationTabName"></span>
                                </span>
                                <span <span data-ng-if="office365CloudAppsRestoreOptionsCtrl.folderTabMode === 'FOLDER'">
                                    <svg
                                        class="margin-right-5" xmlns="http://www.w3.org/2000/svg" height="16px" width="16px" style="vertical-align: text-top;" viewBox="0 0 40 40">
                                        <path d="M3.5 8.036h32.93c-.084-.005-.163-.024-.25-.024H18.217L14.17 3.964H4.048C1.77 3.964 0 5.735 0 8.012v3.524a3.5 3.5 0 0 1 3.5-3.5z" fill="#ffa000"/>
                                        <path d="M39.978 11.316l-.045-.443c-.008-.043-.02-.085-.03-.127-.042-.18-.095-.357-.163-.526-.037-.092-.088-.176-.133-.264l-.15-.275c-.62-.985-1.708-1.645-2.957-1.645h-33a3.5 3.5 0 0 0-3.5 3.5v21a3.5 3.5 0 0 0 3.5 3.5h33a3.5 3.5 0 0 0 3.5-3.5v-21c0-.075-.017-.146-.022-.22z" fill="#ffca28"/>
                                    </svg>
                                    <span data-ng-bind="office365CloudAppsRestoreOptionsCtrl.destinationFolderPath"></span>
                                </span>
                            </span>
                        </label>

                        <span class="input-group-btn">
                            <button type="button" id="secondaryDestinationBrowseBtn" class="icon-style cv-material-button browse" data-ng-click="office365CloudAppsRestoreOptionsCtrl.performSecondaryDestinationBrowse()"> 
                                <div class="cv-material-button-icon cursor-pointer">
                                    <svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path d="M0 0h24v24H0z" fill="none"/><path d="M19 4H5c-1.11 0-2 .9-2 2v12c0 1.1.89 2 2 2h4v-2H5V8h14v10h-4v2h4c1.1 0 2-.9 2-2V6c0-1.1-.89-2-2-2zm-7 6l-4 4h3v6h2v-6h3l-4-4z"/></svg>
                                </div><div class="cv-material-button-tooltip"><cv:msg key="Browse" bundle="storage" /></div>
                            </button>
                        </span>
                    </div>                
                    <div class="help-block"
                        data-ng-show="office365RestoreOptionsForm.$submitted"
                        data-ng-if="(!office365CloudAppsRestoreOptionsCtrl.selectedSecondaryDestinationEntity.length && !office365CloudAppsRestoreOptionsCtrl.isOptional">
                        <span data-ng-bind="office365CloudAppsRestoreOptionsCtrl.destinationSubEntitySelectionError"></span>
                    </div>                 
                </div>
            </div>
            <!--Microsoft Teams/Dynamics 365--END-->
            <!--Team selection/Instance Selection--START-->

            
            <!--OneDrive--END-->
        </div>
        <!--Restore to User Account/Site/Web/Server --END-->

         <!--Restore flags/options --START-->
        <div class="plain-accordion margin-top-10" data-ng-if="!office365CloudAppsRestoreOptionsCtrl.restoreToFileLocation">
            <cv-plain-accordion accordion-label="{{office365CloudAppsRestoreOptionsCtrl.fileLevelRestoreOptionsLabel}}">			
				<div class="margin-left-5 margin-right-0 padding-left-15 padding-right-15">                   
                    <div class="form-group row margin-top-10">
						<span data-ng-if="office365CloudAppsRestoreOptionsCtrl.restoreToCloudApp" >
							<cv-help-text class="col-xs-12 col-md-4 margin-top-5" help-label="label.restore.file.exists" help-text="help.restore.file.exists" />
						</span>
                        <div class="col-xs-12 col-md-8">                                         
                            <cv-radio-group 
                                is-vertical="true" 
                                radio-model="office365CloudAppsRestoreOptionsCtrl.fileRestoreOptionSelected" 
                                radio-obj="office365CloudAppsRestoreOptionsCtrl.fileRestoreOptions" 
                                on-click="office365CloudAppsRestoreOptionsCtrl.fileRestoreOptionChange(data)">
                            </cv-radio-group>	               
                        </div>                 
                    </div>              
                    <!--Overwrite data--END-->
				</div>
			</cv-plain-accordion>
        </div>
        
        <!--Restore flags/options options --END-->

        <!--Advanced options --START-->
        <div data-ng-if="office365CloudAppsRestoreOptionsCtrl.hasAdvancedOptions" class="plain-accordion">
            <cv-plain-accordion accordion-label="header.restoreoptions.advancedOptions">			
				<div class="margin-left-5 margin-right-0 padding-left-15 padding-right-15">
                    <!--Destination pseudo client (tenant) --START-->
                    <div class="form-group row margin-top-10" data-ng-if="!office365CloudAppsRestoreOptionsCtrl.restoreToFileLocation"
                        data-ng-disabled="office365CloudAppsRestoreOptionsCtrl.restoreToOriginalLocation">
                        <label class="col-xs-12 col-md-4" for="restoreDestination"><cv:msg
                                key="label.restore.office365app" bundle="office365" /></label>
                        <div class="col-xs-12 col-md-8">                                         
                            <isteven-multi-select
                                id="office365PseudoClientsDropdown"
                                name="office365PseudoClientsDropdown"
                                class="isteven-multi-select user-group-select isteven-summary-dropdown"
                                input-model="office365CloudAppsRestoreOptionsCtrl.office365PseudoClientAppsList"
                                output-model="office365CloudAppsRestoreOptionsCtrl.selectedOffice365PseudoClientAppsList"
                                item-label="clientName"
                                selection-mode="single"
                                button-label="clientName"
                                max-labels="1"
                                prevent-sort="true"
                                helper-elements="filter"
                                tick-property="selected"           
                                on-item-click="office365CloudAppsRestoreOptionsCtrl.processPseudoClientSelectionChange()"
                                translation="office365CloudAppsRestoreOptionsCtrl.localLang ">
                            </isteven-multi-select>         	               
                        </div>
                    </div>
                    <!--Destination pseudo client (tenant) --END-->
				</div>
			</cv-plain-accordion>
        </div>
        
        <!--Advanced options --END-->

         <!--Selected items --START-->
         <div data-ng-if="office365CloudAppsRestoreOptionsCtrl.showSelectedItemsGrid" class="plain-accordion">
             <cv-plain-accordion accordion-label="restore.options.items.to.restore">
                 <div class="margin-left-5 margin-right-0 padding-left-15 padding-right-15">
                     <cv-kendo-grid
                         data-cv-grid-options="office365CloudAppsRestoreOptionsCtrl.selectedItemsGridOptions">
                     </cv-kendo-grid>
                 </div>
             </cv-plain-accordion>
         </div>
         <!--Selected items --END-->
       
	</div>
	<!--End --Modal Body-->
	<div class="modal-footer">
        <button id="cancel" class="btn btn-default" type="button" data-ng-click="office365CloudAppsRestoreOptionsCtrl.cancel()"> 
            <cv:msg key="Cancel" bundle="messages" />
        </button>
        <button id="submit" class="btn btn-primary cvBusyOnAjax" type="submit">
            <cv:msg key="Submit" bundle="messages" />
        </button>
    </div>		
	<!--End --Modal Footer-->
</form>
