<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.office365"></cv:cvMessages>
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
</script>
<div>
	<div class="row bootstrap-wrapper">
		<div class="col-xs-12 " ng-class="{'col-md-12': addOffice365App.isSetup, 'col-md-10 col-md-offset-1 col-lg-8 col-lg-offset-2 col-xl-6 col-xl-offset-3': !addOffice365App.isSetup}" 
			data-ng-hide="addOffice365App.hideForm">
			<h1 data-ng-bind-html="addOffice365App.pageHeaderTitle" data-ng-if="!addOffice365App.isSetup" class="text-center"></h1>
			<form class="form-horizontal create-createClientAttr-form"
				data-cv-submit="addOffice365App.submitDetails()"
                novalidate name="addOffice365Form" autocomplete="off" cv-hide-api>
                
			    <!-- START O365 General settings: Non-Saas-Tenant-->
				<div data-ng-if="!addOffice365App.isOffice365SaaSTenant">
                    <!-- Step 1: General -->
                    <div class="panel panel-default">
                        <div class="panel-body">
                            <div class="form-group">
                                <label class="col-xs-12 col-md-3" for="appName"><cv:msg
                                        key="label.name" bundle="exchange" /></label>
                                <div class="col-xs-12 col-md-9">
                                    <input type="text" name="appName" id="appName"
                                        placeholder='<cv:msg key="label.exchAppNamePlaceholder" bundle="exchange"/>'
                                        data-ng-pattern="/^[a-zA-Z0-9_-]*$/"
                                        data-ng-model="addOffice365App.createClientAttr.clientInfo.cloudClonnectorProperties.instance.instance.clientName"
                                        required autofocus />
                                    <div class="help-block"
                                        data-ng-show="cv.addOffice365Form.needsAttention(addOffice365Form.appName)">
                                        <cv:msg key="error.noServerName" bundle="exchange" />
                                    </div>
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="col-xs-12 col-md-3" for="serverPlan"><cv:msg
                                        key="label.serverPlan" bundle="exchange" /></label>
                                <div class="col-xs-12 col-md-9">
                                    <cv-plan-summary-dropdown
                                        data-ng-if="addOffice365App.UIAttributes.serverPlan.plansLoaded"
                                        input-model="addOffice365App.UIAttributes.serverPlan.planList"
                                        output-model="addOffice365App.UIAttributes.serverPlan.selectedPlan"
                                        button-label="'planName'"
                                        item-label="'planName'"
                                        tick-property="'selected'"
                                        selection-mode="'single'"
                                        directive-id="'plans'"
                                        max-labels="1"
                                        helper-elements="'filter'"
                                        translation="addOffice365App.localLang"
                                        disable-property="'disabled'"
                                        on-item-clicked="addOffice365App.processServerPlanSelection()">
                                    </cv-plan-summary-dropdown>
                                    <div class="help-block"
                                        data-ng-show="addOffice365Form.$submitted"
                                        data-ng-if="!addOffice365App.UIAttributes.serverPlan.selectedPlan.length">
                                        <cv:msg key="error.selectPlan" bundle="exchange" />
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- END O365 General settings: Non-Saas-Tenant-->

                <!-- START O365 Infrastructure settings: Non-Saas-Tenant-->
                <div data-ng-if="!addOffice365App.isOffice365SaaSTenant">
                    <uib-accordion>
                        <div uib-accordion-group class="panel-default"
                            data-is-open="addOffice365App.showInfrastructureTile"
                            data-is-disabled="addOffice365App.isInfrastructurePoolConfigured">
                            <uib-accordion-heading class="panel-info">
                                <cv:msg key="label.infrastructurePane" bundle="exchange" />
                                <span data-ng-if="addOffice365App.isInfrastructurePoolConfigured" class="restore-help-text margin-left-10"><cv:msg key="label.infrastructureInherited" bundle="exchange" /></span>
                                <i class="float-right glyphicon"
                                    data-ng-class="{'glyphicon-chevron-down': !addOffice365App.createClientAttr.clientInfo.cloudClonnectorProperties.instance.cloudAppsInstance.v2CloudAppsInstance.infraStructurePoolEnabled, 
                                    'glyphicon-chevron-right': addOffice365App.createClientAttr.clientInfo.cloudClonnectorProperties.instance.cloudAppsInstance.v2CloudAppsInstance.infraStructurePoolEnabled}"></i>
                            </uib-accordion-heading>

                            <div data-ng-if="!addOffice365App.isInfrastructurePoolConfigured">
                                
                                <div class="form-group">
                                    <!--  Index Server -->
                                    <cv-help-text class="col-xs-12 col-md-3 margin-top-10" help-label="label.indexServer" help-text="info.indexServer"/>
                                    <div class="col-xs-12 col-md-9">
                                        <div class="input-group">
                                            <isteven-multi-select id="createOffice365App_isteven-multi-select_#2568" 
                                                input-model="addOffice365App.UIAttributes.indexServer.indexServerList"
                                                output-model="addOffice365App.UIAttributes.indexServer.selectedList"
                                                button-label="mediaAgentName"
                                                item-label="mediaAgentName"
                                                selection-mode="single"
                                                helper-elements="filter"
                                                directive-id="'indexServers'"
                                                max-labels="1"
                                                tick-property="selected"
                                                translation="addOffice365App.localLang">
                                            </isteven-multi-select>
                                            <span class="input-group-btn">
                                                <button id="updateIndexServerCtrl_button_#3718" type="button"
                                                    data-ng-click="addOffice365App.createNewIndexServer()"
                                                    class="icon-style cv-material-button browse">
                                                    <div class="cv-material-button-icon cursor-pointer">
                                                        <svg height="20" id="cv_cc" viewBox="0 0 448 448" width="20" xmlns="http://www.w3.org/2000/svg">
                                                            <path d="m408 184h-136c-4.417969 0-8-3.582031-8-8v-136c0-22.089844-17.910156-40-40-40s-40 17.910156-40 40v136c0 4.417969-3.582031 8-8 8h-136c-22.089844 0-40 17.910156-40 40s17.910156 40 40 40h136c4.417969 0 8 3.582031 8 8v136c0 22.089844 17.910156 40 40 40s40-17.910156 40-40v-136c0-4.417969 3.582031-8 8-8h136c22.089844 0 40-17.910156 40-40s-17.910156-40-40-40zm0 0"/>
                                                        </svg>
                                                    </div>
                                                    <div class="cv-material-button-tooltip">
                                                        <cv:msg key="label.newExchangeIndexServer" bundle="exchange" />
                                                    </div>
                                                </button>
                                            </span>
                                        </div>
                                        <div class="help-block"
                                            data-ng-show="addOffice365Form.$submitted"
                                            data-ng-if="addOffice365App.UIAttributes.indexServer.selectedList.length === 0">
                                            <cv:msg key="error.selectIndexServer" bundle="exchange" />
                                        </div>
                                    </div>
                                </div>
                                <!--  Index Server -->
                                <!--  Access Nodes -- Office 365-->
                                <div class="form-group">
                                    <cv-help-text class="col-xs-12 col-md-3 margin-top-10" help-label="label.accessNodes" help-text="help.exchangeAccessNode"/>
                                    <div class="col-xs-12 col-md-9">
                                        <isteven-multi-select id="createOffice365App_isteven-multi-select_#5438" 
                                            input-model="addOffice365App.UIAttributes.accessNodes.nodeList"
                                            output-model="addOffice365App.createClientAttr.clientInfo.cloudClonnectorProperties.instance.cloudAppsInstance.generalCloudProperties.memberServers"
                                            button-label="clientName"
                                            item-label="clientName"
                                            tick-property="selected"
                                            data-ng-required="true"
                                            class="isteven-multi-select user-group-select"
                                            directive-id="'accessNodes'"
                                            name="accessNodes"
                                            helper-elements="all none reset filter"
                                            max-labels="8"
                                            on-item-click="addOffice365App.processAccessNodeSelection()"
                                            on-select-none="addOffice365App.processAccessNodeSelection()"
                                            on-select-all="addOffice365App.processAccessNodeSelection()"
                                            on-reset="addOffice365App.processAccessNodeSelection()"
                                            required translation="addOffice365App.localLang"
                                            group-property="msGroup">
                                        </isteven-multi-select>
                                        <span data-ng-show="addOffice365Form.$submitted" class="help-block"
                                            data-ng-if="addOffice365App.createClientAttr.clientInfo.cloudClonnectorProperties.instance.cloudAppsInstance.generalCloudProperties.memberServers.length === 0"><cv:msg
                                                key="error.selectNodes" bundle="exchange" /></span>
                                    </div>
                                </div>
                                <!--  Access Nodes -->
                                <!--  Shared Path -->
                                <div class="form-group"
                                    data-ng-if="addOffice365App.getSharedJobDirData">
                                    <cv-help-text class="col-xs-12 col-md-3 margin-top-10" help-label="label.jobResultsDirectory" help-text="info.jobResultsDir"/>
                                    <div class="col-xs-12 col-md-9">
                                        <input type="text" id="jobResultDirectory"
                                            name="jobResultDirectory" required
                                            placeholder='<cv:msg key="label.help.jobResultsDirectory" bundle="exchange" />'
                                            data-ng-model="addOffice365App.createClientAttr.clientInfo.cloudClonnectorProperties.instance.cloudAppsInstance.generalCloudProperties.jobResultsDir.path"
                                            data-ng-pattern="addOffice365App.REGEX.WINDOWS_NETWORK_PATH" />
                                        <div class="help-block"
                                            data-ng-show="cv.addOffice365Form.needsAttention(addOffice365Form.jobResultDirectory) || addOffice365Form.jobResultDirectory.$error.pattern">
                                            <cv:msg key="error.validUNCPath" bundle="exchange" />
                                        </div>
                                    </div>
                                </div>
                                <!--  Shared Path -->
                                <div class="form-group"
                                    data-ng-if="addOffice365App.getSharedJobDirData">
                                    <label class="col-xs-12 col-md-3" for="serviceAccounts"><cv:msg
                                            key="label.sharePathAccount" bundle="exchange" /></label>
                                    <div class="margin-top-10 col-xs-12 col-md-9">
                                        <a id="addLocalAccount" name="addLocalAccount"
                                            data-ng-if="addOffice365App.UIAttributes.accessNodes.sharedPath.localSysAccDetails.userAccount.userName.length == 0"
                                            data-ng-click="addOffice365App.addAccountToAccessSharedPath(false)"
                                            class="float-left">
                                                <i class="fa fa-pencil margin-right-5"></i>
                                                <cv:msg key="label.add" bundle="exchange" />
                                            </a>
                                        <a class="float-left"
                                            data-ng-if="addOffice365App.UIAttributes.accessNodes.sharedPath.localSysAccDetails.userAccount.userName.length > 0"
                                            data-ng-click="addOffice365App.addAccountToAccessSharedPath(true)"										
                                            ng-bind="addOffice365App.UIAttributes.accessNodes.sharedPath.localSysAccDetails.userAccount.userName">
                                        </a>
                                        <div class="help-block" data-ng-show="addOffice365Form.$submitted"
                                            data-ng-if="(addOffice365App.getSharedJobDirData) && addOffice365App.UIAttributes.accessNodes.sharedPath.localSysAccDetails.userAccount.userName.length === 0">
                                            <cv:msg key="error.addSharedPathAccount" bundle="exchange" />
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </uib-accordion>
                </div>
                <!-- END O365 Infrastructure settings: Non-Saas-Tenant-->

                <!-- START Office365 Connection Settings-->
                <div class="panel panel-default">
                    <div class="panel-body">
                        <h4 data-ng-if="!addOffice365App.isOffice365SaaSTenant" data-ng-bind="addOffice365App.UIAttributes.configPane.title"></h4>
                        <!--Office 365 SAAS Config-->
                        <div data-ng-if="addOffice365App.isOffice365SaaSTenant"
                            data-ng-show="addOffice365App.showAppNameInput"> 
                            <div class="form-group">
                                <label class="col-xs-12 col-md-3" for="appName"><cv:msg
                                        key="label.name" bundle="exchange" /></label>
                                <div class="col-xs-12 col-md-9">
                                    <div class="input-group">
                                        <span class="input-group-addon" style="background-color:transparent; padding:0px; border:none;"
                                            data-ng-bind="addOffice365App.office365AppPrefix"></span>
                                        <input type="text" name="appName" id="appName"
                                            placeholder='<cv:msg key="label.exchAppNamePlaceholder" bundle="exchange"/>'
                                            data-ng-disabled="addOffice365App.createClientAttr.disableClientName"
                                            data-ng-pattern="/^[a-zA-Z0-9_-]*$/"
                                            data-ng-model="addOffice365App.createClientAttr.clientInfo.cloudClonnectorProperties.instance.instance.clientName"
                                            required autofocus />
                                    </div>
                                    <div class="help-block"
                                        data-ng-show="cv.addOffice365Form.needsAttention(addOffice365Form.appName)">
                                        <cv:msg key="error.noServerName" bundle="exchange" />
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div data-ng-if="addOffice365App.isOffice365SaaSTenant"
                            data-ng-show="!addOffice365App.showAppNameInput"> 
                            <div class="form-group">
                                <label class="col-xs-12 col-md-3" for="nAppName"><cv:msg
                                        key="label.name" bundle="exchange" /></label>
                                <div class="col-xs-12 col-md-9">
                                    <!-- <span class="input-group-addon" style="background-color:transparent; padding:0px; border:none;"
                                        data-ng-bind="addOffice365App.office365AppPrefix"></span> -->
                                    <input type="text" name="nAppName" id="nAppName"
                                        placeholder='<cv:msg key="label.exchAppNamePlaceholder" bundle="exchange"/>'
                                        data-ng-disabled="addOffice365App.createClientAttr.disableClientName"
                                        data-ng-pattern="/^[a-zA-Z0-9_-]*$/"
                                        data-ng-model="addOffice365App.createClientAttr.clientInfo.cloudClonnectorProperties.instance.instance.clientName"
                                        required autofocus />
                                    <div class="help-block"
                                        data-ng-show="cv.addOffice365Form.needsAttention(addOffice365Form.nAppName)">
                                        <cv:msg key="error.noServerName" bundle="exchange" />
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="form-group margin-top-20" data-ng-if="addOffice365App.appConsts.showRegion">
                            <label class="col-xs-12 col-md-3" for="region"><cv:msg
                                    key="label.region" bundle="exchange" /></label>
                            <div class="col-xs-12 col-md-9"
                                    data-ng-disabled="addOffice365App.generalAttributes.isGlobalLogin && addOffice365App.createClientAttr.clientInfo.cloudClonnectorProperties.instance.cloudAppsInstance.v2CloudAppsInstance.azureAppList.azureApps[0].azureAppId.length > 0">
                                    <isteven-multi-select id="createOffice365App_isteven-multi-select_#1167" 
                                            input-model="addOffice365App.msCloudRegions"
                                            output-model="addOffice365App.selectedRegionList"
                                            button-label="region"
                                            item-label="region"
                                            directive-id="'cloudRegions'"
                                            selection-mode="single"
                                            helper-elements="filter"
                                            max-labels="1"
                                            tick-property="selected"
                                            translation="addOffice365App.localLang">
                                </isteven-multi-select>
                            </div>
                        </div>

                        <div class="margin-top-20"
                            data-ng-if="addOffice365App.generalAttributes.isGlobalLogin && addOffice365App.createClientAttr.clientInfo.cloudClonnectorProperties.instance.cloudAppsInstance.v2CloudAppsInstance.azureAppList.azureApps[0].azureAppId.length > 0">
                            <div class="form-group">
                                <cv-help-text class="col-xs-12 col-md-3" help-label="label.globalAdministrator" help-text="help.globalAdmin"/>
                                <div class="col-xs-12 col-md-9">
                                    <span id="globalAdminUsername" name="globalAdminUsername"
                                        class="float-left" ng-bind="addOffice365App.globalAdminAccount.adminCredential.userName"></span>
                                </div>
                            </div>
                        </div>

                        <div class="margin-top-10" 
                            data-ng-if="addOffice365App.generalAttributes.isGlobalLogin && addOffice365App.createClientAttr.clientInfo.cloudClonnectorProperties.instance.cloudAppsInstance.v2CloudAppsInstance.azureAppList.azureApps[0].azureAppDisplayName.length > 0">
                            <div class="form-group">
                                <label class="col-xs-12 col-md-3" for="azureAppDetails"><cv:msg
                                    key="label.azureAppDetails" bundle="exchange" /></label>
                                <div class="col-xs-12 col-md-9 margin-top-10">
                                    <span id="globalAppName" name="globalAppName" class="float-left" ng-bind="addOffice365App.createClientAttr.clientInfo.cloudClonnectorProperties.instance.cloudAppsInstance.v2CloudAppsInstance.azureAppList.azureApps[0].azureAppDisplayName"></span>
                                </div>
                            </div>
                            <div class="form-group">
                                <div class="help-block margin-top-5"
                                    data-ng-show="addOffice365App.showAzureErrorMsg"
                                    data-ng-bind-html="addOffice365App.createAzureApp.appCreationError"></div>
                            </div>
                        </div>
                       
                            <div class="margin-top-15">
                                <div class="form-group" ng-if="!addOffice365App.generalAttributes.isGlobalLogin || (addOffice365App.generalAttributes.isGlobalLogin && addOffice365App.createClientAttr.clientInfo.cloudClonnectorProperties.instance.cloudAppsInstance.v2CloudAppsInstance.azureAppList.azureApps.length <= 0)">
                                        <cv-help-text class="col-xs-12 col-md-3 margin-top-10" help-label="label.office365.config.mode" help-text="label.office365.conn.config.header"/>
                                        <div class="col-xs-12 col-md-9">
                                            <cv-radio-group
                                                class="font-weight-bold" 
                                                radio-model="addOffice365App.office365AccountCreationOptionVal" 
                                                radio-obj="addOffice365App.office365AccountCreationOptions"
                                                is-disabled="addOffice365App.azureAppCreationInProgress"
                                                on-click="addOffice365App.office365AccountCreationOptionValChange(data)">
                                            </cv-radio-group>

                                            <!-- Global Admin Login --Start-->
                                            <div data-ng-if="addOffice365App.generalAttributes.isGlobalLogin"
                                            class="margin-top-20 padding-left-20 margin-left-5">
                                            <!--Global Administrator Credentials--Header-->
                                            <label  
                                                class="font-weight-bold" 
                                                data-ng-bind="addOffice365App.gaCredsTitleHeader">
                                            </label>
                                            <!--Global Administrator Credentials--Header-->
                                            <div class="form-group margin-left-10">
												<cv-call-out
													class="margin-top-10 col-xs-12 col-md-4"
													html-template="addOffice365App.getGlobalAdminUserNameCallOut()"
													label='<cv:msg key="label.globalAdministrator" bundle="office365" />'
													placement="right"
													trigger="click"
												/>
                                                <div class="col-xs-12 col-md-8">
                                                    <input type="email" id="globalUserName" name="globalUserName"
                                                        data-ng-required="addOffice365App.generalAttributes.isGlobalLogin"
                                                        data-ng-model="addOffice365App.globalAdminAccount.adminCredential.userName"
                                                        placeholder='<cv:msg key="label.gadmin.example" bundle="office365"/>' />
                                                    <div class="help-block"
                                                        data-ng-show="cv.addOffice365Form.needsAttention(addOffice365Form.globalUserName)">
                                                        <cv:msg key="error.globalAppUsernameError" bundle="exchange" />
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group margin-left-10">
                                                <label class="col-xs-12 col-md-4" for="globalPassword"><cv:msg
                                                        key="label.password" bundle="exchange"></cv:msg></label>
                                                <div class="col-xs-12 col-md-8">
                                                    <input type="password" id="globalPassword"
                                                        name="globalPassword"
                                                        data-ng-required="addOffice365App.generalAttributes.isGlobalLogin"
                                                        data-ng-model="addOffice365App.globalAdminAccount.adminCredential.password"
                                                        placeholder='<cv:msg key="label.password" bundle="exchange"/>' />
                                                    <div class="help-block"
                                                        data-ng-show="cv.addOffice365Form.needsAttention(addOffice365Form.globalPassword)">
                                                        <cv:msg key="error.password" bundle="exchange" />
                                                    </div>
                                                </div>
                                            </div>
                                            <!--Confirmation checkboxes -->
                                            <div class="form-group margin-left-25">
                                                <cv-checkbox-group 
                                                    id="confirm-actions-checkbox-label"
                                                    check-obj="addOffice365App.confirmGAChkOptionsList" 
                                                    output-model="addOffice365App.confirmedChkOptions" 
                                                    is-vertical="true"
                                                    is-disabled="addOffice365App.azureAppCreationInProgress" 
                                                    on-click-checkbox="addOffice365App.onClickConfirmationCheckbox(data)">
                                                </cv-checkbox-group>
                                            </div>
                                            <!--Confirmation checkboxes -->
                                            <!--Connection info header-->
                                            <label  
                                                class="font-weight-bold" 
                                                data-ng-bind="addOffice365App.connectionRequirementsHeader">
                                            </label>
                                            <!--Connection info header-->
                                            <!--Confirmation checkboxes -->
                                            <div class="form-group margin-left-25">
                                                <cv-checkbox-group 
                                                    id="confirm-actions-checkbox-label"
                                                    check-obj="addOffice365App.confirmChkOptionsList" 
                                                    output-model="addOffice365App.confirmedChkOptions" 
                                                    is-vertical="true"
                                                    is-disabled="addOffice365App.azureAppCreationInProgress" 
                                                    on-click-checkbox="addOffice365App.onClickConfirmationCheckbox(data)">
                                                </cv-checkbox-group>
                                            </div>
                                            <!--Confirmation checkboxes -->
                                            <div class="form-group margin-left-25">
                                                <button id="createOffice365App_button_#6055" class="btn btn-default margin-top-10" type="button" 
                                                    data-ng-disabled="addOffice365App.createAzureApp.appCreationInProgress || !addOffice365App.confirmRequirementsModel.mfaDisabled || !addOffice365App.confirmRequirementsModel.chkTeamsSvcUsage || addOffice365App.globalAdminAccount.adminCredential.password.length < 1 || addOffice365App.globalAdminAccount.adminCredential.userName.length < 1"
                                                    data-ng-click="addOffice365App.createAzureAppFromGlobalLogin()">
                                                    <cv:msg key="label.createApp" bundle="exchange" />
                                                    <i data-ng-if="addOffice365App.azureAppCreationInProgress"
                                                        class="fa fa-spinner fa-spin"></i>
                                                </button>
                                                <div class="help-block margin-top-5"
                                                    data-ng-show="addOffice365App.showAzureErrorMsg"
                                                    data-ng-bind-html="addOffice365App.createAzureApp.appCreationError">
                                                </div>
                                            </div>
                                            </div>
                                            <!-- Global Admin Login --End-->


                                            <!--Add Azure app / Svc Accounts manually --START-->
                                            <div class="margin-top-10 padding-left-20 margin-left-5" data-ng-if="!addOffice365App.generalAttributes.isGlobalLogin">

                                                <!--Download config helper files --START-->
                                                <div class="row margin-left-15 margin-right-15">                      
                                                    <div class="form-group info-message message-background no-padding">                                            
                                                        <span class="margin-left-5 message-width margin-right-5">
                                                            <h5 class="line-height-2">
                                                                <cv:msg key="label.download.o365.config.pdf.i" bundle="office365" />
                                                                <a data-ng-click="addOffice365App._downloadToolkit()"><cv:msg key="label.click.here" bundle="office365" />
                                                                    <i class="margin-left-5 fa fa-download"></i>
                                                                </a>.&nbsp;
                                                                <cv:msg key="label.download.o365.config.pdf.ii" bundle="office365" />
                                                            </h5>
                                                            <h5 class="line-height-2">
                                                                <cv:msg key="label.click.copy.uri" bundle="office365" />
                                                                <a data-ng-click="addOffice365App._copyRedirectURI()"><cv:msg key="label.click.here" bundle="office365" />
                                                                    <i class="margin-left-5 fa fa-copy"></i>
                                                                </a>.
                                                            </h5>                                                       
                                                        </span>                              
                                                    </div>
                                                </div>
                                                <!--Download config helper files --END-->

                                                <div data-ng-if="!addOffice365App.appConsts.showAzureAppInputInline">
                                                    <!-- Azure AD App + Service Account Details Required--Added Manually-- Start-->
                                                    <!-- Azure AD App Details --Added Manually-- Start-->
                                                    <div class="form-group">
                                                        <label class="col-xs-12 col-md-4" for="mAzureApplicationId"><cv:msg
                                                                key="label.azureAppDetails" bundle="exchange" /></label>
                                                        <div class="margin-top-10 col-xs-12 col-md-8">
                                                            <div data-ng-if="!addOffice365App.isAzureAppSetManually">
                                                                <a
                                                                    data-ng-click="addOffice365App.addEditServiceAccount(addOffice365App.AZURE_APP_SUBMODE, false, false, true)">
                                                                    <i class="fa fa-pencil margin-right-5"></i>
                                                                    <cv:msg key="label.option.addAzureAppManually" bundle="office365" />
                                                                </a>
                                                            </div>
                                                            <div data-ng-if="addOffice365App.isAzureAppSetManually">
                                                                <a id="mAzureApplicationId" name="mAzureApplicationId"
                                                                data-ng-click="addOffice365App.addEditServiceAccount(addOffice365App.office365V2Constants.manualSubMode.AZURE_AD, true, false, true)"						
                                                                    class="float-left" ng-bind="addOffice365App.createClientAttr.clientInfo.cloudClonnectorProperties.instance.cloudAppsInstance.v2CloudAppsInstance.azureAppList.azureApps[0].azureAppId">
                                                                </a>
                                                            </div>
                                                            <div class="help-block" data-ng-show="addOffice365Form.$submitted"
                                                                data-ng-if="!addOffice365App.isAzureAppSetManually">
                                                                <cv:msg key="error.addAzureAppManually" bundle="office365" />
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!-- Azure AD App Details --Added Manually-- End-->

                                                    <!-- Service Accounts --Added Manually - Start-->
                                                    <div class="form-group" data-ng-if="addOffice365App.appConsts.requireServiceAccForBackup">
                                                        <label class="col-xs-12 col-md-4" for="serviceAccounts"><cv:msg
                                                                key="label.addO365ServiceAccount" bundle="exchange" /></label>
                                                        <div class="margin-top-10 col-xs-12 col-md-8">
                                                            <div data-ng-if="!addOffice365App.isServiceAccountSet">
                                                                <a
                                                                    data-ng-click="addOffice365App.addEditServiceAccount(addOffice365App.office365V2Constants.manualSubMode.EXCHANGE_ONLINE, false, false, true)">
                                                                    <i class="fa fa-pencil margin-right-5"></i>
                                                                    <cv:msg key="label.option.addServiceAccountManually" bundle="office365" />
                                                                </a>
                                                            </div>
                                                            <div data-ng-if="addOffice365App.isServiceAccountSet">
                                                                <a
                                                                    data-ng-repeat="userAccount in addOffice365App.createClientAttr.clientInfo.cloudClonnectorProperties.instance.cloudAppsInstance.v2CloudAppsInstance.serviceAccounts.accounts"
                                                                data-ng-click="addOffice365App.addEditServiceAccount(addOffice365App.office365V2Constants.manualSubMode.EXCHANGE_ONLINE, true, false, true)"										
                                                                    ng-bind="addOffice365App.createClientAttr.clientInfo.cloudClonnectorProperties.instance.cloudAppsInstance.v2CloudAppsInstance.serviceAccounts.accounts[$index].AdminSmtpAddress">
                                                                </a>
                                                            </div>
                                                            <div class="help-block" data-ng-show="addOffice365Form.$submitted" data-ng-if="!addOffice365App.isServiceAccountSet">
                                                                <cv:msg key="dialog.header.serviceaccount.title" bundle="office365" />
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!--  Service Accounts --Added Manually - End-->
                                                </div>
                                                <div data-ng-if="addOffice365App.appConsts.showAzureAppInputInline">
                                                    <!--Add Azure app info header-->
                                                    <label  
                                                        class="font-weight-bold"> 
                                                        <cv:msg key="dialog.azureapp.title" bundle="office365" />
                                                    </label>
                                                    <!--Add Azure app info header-->
                                                    <!-- Azure AD App Details Only needed--Added Manually-- Start-->
                                                    <div class="margin-left-25 margin-top-10"> 
                                                        <div class="form-group">
                                                            <label class="col-xs-12 col-md-4" for="applicationId"> <cv:msg
                                                                    key="label.applicationId" bundle="exchange"></cv:msg>
                                                            </label>
                                                            <div class="col-xs-12 col-md-8">
                                                                <input type="text" id="applicationId" name="applicationId" required
                                                                    placeholder='<cv:msg key="placeholder.azureAppId" bundle="office365"/>'
                                                                    data-ng-model="addOffice365App.createClientAttr.clientInfo.cloudClonnectorProperties.instance.cloudAppsInstance.v2CloudAppsInstance.azureAppList.azureApps[0].azureAppId" />
                                                                <div class="help-block"
                                                                        data-ng-if="!addOffice365App.createClientAttr.clientInfo.cloudClonnectorProperties.instance.cloudAppsInstance.v2CloudAppsInstance.azureAppList.azureApps[0].azureAppId.length"                    
                                                                        data-ng-show="cv.addOffice365Form.needsAttention(addOffice365Form.applicationId) || addOffice365App.isTokenRequestSubmitted">
                                                                    <cv:msg key="label.appIdRequired" bundle="exchange" />
                                                                </div>
                                                            </div>		
                                                        </div>

                                                        <div class="form-group">
                                                            <label class="col-xs-12 col-md-4" for="secretAccessKey"> <cv:msg
                                                                    key="label.azureAppSecret" bundle="office365"></cv:msg>
                                                            </label>
                                                            <div class="col-xs-12 col-md-8">
                                                                <input type="password" id="secretAccessKey" name="secretAccessKey" required
                                                                    placeholder='<cv:msg key="placeholder.azureAppSecret" bundle="office365" />'
                                                                    data-ng-model="addOffice365App.createClientAttr.clientInfo.cloudClonnectorProperties.instance.cloudAppsInstance.v2CloudAppsInstance.azureAppList.azureApps[0].azureAppKeyValue" />
                                                                <div class="help-block"
                                                                        data-ng-if="!addOffice365App.createClientAttr.clientInfo.cloudClonnectorProperties.instance.cloudAppsInstance.v2CloudAppsInstance.azureAppList.azureApps[0].azureAppKeyValue.length"
                                                                        data-ng-show="cv.addOffice365Form.needsAttention(addOffice365Form.secretAccessKey) || addOffice365App.isTokenRequestSubmitted">
                                                                    <cv:msg key="label.appSecretRequired" bundle="exchange" />
                                                                </div>
                                                            </div>		
                                                        </div>

                                                        <div class="form-group">
                                                            <label class="col-xs-12 col-md-4" for="tenantName"> <cv:msg
                                                                    key="label.azureDirectoryID" bundle="exchange"></cv:msg>
                                                            </label>
                                                            <div class="col-xs-12 col-md-8">
                                                                <div>
                                                                    <input type="text" id="tenantName" name="tenantName" required
                                                                        placeholder='<cv:msg key="label.help.azureDirectoryID" bundle="exchange"/>'                        
                                                                        data-ng-model="addOffice365App.createClientAttr.clientInfo.cloudClonnectorProperties.instance.cloudAppsInstance.v2CloudAppsInstance.azureAppList.azureApps[0].azureDirectoryId" />
                                                                </div>
                                                                <div class="help-block"
                                                                        data-ng-if="!addOffice365App.createClientAttr.clientInfo.cloudClonnectorProperties.instance.cloudAppsInstance.v2CloudAppsInstance.azureAppList.azureApps[0].azureDirectoryId.length"
                                                                        data-ng-show="cv.addOffice365Form.needsAttention(addOffice365Form.tenantName) || addOffice365App.isTokenRequestSubmitted">
                                                                    <cv:msg key="label.azureTenantIdRequired" bundle="exchange" />
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!-- Azure AD App Details --Added Manually-- End-->
                                                </div>

                                            <!--Connection info header-->
                                            <label  
                                                class="font-weight-bold" 
                                                data-ng-bind="addOffice365App.connectionRequirementsHeader">
                                            </label>
                                            <!--Connection info header-->
                                            <!--Confirmation checkboxes -->
                                            <div class="form-group margin-left-25">
                                                <cv-checkbox-group 
                                                    id="confirm-actions-checkbox-label"
                                                    check-obj="addOffice365App.confirmChkOptionsList" 
                                                    output-model="addOffice365App.confirmedChkOptions" 
                                                    is-vertical="true"
                                                    is-disabled="addOffice365App.generalAttributes.isTokenAcquiredManually" 
                                                    on-click-checkbox="addOffice365App.onClickConfirmationCheckbox(data)">
                                                </cv-checkbox-group>
                                                <div class="help-block margin-top-5"
                                                    data-ng-show="addOffice365App.showAzureErrorMsg"
                                                    data-ng-bind-html="addOffice365App.createAzureApp.appCreationError">
                                                </div>
                                            </div>
                                            <!--Confirmation checkboxes -->

                                                <!--Acquire Token info header-->
                                                <label  
                                                    class="font-weight-bold"> 
                                                    <cv:msg key="label.acquireToken" bundle="office365" />
                                                </label>
                                                <!--Acquire Token info header-->

                                                <!-- MS Teams -- Acquire Token - Start-->
                                                <div class="form-group margin-left-25">
                                                    <cv-help-text class="col-xs-12 col-md-4 margin-top-10" help-label="label.token" help-text="label.token.helptext"/>
                                                     <div class="margin-top-10 col-xs-12 col-md-8">
                                                        <div data-ng-if="!addOffice365App.generalAttributes.isTokenAcquiredManually">
                                                            <a id="tokenStatus" name="tokenStatus"
                                                                data-ng-click="addOffice365App.acquireTokenManually()">
                                                                <i data-ng-if="!addOffice365App.manualTokenAcquisitionInProgress" class="k-icon k-i-hyperlink-open-sm margin-right-5"></i>
                                                                <i data-ng-if="addOffice365App.manualTokenAcquisitionInProgress" class="fa fa-spinner fa-spin margin-right-5"></i>
                                                                <cv:msg key="label.acquireToken" bundle="office365" />
                                                            </a>
                                                        </div>
                                                        <div data-ng-if="addOffice365App.generalAttributes.isTokenAcquiredManually">
                                                            <span id="tokenStatus" name="tokenStatus"										
                                                                class="float-left">
                                                                 <i class="k-icon k-i-check green-font"></i>
                                                                <cv:msg key="label.tokenAcquired" bundle="office365" />
                                                            </span>
                                                        </div>
                                                        <div class="help-block" data-ng-show="addOffice365Form.$submitted || addOffice365App.showTokenErrorMessage"
                                                            data-ng-if="!addOffice365App.generalAttributes.isTokenAcquiredManually"
                                                            data-ng-bind="addOffice365App.tokenErrorMessage">
                                                        </div>
                                                        <!--AcquireToken--License Error-->
                                                        <div class="margin-top-20" data-ng-if="addOffice365App.acquireTokenLicenseError">
                                                            <span class="red-font" data-ng-bind-html="addOffice365App.acquireTokenLicenseErrorMsg"></span>                                 
                                                        </div>
                                                        <!--AcquireToken--License Error-->
                                                    </div>
                                                </div>
                                                <!-- MS Teams -- Acquire Token - Start-->                                                
                                            <!-- Azure AD App + Service Account Details Required--Added Manually-- End-->                                               
                                            </div>
                                            <!--Add Azure app / Svc Accounts manually --END-->
                                        
                                    </div>
                                 </div>

                                <!-- Azure AD App Details --Global Admin--Start-->
                                <div
                                    data-ng-if="addOffice365App.generalAttributes.isGlobalLogin"
                                    class="col-xs-12 col-md-12 margin-bottom-10 padding-left-20 padding-right-20 padding-bottom-20">
                                    <div class="form-group">
                                        <div class="col-xs-12 col-md-12 margin-top-10">
                                            <cv-progress-stepper 
                                                input-model="addOffice365App.azureAppStepperModel" 
                                                progress="addOffice365App.appCreationProgress"
                                                on-click="addOffice365App.stepperCallback()">
                                            </cv-progress-stepper>
                                        </div>
                                    </div>
                                </div>
                                <!-- Azure AD App Details --Global Admin--End-->                                                         
                            </div>
                    </div>
                    <!--Acquire Token License Error-->
                    <div class="padding-15 margin-left-10 margin-top-10 margin-right-10" data-ng-if="addOffice365App.generalAttributes.isGlobalLogin && addOffice365App.acquireTokenLicenseError">
                        <span class="red-font" data-ng-bind-html="addOffice365App.acquireTokenLicenseErrorMsg"></span>                                 
                        <a data-ng-bind-html="addOffice365App.retryAppAuthAndTokenOpText" data-ng-click="addOffice365App.retryAppAuthorizationFromTokenFailure()"></a>
                    </div>
                    <!--Acquire Token License Error-->
                </div>
                <!-- END Office365 Connection Settings-->


                 <!-- START Client creation error msg-->
                <span class="text-danger incomplete" data-ng-if="addOffice365App.clientCreationFailed" ng-bind="addOffice365App.clientCreationError"></span>
                
				<!-- Buttons -->
				<div class="button-container padding-0">
					<button id="createOffice365App_button_#7924" type="submit" 
						class="btn btn-primary margin-right-0 cvBusyOnAjax"
						data-ng-disabled="addOffice365App.processingRequest || addOffice365App.azureAppCreationInProgress">
                        <cv:msg key="label.client.create" bundle="office365" />
						<i data-ng-if="addOffice365App.processingRequest"
							class="fa fa-spinner fa-spin"></i>
					</button>
				</div>
				<!-- Buttons -->
			</form>
		</div>
	</div>
	<script src="${pageContext.request.contextPath}/common/js/encoder.js"></script>
</div>
