<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
    <cv:cvMessages bundle="localization.office365"></cv:cvMessages>
</script>

<form data-cv-submit="createIndexServerCtrl.add()" cv-hide-api name="addIndexServerForm" class="form-horizontal bootstrap-wrapper" novalidate>
	<div class="modal-header">
		<h1 class="modal-title"> <cv:msg key="label.newIndexServer" bundle="office365" /> </h1>
	</div>
	<div class="modal-body">
		<div class="row">
			<div class="col-xs-12 col-md-4 margin-top-10">
				<label class="less-margin margin-top-10">
					<span class="label-spacer">
						<cv:msg key="label.indexServerName" bundle="office365" />
					</span>
				</label>
			</div>
			<div class="col-xs-12 col-md-8">
				<input type="text" name="newIndexServerName" id="newIndexServerName"
						data-ng-disabled="createIndexServerCtrl.processingRequest"
						data-ng-model="createIndexServerCtrl.newIndexServerName" required data-ng-pattern="/^[a-zA-Z0-9_-]*$/" />
				<div data-ng-if="cv.addIndexServerForm.needsAttention(addIndexServerForm.newIndexServerName)"
					class="help-block margin-left-0" >
					<cv:msg key="error.validIndexSeverName" bundle="office365" />
				</div>
			</div>
		</div>
		<div class="row margin-top-10">		
			<cv-help-text class="col-xs-12 col-md-4 less-margin margin-top-10" help-label="label.indexServerNodes" help-text="helptext.index.server.node"/>
			<div class="col-xs-12 col-md-8">
				<isteven-multi-select
					id="createIndexServer_isteven-multi-select_#2168"
					input-model="createIndexServerCtrl.cloudClientList"
					output-model="createIndexServerCtrl.selectedCloudClientList"
					button-label="clientName"
					item-label="clientName"
					selection-mode={{createIndexServerCtrl.selectionMode}}
					helper-elements="filter"
					disable-property="disabled"
					directive-id="'cloudClientList'"
					max-labels="4"
					on-item-click="createIndexServerCtrl.processIndexCloudNodeSelection()"
					tick-property="selected"
					translation="createIndexServerCtrl.localLang">
				</isteven-multi-select>
				<div data-ng-if="addIndexServerForm.$submitted" class="help-block margin-left-0"
					data-ng-show="!createIndexServerCtrl.selectedCloudClientList.length">
					<cv:msg key="placeholder.selectClient" bundle="profiles" />
				</div>
			</div>
		</div>

		<div data-ng-repeat="node in createIndexServerCtrl.selectedCloudClientList">
			<div class="row margin-top-10">
				<div class="col-xs-12 col-md-4">
					<label class="less-margin margin-top-10"><span class="label-spacer">
							<cv:msg key="label.indexDirectory" bundle="profiles" /></span> 
							<br><span class="optional-text">{{node.clientName}}</span></label>
				</div>
				<div class="col-xs-12 col-md-8">
					<div class="input-group">
						<input type="text" name={{node.clientName}} id={{node.clientName}}
							data-ng-disabled="!node.clientId || createIndexServerCtrl.processingRequest"
							data-ng-model="node.indexCachePath" required data-ng-pattern='pathPattern' />
						<span class="input-group-btn" data-ng-disabled="!node.clientId">
							<button id="createIndexServer_button_#3718" type="button"
								data-ng-click="createIndexServerCtrl.browse(node.clientId, $index)"
								class="icon-style cv-material-button browse">
								<div class="cv-material-button-icon cursor-pointer">
									<svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
										<path d="M0 0h24v24H0z" fill="none" />
										<path d="M19 4H5c-1.11 0-2 .9-2 2v12c0 1.1.89 2 2 2h4v-2H5V8h14v10h-4v2h4c1.1 0 2-.9 2-2V6c0-1.1-.89-2-2-2zm-7 6l-4 4h3v6h2v-6h3l-4-4z" />
									</svg>
								</div>
								<div class="cv-material-button-tooltip">
									<cv:msg key="Browse" bundle="storage" />
								</div>
							</button>
						</span>
					</div>
					<div data-ng-if="addIndexServerForm.$submitted && !node.indexCachePath.length"
						class="help-block margin-left-0">
						<cv:msg key="error.noIndexDirectory" bundle="exchange" />
					</div>
				</div>
			</div>
		</div>

	</div>
	<div class="modal-footer">
		<button id="cancel" class="btn btn-default cvBusyOnAjax" type="button" data-ng-click="createIndexServerCtrl.cancel()">
			<cv:msg key="Cancel" bundle="messages" />
		</button>
		<button id="add" class="btn btn-primary cvBusyOnAjax" type="submit">
			<cv:msg key="Add" bundle="messages" />
			<i data-ng-if="createIndexServerCtrl.processingRequest"
							class="fa fa-spinner fa-spin"></i>
		</button>
	</div>
</form>
