<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
    <cv:cvMessages bundle="localization.office365"></cv:cvMessages>
    <cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
    <cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
</script>
<form
	class="bootstrap-wrapper"
	data-cv-submit="addOffice365AccountCtrl.saveChanges()"
	name="addOffice365AccountForm"
	id="addOffice365AccountForm"
	novalidate
    cv-hide-api
	autocomplete="off"
>
	<div class="modal-header">
		<h1 data-ng-bind="addOffice365AccountCtrl.headerTitle"></h1>
	</div>
	<!--End --Modal Header-->
	<div class="modal-body-fixed masked padding-left-20 padding-top-10 padding-bottom-10 padding-right-20">

		<div
			data-ng-if="addOffice365AccountCtrl.showServiceAccountSelection"
			class="margin-top-10"
			data-ng-class="!addOffice365AccountCtrl.showExpressCustomRadioOptions ? 'margin-bottom-15' : ''">
			<div class="row" data-ng-disabled="addOffice365AccountCtrl.disableServiceAccountSelection">
				<label class="col-xs-12 col-lg-4 margin-top-10">
					<cv:msg key="label.serviceType" bundle="exchange" />
				</label>
				<div class="col-xs-12 col-lg-8">
					<isteven-multi-select
						input-model="addOffice365AccountCtrl.serviceAccountTypes"
						output-model="addOffice365AccountCtrl.selectedServiceAccountType"
						button-label="display"
						item-label="display"
						selection-mode="single"
						max-labels="1"
						on-item-click="addOffice365AccountCtrl.processServiceAccountTypeSelection()"
						tick-property="selected"
						translation="addOffice365AccountCtrl.localLang"
					></isteven-multi-select> 
				</div>
			</div>
		</div>

		<div
			data-ng-if="addOffice365AccountCtrl.showExpressCustomRadioOptions"
			data-ng-class="addOffice365AccountCtrl.showServiceAccountSelection ? 'margin-top-10' : ''">
			<cv-radio-group ng-if="!addOffice365AccountCtrl.isEdit"
				is-vertical="true" 
				radio-model="addOffice365AccountCtrl.office365AccountCreationOptionVal" 
				radio-obj="addOffice365AccountCtrl.office365AccountCreationOptions"
				is-disabled="addOffice365AccountCtrl.appCreationInProgress || addOffice365AccountCtrl.saveInProgress || addOffice365AccountCtrl.isAzureAppCreatedUsingGlobalAdmin"
				on-click="addOffice365AccountCtrl._office365AccountCreationOptionValChange(data)">
            </cv-radio-group>
        </div>
        
        <div class="margin-left-10" data-ng-if="
        addOffice365AccountCtrl.getBothAzureAppServiceAccManually && 
        !addOffice365AccountCtrl.createAppSvcAccountUsingGlobalAdmin && 
        addOffice365AccountCtrl.cloudAppUIAttributes.requiresToken && 
        addOffice365AccountCtrl.mode === 'AZURE_APP'">
            <!-- Azure App --Added Manually - Start-->
            <div class="form-group">
                <label class="col-xs-12 col-lg-4 margin-top-10 margin-bottom-0" for="mAzureApplicationId"><cv:msg
                        key="label.azureAppDetails" bundle="exchange"></cv:msg></label>
                <div class="col-xs-12 col-lg-8 margin-top-5 margin-bottom-0">
                    <div data-ng-if="!addOffice365AccountCtrl.isAzureAppSetManually">
                        <a
                            data-ng-click="addOffice365AccountCtrl.addEditServiceAccount(addOffice365AccountCtrl.office365Constants.manualSubMode.AZURE_AD, false, false, false)" class="padding-5 inline-block">
                            <i class="fa fa-pencil margin-right-5"></i>
                            <cv:msg key="label.option.addAzureAppManually" bundle="office365" />
                        </a>
                    </div>

                    <div data-ng-if="addOffice365AccountCtrl.isAzureAppSetManually">
                        <a id="mAzureApplicationId" name="mAzureApplicationId"
                            data-ng-click="addOffice365AccountCtrl.addEditServiceAccount(addOffice365AccountCtrl.office365Constants.manualSubMode.AZURE_AD, true, false, true)"										
                            class="float-left padding-5 inline-block" ng-bind="addOffice365AccountCtrl.azureApp.azureAppId">
                        </a>
                    </div>
                    <div class="help-block" data-ng-show="addOffice365Form.$submitted"
                        data-ng-if="!addOffice365AccountCtrl.isAzureAppSetManually">
                        <cv:msg key="error.addAzureAppManually" bundle="office365" />
                    </div>
                </div>
            </div>
            <!--  Azure App --Added Manually - End-->
                
            <!-- Service Accounts --Added Manually - Start-->
            <div class="form-group">
                <label class="col-xs-12 col-lg-4 margin-top-10 margin-bottom-0" for="serviceAccounts"><cv:msg
                        key="label.addO365ServiceAccount" bundle="exchange"></cv:msg></label>
                <div class="col-xs-12 col-lg-8 margin-top-5 margin-bottom-0">
                    <div data-ng-if="!addOffice365AccountCtrl.isServiceAccountSet">
                        <a
                            data-ng-click="addOffice365AccountCtrl.addEditServiceAccount(addOffice365AccountCtrl.office365Constants.manualSubMode.EXCHANGE_ONLINE, false, false, false)" class="padding-5 inline-block">
                            <i class="fa fa-pencil margin-right-5"></i>
                            <cv:msg key="label.option.addServiceAccountManually" bundle="office365" />
                        </a>
                    </div>
                    <div data-ng-if="addOffice365AccountCtrl.isServiceAccountSet">
                        <a id="manuallyAddedServiceAcc" name="manuallyAddedServiceAcc"
                            data-ng-click="addOffice365AccountCtrl.addEditServiceAccount(addOffice365AccountCtrl.office365Constants.manualSubMode.EXCHANGE_ONLINE, true, false, true)"										
                            class="float-left padding-5 inline-block" ng-bind="addOffice365AccountCtrl.manuallyAddedServiceAcc.AdminSmtpAddress">
                        </a>
                    </div>
                    <div class="help-block" data-ng-show="addOffice365Form.$submitted" data-ng-if="!addOffice365AccountCtrl.isServiceAccountSet">
                        <cv:msg key="dialog.header.serviceaccount.title" bundle="office365" />
                    </div>
                </div>
            </div>
            <!--  Service Accounts --Added Manually - End-->

            <!-- MS Teams -- Acquire Token - Start-->
            <div class="form-group">
                <label class="col-xs-12 col-lg-4 margin-top-10 margin-bottom-0" for="tokenStatus"><cv:msg
                        key="label.token" bundle="office365"></cv:msg></label>
                <div class="col-xs-12 col-lg-8 margin-top-5 margin-bottom-0">
                    <div data-ng-if="!addOffice365AccountCtrl.cloudAppUIAttributes.isTokenAcquiredManually">
                        <a id="tokenStatus" name="tokenStatus" class="padding-5 inline-block"
                            data-ng-click="addOffice365AccountCtrl.acquireTokenManually()">
                            <i data-ng-if="!addOffice365AccountCtrl.manualTokenAcquisitionInProgress" class="k-icon k-i-hyperlink-open-sm margin-right-5"></i>
                            <i data-ng-if="addOffice365AccountCtrl.manualTokenAcquisitionInProgress" class="fa fa-spinner fa-spin margin-right-5"></i>
                            <cv:msg key="label.acquireToken" bundle="office365" />
                        </a>
                    </div>
                    <div data-ng-if="addOffice365AccountCtrl.cloudAppUIAttributes.isTokenAcquiredManually">
                        <span id="tokenStatus" name="tokenStatus"										
                            class="float-left">
                                <i class="k-icon k-i-check green-font"></i>
                            <cv:msg key="label.tokenAcquired" bundle="office365" />
                        </span>
                    </div>
                    <div class="help-block" data-ng-show="addOffice365Form.$submitted || addOffice365AccountCtrl.showTokenErrorMessage"
                        data-ng-if="!addOffice365AccountCtrl.cloudAppUIAttributes.isTokenAcquiredManually && !addOffice365AccountCtrl.createAppSvcAccountUsingGlobalAdmin && addOffice365AccountCtrl.cloudAppUIAttributes.requiresToken"
                        data-ng-bind="addOffice365AccountCtrl.tokenErrorMessage">
                    </div>
                </div>
            </div>
            <!-- MS Teams -- Acquire Token - Start-->
            
        </div>
            
        <!--Add Azure app manually-->
        <div data-ng-if="(
            !addOffice365AccountCtrl.createAppSvcAccountUsingGlobalAdmin && 
            addOffice365AccountCtrl.mode === 'AZURE_APP' && 
            (!addOffice365AccountCtrl.cloudAppUIAttributes.requiresToken ||
            !addOffice365AccountCtrl.getBothAzureAppServiceAccManually))" class="margin-left-10">
            <div class="form-group">
                <label class="col-xs-12 col-lg-4" for="applicationId"> <cv:msg
                        key="label.applicationId" bundle="exchange"></cv:msg>
                </label>
                <div class="col-xs-12 col-lg-8">
                    <input type="text" id="applicationId" name="applicationId" required
                        placeholder='<cv:msg key="placeholder.azureAppId" bundle="office365"/>'
                        data-ng-disabled="addOffice365AccountCtrl.isEdit"
                        data-ng-model="addOffice365AccountCtrl.azureApp.azureAppId" />
                    <div class="help-block"
                            data-ng-show="cv.addOffice365AccountForm.needsAttention(addOffice365AccountForm.applicationId)">
                        <cv:msg key="label.appIdRequired" bundle="exchange" />
                    </div>
                </div>		
            </div>

            <div class="form-group">
                <label class="col-xs-12 col-lg-4" for="secretAccessKey"> <cv:msg
                        key="label.azureAppSecret" bundle="office365"></cv:msg>
                </label>
                <div class="col-xs-12 col-lg-8">
                    <input type="password" id="secretAccessKey" name="secretAccessKey" required
                        placeholder='<cv:msg key="placeholder.azureAppSecret" bundle="office365" />'
                        data-ng-model="addOffice365AccountCtrl.azureApp.azureAppKeyValue" />
                    <div class="help-block"
                            data-ng-show="cv.addOffice365AccountForm.needsAttention(addOffice365AccountForm.secretAccessKey)">
                        <cv:msg key="label.appSecretRequired" bundle="exchange" />
                    </div>
                </div>		
            </div>

            <div class="form-group">
                <label class="col-xs-12 col-lg-4" for="tenantName"> <cv:msg
                        key="label.azureDirectoryID" bundle="exchange"></cv:msg>
                </label>
                <!-- <label class="col-xs-12 col-lg-8 margin-bottom-20" ng-if="addOffice365AccountCtrl.azureDirectoryId.length > 0"
                    data-ng-bind="addOffice365AccountCtrl.azureApp.azureDirectoryId">
                </label> -->
                <div class="col-xs-12 col-lg-8">
                    <input type="text" id="azureDirID" name="azureDirID" required
                        placeholder='<cv:msg key="label.help.azureDirectoryID" bundle="exchange" />'
                        data-ng-disabled="addOffice365AccountCtrl.isEdit"
                        data-ng-model="addOffice365AccountCtrl.azureApp.azureDirectoryId" />
                    <div class="help-block"
                            data-ng-show="cv.addOffice365AccountForm.needsAttention(addOffice365AccountForm.azureDirID)">
                        <cv:msg key="label.appSecretRequired" bundle="exchange" />
                    </div>
                </div>	
            </div>

            <!-- MS Teams -- Acquire Token - Start-->
            <div class="form-group" data-ng-if="addOffice365AccountCtrl.cloudAppUIAttributes.requiresToken">
                <label class="col-xs-12 col-md-4" for="tokenStatus"><cv:msg
                        key="label.token" bundle="office365" /></label>
                 <div class="margin-top-10 col-xs-12 col-md-8">
                    <div data-ng-if="!addOffice365AccountCtrl.cloudAppUIAttributes.isTokenAcquiredManually">
                        <a id="tokenStatus" name="tokenStatus"
                            data-ng-click="addOffice365AccountCtrl.acquireTokenManually()">
                            <i data-ng-if="!addOffice365AccountCtrl.manualTokenAcquisitionInProgress" class="k-icon k-i-hyperlink-open-sm margin-right-5"></i>
                            <i data-ng-if="addOffice365AccountCtrl.manualTokenAcquisitionInProgress" class="fa fa-spinner fa-spin margin-right-5"></i>
                            <cv:msg key="label.acquireToken" bundle="office365" />
                        </a>
                    </div>
                    <div data-ng-if="addOffice365AccountCtrl.cloudAppUIAttributes.isTokenAcquiredManually">
                        <span id="tokenStatus" name="tokenStatus"										
                            class="float-left">
                             <i class="k-icon k-i-check green-font"></i>
                            <cv:msg key="label.tokenAcquired" bundle="office365" />
                        </span>
                    </div>
                    <div class="help-block" data-ng-show="addOffice365Form.$submitted || addOffice365AccountCtrl.showTokenErrorMessage"
                        data-ng-if="!addOffice365AccountCtrl.cloudAppUIAttributes.isTokenAcquiredManually && !addOffice365AccountCtrl.createAppSvcAccountUsingGlobalAdmin && addOffice365AccountCtrl.cloudAppUIAttributes.requiresToken"
                        data-ng-bind="addOffice365AccountCtrl.tokenErrorMessage">
                    </div>
                </div>
            </div>
            <!-- MS Teams -- Acquire Token - Start-->

        </div>
        <!--Add Azure app manually --END-->

        <!--Add Exchange Online service account manually --START-->
        <div data-ng-if="!addOffice365AccountCtrl.createAppSvcAccountUsingGlobalAdmin && addOffice365AccountCtrl.mode === 'SERVICE_ACCOUNT'"
			data-ng-class="addOffice365AccountCtrl.showExpressCustomRadioOptions ? 'margin-left-10' : ''">
            <div class="form-group" data-ng-class="!addOffice365AccountCtrl.showExpressCustomRadioOptions ? 'row' : ''">
                <label class="col-xs-12 col-lg-4" for="exchangeAdminSmtpAddress">
                    <cv:msg key="label.emailAddress" bundle="exchange"></cv:msg>
                </label>
                <div class="col-xs-12 col-lg-8">
                    <input type="email" id="exchangeAdminSmtpAddress"
                        name="exchangeAdminSmtpAddress"
                        data-ng-model="addOffice365AccountCtrl.serviceAccount.exchangeAdminSmtpAddress"
                        placeholder='<cv:msg key="label.emailAddressPlaceholder" bundle="exchange"></cv:msg>'
                        required />
                    <div class="help-block"
                        data-ng-show="cv.addOffice365AccountForm.needsAttention(addOffice365AccountForm.exchangeAdminSmtpAddress)">
                        <cv:msg key="error.noEmail" bundle="exchange" />
                    </div>
                </div>
            </div>

			<div data-ng-if="addOffice365AccountCtrl.showUserNameInput" class="form-group" data-ng-class="!addOffice365AccountCtrl.showExpressCustomRadioOptions ? 'row' : ''">
				<label class="col-xs-12 col-lg-4" for="userName">
					<cv:msg key="label.userName" bundle="exchange" />
				</label>
				<div class="col-xs-12 col-lg-8">
					<input
						type="text"
						id="userName"
						name="userName"
						data-ng-model="addOffice365AccountCtrl.serviceAccount.userAccount.userName"
						placeholder='<cv:msg key="label.helptextDomain" bundle="serversJs"></cv:msg>\<cv:msg key="label.helpTextUsername" bundle="serversJs"></cv:msg>'
						required
					/>
					<div class="help-block" data-ng-show="cv.addOffice365AccountForm.needsAttention(addOffice365AccountForm.userName)">
						<cv:msg key="error.noUserName" bundle="exchange" />
					</div>
				</div>
			</div>

            <div class="form-group" data-ng-class="!addOffice365AccountCtrl.showExpressCustomRadioOptions ? 'row' : ''">
                <label class="col-xs-12 col-lg-4" for="password">
                    <cv:msg key="label.password" bundle="exchange" />
                </label>
                <div class="col-xs-12 col-lg-8">
                    <input type="password" name="password" id="password"
                        data-ng-model="addOffice365AccountCtrl.serviceAccount.userAccount.password"
                        required />
                    <div class="help-block"
                        data-ng-show="cv.addOffice365AccountForm.needsAttention(addOffice365AccountForm.password)">
                        <cv:msg key="error.noPassword" bundle="exchange" />
                    </div>
                </div>
            </div>

            <div class="form-group" data-ng-class="!addOffice365AccountCtrl.showExpressCustomRadioOptions ? 'row' : ''">
                <label class="col-xs-12 col-lg-4 margin-bottom-20" for="confirmPassword">
                    <cv:msg key="label.confirmPassword" bundle="exchange" />
                </label>
                <div class="col-xs-12 col-lg-8 margin-bottom-20">
                    <input type="password" name="confirmPassword" id="confirmPassword"
                        data-ng-model="addOffice365AccountCtrl.serviceAccount.userAccount.confirmPassword"
                        data-cv-equals="{{addOffice365AccountCtrl.serviceAccount.userAccount.password}}"
                        required />
                    <div class="help-block"
                        data-ng-show="addOffice365AccountForm.confirmPassword.$error.required && cv.addOffice365AccountForm.needsAttention(addOffice365AccountForm.confirmPassword)">
                        <cv:msg key="error.noConfirmPassword" bundle="exchange" />
                    </div>
                    <div class="help-block"
                        data-ng-show="!addOffice365AccountForm.confirmPassword.$error.required && addOffice365AccountForm.confirmPassword.$error.cvEquals && cv.addOffice365AccountForm.needsAttention(addOffice365AccountForm.confirmPassword)">
                        <cv:msg key="error.mismatchedPassword" bundle="exchange" />
                    </div>
                </div>
            </div>
        </div>
        <!--Add Exchange Online service account manually --END-->
        
        <!--Add GLOBAL Admin --START-->
		<div data-ng-if="addOffice365AccountCtrl.createAppSvcAccountUsingGlobalAdmin && !addOffice365AccountCtrl.isGlobalAdminConfigured" class="margin-left-10">
            <div class="form-group">  
                <cv-call-out
                    class="margin-top-10 col-xs-12 col-md-4"
                    html-template="addOffice365AccountCtrl.getGlobalAdminUserNameCallOut()"
                    label='<cv:msg key="label.globalAdministrator" bundle="office365" />'
                    placement="right"
                    trigger="mouseenter"
                />         
                <!-- <cv-help-text class="col-xs-12 col-lg-4 margin-top-10" help-label="label.globalAdministrator" help-text="help.globalAdmin"/> -->
                <div class="col-xs-12 col-lg-8">
                    <input type="email" id="globalAdministrator" name="globalAdministrator" required
                        data-ng-model="addOffice365AccountCtrl.globalAdministratorServiceAccount.AdminSmtpAddress"
                        placeholder='<cv:msg key="label.emailAddressPlaceholder" bundle="exchange"/>'/>
                    <div class="help-block"
                        data-ng-show="cv.addOffice365AccountForm.needsAttention(addOffice365AccountForm.globalAdministrator)">
                        <cv:msg key="error.globalAppUsernameError" bundle="exchange" />
                    </div>
                </div>
            </div>
    
            <div class="form-group">
                <label class="col-xs-12 col-lg-4" for="password">
                    <cv:msg key="label.password" bundle="exchange" /></label>
                <div class="col-xs-12 col-lg-8">
                    <input type="password" name="password" id="password"  required
                        data-ng-model="addOffice365AccountCtrl.globalAdministratorServiceAccount.userAccount.password"/>
                    <div class="help-block"
                        data-ng-show="cv.addOffice365AccountForm.needsAttention(addOffice365AccountForm.password)">
                        <cv:msg key="error.noPassword" bundle="exchange" />
                    </div>
                </div>
            </div>
    
            <div class="form-group">
                <label class="col-xs-12 col-lg-4" for="confirmPassword">
                    <cv:msg key="label.confirmPassword" bundle="exchange" /></label>
                <div class="col-xs-12 col-lg-8">
                    <input type="password" name="confirmPassword" id="confirmPassword" required
                        data-ng-model="addOffice365AccountCtrl.globalAdministratorServiceAccount.userAccount.confirmPassword"
                        data-cv-equals="{{addOffice365AccountCtrl.globalAdministratorServiceAccount.userAccount.password}}"/>
                
                    <div class="help-block"
                        data-ng-show="addOffice365AccountForm.confirmPassword.$error.required && cv.addOffice365AccountForm.needsAttention(addOffice365AccountForm.confirmPassword)">
                        <cv:msg key="error.noConfirmPassword" bundle="exchange" />
                    </div>
                    
                    <div class="help-block"
                        data-ng-show="!addOffice365AccountForm.confirmPassword.$error.required && addOffice365AccountForm.confirmPassword.$error.cvEquals && cv.addOffice365AccountForm.needsAttention(addOffice365AccountForm.confirmPassword)">
                        <cv:msg key="error.mismatchedPassword" bundle="exchange" />
                    </div>
                </div>
            </div>
        </div>
        <!--Add GLOBAL Admin --END-->

        <!--Progress and Info (Service Account) --START-->
        <div data-ng-if="addOffice365AccountCtrl.createAppSvcAccountUsingGlobalAdmin && addOffice365AccountCtrl.mode === 'SERVICE_ACCOUNT'">
            <div class="form-group row margin-top-10 margin-bottom-10 margin-left-5 margin-right-5">    
                <div class="col-xs-12 col-md-12">
                    <div data-ng-if="!addOffice365AccountCtrl.isGlobalAdminConfigured">
                        <!--Progress stepper--START-->
                        <cv-progress-stepper 
                            input-model="addOffice365AccountCtrl.serviceAccountStepperModel">
                        </cv-progress-stepper>
                        <!--Progress stepper--END-->
    
                        <div class="help-block margin-top-20" data-ng-if="addOffice365AccountCtrl.appCreationError.length">
                            <label data-ng-bind-html="addOffice365AccountCtrl.appCreationError"></label> 
                        </div>
                    </div>

                    <div class="input-group" data-ng-if="addOffice365AccountCtrl.isGlobalAdminConfigured">
                        <span class="input-group-btn">
                            <svg
                                version="1.1"
                                id="cv_cc"
                                xmlns="http://www.w3.org/2000/svg"
                                xmlns:xlink="http://www.w3.org/1999/xlink"
                                x="0px"
                                y="0px"
                                viewBox="0 0 432.4 432.4"
                                style="enable-background:new 0 0 432.4 432.4;"
                                height="25px"
                                width="25px"
                                xml:space="preserve"
                            >
                                <path
                                    style="fill:#0B2E44;"
                                    d="M216.529,93.2c-61.2,0-111.2,50-111.2,111.2c0,32,14,62.8,37.6,83.6c17.6,17.6,16,55.2,15.6,55.6
                                    c0,2,0.4,3.6,2,5.2c1.2,1.2,3.2,2,4.8,2h102c2,0,3.6-0.8,4.8-2c1.2-1.2,2-3.2,2-5.2c0-0.4-2-38,15.6-55.6
                                    c0.4-0.4,0.8-0.8,1.2-1.2c23.2-21.2,36.8-51.2,36.8-82.4C327.729,143.2,277.729,93.2,216.529,93.2z M280.529,277.6
                                    c-0.4,0.4-1.2,1.2-1.2,1.6c-15.6,16.8-18.4,44.4-18.8,57.6h-88.4c-0.4-13.2-3.2-42-20-59.2c-21.2-18.4-33.6-45.2-33.6-73.6
                                    c0-54,43.6-97.6,97.6-97.6s97.6,43.6,97.6,97.6C313.729,232.4,301.729,259.2,280.529,277.6z"
                                />
                                <path
                                    style="fill:#0B2E44;"
                                    d="M216.129,121.6c-3.6,0-6.8,3.2-6.8,6.8c0,3.6,3.2,6.8,6.8,6.8c40.4,0,72.8,32.8,72.8,72.8
                                    c0,3.6,3.2,6.8,6.8,6.8c3.6,0,6.8-3.2,6.8-6.8C302.929,160.4,264.129,121.6,216.129,121.6z"
                                />
                                <path
                                    style="fill:#0B2E44;"
                                    d="M260.529,358.4h-88.8c-9.2,0-16.8,7.6-16.8,16.8s7.6,16.8,16.8,16.8h88.4
                                    c9.6-0.4,17.2-7.6,17.2-16.8C277.329,366,269.729,358.4,260.529,358.4z M260.529,378h-88.8c-1.6,0-3.2-1.2-3.2-3.2
                                    s1.2-3.2,3.2-3.2h88.4c1.6,0,3.2,1.2,3.2,3.2S262.129,378,260.529,378z"
                                />
                                <path
                                    style="fill:#0B2E44;"
                                    d="M247.329,398.8h-62.4c-9.2,0-16.8,7.6-16.8,16.8s7.6,16.8,16.8,16.8h62.4
                                    c9.2,0,16.8-7.6,16.8-16.8C264.129,406,256.529,398.8,247.329,398.8z M247.329,418.4h-62.4c-1.6,0-3.2-1.2-3.2-3.2
                                    s1.2-3.2,3.2-3.2h62.4c1.6,0,3.2,1.2,3.2,3.2S248.929,418.4,247.329,418.4z"
                                />
                                <path
                                    style="fill:#0B2E44;"
                                    d="M216.129,60c4,0,6.8-3.2,6.8-6.8V6.8c0-3.6-3.2-6.8-6.8-6.8c-3.6,0-6.8,3.2-6.8,6.8v46.4
                                    C209.329,56.8,212.529,60,216.129,60z"
                                />
                                <path
                                    style="fill:#0B2E44;"
                                    d="M329.329,34.4c-3.2-2.4-7.2-1.2-9.2,1.6l-25.6,38.4c-2.4,3.2-1.6,7.6,1.6,9.6
                                    c1.2,0.8,2.4,1.2,3.6,1.2c2.4,0,4.4-1.2,5.6-3.2l25.6-38.4C333.329,40.8,332.529,36.4,329.329,34.4z"
                                />
                                <path
                                    style="fill:#0B2E44;"
                                    d="M134.929,83.6c1.2,0,2.4-0.4,3.6-1.2c3.2-2,4-6.4,2-9.6l-24.8-38.8c-2-3.2-6.4-4-9.6-2
                                    s-4,6.4-2,9.6l24.8,38.8C130.529,82.8,132.529,83.6,134.929,83.6z"
                                />
                                <path
                                    style="fill:#0B2E44;"
                                    d="M86.529,126l-40.4-22c-3.2-1.6-7.6-0.4-9.2,2.8c-2,3.2-0.8,7.6,2.8,9.2l40.4,22
                                    c1.2,0.4,2,0.8,3.2,0.8c2.4,0,4.8-1.2,6-3.6C90.929,132,89.729,127.6,86.529,126z"
                                />
                                <path
                                    style="fill:#0B2E44;"
                                    d="M395.729,106.8c-1.6-3.2-6-4.4-9.2-2.8l-40.8,22c-3.2,1.6-4.4,6-2.8,9.2c1.2,2.4,3.6,3.6,6,3.6
                                    c1.2,0,2.4-0.4,3.2-0.8l40.8-22C396.129,114.4,397.329,110,395.729,106.8z"
                                />
                            </svg>
                        </span>
                        <span>
                            <label class="cv-material-label">
                                <span data-ng-bind="addOffice365AccountCtrl.serviceAccountTip"></span>
                            </label>
                        </span>
                    </div>
                </div>
            </div>
        </div>
        <!--Progress and Info (Service Account) --END-->

        <!--Progress and Info (Azure App) --START-->
        <div data-ng-if="(addOffice365AccountCtrl.createAppSvcAccountUsingGlobalAdmin && addOffice365AccountCtrl.mode === 'AZURE_APP') || (!addOffice365AccountCtrl.createAppSvcAccountUsingGlobalAdmin && addOffice365AccountCtrl.mode === 'AZURE_APP' && addOffice365AccountCtrl.cloudAppUIAttributes.requiresToken && !addOffice365AccountCtrl.isEdit)">
            <div class="form-group row margin-top-10 margin-bottom-10 margin-left-5 margin-right-5">    
                <div class="col-xs-12 col-md-12">
                        <!--Progress stepper--START-->         
                        <cv-progress-stepper 
                            input-model="addOffice365AccountCtrl.azureAppStepperModel" 
                            progress="addOffice365AccountCtrl.appCreationProgress"
                            on-click="addOffice365AccountCtrl.stepperCallback()">
                        </cv-progress-stepper>
                        <!--Progress stepper--END-->
    
                    <div class="help-block margin-top-20" data-ng-if="addOffice365AccountCtrl.appCreationError.length">
                        <label data-ng-bind-html="addOffice365AccountCtrl.appCreationError"></label> 
                    </div>
    
                    <div class="help-block margin-top-20" data-ng-if="addOffice365AccountCtrl.genericError.length">
                        <i class="k-icon k-i-exception margin-right-5"></i>
                        <label data-ng-bind="addOffice365AccountCtrl.genericError"></label>
                    </div>          
                </div>
            </div>
            <div data-ng-if="addOffice365AccountCtrl.azureAppCreationSuccess" class="form-group margin-top-30">
                <div class="col-xs-12 col-md-9">
                    <span class="float-left small italic" data-ng-if="addOffice365AccountCtrl.authRetryCount >= 2 && !addOffice365AccountCtrl.isAzureAppAuthorized">
                        <cv:msg key="confirm.appAuthorized" bundle="office365" />
                        <a class="margin-left-5" data-ng-click="addOffice365AccountCtrl.appAuthorizedOverride()">
                            <cv:msg key="button.yes" bundle="messages"></cv:msg>
                        </a>
                        <a class="margin-left-5" data-ng-click="addOffice365AccountCtrl._loginToMicrosoftAzure()">
                            <cv:msg key="button.no" bundle="messages"></cv:msg>
                        </a>
                    </span>
                </div>
                <div class="col-xs-12 col-md-3"></div>
            </div>

            <div data-ng-show="addOffice365Form.$submitted || addOffice365AccountCtrl.showTokenErrorMessage"
                data-ng-if="!addOffice365AccountCtrl.cloudAppUIAttributes.isTokenAcquiredManually && addOffice365AccountCtrl.cloudAppUIAttributes.requiresToken">
                <span class="error">
                    <label class="display-inline" data-ng-bind="addOffice365AccountCtrl.tokenErrorMessage">  </label> 
                    <a class="margin-left-5" data-ng-click="addOffice365AccountCtrl._authorizeAzureApp(true)">
                        <cv:msg key="label.retry" bundle="office365"></cv:msg>
                    </a>
                </span>
            </div>
            <div class="form-group margin-top-20" data-ng-if="!addOffice365AccountCtrl.isAzureAppAuthorized && (addOffice365AccountCtrl.readyForAuthorize || addOffice365AccountCtrl.skipAppSync) && addOffice365AccountCtrl.azureApplicationDisplayName.length">
                <label class="cvStepper-info-text"data-ng-bind-html="addOffice365AccountCtrl.appProgressInfoText"></label>      
            </div>
    
            <div class="form-group margin-top-20" data-ng-if="addOffice365AccountCtrl.isAzureAppAuthorized && addOffice365AccountCtrl.azureApplicationDisplayName.length"> 
                <label class="cvStepper-info-text"data-ng-bind-html="addOffice365AccountCtrl.appAuthSuccessText"></label>
            </div>
        </div>
        <!--Progress and Info (Azure App) --END-->  
        
       
	</div>
	<!--End --Modal Body-->
	<div class="modal-footer">       
        <button id="close" class="btn btn-default cvBusyOnAjax" type="button" data-ng-click="addOffice365AccountCtrl.closeDialogAlert()"> 
            <cv:msg key="label.close" bundle="messagesJs" />
        </button>
        <button data-ng-show="addOffice365AccountCtrl.showAddButton"id="addAccount" class="btn btn-primary cvBusyOnAjax" data-ng-disabled="addOffice365AccountCtrl.appCreationInProgress" type="submit"> 
            <cv:msg key="Add" bundle="messages"></cv:msg>
        </button>  
        <button data-ng-if="addOffice365AccountCtrl.showSaveButton"id="addAccount" class="btn btn-primary cvBusyOnAjax" type="submit"> 
            <cv:msg key="Save" bundle="messages"></cv:msg>
        </button>
    </div>		
	<!--End --Modal Footer-->
</form>
