<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.office365"></cv:cvMessages>
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
	<cv:cvEnum name="App.MSCloudRegion"></cv:cvEnum>
</script>
<div class="office365-app-content">
<div class="row">
	<div class="col-md-12" ng-if="!O365ClientDetailsCtrl.isSharepointV1">
		<cv-changename obj='O365ClientDetailsCtrl.changeNameObj' service-method='changeServerName.do' class="float-left"></cv-changename>
		<div id="showAlertIcon" name="showAlertIcon" class="tile_count mini hidden">
			<span
				class="k-icon k-i-warning k-i-exception error"
				cv-toggle="tooltip"
				cv-toggle-content="this.indexErrorMessage"
			></span>
		</div>
		<div id="mailboxStats" name="mailboxStats" class="tile_count mini hidden"></div>
	</div>
	<div class="col-md-12" ng-if="O365ClientDetailsCtrl.isSharepointV1">
		<h1 class="float-left" data-ng-bind="O365ClientDetailsCtrl.clientName"></h1>
	</div>
</div>
<div class="row">
	<div class="col-md-12">
		<span class="server-message {{O365ClientDetailsCtrl.serverMessage.type}} text-center" data-ng-bind="O365ClientDetailsCtrl.serverMessage.message"></span>
	</div>
</div>
<cv-tab-nav></cv-tab-nav>

<div class="form-group">
	<div ng-if="O365ClientDetailsCtrl.tabType === 'overview'">
		<ng-include
			src="O365ClientDetailsCtrl.office365View"
			data-ng-controller="office365OverviewController as office365OverviewCtrl"
		></ng-include>
	</div>
	<div
		ng-if="O365ClientDetailsCtrl.clientAppType === O365ClientDetailsCtrl.office365Constants.office365AppID.EXCHANGE_ONLINE"
	>
		<div ng-if="O365ClientDetailsCtrl.tabType === 'content' || O365ClientDetailsCtrl.tabType === 'users' ">
			<ng-include
				src="O365ClientDetailsCtrl.office365View"
				data-ng-controller="exchangeMBBackupSetDetailsControllerV2 as mbBackupSetDetailsCtrl"
			></ng-include>
		</div>
		<div ng-if="O365ClientDetailsCtrl.tabType === 'configuration'">
			<ng-include
				src="O365ClientDetailsCtrl.office365View"
				data-ng-controller="exchangeMBSettingsControllerV2 as exchSettingsCtrl"
			></ng-include>
		</div>
		<div ng-if="O365ClientDetailsCtrl.tabType === 'recoveryPoints'">
			<ng-include
				src="O365ClientDetailsCtrl.office365View"
				data-ng-controller="recoveryPointsController as recoveryPointsCtrl"
			></ng-include>
		</div>
	</div>
	<div
		ng-if="O365ClientDetailsCtrl.clientAppType === O365ClientDetailsCtrl.office365Constants.office365AppID.CLOUD_APPS"
	>
		<div
		ng-if="O365ClientDetailsCtrl.cloudAppType === O365ClientDetailsCtrl.office365Constants.office365AppID.CLOUDAPP_ONEDRIVE">
			<!--OneDrive V2-->
			<div ng-if="O365ClientDetailsCtrl.isOffice365PseudoClient">
				<div ng-if="O365ClientDetailsCtrl.tabType === 'content' || O365ClientDetailsCtrl.tabType === 'users'">
					<ng-include
						src="O365ClientDetailsCtrl.office365View"
						data-ng-controller="office365OneDriveAppDetailsController as office365OneDriveAppDetailsCtrl"
					></ng-include>
				</div>
				<div ng-if="O365ClientDetailsCtrl.tabType === 'configuration'">
					<ng-include
						src="O365ClientDetailsCtrl.office365View"
						data-ng-controller="office365OneDriveSettingsController as office365OneDriveSettingsCtrl"
					></ng-include>
				</div>
			</div>
			<!--OneDrive Classic-->
			<div ng-if="!O365ClientDetailsCtrl.isOffice365PseudoClient">
				<div ng-if="O365ClientDetailsCtrl.tabType === 'content' || O365ClientDetailsCtrl.tabType === 'users'">
					<ng-include
						src="O365ClientDetailsCtrl.office365View"
						data-ng-controller="oneDriveClassicAppDetailsController as oneDriveClassicAppDetailsCtrl"
					></ng-include>
				</div>
				<div ng-if="O365ClientDetailsCtrl.tabType === 'configuration'">
					<ng-include
						src="O365ClientDetailsCtrl.office365View"
						data-ng-controller="oneDriveClassicSettingsController as oneDriveClassicSettingsCtrl"
					></ng-include>
				</div>
			</div>
		</div>

		<!--Microsoft Teams, Dynamics 365 and v2CloudApps-->
		<div
		ng-if="O365ClientDetailsCtrl.cloudAppType === O365ClientDetailsCtrl.office365Constants.office365AppID.CLOUDAPP_DYNAMICS365 || 
			O365ClientDetailsCtrl.cloudAppType === O365ClientDetailsCtrl.office365Constants.office365AppID.CLOUDAPP_MSTEAMS">
			<div ng-if="(O365ClientDetailsCtrl.tabType === 'content' || O365ClientDetailsCtrl.tabType === 'users') ">
				<ng-include
						src="O365ClientDetailsCtrl.office365View"
						data-ng-controller="appDetailsController as appDetailsCtrl"
					></ng-include>
			</div>
			<div ng-if="O365ClientDetailsCtrl.tabType === 'configuration'">
				<ng-include
					src="O365ClientDetailsCtrl.office365View"
					data-ng-controller="clientConfigurationController as clientConfigurationCtrl"
				></ng-include>
			</div>
		</div>
	</div>

	<!--SHAREPOINT-->
	<div ng-if="O365ClientDetailsCtrl.clientAppType === O365ClientDetailsCtrl.office365Constants.office365AppID.SHAREPOINT_ONLINE || O365ClientDetailsCtrl._isSharePointClassic()">
		<!--SharePoint V2-->
		<div ng-if="O365ClientDetailsCtrl.isOffice365PseudoClient">
			<div ng-if="O365ClientDetailsCtrl.tabType === 'content' || O365ClientDetailsCtrl.tabType === 'webs'">
				<ng-include src="O365ClientDetailsCtrl.office365View" data-ng-controller="o365sharepointV2BackupSetDetailsController as o365spV2BackupSetDetailsCtrl"></ng-include>
			</div>
			<div ng-if="O365ClientDetailsCtrl.tabType === 'configuration'">
				<ng-include src="O365ClientDetailsCtrl.office365View" data-ng-controller="o365SharepointSettingsController as o365SharepointSettingsCtrl"></ng-include>
			</div>
		</div>
		<!--SharePoint Classic-->
		<div ng-if="!O365ClientDetailsCtrl.isOffice365PseudoClient">
			<div ng-if="O365ClientDetailsCtrl.tabType === 'content'">
				<ng-include src="O365ClientDetailsCtrl.office365View" data-ng-controller="sharepointClassicAppDetailsController as sharepointClassicAppDetailsCtrl"></ng-include>
			</div>
			<div ng-if="O365ClientDetailsCtrl.tabType === 'configuration'">
				<ng-include src="O365ClientDetailsCtrl.office365View" data-ng-controller="sharepointClassicAppSettingsController as sharepointClassicAppSettingsCtrl"></ng-include>
			</div>
		</div>
	</div>

	 <!--Active Directory-->
	 <div ng-if="O365ClientDetailsCtrl.clientAppType === O365ClientDetailsCtrl.office365Constants.office365AppID.AZURE_ACTIVE_DIRECTORY ">
		<div ng-if="O365ClientDetailsCtrl.tabType === 'configuration'">
			<ng-include src="O365ClientDetailsCtrl.office365View" data-ng-controller="azureADSettingsController as azureADSettingsCtrl"></ng-include>
		</div>
	</div>

</div>
</div>

<!--Onboarding Walkthrough-->
<div class="office365-onboarding-content" data-ng-if="O365ClientDetailsCtrl.showOnBoardingUI">
	<cv-onboarding-walkthrough 
		input-model="O365ClientDetailsCtrl.onboardingStepsList"
		on-click-close="O365ClientDetailsCtrl.closeOnboardingWalkthrough()">
	</cv-onboarding-walkthrough>
</div>
<!--Onboarding Walkthrough-->
