<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<script nonce="${sessionScope.cspNonce}" >
    <cv:cvMessages bundle="localization.collections"></cv:cvMessages>
    <cv:cvMessages bundle="localization.vmsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
    <cv:cvMessages bundle="localization.messages"></cv:cvMessages>
     <cv:cvMessages bundle="localization.browseJs"></cv:cvMessages>
     <cv:cvMessages bundle="localization.browse"></cv:cvMessages>
     <cv:cvMessages bundle="localization.fs"></cv:cvMessages>
</script>
<script type="text/ng-template"  id="browse_tree_item_renderer.html">
    <div ng-class="{selected: (!selectMultiple && item == selectedItem) || (selectMultiple && selectedItems[getPath(item)] !== undefined)}" >
        <button id="selectFsContent_button_#9801" ng-if="item.state!='LEAF'" ng-class="item.state | lowercase" ng-click="folderDrilledDown(item)"></button> 
        <span ng-click="folderSelected(item)"><span class="path-title">{{item.label}}</span></span>
    </div>
    <div class="children" ng-class="item.state">
        <div class="browse-item" ng-repeat="item in item.children" ng-include="'browse_tree_item_renderer.html'"></div>
    </div>
</script>
<div class="bootstrap-wrapper">
 <form class="form-horizontal">
    <div class="panel panel-default setup-panel">
		<div class="panel-heading">
            <div class="panel-title">
                <cv:msg key="label.selectContent" bundle="vmsJs"></cv:msg>
            </div>
        </div>
        <div class="panel-body">
            <div class="row">
                <div
                    class="col-xs-12 col-md-10 col-md-offset-1 col-lg-8 col-lg-offset-2" >
                        <div class="form-group">
                            <label class="col-xs-12 col-md-4" ><cv:msg
                                    key="label.servers" bundle="vmsJs"></cv:msg></label>
                            <div class="col-xs-12 col-md-8" data-ng-disabled="replicationGroup.task">
                                <isteven-multi-select id="selectFsContent_isteven-multi-select_#1196" 
                                    data-input-model="configRepliFsGroupContent.clients"
                                    data-tick-property="checked"
                                    data-item-label="name"
                                    class="isteven-multi-select user-group-select"
                                    data-button-label="name"
                                    data-helper-elements="filter"
									on-item-click="configRepliFsGroupContent.serverClick( data )"
                                    data-selection-mode="single" translation="configRepliFsGroupContent.localLang"></isteven-multi-select>
                            </div>
                        </div>
						<div class="form-group">
							<label class="col-xs-12 col-md-4"> <cv:msg
									key="label.name" bundle="vmsJs"></cv:msg>
							</label>
							<div class="col-xs-12 col-md-8">
								<input type="text" id="name"
								data-ng-model="configRepliFsGroupContent.replicationName" required />
							</div>
						</div>
						<div class="form-group">
                            <label class="col-xs-12 col-md-4"><cv:msg
                                    key="heading.Subclients" bundle="clients"></cv:msg></label>
                            <div class="col-xs-12 col-md-8" data-ng-disabled="replicationGroup.task">
                                <isteven-multi-select id="selectFsContent_isteven-multi-select_#4650" 
                                    data-input-model="configRepliFsGroupContent.subclients"
                                    data-tick-property="checked"
                                    data-item-label="name"
                                    class="isteven-multi-select user-group-select"
                                    data-button-label="name"
                                    data-helper-elements="filter"
                                    tick-property="ticked"
                                    group-property="subclientsGroup"
									on-item-click="configRepliFsGroupContent.contentClick( data )"
                                    data-selection-mode="single" translation="configRepliFsGroupContent.localLang"></isteven-multi-select>
                            </div>
                        </div>
                </div>
            </div>
        </div>
	</div>
</form>
</div>
<div  data-ng-if="configRepliFsGroupContent.showSubClientInfo" class="browse-table" data-ng-class="{'fullWidthTable':$state.params.browseType=='vsVolumeBrowse'}">
		<!--	<div data-cv-breadcrumb data-ng-model="breadcrumbModel" item-template="'breadcrumbItem'"></div>  -->
<div data-uib-collapse="!replicationGroup.task" class="bootstrap-wrapper">
	<div class="panel panel-default">
		<div class="panel-heading">
 		<div class="panel-title">
                <cv:msg key="label.selectedContent" bundle="vmsJs"></cv:msg>
		</div></div>
			<div class="panel-body">
				<ul>
					<li data-ng-repeat="item in configRepliFsGroupContent.breadCrumbs">{{item.sourceItem}}</li>
				</ul>
			</div>
	</div>
</div>
 <ul class="breadcrumb breadcrumb-fix">
            <span class="breadcrumbPathLabel">&nbsp;</span>
            <li data-ng-repeat="item in breadcrumbModel"><a
				data-ng-hide="$last" data-ng-click="configRepliFsGroupContent.doShowContent({path : item.path})">{{item.display}}</a>
            <span data-ng-show="$last">{{item.display}}</span></li>
</ul>
<div class="form-group">
	<div data-ng-if="configRepliFsGroupContent.lastBackupTime" data-ui-grid="gridOptions" data-ui-grid-pagination data-ui-grid-selection
	            data-ui-grid-auto-resize data-cv-ui-grid-resize class="grid-style users-grid">
	            <span style="position: absolute;top: 45%; left: 55%" data-cv-loading-spinner data-ng-model="browseResp"></span>
	</div>
</div>
<div data-ng-hide="configRepliFsGroupContent.lastBackupTime" class="error horz-center extra-top-padding" data-ng-bind="configRepliFsGroupContent.errorMessageToShow"/>
</div>
<div class="form-group">
	<div class="button-container">
			<button id="selectFsContent_button_#7376" class="btn btn-primary" type="button" 
			    data-ng-click="configRepliFsGroupContent.addContent()"
			    data-ng-disabled="((!configRepliFsGroupContent.restoreAllowed && !replicationGroup.task )
			    || (!configRepliFsGroupContent.replicationName.length ) || ( configRepliFsGroupContent.copyPrecedence == 0 && replicationGroup.task ) )">
				<cv:msg key="Next" bundle="messages"></cv:msg>
			</button>
	</div>
</div>
