<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.blrJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.fs"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1>
		<span data-ng-if="!modalData.isEditMode"><cv:msg
				key="label.configureReplicationPair" bundle="fs" /></span> <span
			data-ng-if="modalData.isEditMode"><cv:msg
				key="label.editReplicationVolume" bundle="blrJs" /></span>
	</h1>
</div>
<div class="text-center" data-ng-show="!modalData.showModal">
	<img
		src="${pageContext.request.contextPath}/common/img/ajax-loader.gif">
</div>
<form novalidate autocomplete="off" id="configurePairs"
	name="configurePairs" data-cv-submit="submitClick()"
	class="form-horizontal" data-ng-if="modalData.showModal">
	<div class="bootstrap-wrapper modal-margin margin-top-10">

		<div class="form-group margin-bottom-10" id="divServerMessage">
			<span class="{{serverMessage.type}} serverMessage"
			data-ng-bind="serverMessage.message"></span>
		</div>
		<br>
		<!-- Source Server : START -->
		<div class="form-group" data-ng-if="!modalData.isEditMode">
			<label for="sourceServer" class="col-xs-12 col-sm-5"><cv:msg
					key="label.source" bundle="fs"></cv:msg></label>
			<div class="col-xs-12 col-sm-7">
				<isteven-multi-select id="liveSyncIOConfigurePairsModal_isteven-multi-select_#0707" data-input-model="sourceClients"
					data-output-model="modalData.selectedSourceClient"
					data-tick-property="checked" data-item-label="clientName"
					class="isteven-multi-select user-group-select"
					data-button-label="clientName" data-helper-elements="filter"
					data-selection-mode="single"
					on-item-click="sourceClientClick( data )"
					directive-id="sourceServer"> </isteven-multi-select>
				<input type="text" style="display: none"
					data-ng-model="modalData.selectedSourceClient"
					name="validateSourceServer" required /> <span class="help-block"
					data-ng-show="cv.configurePairs.needsAttention(configurePairs.validateSourceServer)">
					<i class="ion-alert-circled"></i> <cv:msg
						key="error.selectSourceClient" bundle="fs" />
				</span>
			</div>
		</div>
		<!-- Source Server : END -->
		<div data-ng-if="modalData.isEditMode">
			<div class="form-group">
				<div class="col-xs-12 col-sm-5">
					<cv:msg key="label.source" bundle="fs" />
				</div>
				<div class="col-xs-12 col-sm-7">
					<span data-ng-bind="modalData.sourceName"></span>
				</div>
			</div>
			<div class="form-group">
				<div class="col-lg-12">
					<span class="help-block" data-ng-show="!modalData.sourceClient">
						<i class="ion-alert-circled"></i> <cv:msg
							key="error.noBLRPackageFoundOnSourceClient" bundle="fs" />
					</span>
				</div>
			</div>
		</div>
		<!-- Destination Server : START -->
		<div class="form-group" data-ng-if="!modalData.isEditMode">
			<label for="destinationServer"
				class="restorePathLabel col-xs-12 col-sm-5"><cv:msg
					key="label.destination" bundle="fs" /></label>
			<div class="col-xs-12 col-sm-7">
				<isteven-multi-select id="liveSyncIOConfigurePairsModal_isteven-multi-select_#7456" data-input-model="destinationClients"
					data-output-model="modalData.selectedDestinationClient"
					data-tick-property="checked" data-item-label="clientName"
					class="isteven-multi-select user-group-select"
					data-button-label="clientName" data-helper-elements="filter"
					data-selection-mode="single"
					on-item-click="destinationClientClick( data )"
					directive-id="destinationServer"> </isteven-multi-select>
				<input type="text" style="display: none"
					data-ng-model="modalData.selectedDestinationClient"
					name="validateDestinationServer" required /> <span
					class="help-block"
					data-ng-show="cv.configurePairs.needsAttention(configurePairs.validateDestinationServer)">
					<i class="ion-alert-circled"></i> <cv:msg
						key="error.selectDestinationClient" bundle="fs" />
				</span>
			</div>
		</div>
		<!-- Destination Server : END -->
		<div data-ng-if="modalData.isEditMode">
			<div class="form-group">
				<div class="col-xs-12 col-sm-5">
					<cv:msg key="label.destination" bundle="fs" />
				</div>
				<div class="col-xs-12 col-sm-7">
					<span data-ng-bind="modalData.destinationName"></span>
				</div>
			</div>
			<div class="form-group">
				<div class="col-lg-12">
					<span class="help-block"
						data-ng-show="!modalData.destinationClient"> <i
						class="ion-alert-circled"></i> <cv:msg
							key="error.noBLRPackageFoundOnDestinationClient" bundle="fs" />
					</span>
				</div>
			</div>
		</div>
		<!-- Display selected volumes and Browse Button : START -->
		<div class="form-group margin-bottom-10">
			<div class="col-xs-12  col-sm-6">
				<h4>
					<cv:msg key="label.volumesToReplicate" bundle="fs" />
				</h4>
			</div>
			<!-- data-ng-disabled has to be used with div here, will not work with <span or <a to display correct cursor style -->
			<div class="col-xs-12 col-sm-6" data-ng-disabled="(!modalData.sourceClient || modalData.sourceClient.length == 0)" >
				<a href="javascript:void(0);"
					class="float-right inline-block margin-top-10"
					data-ng-click="((!modalData.sourceClient || modalData.sourceClient.length == 0)) ? '' : browseForSourceClient()">
					<cv:msg key="label.addVolume" bundle="fs" />
				</a>
			</div>
		</div>
		<div></div>
		<div class="editReplicationPair">
			<cv-kendo-grid id="gridBLRFSPairs" data-cv-grid-options="gridOptionsBLRFSPairs"></cv-kendo-grid>
		</div>
		<div class="form-group">
			<div class="col-lg-6 offset-lg-6">
				<span class="help-block"
					data-ng-if="!modalData.allDestinationsSelected"> <i
					class="ion-alert-circled"></i> <cv:msg
						key="error.selectDestinationPath" bundle="fs" />
				</span>
				<span data-ng-if="!modalData.srcDestVolumeMap">
					<input
					type="text" style="display: none"
					data-ng-model="modalData.srcDestVolumeMap"
					name="validatesrcDestVolumeMap" required />
					<span
						class="help-block"
						data-ng-show="cv.configurePairs.needsAttention(configurePairs.validatesrcDestVolumeMap)">
							<i class="ion-alert-circled"></i> <cv:msg
								key="error.configureAPair" bundle="fs" />
					</span>
				</span>
			</div>
		</div>
		<!-- Display selected volumes and Browse Button : END -->
		<!-- Recovery Options : START -->
		<div id="recovery-options-wrapper" data-ng-if="!modalData.isEditMode">
			<cv-recovery-options model="modalData.blrRecoveryOpts" />
		</div>
		<!-- Recovery Options : END -->
		<div class="button-container">
			<button id="liveSyncIOConfigurePairsModal_button_#4840" type="button"
				class="btn btn-default cvBusyOnAjax setup-btn--hidden"
				data-ng-click="cancel()">
				<cv:msg key="Cancel" bundle="messages" />
			</button>
			<!--
			disable submit button if edit mode and source or destination client does not have blr package
			for edit mode, same variables modalData.sourceClient and modalData.destinationClient will be assigned if found from blreligibleclients,
			so if package is not there now, user should not be able to save, we are already displaying message on this page that blr package is not there.
			 -->
			<button id="liveSyncIOConfigurePairsModal_button_#1862" class="btn btn-primary cvBusyOnAjax" type="submit"
				data-ng-disabled="(( modalData.isEditMode) && (( !modalData.sourceClient) || ( !modalData.destinationClient)))">
				<cv:msg key="Save" bundle="messages" />
			</button>
		</div>
	</div>
</form>
