<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
<cv:cvMessages bundle="localization.collectionsJs"></cv:cvMessages>
<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
</script>
<fmt:setBundle basename="localization.collections" var="collections"/>
<fmt:setBundle basename="localization.servers" var="servers"/>
<fmt:setBundle basename="localization.serversJs" var="serversJs"/>
<h1 class="page-title">{{serverMessage.message}}{{details.clientInfo.client.displayName}}</h1>
<uib-tabset>
    <uib-tab heading="General">
    <div class="group">
    	<div class="page-details-left">
		<div class="page-details-box maxdiv">
			<div class="page-details group">
			<span class="name"><fmt:message key="label.summary" bundle="${servers}"/></span>
			<ul class="list-style-secondary">
				<li class="group"><span class="detail-results"><fmt:message key="label.data.management" bundle="${servers}"/></span> <span class="detail-results">{{dataManagement}}</span></li>
				<li class="group"><span class="detail-results"><fmt:message key="label.data.recovery" bundle="${servers}"/></span> <span class="detail-results">{{dataRecovery}}</span></li>
			</ul>
			</div>
		</div>
		</div>
		 <div class="page-details-right">
		<div class="page-details-box maxdiv">
			<div class="page-details group">
				<span class="name"><fmt:message key="label.alerts" bundle="${servers}"/></span>
					<span ng-show="!alerts.length">
							<p class="info-place-holder"><fmt:message key="label.noalerts" bundle="${servers}"/></p>
						</span>
					<ul class="list-style__row group" data-ng-repeat="alert in alerts">
						<li class="alertli"><a href="#alertDetails/{{alert.alert.id}}">{{alert.alert.name}}</a></li>
						<!-- <li class="alertli" data-ng-if="(alert.status) | bitwiseAnd : 1"><span><input class="alertChk" id="{{alert.alert.id}}" type="checkbox" checked disabled/></span></li>
						<li class="alertli" data-ng-if="!((alert.status) | bitwiseAnd : 1)"><span><input class="alertChk" id="{{alert.alert.id}}" type="checkbox" disabled/></span></li> -->
					</ul>
			</div>
		</div>
	</div>
		</div>
    </uib-tab>
    <tab>
      <tab-heading>
        <i class="glyphicon glyphicon-bell"></i> Security
      </tab-heading>
     	Add Security DOM here...
    </uib-tab>
  </uib-tabset>
<div class="page-details-list maxdiv">
<div class="group">
	<span class="page-details-list-links">
		<ul>
			<li>
				<a href=""  ng-click="openAddCollectionDialog()"><fmt:message key="action.addCollection" bundle="${collections}" /></a>
			</li>
		</ul>
	</span>
	<span class="name"><fmt:message key="pageHeader.collections" bundle="${collections}" /></span>
	<span class="server-message {{serverMessage.type}}">{{serverMessage.message}}</span>
	<ul class="collections-list group list-style__header">
		<li><fmt:message key="header.collectionName"  bundle="${servers}" /></li>
		<li><fmt:message key="header.backupSize" bundle="${servers}" /></li>
		<li><fmt:message key="header.backupTime" bundle="${servers}" /></li>
		<li><fmt:message key="header.restore" bundle="${servers}" /></li>
		<li><fmt:message key="header.jobs" bundle="${servers}" /></li>
	</ul>
	<ul class="collections-list list-style__row group" ng-repeat="sc in subclientList">
		<li>
			<a
			href="#collectionDetails/{{serverId}}/fs/{{sc.sc.subClientEntity.subclientId}}">{{sc.sc.subClientEntity.subclientName}}</a>
		</li>
		<li>{{sc.sc.commonProperties.lastBackupSize / (1024 * 1024) | number:0}} MB</li>
		<li data-ng-show="sc.sc.commonProperties.lastBackupTime==0"><div><fmt:message key="label.neverBackedUp" bundle="${serversJs}"/></div></li>
		<li data-ng-show="sc.sc.commonProperties.lastBackupTime!=0"><div class="time" val="{{sc.sc.commonProperties.lastBackupTime}}"></div></li>
		<li><span data-ng-show="sc.sc.commonProperties.lastBackupTime!=0"><a href="#browse/fs/{{sc.sc.subClientEntity.subclientId}}/%5c">Restore</a></span></li>
		<li><a href="#jobs?collectionId={{sc.sc.subClientEntity.subclientId}}&collectionName={{sc.sc.subClientEntity.subclientName}}"><fmt:message key="action.jobs" bundle="${servers}" /></a></li>
	</ul>
</div>
</div>
