<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.collectionsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
</script>

<div class="modal-header">
	<h1>
		<cv:msg key='label.editBlockLevelBackup' bundle='collectionsJs'/>
	</h1>
</div>

<div class="bootstrap-wrapper">
	<div class="{{editBlockBackupCtrl.editBlockLevelBackupMessage.type}} serverMessage">
		{{editBlockBackupCtrl.editBlockLevelBackupMessage.message}}
	</div>
	<form id="editBlockLevelBackup" class="form-horizontal" name="editBlockLevelBackup" data-cv-submit="editBlockBackupCtrl.saveBlockLevelBackup()" cv-hide-api novalidate autocomplete="off">
		<div class="panel panel-default">
			<div class="panel-body">
				<div>
					<!-- Install block filter driver -->
					<div class="form-group">
						<cv-toggle class="col-xs-12" ng-if="editBlockBackupCtrl.showInstallBlockFilterDriver" toggle-name="installBlockFilterDriver" toggle-label="label.installBlockFilterDriver" value="editBlockBackupCtrl.enableInstallBlockFilterDriver" on-click="editBlockBackupCtrl.modifyInstallBlockFilterDriver()">
						</cv-toggle>
						<div class="col-xs-12" data-ng-if="editBlockBackupCtrl.showForeverFullwarning">
							<span for="foreverFull" class="serverMessage error">
								{{editBlockBackupCtrl.foreverFullWarning}}
							</span>
						</div>
					</div>

					<!-- Reboot options for install block filter driver -->
					<div class="form-group">
						<cv-radio-group class="col-xs-12" ng-if="editBlockBackupCtrl.showRebootOptions" radio-name="rebootOptions" radio-model="editBlockBackupCtrl.rebootOption" radio-obj="editBlockBackupCtrl.rebootOptionsObj">
						</cv-radio-group>
					</div>
				</div>
			</div>
		</div>

		<div class="modal-footer">
			<!-- Cancel -->
			<button id="cancel" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="editBlockBackupCtrl.cancel()">
				<cv:msg key="action.cancel" bundle="profiles"/>
			</button>
			<!-- Save -->
			<button id="save" type="button" class="btn btn-primary cvBusyOnAjax" data-ng-click="editBlockBackupCtrl.saveBlockLevelBackup()">
				<cv:msg key="action.save" bundle="profiles"/>
			</button>
		</div>
	</form>
</div>