<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
	<cv:cvMessages bundle="localization.collections"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1 ng-if="planSubType !== 'FSIBMiVTL'">
		<cv:msg key="label.createServerPlan" bundle="profiles"/>
		<cv-help-component data-ng-if="!skipForSetup" help-text='<cv:msg key="label.addServerPlanHelpText" bundle="profiles" />'></cv-help-component>
		<span data-ng-if="isDerived" class="subtext-unspaced small-size italic">
			<br />
			<span><cv:msg key="label.basePlan" bundle="profiles" /></span>
			<span>-</span>
			<a data-ng-click="goToBaseProfileDetails()" data-ng-bind="basePlanName"></a>
		</span>
	</h1>
	<h1 ng-if="planSubType === 'FSIBMiVTL'">
		<cv:msg key="header.IBMiPlan" bundle="profiles" />
	</h1>
	<span data-ng-hide="showPlanSkip || !skipForSetup" class="help-text"><cv:msg key="label.addServerPlanHelpText" bundle="profiles"/></span>
</div>
<div class="setup-content server-plan medium-width server-backup-plan" data-ng-class="{'ac-setup' : acSetupPlan}">
	<div data-ng-class="generalSetupMessage.type" class="serverMessage" data-ng-bind="generalSetupMessage.message"></div>
	<p class="text-center"><a data-ng-click="goToCreatePlan()" data-ng-hide="showCreateNewProfileLink === false ? true : showCreatePlanForm || !showPlanSkip || !skipForSetup || formConfig.hide === false || showMandateOwnStorageMessage"> <cv:msg key="label.CreateNewPlan" bundle="profiles" /></a></p>

  	<cv-plan-creation-messages data-ng-if="showMessagesLoaded" show-messages=showMessages></cv-plan-creation-messages>



  <form class="bootstrap-wrapper form-horizontal"
  		data-ng-show="!formConfig.hide && (!skipForSetup || showPlanSkip===false || showCreatePlanForm || $state.current.name === 'acSetup')"
  		name="addServerPLanForm"
  		data-cv-submit="addServerPlan()"
  		data-cv-validate="true"
  		novalidate
  		autocomplete="off">
<div class="panel panel-default">
<div class="panel-body no-padding">
		<!-- // name // -->
			<div class="global-options remove-border-padding">
				<label for="planName"><cv:msg key="label.profileName" bundle="profiles" />
					<input type="text" name="planName" data-ng-model="globalTemplate.name" id="planName" data-autoselect="{{autoSelect}}" autofocus />
 				</label>
			</div>
			<!-- indexing -->
			<div class="global-options remove-border-padding" data-ng-if="showIndexingOption">
 			<label>
					<toggle-control status="indexingStatus" data-ng-click="toggleIndexing()"></toggle-control>
					&nbsp;<cv-help-text help-label="label.enableIndexing" help-text="label.indexingHelpText"></cv-help-text>
 				</label>
			</div>
		<!-- // storage // -->
  
  
  
  
  
  
		<div class="storage" data-ng-if="storagePoolsLoaded">
			<h4 class="plan">
				<span><cv:msg key="label.plan.storageAndRetention" bundle="profiles" /></span>
				<span data-ng-hide="skipForSetup" class="pull-right" data-cv-derivable-input data-override-base="!isDerived || globalTemplate.deriveSettings.definesStorage.definesEntity">
					<a data-ng-show="!globalTemplate.storages || !globalTemplate.storages.length" data-ng-click="addStorage()" data-ng-class="{'disabled' : !storagePoolsLoaded}">
						<cv:msg key="label.addCopy" bundle="profiles" />
					</a>
					<a data-ng-show="globalTemplate.storages && globalTemplate.storages.length" data-ng-click="addStorage()" data-ng-class="{'disabled' : !storagePoolsLoaded}">
						<cv:msg key="action.addCopy" bundle="profiles" />
					</a>
				</span>
			</h4>
			<div class="setup-input-group">
				<cv-derivable-input-toggle data-model="globalTemplate.deriveSettings.definesStorage.definesEntity"
						class="row" data-toggle-class="storage-derive-checkbox col-xs-6 col-sm-5" data-help-text-class="col-xs-6 col-sm-7"
						data-derive-setting="globalTemplate.deriveSettings.definesStorage.overrideEntity" data-ng-if="isDerived">
				</cv-derivable-input-toggle>
			</div>
			<div class="global-options remove-border-padding plan-storage-table"
					data-cv-derivable-input data-override-base="!isDerived || globalTemplate.deriveSettings.definesStorage.definesEntity">
				<cv-plan-storage-component data-cv-model="globalTemplate.storages" data-cv-plan-sub-type ="planSubType" data-cv-storage-pools="allStoragePools"
						data-cv-on-storage-added="onStorageAdded" data-cv-on-storage-deleted="onStorageDeleted" data-cv-on-register-api="onRegisterPlanStorageApi" data-cv-is-derive-plan-req="isDerivePlanReq" data-cv-on-storage-updated="onStorageUpdated">
				</cv-plan-storage-component>
			</div>
		</div>
  
  
  
  
  
  
  
</div></div>
<div class="panel panel-default">
<div class="panel-body no-padding">
		<div class="storage" data-ng-if="!storagePoolsLoaded">
			<h4 class="plan">
				<span>
					<cv:msg key="label.plan.storageAndRetention" bundle="profiles" />
				</span>
				<span class="pull-right">
					<a class="disabled">
						<cv:msg key="label.addCopy" bundle="profiles" />
					</a>
				</span>
			</h4>
			<div class="global-options remove-border-padding">
				<label class="loading-text">
					<cv:msg key="label.loading" bundle="profiles" />
				</label>
			</div>
		</div>

		<!-- RPO and SLA start -->
		<h4 class="plan">
			<cv:msg key="label.rpo" bundle="profiles" /><cv-help-component help-text="'<cv:msg key='info.help.rpo' bundle='profiles' />'" help-placement="right"></cv-help-component>
		</h4>

		<div class="rpo-container">

		<div class="setup-input-group">
			<cv-derivable-input-toggle data-model="globalTemplate.deriveSettings.definesSchedule.definesEntity"
					class="row" data-toggle-class="col-xs-6 col-sm-5" data-help-text-class="col-xs-6 col-sm-7"
					data-derive-setting="globalTemplate.deriveSettings.definesSchedule.overrideEntity" data-ng-if="isDerived">
			</cv-derivable-input-toggle>
		</div>

		<cv-derivable-input data-override-base="!isDerived || globalTemplate.deriveSettings.definesSchedule.definesEntity">




			<div class="form-group">
				<label class="col-xs-12 col-md-4 col-lg-4" for="rpo"><cv-help-text help-label="<cv:msg key="label.backupFrequency" bundle="profiles" />" help-text="'<cv:msg key='info.help.rpo.backupFrequency' bundle='profiles' />'"></cv-help-text></label>
				<div class="col-xs-12 col-md-4 col-lg-8"><label class="inline-label"><cv:msg key="label.incrementalFrequencyText" bundle="profiles"/></label>
					<input id="rpo" name="rpo" type="number" min="1" max="{{isDerivePlanServerPlan || planSubType == 'Server'? '' : rpoMaxLimit}}" required data-ng-model="globalTemplate.rpo" class="frequency-input" data-ng-class="{'setup' : skipForSetup, 'invalid-rpo' : invalidRPO}"  ng-disabled="incrementalBackupFreq.type === 'YEARS'"/>
					<select data-ng-model="incrementalBackupFreq.type"
							data-ng-change="incrementalBackupFrequencyChanged(incrementalBackupFreq.type)"
							data-ng-options="incrementalBackupFreq.value as incrementalBackupFreq.name for incrementalBackupFreq in incrementalBackupFreqs"
							class="float-none width-auto padding-right-30"></select>
					<div class="width-auto inline-block padding-left-5 padding-right-5" ng-if="incrementalBackupFreq.type == 'WEEKS'">on</div>
					<isteven-multi-select ng-if="incrementalBackupFreq.type === 'WEEKS'"
						input-model="incrementalDaysToRun"
						button-label="name"
						item-label="name"
						tick-property="ticked"
						class="isteven-multi-select user-group-select width-auto min-width-100"
						id="isteven-multi-select2"
						on-item-click="incrementalDaysToRunChanged()"
						prevent-sort="true"
						max-labels="1">
					</isteven-multi-select>
					<div ng-if="incrementalBackupFreq.type === 'MONTHS' || incrementalBackupFreq.type === 'YEARS'">
						<div class="margin-top-10">
							<span class="margin-right-10">
								<input value="RELATIVE" name="incrementalRPOMode" type="radio" data-ng-model="incrementalBackupFreq.incrementalRPOMode" />
								<span class="margin-left-10"><cv:msg key="label.on.the" bundle="profiles" /></span>
							</span>
							<select class="width-auto float-none min-width-80" data-ng-model="incrementalBackupFreq.weekOfMonth" data-ng-disabled="incrementalBackupFreq.incrementalRPOMode !== 'RELATIVE'"
								data-ng-options="weekToRun.value as weekToRun.name for weekToRun in incrementalWeeksToRun"></select>
							<select class="width-auto float-none min-width-80" data-ng-model="incrementalBackupFreq.dayOfWeek" data-ng-disabled="incrementalBackupFreq.incrementalRPOMode !== 'RELATIVE'"
								data-ng-options="dayOfWeek.value as dayOfWeek.name for dayOfWeek in incrementalDaysOfWeek"></select>
						</div>
						<div>
							<span class="margin-right-10">
								<input value="NORMAL" name="incrementalRPOMode" type="radio" data-ng-model="incrementalBackupFreq.incrementalRPOMode" /> 
								<span class="margin-left-10"><cv:msg key="label.on.the" bundle="profiles" /></span>
							</span>
							<input id="incrementalDayOfMonth" name="incrementalDayOfMonth" type="number" data-ng-model="incrementalBackupFreq.dayOfMonth" data-ng-change="incrementalDayOfMonthChanged()" ng-blur="incrementalDayOfMonthChanged(true)"
								class="frequency-input" data-ng-disabled="incrementalBackupFreq.incrementalRPOMode === 'RELATIVE'"/> 
							<span ng-bind="getDaySuffix(incrementalBackupFreq.dayOfMonth)"></span>
							<span><cv:msg key="label.rpoFreq.daily" bundle="profiles" /></span>
						</div>
						<div ng-if="incrementalBackupFreq.type === 'YEARS'" class="margin-top-10">
							<span class="margin-right-10">								
								<span><cv:msg key="label.of.month" bundle="profiles" /></span>
							</span>
							<select class="width-auto float-none min-width-80" data-ng-model="incrementalBackupFreq.monthOfYear"
								data-ng-options="monthOfYear.value as monthOfYear.name for monthOfYear in incrementalMonthsOfYear" data-ng-change="incrementalDayOfMonthChanged(true)"></select>
						</div>
					</div>
				</div>
			</div>
			<div data-ng-if="incrementalBackupFreq.type === 'DAYS' || incrementalBackupFreq.type === 'WEEKS' || incrementalBackupFreq.type === 'MONTHS' || incrementalBackupFreq.type === 'YEARS'">
			<div class="form-group">
				<label class="col-xs-12 col-md-4 col-lg-4" for="incrementalBackupRPOScheduleTime"><cv-help-text help-label="<cv:msg key="label.rpo.startTime" bundle="profiles" />" help-text="'<cv:msg key='info.help.rpoSchedule.startTime' bundle='profiles' />'"></cv-help-text></label>
				<div class="col-xs-12 col-md-8 col-lg-8" id="time-picker-wrapper"><table uib-timepicker id="incrementalBackupRPOScheduleTime" name="incrementalBackupRPOScheduleTime" data-ng-model="incrementalBackupFreq.scheduleTime" hour-step="1" show-meridian="true" show-spinners="false"></table></div>
			</div>
			</div>


			<div data-ng-if="!isCoreSetup">

			<div class="form-group">
				<div class="col-xs-12">
					<toggle-control class="add-full-backup-toggle"
						id="rpo-add-full-backup"
						status="addFullBackup ? 'enabled-activity' : 'disabled-activity'"
						title="<cv:msg key="label.enableDisable" bundle="messages" />"
						data-ng-click="toggleFullBackup()">
					</toggle-control>
					<span class="padding-left-5"><cv:msg key="label.addFullBackup" bundle="profiles" /></span>
				</div>
			</div>

			<div data-ng-if="addFullBackup === true">
			<div class="form-group">
				<label class="col-xs-12 col-md-4 col-lg-4 padding-left-30" for=""><cv:msg key="label.fullBackupFrequency" bundle="profiles" /></label>
				<div class="col-xs-12 col-md-8 col-lg-8">
					<select class="width-auto float-none min-width-80" data-ng-model="fullBackupScheduleInfo.fullBackupSchedule.freqType" data-ng-options="fullBackupFrequencyType.value as fullBackupFrequencyType.name for fullBackupFrequencyType in fullBackupFrequencyTypes"></select>
					<div class="width-auto inline-block padding-left-5 padding-right-5" ng-if="fullBackupScheduleInfo.fullBackupSchedule.freqType != 'DAILY'">on</div>
					<select class="width-auto float-none min-width-80" 
						ng-if="fullBackupScheduleInfo.fullBackupSchedule.freqType === 'MONTHLY_RELATIVE' || fullBackupScheduleInfo.fullBackupSchedule.freqType === 'YEARLY_RELATIVE'" 
						data-ng-model="fullBackupScheduleInfo.fullBackupSchedule.weekOfMonth" data-ng-options="weekToRun.value as weekToRun.name for weekToRun in weeksToRun"></select>
					<select class="width-auto float-none min-width-80" 
						ng-if="fullBackupScheduleInfo.fullBackupSchedule.freqType === 'MONTHLY_RELATIVE' || fullBackupScheduleInfo.fullBackupSchedule.freqType === 'YEARLY_RELATIVE'" 
						data-ng-model="fullBackupScheduleInfo.fullBackupSchedule.dayOfWeek" data-ng-options="dayOfWeek.value as dayOfWeek.name for dayOfWeek in daysOfWeek"></select>
					<div ng-if="fullBackupScheduleInfo.fullBackupSchedule.freqType === 'YEARLY_RELATIVE'" class="margin-right-10">
						<span>
							<cv:msg key="label.of.month" bundle="profiles" /></span>
						<select class="width-auto float-none min-width-80"
							data-ng-model="fullBackupScheduleInfo.fullBackupSchedule.monthOfYear"
							data-ng-options="monthOfYear.value as monthOfYear.name for monthOfYear in fullBackupMonthsOfYear">
						</select>
					</div>

			  		<isteven-multi-select ng-if="fullBackupScheduleInfo.fullBackupSchedule.freqType === 'WEEKLY'"
		   				  input-model="daysToRun"
		  				  button-label="name"
		  				  item-label="name"
		   				  tick-property="ticked"
		   				  class="isteven-multi-select user-group-select width-auto min-width-100"
		   				  id="isteven-multi-select2"
						  on-item-click="daysToRunChanged(data)"
						  prevent-sort="true"
		   				  max-labels="1">
 					</isteven-multi-select>
				</div>
			</div>
			</div>

			<div data-ng-if="addFullBackup === true">
			<div class="form-group">
				<label class="col-xs-12 col-md-4 col-lg-4 padding-left-30" for="fullBackupRPOScheduleTime"><cv-help-text help-label="<cv:msg key="label.rpo.startTime" bundle="profiles" />" help-text="'<cv:msg key='info.help.rpoSchedule.startTime' bundle='profiles' />'"></cv-help-text></label>
				<div class="col-xs-12 col-md-8 col-lg-8" id="time-picker-wrapper"><table uib-timepicker id="fullBackupRPOScheduleTime" name="fullBackupRPOScheduleTime" data-ng-change="fullBackupRPOStartTimeChanged()" data-ng-model="fullBackupScheduleInfo.scheduleTime" hour-step="1" minute-step="15" show-meridian="true" show-spinners="false"></table></div>
			</div>
			</div>

			<div class="form-group">
				<label class="col-xs-12 col-md-4 col-lg-4" for=""><cv:msg key="label.backupWindow" bundle="profiles" /></label>
				<div class="col-xs-12 col-md-8 col-lg-8" data-ng-class="{'setup' : skipForSetup}"><cv-backup-window-list data-cv-model="globalTemplate.backupWindow"></cv-backup-window-list></div>
			</div>

			<div class="form-group">
				<label class="col-xs-12 col-md-4 col-lg-4" for=""><cv:msg key="label.fullBackupWindow" bundle="profiles" /></label>
				<div class="col-xs-12 col-md-8 col-lg-8"
						data-ng-class="{'setup' : skipForSetup}"><cv-backup-window-list
																	data-cv-model="globalTemplate.fullBackupWindow"
																	data-cv-edit-modal-title='"<cv:msg key="title.editFullBackupWindow" bundle="profiles"/>"'></cv-backup-window-list></div>
			</div>


			</div><!-- // end !isCoreSetup div // -->
		</cv-derivable-input>
	</div><!-- // end rpo-container div // -->

</div></div>

<div class="panel panel-default" data-ng-if="!isCoreSetup">
<div class="panel-body no-padding">
		<div data-ng-if="windowsFolderSelected.length || unixFolderSelected.length || macFolderSelected.length" class="schedule" data-ng-class="{'padding-left-right' : skipForSetup}">
			<uib-accordion close-others="true">
				<cv-plain-accordion ng-hide="planSubType == 'FSIBMiVTL'" accordion-label="label.folderToBackup" accordion-help-label="info.optionForFileSystemAgents">
					<div class="setup-input-group">
						<cv-derivable-input-toggle data-model="globalTemplate.deriveSettings.definesSubclientWin.definesEntity" class="row"
								data-toggle-class="col-xs-6 col-sm-5" data-help-text-class="col-xs-6 col-sm-7" data-ng-if="isDerived"
								data-derive-setting="globalTemplate.deriveSettings.definesSubclientWin.overrideEntity">
						</cv-derivable-input-toggle>
					</div>
					<cv-derivable-input data-override-base="!isDerived || globalTemplate.deriveSettings.definesSubclientWin.definesEntity">
						<div class="backup-content" data-ng-controller="profileBackupContentController">
							<div class="{{backupContentMessage.type}} serverMessage">{{backupContentMessage.message}}</div>
							<span class="angular-tab-wrapper">
								<uib-tabset justified="true">
									<!-- // windows starts // -->
									<uib-tab heading="Windows">
										<div id="backup-content-wrapper">
											<div class="content-checkboxes">
												<div id="backup-content-folders">
													<div class="content-header clearfix">
														<h4>
															<cv:msg key="label.contentToBackup" bundle="profiles" />
														</h4>
														<div class="content-header-actions">
															<span class="page-action-item" data-ng-hide="(acSetupPlan && !windowsFolderSelected.length) || (windowsFolderSelected.length ===1 && windowsFolderSelected[0] === '\\')">
																<a href="" data-ng-click="deleteAll('windows')">
																	<cv:msg key="label.removeAll" bundle="profiles" /></a>
															</span>
															<span class="page-action-item"> <a href="" data-ng-click="addFolder('windows')">
																	<cv:msg key="action.add" bundle="profiles" /></a>
															</span>
														</div>
													</div>
													<div class="peopleInfos ownerInfo">
														<div class="users-list limit-modal-height">
															<ul class="users-list__user less-padding group" data-ng-repeat="folder in windowsFolderSelected track by $index">
																<li title="{{folder | trimFolderName}}"><span class="content-library-folder content-library-{{folder | trimFolderName}}"
																	data-ng-class="{'content-library-file' : {{folder | isFolder}} === false}">
																		<label for="windows-{{folder}}" class="ellipsis-parent ellipsis-content">{{folder
																			| trimFolderName}} <span data-ng-if="folder == '\\'" class='laptop-content-help-text'>
																				<cv:msg key='label.allContents' bundle='profiles' /></span></label> <span class="delete-row"><a href="javascript:void(0);"
																			data-ng-click="toggleWindowsFolderSelection(folder)" title="<cv:msg key='label.removeContent' bundle='collectionsJs' /> {{folder | trimFolderName}}">&times;</a></span>
																	</span>
																</li>
															</ul>
															<div class="backup-content-empty" ng-hide="windowsFolderSelected.length" ng-click="addFolder('windows')">
																<div>
																	<svg xmlns="http://www.w3.org/2000/svg" width="72" height="72" viewBox="0 0 72 72">
																		<path d="M0,10.2l29.4-4V34.5L0,34.7ZM29.4,37.8V66.1L0,62V37.6ZM33,5.7,72,0V34.1l-39,.3ZM72,38V72L33,66.5V38Z" />
																	</svg>
																</div>
																<div>
																	<h4>
																		<cv:msg key="label.addContentToBackup" bundle="profiles" />
																	</h4>
																</div>
															</div>
														</div>
													</div>
												</div>
												<div id="exclude-folders">
													<div class="content-header clearfix">
														<h4>
															<cv:msg key="label.excludes" bundle="profiles" />
														</h4>
														<div class="content-header-actions">
															<span class="page-action-item" data-ng-if="windowsExcludeSelected.length">
																<a href="" data-ng-click="deleteAll('windows', true)">
																	<cv:msg key="label.removeAll" bundle="profiles" /></a>
															</span>
															<span class="page-action-item"> <a href="" data-ng-click="addFolder('windows', true)">
																	<cv:msg key="action.add" bundle="profiles" /></a>
															</span>
														</div>
													</div>
													<div class="peopleInfos ownerInfo">
														<div class="users-list limit-modal-height">
															<ul class="users-list__user less-padding group" data-ng-repeat="exclude in windowsExcludeSelected track by $index">
																<li title="{{exclude}}"><span class=" content-library-folder content-library-{{exclude | trimFolderName}}"
																	data-ng-class="{'content-library-file' : {{exclude | isFolder}} === false}">
																		<label for="windows-{{exclude}}" class="ellipsis-parent ellipsis-content">{{exclude
																			| trimFolderName}} </label> <span class="delete-row"><a href="javascript:void(0);" data-ng-click="toggleWindowsExcludeSelection(exclude)"
																			title="<cv:msg key='label.removeContent' bundle='collectionsJs' /> {{exclude | trimFolderName}}">&times;</a></span>
																	</span></li>
															</ul>
															<div class="backup-content-empty" ng-hide="windowsExcludeSelected.length" ng-click="addFolder('windows', true)">
																<div>
																	<svg xmlns="http://www.w3.org/2000/svg" width="84" height="84" viewBox="0 0 84 84">
																		<path d="M29.1,37.4v28L0,61.4V37.2L29.1,37.4z M71.2,0L32.6,5.6v28.5l38.6-0.3V0z M39.6,64.3
																				c0.1-13.6,11.1-24.6,24.7-24.7c2.3,0,4.7,0.3,6.9,1v-3H32.6v28.2l7.1,1C39.6,66,39.6,65.1,39.6,64.3z M0,10.1v24.2l29.1-0.2v-28
																				L0,10.1z M84,64.2c0-10.9-8.9-19.8-19.8-19.8c-10.9,0-19.8,8.9-19.8,19.8c0,10.9,8.9,19.8,19.8,19.8S84,75.1,84,64.2L84,64.2z
																					M79.1,63.2c0.7,8.2-5.4,15.4-13.6,16.1c-8.2,0.7-15.4-5.4-16.1-13.6c-0.1-0.8-0.1-1.6,0-2.4c0.7-8.2,7.9-14.3,16.1-13.6
																				C72.7,50.2,78.5,55.9,79.1,63.2z M74.1,64.2c0-1.4-1.1-2.5-2.5-2.5H56.8c-1.4,0-2.5,1.1-2.5,2.5c0,1.4,1.1,2.5,2.5,2.5h14.8
																				C73,66.7,74.1,65.6,74.1,64.2z" />
																	</svg>
																</div>
																<div>
																	<h5>
																		<cv:msg key="label.addExcludes" bundle="profiles" />
																	</h5>
																</div>
															</div>
														</div>
													</div>
												</div>
												<div>
													<div class="peopleInfos ownerInfo margin-top-20">
														<div class="row">
															<div class="col-xs-12">
																<div class="form-group">
																	<input type="checkbox" id="{{id}}backupSystemState" data-ng-click="globalTemplate.contentInfo.windows.backupSystemStateforFullBkpOnly = (!globalTemplate.contentInfo.windows.backupSystemState ? false : globalTemplate.contentInfo.windows.backupSystemStateforFullBkpOnly); globalTemplate.contentInfo.windows.useVSSForSystemState = (!globalTemplate.contentInfo.windows.backupSystemState ? false : globalTemplate.contentInfo.windows.useVSSForSystemState);"
																	data-ng-model="globalTemplate.contentInfo.windows.backupSystemState" data-ng-true-value="true"
																	data-ng-false-value="false" />
																	<label for="{{id}}backupSystemState">{{'label.backupSystemState'
																		| cvLoc}}</label>
																</div>
																<div class="row systemstate-options" data-ng-disabled="!globalTemplate.contentInfo.windows.backupSystemState">
																	<div class="col-md-12 form-group">
																		<input type="checkbox" id="{{id}}backupSystemStateforFullBkpOnly" data-ng-model="globalTemplate.contentInfo.windows.backupSystemStateforFullBkpOnly"
																		data-ng-true-value="true" data-ng-false-value="false" />
																		<label for="{{id}}backupSystemStateforFullBkpOnly">{{'label.backupSystemStateforFullBkpOnly'
																			| cvLoc}}</label>
																	</div>
																	<div class="col-md-12 form-group">
																		<input type="checkbox" id="{{id}}useVSSForSystemState" data-ng-model="globalTemplate.contentInfo.windows.useVSSForSystemState"
																		data-ng-true-value="true" data-ng-false-value="false" />
																		<label for="{{id}}useVSSForSystemState">{{'label.useVSSForSystemState'
																			| cvLoc}}</label>
																	</div>
																</div>
															</div>
														</div>
													</div>
												</div>
											</div>
										</div>
									</uib-tab> <!-- // windows ends // -->
									<!-- // mac starts // -->
									<uib-tab heading="Mac" data-ng-if="!fsPlan">
										<div id="backup-content-wrapper">
											<div class="content-checkboxes">
												<div id="backup-content-folders">
													<div class="content-header clearfix">
														<h4>
															<cv:msg key="label.contentToBackup" bundle="profiles" />
														</h4>
														<div class="content-header-actions">
															<span class="page-action-item" data-ng-hide="(acSetupPlan && !macFolderSelected.length) || (macFolderSelected.length ===1 && macFolderSelected[0] === '/')">
																<a href="" data-ng-click="deleteAll('mac')">
																	<cv:msg key="label.removeAll" bundle="profiles" /></a>
															</span>
															<span class="page-action-item"> <a href="" data-ng-click="addFolder('mac')">
																	<cv:msg key="action.add" bundle="profiles" /></a>
															</span>
														</div>
													</div>
													<div class="peopleInfos ownerInfo">
														<div class="users-list limit-modal-height">
															<ul class="users-list__user less-padding group" data-ng-repeat="folder in macFolderSelected track by $index">
																<li title="{{folder | trimFolderName}}"><span class=" content-library-folder content-library-{{folder | trimUnixFolderName}}"
																	data-ng-class="{'content-library-file' : {{folder | isFolder}} === false}">
																		<label for="mac-{{folder}}" class="ellipsis-parent ellipsis-content">{{folder
																			| trimUnixFolderName}} <span data-ng-if="folder == '/'" class='laptop-content-help-text'>
																				<cv:msg key='label.allContents' bundle='profiles' /></span></label> <span class="delete-row"><a href="javascript:void(0);"
																			data-ng-click="toggleMacFolderSelection(folder)" title="<cv:msg key='label.removeContent' bundle='collectionsJs' /> {{folder | trimUnixFolderName}} ">&times;</a></span>
																	</span></li>
															</ul>
															<div class="backup-content-empty" ng-hide="macFolderSelected.length" ng-click="addFolder('mac')">
																<div>
																	<svg xmlns="http://www.w3.org/2000/svg" width="72" height="72" viewBox="0 0 72 72">
																		<path d="M66.5,52.8a55.1,55.1,0,0,1-4.6,8.7c-3,4.7-7.2,10.4-12.5,10.5s-5.8-3.1-12.1-3.1S29.7,72,25,
																			72s-9.2-5.3-12.2-9.9C4.4,49.2,3.5,34,8.7,25.9c3.7-5.7,9.5-9,14.9-9s9,3,13.6,3,7.2-3.1,13.6-3.1c4.8,0,
																			10,2.7,13.6,7.3C52.4,30.8,54.4,48.2,66.5,52.8ZM45.9,11.7A15.8,15.8,0,0,0,49.4,0,17,17,0,0,0,38.5,5.9c-2.3,2.9-4.3,7.2-3.5,
																			11.4C39.1,17.4,43.4,14.9,45.9,11.7Z" />
																	</svg>
																</div>
																<div>
																	<h4>
																		<cv:msg key="label.addContentToBackup" bundle="profiles" />
																	</h4>
																</div>
															</div>
														</div>
													</div>
												</div>
												<div id="exclude-folders">
													<div class="content-header clearfix">
														<h4>
															<cv:msg key="label.excludes" bundle="profiles" />
														</h4>
														<div class="content-header-actions">
															<span class="page-action-item" data-ng-if="macExcludeSelected.length">
																<a href="" data-ng-click="deleteAll('mac', true)">
																	<cv:msg key="label.removeAll" bundle="profiles" /></a>
															</span>
															<span class="page-action-item"> <a href="" data-ng-click="addFolder('mac', true)">
																	<cv:msg key="action.add" bundle="profiles" /></a>
															</span>
														</div>
													</div>
													<div class="peopleInfos ownerInfo">
														<div class="users-list limit-modal-height">
															<ul class="users-list__user less-padding group" data-ng-repeat="exclude in macExcludeSelected track by $index">
																<li title="{{exclude}}"><span class=" content-library-folder content-library-{{exclude | trimUnixFolderName}}"
																	data-ng-class="{'content-library-file' : {{exclude | isFolder}} === false}">
																		<label for="mac-{{exclude}}" class="ellipsis-parent ellipsis-content">{{exclude
																			| trimUnixFolderName}} </label> <span class="delete-row"><a href="javascript:void(0);" data-ng-click="toggleMacExcludeSelection(exclude)"
																			title="<cv:msg key='label.removeContent' bundle='collectionsJs' /> {{exclude | trimUnixFolderName}}">&times;</a></span>
																	</span></li>
															</ul>
															<div class="backup-content-empty" ng-hide="macExcludeSelected.length" ng-click="addFolder('mac', true)">
																<div>
																	<svg xmlns="http://www.w3.org/2000/svg" width="84" height="84" viewBox="0 0 84 84">
																		<path d="M29.2,17.1c-0.8-4.1,1.2-8.4,3.5-11.2c2.7-3.2,6.5-5.3,10.7-5.9c0.7,4.3-1.1,8.6-3.4,11.6S33.3,17.3,29.2,17.1
																				z M39.6,64.3c0-8.6,4.5-16.6,11.8-21.1c-2.9-7.3,0-15.6,6.9-19.3c-3.6-4.6-8.7-7.2-13.5-7.2s-9,3-13.4,3s-8-3-13.5-3
																				S6.8,20,3.2,25.7c-5.1,8-4.3,23,4,35.8c3,4.5,6.9,9.7,12.1,9.7s5.9-2.9,12.2-3c4.6,0,6.4,1.7,8.9,2.5
																				C39.9,68.6,39.6,66.5,39.6,64.3z M84,64.2c0-10.9-8.9-19.8-19.8-19.8c-10.9,0-19.8,8.9-19.8,19.8c0,10.9,8.9,19.8,19.8,19.8
																				S84,75.1,84,64.2L84,64.2z M79.1,63.2c0.7,8.2-5.4,15.4-13.6,16.1c-8.2,0.7-15.4-5.4-16.1-13.6c-0.1-0.8-0.1-1.6,0-2.4
																				c0.7-8.2,7.9-14.3,16.1-13.6C72.7,50.2,78.5,55.9,79.1,63.2z M74.1,64.2c0-1.4-1.1-2.5-2.5-2.5H56.8c-1.4,0-2.5,1.1-2.5,2.5
																				c0,1.4,1.1,2.5,2.5,2.5h14.8C73,66.7,74.1,65.6,74.1,64.2z" />
																	</svg>
																</div>
																<div>
																	<h5>
																		<cv:msg key="label.addExcludes" bundle="profiles" />
																	</h5>
																</div>
															</div>
														</div>
													</div>
												</div>
											</div>
										</div>
									</uib-tab> <!-- // mac ends // -->
									<!-- // Unix starts // -->
									<uib-tab heading="Unix">
										<div id="backup-content-wrapper">
											<div class="content-checkboxes">
												<div id="backup-content-folders">
													<div class="content-header clearfix">
														<h4>
															<cv:msg key="label.contentToBackup" bundle="profiles" />
														</h4>
														<div class="content-header-actions">
															<span class="page-action-item" data-ng-hide="(acSetupPlan && !unixFolderSelected.length) || (unixFolderSelected.length ===1 && unixFolderSelected[0] === '/')">
																<a href="" data-ng-click="deleteAll('unix')">
																	<cv:msg key="label.removeAll" bundle="profiles" /></a>
															</span>
															<span class="page-action-item"> <a href="" data-ng-click="addFolder('unix')">
																	<cv:msg key="action.add" bundle="profiles" /></a>
															</span>
														</div>
													</div>
													<div class="peopleInfos ownerInfo">
														<div class="users-list limit-modal-height">
															<ul class="users-list__user less-padding group" data-ng-repeat="folder in unixFolderSelected track by $index">
																<li title="{{folder | trimFolderName}}"><span class=" content-library-folder content-library-{{folder | trimUnixFolderName}}"
																	data-ng-class="{'content-library-file' : {{folder | isFolder}} === false}">
																		<label for="unix-{{folder}}" class="ellipsis-parent ellipsis-content">{{folder
																			| trimUnixFolderName}} <span data-ng-if="folder == '/'" class='laptop-content-help-text'>
																				<cv:msg key='label.allContents' bundle='profiles' /></span> </label> <span class="delete-row"><a href="javascript:void(0);"
																			data-ng-click="toggleUnixFolderSelection(folder)" title="<cv:msg key='label.removeContent' bundle='collectionsJs' /> {{folder | trimUnixFolderName}}">&times;</a></span>
																	</span></li>
															</ul>
															<div class="backup-content-empty" ng-hide="unixFolderSelected.length" ng-click="addFolder('unix')">
																<div>
																	<svg xmlns="http://www.w3.org/2000/svg" width="72" height="72" viewBox="0 0 72 72">
																		<path d="M19.9,50a1.1,1.1,0,0,1-.2-.6l.8.9C20.4,50.4,20.2,50.2,19.9,50ZM66.4,61a2,2,0,0,1-.9,
																			1.8c-.7.6-3.9,2.3-6.1,3.7a33,33,0,0,0-4.6,3.6A5.9,5.9,0,0,1,50,72a5.1,5.1,0,0,1-3.6-1,4.6,4.6,0,0,
																			1-1.1-2c-4.5-1.2-5.8-1-10.5-.7s-3.8-.1-6.2,1l-1.1.9c-1.4,1.2-1.8,1.9-4.1,
																			1.8s-5.6-2.1-9.1-2.8c-6.6-1.4-7.7-1.7-8.5-2.9a3,3,0,0,1,0-2.3,18.5,18.5,0,0,0,.3-2.9c0-2.9-.8-4.4,0-5.5s4-1,
																			5.3-1.9,2.1-2.8,2.9-3.5.1-.1.1-.2c-.8-3.2-.6-3.6.9-7.4a57.7,57.7,0,0,1,5.1-10.3c2.8-4.2,5.8-6.5,5.6-9.7-.9-12.2-1.6-18.3,
																			3.8-21.1A11.9,11.9,0,0,1,44.3,3.8,12.1,12.1,0,0,1,47,9.6c1.2,5-.5,3.4.9,9.1s3.9,8.6,7.1,13.1,6.6,12.1,5.5,16.4a24.3,24.3,
																			0,0,1-1,2.8,1.2,1.2,0,0,1,1,.5c.9,1.3,0,3,.6,4a17,17,0,0,0,4,3.8C65.6,59.6,66.5,60,66.4,61ZM35.2,14.5a5.1,5.1,0,0,0,.2,
																			1.3l1.1.4.5.4a8.8,8.8,0,0,1-.2-1.6,3,3,0,0,1,.6-1.8,2,2,0,0,1,1.3-.4c1.1,0,1.7.9,1.9,2.2a2,2,0,0,1-.4,1.6,2.2,2.2,0,0
																			,1-1.3.8,11.4,11.4,0,0,1,2.2.7,3.2,3.2,0,0,0,1-1.8,4.9,4.9,0,0,0-.6-4.3c-.8-1.6-1.4-1.8-2.6-1.9a3.3,3.3,0,0,0-3.4,2.2A3.8,
																			3.8,0,0,0,35.2,14.5Zm-7.4,2.4a4.1,4.1,0,0,0,.8,1.3c.1-.2.3-.3.4-.4l.5-.4c-.3-.1-.4-.3-.8-.7a3,3,0,0,1-.6-1.7,3.2,3.2,0,0,1,
																			.2-1.6,1.2,1.2,0,0,1,1.1-.5,1.6,1.6,0,0,1,1.2.6,2.5,2.5,0,0,1,.5,1.5,5.1,5.1,0,0,1-.2,1.3l.6-.3.6-.2a6.3,6.3,0,0,0,.2-1.6,4.2,
																			4.2,0,0,0-1.1-2.8,2.3,2.3,0,0,0-2.3-.8c-.4,0-.9.5-1.2,1.2a4.7,4.7,0,0,0-.4,1.7A8.4,8.4,0,0,0,27.8,16.9ZM45.2,59.8a9.4,9.4,0,0,
																			0,1-1c.1-1.3,0-2.8,0-4.1s.1-3.6.5-3.9a2.4,2.4,0,0,1,1.8-.5h1.2c.1-1.1.3-2.8.3-3.7a32.6,32.6,0,0,0-1-8.1,43,43,0,0,
																			0-2.5-5.3c-1.7-3.7-1.6-5.4-3.1-7.8s-1.2-3.1-1.7-3.8A2.8,2.8,0,0,1,39.9,23c-1.4.4-3.7,2.7-5.6,2.7a7.4,7.4,0,0,1-2.6-.2,17.2,
																			17.2,0,0,1-2.5-2.1l-1.3-1.1h0a21.7,21.7,0,0,0-.2,3.6c0,1.1-.6,1.2-1.7,3a15.9,15.9,0,0,0-1.5,2.9l-.6,1.9c0,.3-.2.6-.2.9-.6,2.2-2.7,
																			4.8-3.1,6.9a19.3,19.3,0,0,0-1,6.3,6.2,6.2,0,0,0,.1,1.6,7.2,7.2,0,0,1-1.1-1.5,7.1,7.1,0,0,1-.6-3.8,16.1,16.1,0,0,1,1.5-5.2c1.1-2.5,
																			1.9-3.1,1.6-3.3s-1.1,1.6-1.4,2.3a20.8,20.8,0,0,0-2,6.1,7.3,7.3,0,0,0,.5,3.8A10.1,10.1,0,0,0,19.9,50l.6.5c.9.7,1.8,1.4,3.1,2.6s4.3,
																			3.3,4.7,4a2.4,2.4,0,0,1,.2,2.7c-.5.7-1.9.8-2.7.8,1,1.5,1.9,2.4,2.6,3.4s3.2,1.5,8.3.5A17.2,17.2,0,0,0,45.2,59.8Z" />
																	</svg>
																</div>
																<div>
																	<h4>
																		<cv:msg key="label.addContentToBackup" bundle="profiles" />
																	</h4>
																</div>
															</div>
														</div>
													</div>
												</div>
												<div id="exclude-folders">
													<div class="content-header clearfix">
														<h4>
															<cv:msg key="label.excludes" bundle="profiles" />
														</h4>
														<div class="content-header-actions">
															<span class="page-action-item" data-ng-if="unixExcludeSelected.length">
																<a href="" data-ng-click="deleteAll('unix', true)">
																	<cv:msg key="label.removeAll" bundle="profiles" /></a>
															</span>
															<span class="page-action-item"> <a href="" data-ng-click="addFolder('unix', true)">
																	<cv:msg key="action.add" bundle="profiles" /></a>
															</span>
														</div>
													</div>
													<div class="peopleInfos ownerInfo">
														<div class="users-list limit-modal-height">
															<ul class="users-list__user less-padding group" data-ng-repeat="exclude in unixExcludeSelected track by $index">
																<li title="{{exclude}}"><span class=" content-library-folder content-library-{{exclude | trimUnixFolderName}}"
																	data-ng-class="{'content-library-file' : {{exclude | isFolder}} === false}">
																		<label for="unix-{{exclude}}" class="ellipsis-parent ellipsis-content">{{exclude
																			| trimUnixFolderName}} </label> <span class="delete-row"><a href="javascript:void(0);" data-ng-click="toggleUnixExcludeSelection(exclude)"
																			title="<cv:msg key='label.removeContent' bundle='collectionsJs' /> {{exclude | trimUnixFolderName}}">&times;</a></span>
																	</span></li>
															</ul>
															<div class="backup-content-empty" ng-hide="unixExcludeSelected.length" ng-click="addFolder('unix', true)">
																<div>
																	<svg xmlns="http://www.w3.org/2000/svg" width="84" height="84" viewBox="0 0 84 84">
																		<path d="M39.6,64.3c0-9.6,5.6-18.3,14.3-22.4c-1.1-3.7-2.8-7.2-5-10.4c-3.2-4.5-5.8-7.3-7.1-13s0.4-4-0.8-9
																				c-0.4-2.1-1.3-4-2.6-5.7c-0.9-1.1-2-1.9-3.3-2.5C31.6-0.5,27.4-0.4,24,1.5c-5.3,2.7-4.6,8.8-3.8,20.8c0.3,3.3-2.8,5.5-5.5,9.7
																				c-2,3.2-3.7,6.6-5.1,10.1c-1.5,3.8-1.6,4.2-0.8,7.4l-0.2,0.2c-0.7,0.7-1.6,2.5-2.8,3.5S1.3,54,0.5,55s0,2.6,0,5.5
																				c0,0.9-0.1,1.9-0.3,2.8C-0.1,64,0,64.9,0.3,65.6c0.7,1.2,1.8,1.5,8.3,2.8c3.5,0.8,6.8,2.6,9.1,2.8s2.6-0.5,4-1.7l1.1-0.9
																				c2.4-1.1,1.7-0.7,6.1-1s6-0.5,10.4,0.7c0.1,0.7,0.5,1.3,1,1.8C39.8,68.2,39.6,66.3,39.6,64.3z M29.6,12.1c0.5-1.3,1.9-2.2,3.3-2.2
																				c1.3,0.1,1.8,0.4,2.7,2c0.8,1.3,1,2.8,0.6,4.2c-0.1,0.7-0.5,1.4-1.1,1.8L33,17.2c0.5-0.1,1-0.4,1.3-0.8c0.3-0.5,0.5-1,0.4-1.6
																				c-0.2-1.2-0.8-2.1-1.9-2.1c-0.5-0.1-0.9,0.1-1.3,0.4c-0.4,0.5-0.7,1.1-0.6,1.7c0,0.5,0.1,1.1,0.2,1.6l-0.5-0.3l-1.1-0.5
																				c-0.1-0.4-0.2-0.8-0.2-1.2C29.2,13.6,29.3,12.8,29.6,12.1z M21.5,13.3c0-0.6,0.2-1.1,0.4-1.6c0.3-0.7,0.8-1.2,1.2-1.2
																				c0.8-0.2,1.7,0.1,2.2,0.8C26,12,26.4,13,26.4,14c0,0.5,0,1.1-0.1,1.6l-0.6,0.2l-0.6,0.3c0.1-0.4,0.1-0.8,0.1-1.2
																				c0-0.5-0.1-1-0.4-1.5c-0.3-0.4-0.7-0.6-1.2-0.7c-0.4,0-0.9,0.2-1.1,0.6c-0.2,0.5-0.3,1-0.2,1.5c0,0.6,0.2,1.2,0.6,1.7
																				c0.4,0.4,0.5,0.7,0.8,0.7l-0.5,0.4L22.8,18c-0.4-0.4-0.6-0.8-0.8-1.3C21.6,15.6,21.4,14.5,21.5,13.3z M39.2,59.2
																				c-2.2,2.4-5.2,4-8.4,4.6c-5,1-7.3,0.1-8.2-0.5c-0.9-1-1.7-2.1-2.5-3.3c0.9,0,1.9-0.2,2.6-0.8c0.4-0.9,0.4-1.9-0.2-2.7
																				c-0.4-0.7-3.3-2.8-4.7-4s-2.1-1.8-3-2.5l-0.6-0.5c-0.7-0.7-1.2-1.4-1.7-2.2c-0.5-1.2-0.7-2.5-0.5-3.8c0.3-2.1,0.9-4.1,1.9-6
																				c0.4-0.7,1.3-2.5,1.5-2.3s-0.6,0.8-1.6,3.3c-0.8,1.6-1.3,3.4-1.5,5.2c-0.1,1.3,0.1,2.5,0.6,3.7c0.3,0.5,0.7,1,1.1,1.5
																				c-0.1-0.5-0.1-1.1-0.1-1.6c-0.1-2.8,0.5-4.1,0.9-6.2s2.5-4.7,3.1-6.8l0.3-1c0.2-0.6,0.4-1.2,0.6-1.8c0.3-1,0.8-2,1.4-2.9
																				c1.1-1.8,1.7-1.8,1.7-3c0-1.2,0-2.3,0.2-3.5l0,0l1.2,1.1c1.1,0.9,1.9,2,2.6,2.2c0.9,0.2,1.7,0.2,2.6,0.2c1.8,0,4.1-2.3,5.4-2.7
																				c0.8-0.2,1.5-0.7,1.9-1.4c0.5,0.7,0.5,2.1,1.6,3.9s1.4,4,3.1,7.6c0.9,1.7,1.7,3.5,2.4,5.3c0.7,2.6,1.1,5.3,1,8
																				c0,1.2-0.1,2.5-0.3,3.7h-1.1c-0.6-0.1-1.3,0.1-1.8,0.5c-0.4,0.2-0.5,1.9-0.5,3.8s0.1,2.8,0,4.1L39.2,59.2z M14.2,49.5
																				c-0.1-0.2-0.2-0.4-0.2-0.6c0.4,0.5,0.8,0.8,0.7,0.9S14.5,49.7,14.2,49.5z M64.2,84c-10.9,0-19.8-8.9-19.8-19.8
																				c0-10.9,8.9-19.8,19.8-19.8c10.9,0,19.8,8.9,19.8,19.8S75.1,84,64.2,84L64.2,84z M63.2,49.4c-8.2,0.7-14.3,7.9-13.6,16.1
																				c0.6,7.3,6.4,13,13.6,13.6c8.2,0.7,15.4-5.4,16.1-13.6c0.7-8.2-5.4-15.4-13.6-16.1C64.8,49.3,64,49.3,63.2,49.4z M71.6,66.7H56.8
																				c-1.4,0-2.5-1.1-2.5-2.5c0-1.4,1.1-2.5,2.5-2.5h14.8c1.4,0,2.5,1.1,2.5,2.5C74.1,65.6,73,66.7,71.6,66.7z" />
																	</svg>
																</div>
																<div>
																	<h5>
																		<cv:msg key="label.addExcludes" bundle="profiles" />
																	</h5>
																</div>
															</div>
														</div>
													</div>
												</div>
											</div>
										</div>
									</uib-tab>
								</uib-tabset>
							</span>
						</div>
					</cv-derivable-input>
				</cv-plain-accordion>
			</uib-accordion>
		</div>
		<!-- RPO and SLA end -->
		<div class="schedule" data-ng-class="{'padding-left-right' : skipForSetup}">
			<uib-accordion close-others="true" class="text-left"> 
				<cv-plain-accordion
						data-ng-if="showDatabaseAccordion && templateLoadingCompleted"
						accordion-label='label.snapshotOptions'
						collapsed="status.collapseSnapshotOptions">
      
     
     
     
     
    
     
     
     
     
     
					<div class="">
						<div class="setup-input-group">
							<cv-derivable-input-toggle data-model="globalTemplate.deriveSettings.definesStorage.definesEntity"
									class="row" data-toggle-class="col-xs-6 col-sm-5" data-help-text-class="col-xs-6 col-sm-7"
									data-derive-setting="globalTemplate.deriveSettings.definesStorage.overrideEntity" data-ng-if="isDerived">
							</cv-derivable-input-toggle>
						</div>
    
						<cv-derivable-input data-override-base="!isDerived || globalTemplate.deriveSettings.definesStorage.definesEntity">
							<div class="plan-addons">
											<label for="snapRecoveryPoints" class="addon-option-label">
												<input id="retention-jobs-mode-for-plan" name="planRetentionMode" type="radio" value="JOBS" data-ng-model="retentionInfo.retentionMode" class="ng-pristine ng-untouched ng-valid ng-empty">
													<cv:msg key="label.snapRecoveryPoints" bundle="profiles" />
											</label>
											<input id="snapRecoveryPoints" name="snapRecoveryPoints"
												type="number" min="1"
												data-ng-model="globalTemplate.storageInfo.snapRecoveryPoints"
												class="addon-option-input" />
     
									<label class="addon-option-label" for="retention-non-jobs-mode" >
										<input value="NON_JOBS" id="retention-non-jobs-mode-for-plan" name="planRetentionMode" type="radio" data-ng-model="retentionInfo.retentionMode"/>
										<span><cv:msg key="label.retentionDays" bundle="collections"/></span>
									</label>
										<input class="policy-retention" data-ng-hide="retentionInfo.type === 'INFINITE'"  type="number" min="0" max="9999" data-ng-model="retentionInfo.value"/>
										<select class="retention-type" data-ng-model="retentionInfo.type" data-ng-options="unit.type as unit.label for unit in retentionUnitTypes"></select>
										</div>
										<div class="global-options remove-border-padding">
											<label>
												<toggle-control
													id="snapshot-backup-copy-toggle"
													status="globalTemplate.storageInfo.backupCopy ? 'enabled-activity' : 'disabled-activity'"
													title="<cv:msg key="label.enableDisable" bundle="messages"/>"
													data-ng-click="globalTemplate.storageInfo.backupCopy = !globalTemplate.storageInfo.backupCopy"></toggle-control>
												<span class="addon-option-label">
													&nbsp;
													<cv:msg key="label.enableBackupCopy" bundle="profiles" />
												</span>
											</label>
										</div>
										<div class="plan-addons"
											data-ng-if="globalTemplate.storageInfo.backupCopy">
											<label class="addon-option-label">
												<cv:msg key="label.backupCopyRPO" bundle="profiles" />
											</label>
											<input data-ng-class="{'has-invalid-rpo-time' : invalidBackupCopyRPOHours}" data-ng-change="validateRPOHour(globalTemplate.backupCopyRPO.hours)" class="addon-option-input" type="number" min="0" max="23"
												name="logSlaHours" id="logSlaHours"
												data-ng-model="globalTemplate.backupCopyRPO.hours" />
											&nbsp;
											<label
												class="inline-label schedule-repeat-label vertial-align-middle"
												for="logSlaHours">
												<cv:msg key="label.hours" bundle="schedule" />
											</label>
											<input data-ng-class="{'has-invalid-rpo-time' : invalidBackupCopyRPOMinutes}" data-ng-change="validateRPOMinute(globalTemplate.backupCopyRPO.minutes)" class="addon-option-input" type="number" min="0" max="59"
												name="logSlaMinutes" id="logSlaMinutes"
												data-ng-model="globalTemplate.backupCopyRPO.minutes" />
											&nbsp;
											<label
												class="inline-label schedule-repeat-label vertial-align-middle"
												for="logSlaMinutes">
												<cv:msg key="label.minutes" bundle="schedule" />
											</label>
												<div class="help-block" data-ng-show="showSnapBackupError" data-ng-bind="snapBackupError.message">
											</div>
							</div>
						</cv-derivable-input>
					</div>
      
      
     
					</cv-plain-accordion> 
     
     
					<cv-plain-accordion
						data-ng-if="showDatabaseAccordion && templateLoadingCompleted"
						accordion-label='label.databaseOptions'
						accordion-help-label="info.optionForDatabaseAgents"
						collapsed="status.collapseDatabaseOptions">
      
					<div class="">
						<div class="setup-input-group">
							<cv-derivable-input-toggle data-model="globalTemplate.deriveSettings.definesSchedule.definesEntity"
									class="row" data-toggle-class="col-xs-6 col-sm-5" data-help-text-class="col-xs-6 col-sm-7"
									data-derive-setting="globalTemplate.deriveSettings.definesSchedule.overrideEntity" data-ng-if="isDerived">
							</cv-derivable-input-toggle>
						</div>
    
						<cv-derivable-input data-override-base="!isDerived || globalTemplate.deriveSettings.definesSchedule.definesEntity">
								<div class="plan-addons">
										<label class="addon-option-label">
											<cv:msg key="label.logBackupRPO" bundle="profiles" />
										</label>
										<input class="addon-option-input" type="number" min="0"
											name="logSlaHours" id="logSlaHours"
											data-ng-model="globalTemplate.database.rpoTime.hours" />
										&nbsp;
										<label
											class="inline-label schedule-repeat-label vertial-align-middle"
											for="logSlaHours">
											<cv:msg key="label.hours" bundle="schedule" />
										</label>
										<input class="addon-option-input" type="number" min="0"
											name="logSlaMinutes" id="logSlaMinutes"
											data-ng-model="globalTemplate.database.rpoTime.minutes" />
										&nbsp;
										<label
											class="inline-label schedule-repeat-label vertial-align-middle"
											for="logSlaMinutes">
											<cv:msg key="label.minutes" bundle="schedule" />
										</label>
										<div class="help-block" data-ng-show="showLogBackupError" data-ng-bind="logBackupError.message">
										</div>
									</div>
									<div class="global-options remove-border-padding">
										<label>
											<toggle-control
												id="database-backup-log-cache-toggle"
												status="globalTemplate.database.useStorageSpaceFromMA ? 'enabled-activity' : 'disabled-activity'"
												title="<cv:msg key="label.useDiskCacheForLogBackups" bundle="profiles" />"
												data-ng-click="globalTemplate.database.useStorageSpaceFromMA = !globalTemplate.database.useStorageSpaceFromMA"></toggle-control>
											<span class="addon-option-label">
												&nbsp;
												<cv:msg key="label.useDiskCacheForLogBackups" bundle="profiles" />
											</span>
										</label>
									</div>
									<div class="plan-addons"
										data-ng-show="globalTemplate.database.useStorageSpaceFromMA">
										<label class="addon-option-label inline-label">
											<cv:msg key="lable.commitDailyAt" bundle="profiles" />
										</label>
										<input class="addon-option-input" type="number" min="1" max="24"
											name="sweepIntervalHour" id="sweepIntervalHour"
											data-ng-model="globalTemplate.database.sweepIntervalHour" />
										&nbsp;
										<label
											class="inline-label schedule-repeat-label vertial-align-middle"
											for="sweepIntervalHour">
											<cv:msg key="label.hours" bundle="schedule" />
										</label>
									</div>
						</cv-derivable-input>
      
					</div>
      
     
					</cv-plain-accordion>
				<div uib-accordion-group is-open="status.schedule" data-ng-if="associatedSchedulesEnabled">
					<uib-accordion-heading>
						<cv-derivable-input data-override-base="!isDerived || globalTemplate.deriveSettings.definesSchedule.definesEntity">
						<div class="plain-accordion cv-accordion">
							<div class="cv-accordion-header" data-ng-class="{'expanded': status.schedule}">
								<span class="cv-accordion-text"><cv:msg key="label.associatedSchedule" bundle="schedule"/></span>
								<span>
								<a data-ng-if="status.schedule" href="" class=" accordion-heading-action-link margin-top-0 margin-right-5" data-ng-click="addSchedule()"
									data-ng-class="{disabled: isDerived && !globalTemplate.deriveSettings.definesSchedule.definesEntity}"><cv:msg key="label.addSchedule" bundle="profiles" /></a>
								<span class="cv-accordion-icon k-icon k-i-arrow-chevron-down"></span>
								</span>
							</div>
						</div>
						</cv-derivable-input>
					</uib-accordion-heading>
					<cv-derivable-input data-override-base="!isDerived || globalTemplate.deriveSettings.definesSchedule.definesEntity">
						<div class="schedule-list margin-top-0">
							<ul class="add-schedule__List group" data-ng-repeat="schedule in addedSchedules track by $index">
								<li class="ellipsis-parent ellipsis-content ">
									<a class="always-enabled" data-ng-click="editSchedule(schedule)">{{schedule.name}} </a>
									<span data-ng-if="schedule.flags === slaFlag" class='parenthetical-text'>- 
										<cv:msg key="label.rpoSchedule" bundle="profiles" /></span><span data-ng-if="schedule.flags === fullBackupRPOFlag" class='parenthetical-text'>- <cv:msg key="label.rpoFullSchedule" bundle="profiles" /></span></li>
							</ul>
							<ul class="add-schedule__List group" data-ng-if="addedSchedules.length==0">
								<li class="ellipsis-parent ellipsis-content "><cv:msg key="error.noScheduleAdded" bundle="schedule" /> </li>
							</ul>
						</div>
					</cv-derivable-input>
				</div>
				<cv-plain-accordion class="derive-accordion bootstrap-wrapper" accordion-label="label.overrideRestrictions">
					<cv-derive-settings data-sealed="globalTemplate.sealed" data-model="globalTemplate.deriveSettingsInputModel">
						<cv-derive-select data-name="StoragePolicy" data-class="row" data-label-class="col-xs-12 col-md-6" data-select-class="col-xs-12 col-md-6">
							<span><cv:msg key="label.storagePool" bundle="profiles" /></span><%--
							<span class="subtext full-size"><cv:msg key="label.retentionDays" bundle="collections" /></span>--%>
						</cv-derive-select>
						<cv-derive-select data-name="SchedulePolicy" data-class="row" data-label-class="col-xs-12 col-md-6" data-select-class="col-xs-12 col-md-6">
							<cv:msg key="label.rpo" bundle="profiles" />
						</cv-derive-select>
						<div data-ng-if="windowsFolderSelected.length || unixFolderSelected.length || macFolderSelected.length">
							<cv-derive-select data-name="SubclientPolicyWin" data-class="row" data-label-class="col-xs-12 col-md-6" data-select-class="col-xs-12 col-md-6">
								<cv:msg key="label.folderToBackup" bundle="profiles" />
							</cv-derive-select>
							<cv-derive-select data-name="SubclientPolicyLin" data-group-with="SubclientPolicyWin"></cv-derive-select>
							<cv-derive-select data-name="SubclientPolicyMac" data-group-with="SubclientPolicyWin"></cv-derive-select>
						</div>
					</cv-derive-settings>
				</cv-plain-accordion>
			</uib-accordion>
		</div>
		<!-- Rule details -->
		<!-- RPO and SLA end -->
		<div class="schedule" data-ng-if="globalTemplate.storages.length>0 && enableRules" data-ng-class="{'padding-left-right' : skipForSetup}">
			<uib-accordion close-others="true" class="text-left">
				<div class="derive-accordion" uib-accordion-group is-open="status.storageRules">
					<uib-accordion-heading>
					<div class="plain-accordion cv-accordion">
						<div class="cv-accordion-header" data-ng-class="{'expanded': status.storageRules}">
						<span class="cv-accordion-text"><cv:msg key="label.storageRules" bundle="profiles" /></span>
					  	<span>
						  	<a href="" data-ng-if="status.storageRules" class="accordion-heading-action-link margin-top-0 margin-right-5" data-ng-click="addRule()"><cv:msg key="label.addRule" bundle="profiles" /></a>
					    	<span class="cv-accordion-icon k-icon k-i-arrow-chevron-down"></span>
						</span>
						</div>
					</div>
					</uib-accordion-heading>
					<div class="plan-rule-grid">
					<cv-rules-set profile-details="globalTemplate" data-cv-on-register-api="onRegisterPlanRuleApi" is-tab-set="true" show-edit="showEdit" data-cv-on-rule-added="onRuleAdded" is-new-plan="true"> </cv-rules-set>
				</div>
				</div>
			</uib-accordion>
		</div>
		<!-- end -->
</div></div>
		<div class="button-container">
			<button id="serverPlanTemplate_button_#6344" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="cancel()"><cv:msg key="action.cancel" bundle="profiles"/></button>
			<button id="serverPlanTemplate_button_#4721" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="skip()" data-ng-if="showPlanSkip && skipForSetup && !isCoreSetup"><cv:msg key="action.skip" bundle="profiles"/></button>
			<button id="serverPlanTemplate_button_#4019" type="submit" class="btn btn-primary cvBusyOnAjax" ><cv:msg key="action.save" bundle="profiles"/></button>
		</div>
	</form>
	<div data-ng-hide="showCreatePlanForm || !showPlanSkip || !skipForSetup" class="button-container centered">
		<button id="serverPlanTemplate_button_#8896" type="button" class="btn btn-default cvBusyOnAjax skip-btn--hidden" data-ng-click="skip()"><cv:msg key="label.continue" bundle="profiles" /></button>
	</div>
</div>