<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.storage"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
	<cv:cvMessages bundle="localization.scheduleJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.users"></cv:cvMessages>
	<cv:cvMessages bundle="localization.dbs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.navJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.archiving"></cv:cvMessages>
	<cv:cvMessages bundle="localization.settingsJs"></cv:cvMessages>
</script>
<div class="row">
	<div class="col-md-12">
			<span data-ng-if="showEdit"><cv-changename obj='changeNameObj' service-method="renamePlan.do" class="float-left"></cv-changename></span>
			<h1 class='page-title' data-ng-if="!showEdit">
				<span data-ng-bind="profileName"></span>
			</h1>
			<!-- <span><a class="page-action-item" href=""><cv:msg key="action.asignToUsers" bundle="profiles" /></a></span> -->
			<!-- <span data-ng-if="showDelete"><a class="page-action-item" href="" data-ng-click="deleteProfile(profileId,profileName)"><cv:msg key="action.delete" bundle="profiles" /></a></span>
			<span data-ng-if="showDerive">
				<a href="" class="page-action-item" data-ng-click="derivePlan()"><cv:msg key="action.derive" bundle="profiles"></cv:msg></a>
			</span> -->
			<cv-capability-links data-ng-if="profileDetails" cv-permitted-options="permittedOptions"></cv-capability-links>
	</div>
</div>
<div data-ng-if='hasTabs'><cv-tab-nav></cv-tab-nav></div>
<span class="server-message" data-ng-class="serverMessage.type" data-ng-bind="serverMessage.message"></span>
<div class="row profile-info">
	<div class="col-md-6">
		<cv-tile-component ng-if="planSubType === 'Archiver'" data-ac-id="label_archivingRules" class="bootstrap-wrapper archiving-rules" data-loader="archivingRulesInfo" data-override-text="arcRulesOverrideText" data-title="<cv:msg key="label.archivingRules" bundle="archiving"/>">
			<ul class="list-style-secondary">
				<li class="group">
					<span class="pageDetailColumn">
						<cv:msg key="label.archivingRules.fileTimestamp" bundle="profiles" />
					</span>
					<span class="pageDetailColumn form-group">
						<span ng-if="hideEditArchivingRulesTimeStamp" ng-bind="fileTimestampConfig.accessRule.name"></span>
						<select ng-if="!hideEditArchivingRulesTimeStamp" ng-model="fileTimestampConfig.accessRule" ng-options="fileAccessRule as fileAccessRule.name for fileAccessRule in fileAccessRules"></select>
						<span ng-if="hideEditArchivingRulesTimeStamp" ng-bind="fileTimestampConfig.lastAccessedAgo"></span>
						<input ng-if="!hideEditArchivingRulesTimeStamp" id="accessedAgo" name="accessedAgo" type="number" min="0" max="999" ng-model="fileTimestampConfig.lastAccessedAgo"/>
						<span ng-if="hideEditArchivingRulesTimeStamp" ng-bind="fileTimestampConfig.timestampRule.name"></span>
						<select ng-if="!hideEditArchivingRulesTimeStamp" ng-model="fileTimestampConfig.timestampRule" ng-options="fileTimestampRule as fileTimestampRule.name for fileTimestampRule in fileTimestampRules"></select>
						<span><cv:msg key="label.ago" bundle="profiles" /></span>
						<span ng-if="!hideEditArchivingRulesTimeStamp" class="padding-left-5">
							<a class="inline-editor-button" href ng-click="saveArchivingRules('hideEditArchivingRulesTimeStamp')"><span class="k-icon k-i-check"></span></a>
							<a class="inline-editor-button" href ng-click="toggleEditArchivingRules('hideEditArchivingRulesTimeStamp');"><span class="k-icon k-i-x"></span></a>
						</span>
						<span ng-if="showEdit && hideEditArchivingRulesTimeStamp && !hideEditArchivingRules" class="padding-left-5">
							<a href ng-click="toggleEditArchivingRules('hideEditArchivingRulesTimeStamp');">
								<span class="glyphicon glyphicon-pencil"></span>
							</a>
						</span>
					</span>
				</li>
				<li class="group">
					<span class="pageDetailColumn">
						<cv:msg key="label.archivingRules.fileSize" bundle="profiles" />
					</span>
					<span class="pageDetailColumn form-group">
						<span><cv:msg key="label.greaterThan" bundle="profiles" /></span>
						<span ng-if="hideEditArchivingRulesFileSize" ng-bind="fileSizeConfig.size"></span>
						<input ng-if="!hideEditArchivingRulesFileSize" id="size" name="size" type="number" min="0" ng-model="fileSizeConfig.size"/>
						<span ng-if="hideEditArchivingRulesFileSize" ng-bind="fileSizeConfig.rule.name"></span>
						<select ng-if="!hideEditArchivingRulesFileSize" ng-model="fileSizeConfig.rule" ng-options="fileSizeRule as fileSizeRule.name for fileSizeRule in fileSizeRules"></select>
						<span ng-if="!hideEditArchivingRulesFileSize" class="padding-left-5">
							<a class="inline-editor-button" href ng-click="saveArchivingRules('hideEditArchivingRulesFileSize')"><span class="k-icon k-i-check"></span></a>
							<a class="inline-editor-button" href ng-click="toggleEditArchivingRules('hideEditArchivingRulesFileSize');"><span class="k-icon k-i-x"></span></a>
						</span>
						<span ng-if="showEdit && hideEditArchivingRulesFileSize && !hideEditArchivingRules" class="padding-left-5">
							<a href ng-click="toggleEditArchivingRules('hideEditArchivingRulesFileSize');">
								<span class="glyphicon glyphicon-pencil"></span>
							</a>
						</span>
					</span>
				</li>
			</ul>
		</cv-tile-component>
		<!-- General tile -->
		<cv-tile-component data-ac-id="label_general-profiles" data-title='<cv:msg key="label.general" bundle="profiles"/>' loader="generalInfo" data-ng-if="planSubType=='Laptop'">
			<ul class="list-style-secondary">
				<li class="group" data-ng-if="planSubType=='Laptop'"><span class="pageDetailColumn"><cv:msg key="label.noOfUsers" bundle="profiles" /></span>
					<a class="pageDetailColumn" data-ng-if="generalInfo.numberOfUsers > 0" href="#users?planName={{profileName}}&planId={{profileId}}">{{generalInfo.numberOfUsers}}</a>
					<p class="pageDetailColumn" data-ng-if="generalInfo.numberOfUsers === 0" >{{generalInfo.numberOfUsers}}</p>
				</li>
				<li class="group" data-ng-if="planSubType=='Laptop'"><span class="pageDetailColumn"><cv:msg key="label.noOfDevices" bundle="profiles" /></span>
					<a class="pageDetailColumn" data-ng-if="generalInfo.numberOfDevices > 0" href="#devices?planName={{profileName}}&planId={{profileId}}">{{generalInfo.numberOfDevices}}</a>
					<p class="pageDetailColumn" data-ng-if="generalInfo.numberOfDevices === 0" >{{generalInfo.numberOfDevices}}</p>
			   </li>
				<cv-cloud-direct plan-id="profileId" options="options" has-resource-pool="hasResourcePool"
					non-applicable-pools="nonApplicableStoragePools"
					data-ng-if="showOptimizeCloudBackupOption && options">
				</cv-cloud-direct>
			</ul>
		</cv-tile-component>
		<!-- General tile -->
		<cv-tile-component data-ac-id="label_general-profiles" data-title='<cv:msg key="label.general" bundle="profiles"/>' loader="generalInfo" data-ng-if="showIndexingOption">
			<ul class="list-style-secondary">
				<li class="group">
					<span class="pageDetailColumn">
						<cv-help-text help-label="label.enableIndexing" help-text="label.indexingHelpText"></cv-help-text>
					</span>
					<span class="pageDetailColumn">
					<!-- <span class="pageDetailColumn"> -->
						<toggle-control
							status="profileDetails.options.enableIndexing ? 'enabled-activity' : 'disabled-activity'"
							data-ng-click="toggleEnableIndexing()">
						</toggle-control>
					</span>
				</li>
			</ul>
		</cv-tile-component>
		<!-- Backup content  -->
		<cv-tile-component data-ac-id="label_backupContent-profiles" data-ng-if="laptopPlan || showBackupContent" data-title='<cv:msg key="label.backupContent" bundle="profiles"/>' data-override-text="backupContentOverrideText" loader="localContentTemplate" data-min-height="true">
			<ul class="list-style-secondary">
				<li data-ng-if="winScAvailable !== false" class="group"><span class="pageDetailColumn"><cv:msg key="label.windows" bundle="profiles" /></span>
					 <span class="pageDetailColumn"><span ng-bind="foldersDisplay.windowsFolderDisplay | trimFolderName"></span><span data-ng-if="foldersDisplay.windowsFolderDisplay == '\\'" class='laptop-content-help-text less-padding'> - &nbsp;<cv:msg key='label.allContents' bundle='profiles'/></span></span> </li>
				<li data-ng-if="macScAvailable !== false" class="group"><span class="pageDetailColumn"><cv:msg key="label.mac" bundle="profiles" /></span>
					 <span class="pageDetailColumn"><span ng-bind="foldersDisplay.macFolderDisplay | trimUnixFolderName"></span><span data-ng-if="foldersDisplay.macFolderDisplay == '/'" class='laptop-content-help-text less-padding'> - &nbsp;<cv:msg key='label.allContents' bundle='profiles'/></span></span></li>
				<li data-ng-if="unixScAvailable !== false"class="group"><span class="pageDetailColumn"><cv:msg key="label.unix" bundle="profiles" /></span>
					 <span class="pageDetailColumn"><span ng-bind="foldersDisplay.unixFolderDisplay | trimUnixFolderName"></span><span data-ng-if="foldersDisplay.unixFolderDisplay == '/'" class='laptop-content-help-text less-padding' > - &nbsp;<cv:msg key='label.allContents' bundle='profiles'/></span></span></li>
			</ul>
			<div class="page-details-box-links" data-ng-if="localContentTemplate">
				<a href="" data-ng-click="modifyBackupContent()">
					<span data-ng-if="(showEdit && !hideEditBackupContent) || (!deriveDetails.isDerived && !showEdit && !hideEditBackupContent)"><cv:msg key="action.edit" bundle="profiles" /></span>
					<span data-ng-if="(!deriveDetails.isDerived && !showEdit && hideEditBackupContent) || hideEditBackupContent || (deriveDetails.isDerived && !showEdit)"><cv:msg key="action.view" bundle="profiles" /></span>
				</a>
			</div>
		</cv-tile-component>
		<!-- Storage -->
		<!-- below directive is only for snap plan, since snap plan does not have secondary storage  -->
		 <cv-storage-pool-tile data-ng-if="snapPlan" plan-sub-type="planSubType" show-edit="showEdit && !hideEditStorage" profile-id="profileId" data-override-text="storageOverrideText"
							  primary-storage-pool-info="primaryStoragePoolInfo" secondary-storage-pool-info="secondaryStoragePoolInfo" snap-storage-info="snapStorageInfo" showextendedretention="true" ></cv-storage-pool-tile>
		<!-- below directive is used for server/laptop/FS/database plan -->
	  	<cv-plan-storage-pool data-ng-if="!snapPlan && policyId &&  !enableRules" profile-details="profileDetails" master-profile="masterProfile" plan-sub-type="planSubType" show-edit="showEdit && !hideEditStorage" data-override-text="storageOverrideText" allow-many-storages="serverPlan"></cv-plan-storage-pool>
		<!-- Storage before sp5 -->
		 <cv-tile-component data-ac-id="label_storage-profiles" data-ng-if="storageInfo" data-title='<cv:msg key="label.storage" bundle="profiles"/>' loader="storageInfo">
			<span data-ng-if="storageInfo.libraryName==''">
				<p class="info-place-holder"><cv:msg key="error.noStorageConfigured" bundle="profiles"/></p>
			</span>
			<ul class="list-style-secondary" data-ng-if="storageInfo.libraryName!=''">
				<li class="group"><span class="pageDetailColumn"><cv:msg key="label.library" bundle="profiles" /></span>
					 <span class="pageDetailColumn">{{storageInfo.libraryName}}</span></li>
				<li class="group" data-ng-if="storageInfo.retentionInDays && planSubType == 'Laptop'"><span class="pageDetailColumn"><cv:msg key="label.retentionPeriod" bundle="profiles" /></span>
					 <span class="pageDetailColumn">{{storageInfo.retentionInDays}} <cv:msg key="label.days" bundle="profiles" /></span></li>
				<li class="group" data-ng-if="storageInfo.retentionInDays && (planSubType == 'Server' || planSubType === 'Archiver')"><span class="pageDetailColumn"><cv:msg key="label.retentionDays" bundle="collections" /></span>
					 <span class="pageDetailColumn">{{storageInfo.retentionInDays}} <cv:msg key="label.days" bundle="profiles" /></span></li>
				<li class="group" data-ng-if="storageInfo.snapRecoveryPoints && snapPlan"><span class="pageDetailColumn"><cv:msg key="label.snapRecoveryPoints" bundle="profiles" /></span>
					 <span class="pageDetailColumn">{{storageInfo.snapRecoveryPoints}}</span></li>
			</ul>
			<div class="page-details-box-links" data-ng-if="storageInfo && showEdit">
				<a data-ng-click="modifyStorage()"><cv:msg key="action.edit" bundle="profiles" />
				</a>
			</div>
		</cv-tile-component>
		<!-- Storage end -->
		<!-- Associated users/groups -->
		<cv-tile-component data-ac-id="label_associateUserAndGroup-profiles" data-ng-if="laptopPlan" help-text='<cv:msg key="info.associatedUserInfo" bundle="profiles"/>' data-title='<cv:msg key="label.associateUserAndGroup" bundle="profiles"/>' loader="invitedUsers" min-height="true">
	 		<span data-ng-if="invitedUsers.userList.length==0">
				<p class="info-place-holder"><cv:msg key="error.noUsers" bundle="profiles"/></p>
			</span>
			<ul class="list-style__row group associated-users" data-ng-repeat="users in invitedUsers.userList">
				<li data-ng-if="users.user" class="user-type"><span class="invite-user-plan">{{users.user.userName}}</span> </li>
				<li data-ng-if="users.userGroup" class="group-type"><span class="invite-user-plan">{{users.userGroup.userGroupName}}</span></li>
				<li data-ng-if="users.externalUserGroup" class="group-type"><span class="invite-user-plan">{{users.externalUserGroup.externalGroupName}}</span></li>
			</ul>
			<div class="page-details-box-links multiLinks" data-ng-if="invitedUsers.userList">
				 <a href="" data-ng-click="editInviteUsersAndGroup('Edit',profileName)"><cv:msg key="action.edit" bundle="profiles" />
				</a>
				<!-- <a href="" data-ng-click="editInviteUsersAndGroup('Invite')">Invite
				</a> -->
			</div>
		</cv-tile-component>
		<!-- Security -->
		<cv-security-component entity-type='entityType' generic-entity = 'genericEntity' show-edit="showEdit"
				associations='formattedSecurityAssociations' associations-loaded="associationsLoaded" hide-inherited-associations="isTenantAdmin">
		</cv-security-component>
		<cv-derive-component data-ng-if="showDeriveComponent" data-settings="deriveDetails.settings"
				data-show-edit="showEdit && !deriveDetails.isDerived" data-plan-id="profileId" data-sealed="deriveDetails.isSealed" data-base-plan="basePlan" data-on-override-update = "onOverrideUpdate">
		</cv-derive-component>

		<div data-ng-if="laptopPlan && showManageIdleClient">
			<cv-manage-idle-clients  auto-retire-devices="options.autoRetireDevices" level="PLAN" entity-id="profileId" entity-name="profileName"></cv-manage-idle-clients>
		</div>

		<cv-entity-tags-tile data-ng-if="entityObject" entity="entityObject" has-edit-permissions="userHasEditTagsPermission"></cv-entity-tags-tile>
	</div>
	<div class="col-md-6">
		<!-- Allowed features -->
		<cv-tile-component data-ac-id="label_allowedFeatures-profiles" data-ng-if="laptopPlan" data-title='<cv:msg key="label.allowedFeatures" bundle="profiles"/>' loader="featureInfo.allowedFeatures" min-height="true" data-override-text="allowedFeaturesOverrideText">
			<ul class="list-style-secondary" data-ng-repeat="feature in globalAllowedFeatures | orderBy: 'name' track by $index">
				<li class="group" data-ng-class="{'dlo-animation': feature.move == 'bottom'}">
					<span class="pageDetailColumn" data-ng-style="feature.selected && {'color' : '#444'}" data-ng-bind="feature.name"></span>
					<span class="pageDetailColumn" data-ng-disabled="hideEditAllowedFeatures">
						<toggle-control data-ng-class="feature.option" status="feature.option" data-ng-click="toggleFeatures(feature)" tooltip="{{feature.tooltip}}" disabled="feature.disabled"></toggle-control>
					</span>
					<span data-ng-if="!hideEditAllowedFeatures">
						<a class="no-index-server-error" data-ng-if="showEdit && feature.value === 146 && featureInfo.noIndexServer" data-ng-click="modifyFeatureList()"><cv:msg key="info.noIndexServer" bundle="profiles" /></a>
						<a class="no-index-server-error" data-ng-if="showEdit && feature.value === 215 && feature.selected" data-ng-click="editArchiving()" ><cv:msg key="label.settings" bundle="profiles" /></a>
						<a class="no-index-server-error" data-ng-if="showEdit && feature.value === 146 && feature.selected && !featureInfo.noIndexServer" data-ng-click="editEdgeDrive()"><cv:msg key="label.settings" bundle="profiles" /></a>
					</span>
				</li>
			</ul>
		</cv-tile-component>
		<!-- RPO and associated schedules -->
		<cv-tile-component data-ac-id="label_sla-profiles" data-title='<cv:msg key="label.rpo" bundle="profiles"/>' data-override-text="scheduleOverrideText" help-text="<cv:msg key="info.help.rpo" bundle="profiles"/>{{slaHelpText}}" loader="slaInfo">
			<ul class="list-style-secondary">
				<li class="incremental-rpo-container-for-profile group">
					<div data-ng-if="incrementalRPOErrorMsg.show"><p class="help-block" data-ng-bind="incrementalRPOErrorMsg.message"></p></div>
					<span class="rpo-tile-labels pageDetailColumn">
					<cv-call-out data-ng-if="planSubType !== 'Server'" placement="top" html-template="rpoDocTemplate" label="<cv:msg key="label.backupFrequency" bundle="profiles" />" trigger="mouseenter">
                    </cv-call-out>
                    <cv-call-out data-ng-if="planSubType === 'Server'" placement="top" html-template="rpoServerPlanDocTemplate" label="<cv:msg key="label.backupFrequency" bundle="profiles" />" trigger="mouseenter">
                    </cv-call-out>
                    </span>
					<span data-ng-if="!editIncrementalRPO" class="formatted-incremental-rpo-lbl pageDetailColumn" ng-class="{'width-60-percentage': uiModel.incrementalRPOBackupFreq.type === 'WEEKS' || uiModel.incrementalRPOBackupFreq.type === 'MONTHS' || uiModel.incrementalRPOBackupFreq.type === 'YEARS'}">
						<span ng-bind="getIncrementalRPOScheduleLabel()"></span>
					</span>
					<div class="pageDetailColumn row rpo-tile-value">
						<div data-ng-if="editIncrementalRPO && ((showEdit && !hideEditSchedule) || (!deriveDetails.isDerived && !showEdit && !hideEditSchedule))" class="col-lg-12 col-md-12 incremental-rpo-options-container form-group cv-inline-wrapper">
							<label class="freqLabel inline-label schedule-repeat-label vertial-align-middle" for="logSlaHours"><cv:msg key="label.incrementalFrequencyText" bundle="profiles"/></label>
							<input id="rpo" name="rpo" type="number" min="1" max="{{serverPlan ? '' : maximumRPOlimit}}" data-ng-pattern="/^[0-9]*$/" required="" data-ng-model="uiModel.incrementalRPOBackupFreq.rpoHours" class="frequency-input storage-retention-input sla-input" data-ng-class="{'setup' : skipForSetup, 'invalid-rpo' : invalidRPO}"/>
							<select data-ng-if="isLaptopAutomaticSchedule()" data-ng-model="uiModel.incrementalRPOBackupFreq.automaticScheduleType" data-ng-change="backupFreqChanged()" data-ng-options="incrementalBackupFreq.value as incrementalBackupFreq.name for incrementalBackupFreq in automaticIncrementalBackupFreqs" class="frequency-select"></select>
							<label data-ng-if="!isLaptopAutomaticSchedule() && !serverPlan && !archiverPlan && !fsIBMiVTLPlan" class="freqLabel inline-label schedule-repeat-label vertial-align-middle" for="logSlaHours"><cv:msg key="label.incrementalRPOFreq.hours" bundle="profiles"/></label>
							<select data-ng-if="serverPlan || archiverPlan || fsIBMiVTLPlan" data-ng-model="uiModel.incrementalRPOBackupFreq.type" data-ng-change="incrementalFrequencyTypeChanged()" data-ng-options="incrementalBackupFreq.value as incrementalBackupFreq.name for incrementalBackupFreq in incrementalBackupFreqs" class="frequency-select"></select>
							<a data-ng-if="editIncrementalRPO && (uiModel.incrementalRPOBackupFreq.type === 'HOURS' || uiModel.incrementalRPOBackupFreq.type === 'MINUTES')" data-ng-disabled="disableSaveBtnForIncremental" data-ng-click="saveIncrementalRPO()" class="save-frequency"><i class="glyphicon glyphicon-ok"></i></a>
							<a data-ng-if="editIncrementalRPO && (uiModel.incrementalRPOBackupFreq.type === 'HOURS' || uiModel.incrementalRPOBackupFreq.type === 'MINUTES')" data-ng-disabled="disableSaveBtnForIncremental" data-ng-click="disableEditModeForIncrementalRPO()" class="disable-edit-frequency"><i class="glyphicon glyphicon-remove"></i></a>

						</div>
						<div ng-if="editIncrementalRPO && (uiModel.incrementalRPOBackupFreq.type === 'DAYS' || uiModel.incrementalRPOBackupFreq.type === 'WEEKS' || uiModel.incrementalRPOBackupFreq.type === 'MONTHS' || uiModel.incrementalRPOBackupFreq.type === 'YEARS')" class="col-lg-12 col-md-12 full-backup-rpo-start-time-container">
							<div  class="margin-bottom-10" ng-if="uiModel.incrementalRPOBackupFreq.type === 'WEEKS'">
								<span>on </span>
								<isteven-multi-select
									input-model="incrementalDaysToRun"
									button-label="name"
									item-label="name"
									tick-property="ticked"
									class="isteven-multi-select user-group-select width-auto incremental-days-to-run"
									id="isteven-multi-select2"
									on-item-click="updateIncrementalDaysToRun()"
									prevent-sort="true"
									max-labels="1">
								</isteven-multi-select>
							</div>
							<div ng-if="uiModel.incrementalRPOBackupFreq.type === 'MONTHS' || uiModel.incrementalRPOBackupFreq.type === 'YEARS'" class="margin-bottom-15">
								<div class="margin-top-10">
									<span class="margin-right-10">
										<input value="RELATIVE" name="incrementalRPOMode" type="radio" data-ng-model="uiModel.incrementalRPOMode" /> 
										<span class="margin-left-10"><cv:msg key="label.on.the" bundle="profiles" /></span>
									</span>
									<select class="width-auto float-none min-width-80" data-ng-disabled="uiModel.incrementalRPOMode !== 'RELATIVE'"
										data-ng-model="uiModel.weekOfMonth"
										data-ng-options="weekToRun.value as weekToRun.name for weekToRun in incrementalWeeksToRun"></select>
									<select class="width-auto float-none min-width-80" data-ng-disabled="uiModel.incrementalRPOMode !== 'RELATIVE'"
										data-ng-model="uiModel.dayOfWeek"
										data-ng-options="dayOfWeek.value as dayOfWeek.name for dayOfWeek in incrementalDaysOfWeek"></select>
								</div>
								<div>
									<span class="margin-right-10">
										<input value="NORMAL" name="incrementalRPOMode" type="radio" data-ng-model="uiModel.incrementalRPOMode"/> 
										<span class="margin-left-10"><cv:msg key="label.on.the" bundle="profiles" /></span>
									</span>
									<input id="incrementalDayOfMonth" name="incrementalDayOfMonth" type="number" data-ng-model="uiModel.dayOfMonth"
										data-ng-change="incrementalDayOfMonthChanged()" ng-blur="incrementalDayOfMonthChanged(true)" data-ng-disabled="uiModel.incrementalRPOMode === 'RELATIVE'"
										class="width-15-percentage" />
									<span ng-bind="getDaySuffix(uiModel.dayOfMonth)"></span>
									<span><cv:msg key="label.rpoFreq.daily" bundle="profiles" /></span>
								</div>
								<div ng-if="uiModel.incrementalRPOBackupFreq.type === 'YEARS'" class="margin-top-10">
									<span class="margin-right-10">        
										<span><cv:msg key="label.of.month" bundle="profiles" /></span>
									</span>
									<select class="width-auto float-none min-width-80" data-ng-model="uiModel.monthOfYear" data-ng-change="incrementalDayOfMonthChanged(true)"
										data-ng-options="monthOfYear.value as monthOfYear.name for monthOfYear in incrementalMonthsOfYear"></select>
								</div>
							</div>
							<div class="at-label"><label class="freq-label inline-label vertial-align-middle"><cv:msg key="label.atLabel" bundle="profiles"/></label></div>
								<div class="time-picker"><table uib-timepicker id="incrementalBackupRPOScheduleTime" name="incrementalBackupRPOScheduleTime" data-ng-change="incrementalBackupRPOStartTimeChanged()" data-ng-model="incrementalBackupScheduleRPOTemp.scheduleTime" hour-step="1" minute-step="15" show-meridian="true" show-spinners="false"></table></div>
								<div class="save-options">
									<a data-ng-if="editIncrementalRPO" data-ng-disabled="disableSaveBtnForIncremental" data-ng-click="saveIncrementalRPO()" class="save-frequency"><i class="glyphicon glyphicon-ok"></i></a>
									<a data-ng-if="editIncrementalRPO" data-ng-disabled="disableSaveBtnForIncremental" data-ng-click="disableEditModeForIncrementalRPO()" class="disable-edit-frequency"><i class="glyphicon glyphicon-remove"></i></a>
								</div>
						</div>
						<div data-ng-if="laptopPlan && editIncrementalRPO && ((showEdit && !hideEditSchedule) || (!deriveDetails.isDerived && !showEdit && !hideEditSchedule))" class="col-sm-12 margin-top-15">
							<a data-ng-click="getSchedulesWithTaskId()"><cv:msg key="label.scheduleOptions" bundle="profiles"/></a>
						</div>
					</div>
					<a data-ng-if="((showEdit && !hideEditSchedule) || (!deriveDetails.isDerived && !showEdit && !hideEditSchedule)) && !editIncrementalRPO" data-ng-click="enableEditModeForIncrementalRPO()" class="edit-frequency"><i class="glyphicon glyphicon-pencil"></i></a>
				</li>
	<li class="group" data-ng-if="planSubType=='Server' || planSubType === 'Archiver' || fsIBMiVTLPlan">
		<div>
			<div data-ng-disabled="((!deriveDetails.isDerived && !showEdit && hideEditSchedule) || hideEditSchedule || (deriveDetails.isDerived && !showEdit)) || disableSaveBtnForFullBackup" data-ng-show="fullBackupScheduleRPO != undefined" class="add-full-backup-container-for-profile">
				<toggle-control class="add-full-backup-toggle"
					status="addFullBackup ? 'enabled-activity' : 'disabled-activity'"
					title="<cv:msg key="label.enableDisable" bundle="messages"/>"
					data-ng-click="toggleFullBackup()">
				</toggle-control>
				<label class="add-full-backup-lbl"><cv:msg key="label.addFullBackup" bundle="profiles" /></label>
			</div>
			<div class="full-backup-container-for-profile plan-addons" data-ng-disabled="disableSaveBtnForFullBackup" data-ng-if="addFullBackup === true">
				<span ng-if="!editMode" class="float-right">
					<a ng-if="(showEdit && !hideEditSchedule) || (!deriveDetails.isDerived && !showEdit && !hideEditSchedule)" data-ng-click="enableEditMode()" class="edit-frequency"><i class="glyphicon glyphicon-pencil"></i></a>
				</span>
				<span class="rpo-tile-labels pageDetailColumn">
					<label class="left-padding"><cv-help-text help-label="<cv:msg key="label.fullBackupFrequency" bundle="profiles" />" help-text="'<cv:msg key='info.help.rpoSchedule.startTime' bundle='profiles' />'"></cv-help-text></label>
				</span>
				<span ng-if="!editMode" class="pageDetailColumn">
					<label  class="formatted-frequency-label" ng-bind="getFullBackScheduleLabel()"></label>
				</span>
				<div class="pageDetailColumn row rpo-tile-value">
					<div ng-if="editMode" class="col-lg-12 col-md-12 rpo-full-backup-container form-group">
						<select ng-if="editMode" data-ng-model="fullBackupScheduleRPOTemp.freqType" data-ng-options="fullBackupFrequencyType.value as fullBackupFrequencyType.name for fullBackupFrequencyType in fullBackupFrequencyTypes" class="frequency-type ng-pristine ng-valid ng-touched"></select>
						<label ng-if="editMode && fullBackupScheduleRPOTemp.freqType != 'DAILY'" class="inline-label schedule-repeat-label vertial-align-middle" for="logSlaHours"><cv:msg key="label.onLabel" bundle="profiles" /></label>
						<select ng-if="editMode && (fullBackupScheduleRPOTemp.freqType === 'MONTHLY_RELATIVE' || fullBackupScheduleRPOTemp.freqType === 'YEARLY_RELATIVE')" data-ng-model="fullBackupScheduleRPOTemp.weekOfMonth" data-ng-options="weekToRun.value as weekToRun.name for weekToRun in weeksToRun" class="monthly-options ng-pristine ng-valid ng-touched"></select>
						<select ng-if="editMode && (fullBackupScheduleRPOTemp.freqType === 'MONTHLY_RELATIVE' || fullBackupScheduleRPOTemp.freqType === 'YEARLY_RELATIVE')" data-ng-model="fullBackupScheduleRPOTemp.dayOfWeek" data-ng-options="dayOfWeek.value as dayOfWeek.name for dayOfWeek in daysOfWeek" class="monthly-options ng-pristine ng-valid ng-touched"></select>
						<div ng-if="fullBackupScheduleRPOTemp.freqType === 'YEARLY_RELATIVE'">
							<span><cv:msg key="label.of.month" bundle="profiles" /></span>
							<select class="width-auto float-none min-width-80" data-ng-model="fullBackupScheduleRPOTemp.monthOfYear"
								data-ng-options="monthOfYear.value as monthOfYear.name for monthOfYear in fullBackupMonthsOfYear"></select>
						</div>
						<isteven-multi-select ng-if="editMode && fullBackupScheduleRPOTemp.freqType === 'WEEKLY'"
			   				  input-model="daysToRun"
			  				  button-label="name"
			  				  item-label="name"
			   				  tick-property="ticked"
			   				  class="full-backup-frequency-days isteven-multi-select user-group-select"
			   				  id="isteven-multi-select2"
								on-item-click="daysToRunChanged(data)"
								prevent-sort="true"
			   				  max-labels="1">
 						</isteven-multi-select>
					</div>
					<div ng-if="editMode" class="col-lg-12 col-md-12 full-backup-rpo-start-time-container">
                        <div class="at-label"><label class="at-label inline-label vertial-align-middle"> <cv:msg key="label.atLabel" bundle="profiles"/> </label></div>
						<div class="time-picker">
								<table uib-timepicker id="fullBackupRPOScheduleTime" name="fullBackupRPOScheduleTime" data-ng-change="fullBackupRPOStartTimeChanged()" data-ng-model="fullBackupScheduleRPOTemp.scheduleTime" hour-step="1" minute-step="15" show-meridian="true" show-spinners="false"></table>
						</div>
						<div class="save-options">
							<a data-ng-click="saveFullBackupRPOSchedule()" data-ng-disabled="disableSaveBtnForFullBackup" class="save-frequency"><i class="glyphicon glyphicon-ok"></i></a>
							<a data-ng-click="disableEditMode()" data-ng-disabled="disableSaveBtnForFullBackup" class="disable-edit-frequency"><i class="glyphicon glyphicon-remove"></i></a>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div data-ng-if="fullBackupRPOErrorMsg.show">
			<p class="full-backup-rpo-error-msg help-block margin-top-10-important margin-left-0" data-ng-bind="fullBackupRPOErrorMsg.message"></p>
		</div>
	</li>
				<li class="group" data-ng-if="!laptopPlan">
					<span class="rpo-tile-labels pageDetailColumn"><cv:msg key="label.backupWindow" bundle="profiles" /></span>
					<span class="pageDetailColumn"><cv-backup-window-list data-cv-model="slaInfo.backupWindow" data-cv-no-edit="!showEdit || hideEditSchedule" data-cv-on-edit="editBackupWindow"></cv-backup-window-list><span>
				</li>
				<li class="group" data-ng-if="serverPlan || fsIBMiVTLPlan">
					<span class="rpo-tile-labels pageDetailColumn">
						<cv:msg key="label.fullBackupWindow" bundle="profiles" />
					</span>
					<span class="pageDetailColumn">
						<cv-backup-window-list data-cv-model="slaInfo.fullBackupWindow" data-cv-no-edit="!showEdit || hideEditSchedule" data-cv-on-edit="editFullBackupWindow"
								data-cv-edit-modal-title='"<cv:msg key="title.editFullBackupWindow" bundle="profiles"/>"'>
						</cv-backup-window-list>
					<span>
				</li>
				<li class="group">
					<cv-sla-options data-entity-data="profileDetails.options.slaOptions" data-entity-type="'PLAN_ENTITY'" data-entity-id="profileId"></cv-sla-options>
				</li>
			</ul>
			<span data-ng-if="associatedSchedulesEnabled && !showAssociatedSchedules" class="tile-link-wrapper">
				<a class="tile-content-link" data-ng-click="getAssociatedSchedule()"><cv:msg key="label.showAssociatedSchedules" bundle="profiles" /></a>
			</span>
		</cv-tile-component>
		<cv-schedule-tile data-ng-if="associatedSchedulesEnabled && showAssociatedSchedules" task-id="taskId" data-profile-id="profileId" show-edit="!isTenantAdmin && showEdit && !hideEditSchedule" data-override-text="scheduleOverrideText" plan-sub-type="planSubType" sla="true"></cv-schedule-tile>
		<!-- Secondary schedule -->
		<cv-schedule-tile data-ng-if="!slaInfo && taskId" task-id="taskId" show-edit="showEdit" plan-sub-type="planSubType" show-loader="taskId"></cv-schedule-tile>
		<cv-schedule-tile data-ng-if="showSecondarySchedules" data-profile-id="profileId" policy-id="policyId" show-edit="showEdit && !hideEditSchedule" data-override-text="scheduleOverrideText" plan-sub-type="planSubType" show-loader="policyId" help-text="<cv:msg key="info.help.secondaryCopy.schedule" bundle="profiles"/>"></cv-schedule-tile>
		<cv-schedule-tile data-ng-if="snapPlan " data-profile-id="profileId" policy-id="policyId" show-edit="showEdit" plan-sub-type="planSubType" show-loader="policyId"></cv-schedule-tile>
		<cv-tile-component data-ng-if="::showSnapshotOptions && !showSnapRecoveryPointOptions" class="snap-shot-options-tile rpo-with-snap-shot-options-tile" data-override-text="storageOverrideText" data-ac-id="label_snapshotOptions-profiles" data-title='<cv:msg key="label.snapshotOptions" bundle="profiles"/>'>
		<ul class="list-style-secondary" data-ng-disabled="!(showEdit && !hideEditStorage) || (!deriveDetails.isDerived && !showEdit && !hideEditStorage)">
			<li class="group">
				<span class="pageDetailColumn"><cv:msg key="label.backupCopy" bundle="job" /></span>
				<span class="pageDetailColumn" data-ng-disabled="!showEdit">
					<toggle-control
						status="snapshotOptions.backupCopy ? 'enabled-activity' : 'disabled-activity'"
						title='<cv:msg key="label.backupCopy" bundle="job"/>'
						data-ng-click="toggleSnapshotAddon()">
					</toggle-control>
                    <div class="grid-tile-accordion-more error no-padding ng-binding ng-scope" data-ng-if="snapshotAddonIncomplete && !snapshotOptions.backupCopy" style=""><cv:msg key="error.snapStatuIncomplete" bundle="profiles" /></div>
    </span>
			</li>
			<li class="group" data-ng-if="snapshotOptions.backupCopy || snapshotAddonIncomplete">
				<span class="pageDetailColumn"><cv:msg key="label.backupCopyRPOinHHMM" bundle="profiles"/></span>
				<cv-tile-edit enable-edit="showEdit" value="snapshotOptions.backupCopyRPO | rpoTimeFilter" edit-func="saveBackupCopyRpo()">
					<span class="inline-time-chooser">
						<table uib-timepicker id="scheduleTime" name="scheduleTime" data-ng-model="uiModel.backupCopyRPO" hour-step="1" minute-step="5" show-meridian="false" show-spinners="false"></table>
					</span>
				</cv-tile-edit>
			</li>
			<li class="group only-retention-option" data-ng-hide="!showOnlyRetentionOption" data-ng-disabled="uiModel.retentionMode !== 'NON_JOBS'">
				<label class="pageDetailColumn">
					<span><cv:msg key="label.retentionDays" bundle="collections"/></span>
				</label>
				<cv-tile-edit  is-disabled="uiModel.retentionMode !== 'NON_JOBS'" enable-edit="uiModel.retentionMode === 'NON_JOBS' && showEdit" value="uiModel.formattedRetentionLbl" edit-func="saveBackupRetentionDays()">
				<div class="retention-non-jobs-container">
					<input class="policy-retention" data-ng-hide="uiModel.retentionInfo.type === 'INFINITE'"  type="number" min="0" max="9999" data-ng-model="uiModel.retentionInfo.value"/>
					<select id="retentionPeriodOptions" name="retentionPeriodOptions" class="retention-type" data-ng-model="uiModel.retentionInfo.type" data-ng-options="unit.type as unit.label for unit in retentionUnitTypes"></select>
				</div>
				</cv-tile-edit>
			</li>
		</ul>
		</cv-tile-component>
		<!--laptop plan retention info -->
		<cv-tile-component data-ac-id="label_retention-profiles" data-ng-if="laptopPlan" data-title='Retention' loader="fsSubclientProp" data-override-text="retentionOverrideText">
			<ul class="list-style-secondary">
				<li data-ng-if = "fsSubclientProp.archiverRetention" class="group"><span class="pageDetailColumn"><cv:msg key="label.minRetention" bundle="profiles" /></span>
					<span data-ng-if = "fsSubclientProp.extendRetentionForNDays != -1" class="pageDetailColumn">
					 	{{fsSubclientProp.extendRetentionForNDays | convertDays}}
					 </span>
					 <span data-ng-if = "fsSubclientProp.archiverRetentionMode != 'EXTEND_RETENTION_FOR_N_DAYS'"  class="pageDetailColumn"><cv:msg key="label.indef" bundle="profiles" /></span>
				</li>
				<li class="group"><span class="pageDetailColumn"><cv:msg key="label.deletedRetention" bundle="profiles" /></span>
					 <span data-ng-if = "fsSubclientProp.afterDeletionKeepItemsForNDays != -1" class="pageDetailColumn">
					 {{fsSubclientProp.afterDeletionKeepItemsForNDays | convertDays}}
					 </span>
					 <span data-ng-if = "fsSubclientProp.afterDeletionKeepItemsForNDays == -1"  class="pageDetailColumn"><cv:msg key="label.indef" bundle="profiles" /></span>
				</li>
				<li class="group"><span class="pageDetailColumn"><cv:msg key="label.fileVersions" bundle="profiles" /></span>
					 <span data-ng-if = "fsSubclientProp.olderFileVersionsMode == 'KEEP_OLDER_VERSIONS'" class="pageDetailColumn">{{fsSubclientProp.keepVersions}} <cv:msg key="label.versions" bundle="profiles" /></span>
					 <span data-ng-if = "fsSubclientProp.olderFileVersionsMode == 'KEEP_OLDER_VERSIONS_FOR_N_DAYS'" class="pageDetailColumn">{{fsSubclientProp.keepOlderVersionsForNDays | convertDays}}</span>
					 <span data-ng-if = "fsSubclientProp.olderFileVersionsMode == 'KEEP_SPARSE_VERSIONS'" class="pageDetailColumn">
					 <span data-ng-if = "fsSubclientProp.retainPerDayPeriod<1 && fsSubclientProp.retainPerWeekPeriod<1 && fsSubclientProp.retainPerMonthPeriod<1" >0 <cv:msg key="label.versions" bundle="profiles" /></span>
					 <span data-ng-if = "fsSubclientProp.retainPerDayPeriod>0"><cv:msg key="label.dailyVersionPeriod" bundle="profiles" params="{{fsSubclientProp.retainPerDayPeriod}}" /></span>
					 <span data-ng-if = "fsSubclientProp.retainPerWeekPeriod>0"><br data-ng-if="fsSubclientProp.retainPerDayPeriod>0"/><cv:msg key="label.weeklyVersionPeriod" bundle="profiles" params="{{fsSubclientProp.retainPerWeekPeriod}}" /></span>
					 <span data-ng-if = "fsSubclientProp.retainPerMonthPeriod>0"><br data-ng-if="fsSubclientProp.retainPerDayPeriod>0 || fsSubclientProp.retainPerWeekPeriod>0"/><cv:msg key="label.monthlyVersionPeriod" bundle="profiles" params="{{fsSubclientProp.retainPerMonthPeriod}}" /></span>
					 </span>
				</li>
			</ul>
			<div class="page-details-box-links" data-ng-if="(showEdit && !hideEditRetention) || (!deriveDetails.isDerived && !showEdit && !hideEditRetention)">
				<a data-ng-click="modifyLaptopRetention()"><cv:msg key="action.edit" bundle="profiles" /></a>
			</div>
		</cv-tile-component>
		<!--laptop plan retention info end  -->
		<cv-alert-component loader='alertInfo.currentAlerts' data-ng-if="laptopPlan" alerts='alertInfo.currentAlerts' data-override-text="alertsOverrideText" show-edit='showEdit && !hideAlerts' plan-alerts-obj='alertObj'></cv-alert-component>
		<cv-tile-component data-override-text="storageOverrideText" data-ng-if="(serverPlan || laptopPlan || archiverPlan || fsIBMiVTLPlan) && enableRules" class="rule-grid-component" data-title='<cv:msg key="label.plan.storageAndRetention" bundle="profiles"/>'>
			<cv-rules-set  master-profile="masterProfile"  data-cv-plan-sub-type ="planSubType" show-edit="(showEdit && !hideEditStorage) || (!deriveDetails.isDerived && !showEdit && !hideEditStorage)" profile-details="profileDetails" allow-many-storages="serverPlan || archiverPlan || fsIBMiVTLPlan"></cv-rules-set>
		</cv-tile-component>
		<!--<cv-tile-component data-ac-id="label_accessPolicies-profiles" data-ng-if="!serverPlan && !fsPlan" data-title='<cv:msg key="label.accessPolicies" bundle="profiles"/>' loader="currentAccessPolicies" min-height="true">
			<span data-ng-if="currentAccessPolicies.length==0">
				<p class="info-place-holder"><cv:msg key="error.noAccessPoliciesConfigure" bundle="profiles"/></p>
			</span>
			<ul class="list-style__row group" data-ng-repeat="accessPolicies in currentAccessPolicies">
				<li class="">{{accessPolicies.name}}</li>
			</ul>
			<div class="page-details-box-links" data-ng-if="currentAccessPolicies  && showEdit">
				<a href="" data-ng-click="modifyAccessPolicies()"><cv:msg key="action.edit" bundle="profiles" />
				</a>
			</div>
		</cv-tile-component>-->
		<cv-tile-component data-ac-id="label_options-profiles" data-ng-if="laptopPlan" data-override-text="fileSystemQuotaOverrideText"
			data-title='<cv:msg key="label.options" bundle="profiles"/>' loader="options" min-height="true">
			<ul class="list-style-secondary">
				<li class="group"><span class="pageDetailColumn"><cv:msg key="label.quota" bundle="profiles" /></span>
					 <span data-ng-if="options.quota!==0" class="pageDetailColumn">{{options.quota}} <cv:msg key="label.quota.unit" bundle="profiles"/></span>
					 <span data-ng-if="options.quota===0" class="pageDetailColumn"><cv:msg key="label.infinite" bundle="profiles"/></span>
				</li>
				<li data-ng-if="isTenantAdmin && options.edgeDriveQuota && options.edgeDriveQuota!==0" class="group"><span class="pageDetailColumn"><cv:msg key="label.edgeDriveQuota" bundle="profiles" /></span>
					 <span class="pageDetailColumn">{{options.edgeDriveQuota}} <cv:msg key="label.quota.unit" bundle="profiles"/></span>
				</li>
			</ul>
			<div class="page-details-box-links multiLinks" data-ng-if="showEdit && !hideEditFileSystemQuota">
				<a data-ng-click="editQuota()"><cv:msg key="action.edit" bundle="profiles" /></a>
			</div>
		</cv-tile-component>
		<cv-tile-component data-ac-id="label_networkResources-profiles" data-ng-if="laptopPlan" data-title='<cv:msg key="label.networkResources" bundle="profiles"/>'
			data-override-text="networkResourcesOverrideText" loader="networkResources">
			<ul class="list-style-secondary">
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.maxLANBandwidth" bundle="profiles" /></span>
					 <span class="pageDetailColumn" data-ng-if="networkResources && networkResources.maxLANBandwidth > 0">{{networkResources.maxLANBandwidth}} <cv:msg key="label.kbps" bundle="profiles" /></span>
					 <span class="pageDetailColumn" data-ng-if="networkResources && networkResources.typeOfNetworkResources.typeOfNetworkResourcesLAN == 0"><cv:msg key="label.noLimit" bundle="profiles" /></span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.maxWANBandwidth" bundle="profiles" /></span>
					 <span class="pageDetailColumn" data-ng-if="networkResources && networkResources.maxWANBandwidth > 0">{{networkResources.maxWANBandwidth}} <cv:msg key="label.kbps" bundle="profiles" /></span>
					 <span class="pageDetailColumn" data-ng-if="networkResources && networkResources.typeOfNetworkResources.typeOfNetworkResourcesWAN == 0"><cv:msg key="label.noLimit" bundle="profiles" /></span>
				</li>
			</ul>
			<div class="page-details-box-links" data-ng-if="networkResources && showEdit && !hideEditNetworkResources">
				<a data-ng-click="modifyNetworkResources()"><cv:msg key="action.edit" bundle="profiles" /></a>
			</div>
		</cv-tile-component>
		<cv-encrytion-setting-component generic-entity='genericEntity' profile-details="profileDetails" show-edit="showEdit"></cv-encrytion-setting-component>
		<cv-tile-component data-override-text="storageOverrideText" data-ng-if="::showSnapshotOptions && showSnapRecoveryPointOptions" class="snap-shot-options-tile" data-ac-id="label_snapshotOptions-profiles" data-title='<cv:msg key="label.snapshotOptions" bundle="profiles"/>'>
		<ul class="list-style-secondary" data-ng-disabled="!(showEdit && !hideEditStorage) || (!deriveDetails.isDerived && !showEdit && !hideEditStorage)">
<%-- 			<li class="group">
			</li> --%>

			<li class="group">
				<span class="pageDetailColumn"><cv:msg key="label.backupCopy" bundle="job" /></span>
				<span class="pageDetailColumn" data-ng-disabled="!showEdit">
					<toggle-control
						status="snapshotOptions.backupCopy ? 'enabled-activity' : 'disabled-activity'"
						title='<cv:msg key="label.backupCopy" bundle="job"/>'
						data-ng-click="toggleSnapshotAddon()">
					</toggle-control>
				</span>
			</li>
			<li class="group" data-ng-if="snapshotOptions.backupCopy">
				<span class="pageDetailColumn"><cv:msg key="label.backupCopyRPOinHHMM" bundle="profiles"/></span>
				<cv-tile-edit enable-edit="showEdit" value="snapshotOptions.backupCopyRPO | rpoTimeFilter" edit-func="saveBackupCopyRpo()">
					<span class="inline-time-chooser">
						<table uib-timepicker id="scheduleTime" name="scheduleTime" data-ng-model="uiModel.backupCopyRPO" hour-step="1" minute-step="5" show-meridian="false" show-spinners="false"></table>
					</span>
				</cv-tile-edit>
			</li>
			<li class="group only-retention-option" data-ng-hide="!showOnlyRetentionOption" data-ng-disabled="uiModel.retentionMode !== 'NON_JOBS'">
				<label class="pageDetailColumn">
					<span><cv:msg key="label.retentionDays" bundle="collections"/></span>
				</label>
				<cv-tile-edit  is-disabled="uiModel.retentionMode !== 'NON_JOBS'" enable-edit="uiModel.retentionMode === 'NON_JOBS' && showEdit" value="uiModel.formattedRetentionLbl" edit-func="saveBackupRetentionDays()">
				<div class="retention-non-jobs-container">
					<input class="policy-retention" data-ng-hide="uiModel.retentionInfo.type === 'INFINITE'"  type="number" min="0" max="9999" data-ng-model="uiModel.retentionInfo.value"/>
					<select id="retentionPeriodOptions" name="retentionPeriodOptions" class="retention-type" data-ng-model="uiModel.retentionInfo.type" data-ng-options="unit.type as unit.label for unit in retentionUnitTypes"></select>
				</div>
				</cv-tile-edit>
			</li>
			</ul>
		</cv-tile-component>
			<cv-tile-component data-ng-if="::showSnapshotOptions" data-ng-show="showSnapRecoveryPointOptions" class="retention-options-tile" data-ac-id="retention_snapshot_options" data-title="Retention" sla="sla">
			<ul class="list-style-secondary" data-ng-disabled="!(showEdit && !hideEditStorage) || (!deriveDetails.isDerived && !showEdit && !hideEditStorage)">
			<li class="group snap-recovery-options" data-ng-hide="uiModel.retentionMode !== 'JOBS' && !uiModel.showRadioBtns">
			<label for="retention-jobs-mode" class="pageDetailColumn">
						<input id="retention-jobs-mode-for-plan" name="planRetentionMode" type="radio" value="JOBS" data-ng-model="uiModel.retentionMode" class="ng-pristine ng-untouched ng-valid ng-empty" data-ng-click="switchToSnapRecoveryPoints()">
							<cv:msg key="label.snapRecoveryPoints" bundle="profiles" />
			</label>
				<cv-tile-edit is-disabled="uiModel.retentionMode !== 'JOBS'" enable-edit="uiModel.retentionMode === 'JOBS' && showEdit" value="snapshotOptions.snapRecoveryPoints" edit-func="saveBackupRetentionInfo(true)" class="recovery-options-inline-edit">
					<input class="inline-editor" type="number" name="snapRecoveryPoints" min="1" data-ng-model="uiModel.snapRecoveryPoints" name="snapRecoveryPoints" id="snapRecoveryPoints" />
				</cv-tile-edit>
			</li>
						<li class="group retention-period-options" data-ng-disabled="uiModel.retentionMode !== 'NON_JOBS'">
				<label class="pageDetailColumn" for="retention-non-jobs-mode" >
					<input data-ng-hide="uiModel.retentionMode === 'NON_JOBS' && !uiModel.showRadioBtns" value="NON_JOBS" id="retention-non-jobs-mode-for-plan" name="planRetentionMode" type="radio" data-ng-click="switchToRetentionPeriod()" data-ng-model="uiModel.retentionMode"/>
					<span><cv:msg key="label.retentionDays" bundle="collections"/></span>
				</label>
				<cv-tile-edit  is-disabled="uiModel.retentionMode !== 'NON_JOBS'" enable-edit="uiModel.retentionMode === 'NON_JOBS' && showEdit" value="uiModel.formattedRetentionLbl" edit-func="saveBackupRetentionInfo(false)">
				<div class="retention-non-jobs-container">
					<input class="policy-retention" data-ng-hide="uiModel.retentionInfo.type === 'INFINITE'"  type="number" min="0" data-ng-model="uiModel.retentionInfo.value"/>
					<select id="retentionPeriodOptionsAsRadioBtn" name="retentionPeriodOptionsAsRadioBtn" class="retention-type" data-ng-model="uiModel.retentionInfo.type" data-ng-options="unit.type as unit.label for unit in retentionUnitTypes"></select>
				</div>
				</cv-tile-edit>
			</li>

		</ul>
		</cv-tile-component>
		<cv-tile-component data-ac-id="label_databaseOptions-profiles" data-override-text="scheduleOverrideText" data-ng-if="::showDatabaseOptions" data-title='<cv:msg key="label.databaseOptions" bundle="profiles"/>'>
		<ul class="list-style-secondary" data-ng-disabled="isDatabaseOptionsDisabled()">
			<li class="group">
				<span class="pageDetailColumn">
					<cv-call-out placement="top" html-template="logBackupThresholdimitTemplate" label="<cv:msg key="label.logBackupRPO" bundle="profiles" />" trigger="mouseenter">
                    </cv-call-out>
				</span>
				<cv-tile-edit value="databaseOptions.logBackupRPO | rpoTimeFilter" edit-func="saveLogBackupRpo()" enable-edit="!isDatabaseOptionsDisabled()" >
					<span class="inline-time-chooser">
						<table uib-timepicker id="scheduleTime" name="scheduleTime"
							data-ng-model="uiModel.logBackupRPO" hour-step="1"
							minute-step="5" show-meridian="false" show-spinners="false"></table>
					</span>
				</cv-tile-edit>
			</li>
			<li class="group" ng-if="databaseOptions.autoConvertBackupToFull">
				<span class="pageDetailColumn">
					<cv:msg key="label.runFullBackupEvery" bundle="profiles" />
				</span>
				<cv-tile-edit value="databaseOptions.autoConvertBackupToFull.formattedValue" edit-func="saveAutoConvertBackupToFull()" enable-edit="!isDatabaseOptionsDisabled()">
					<div class="auto-convert-full-container">
						<input class="auto-convert-full" type="number" min="1" max="9999" data-ng-model="uiModel.autoConvertBackupToFull.value"/>
						<select id="autoConvertOptions" name="autoConvertOptions" data-ng-model="uiModel.autoConvertBackupToFull.type" data-ng-options="unit.type as unit.label for unit in autoConvertBackupToFullUnitTypes"></select>
					</div>
				</cv-tile-edit>
			</li>
			<li class="group">
				<span class="pageDetailColumn">
					<cv:msg key="label.useDiskCacheForLogBackups" bundle="profiles" />
				</span>
				<span class="pageDetailColumn" data-ng-disabled="disableRPOEdit">
					<toggle-control
						status="databaseOptions.useStorageSpaceFromMA ? 'enabled-activity' : 'disabled-activity'"
						title='<cv:msg key="label.useDiskCacheForLogBackups" bundle="profiles"/>'
						data-ng-click="toggleUseDiskCache()"> </toggle-control>
				</span>
			</li>
			<li class="group"
				data-ng-if="databaseOptions.useStorageSpaceFromMA && !oneMinRPOEditEnabled">
				<span class="pageDetail-three-columns-first">
					<cv:msg key="lable.commitDailyAt" bundle="profiles" />
				</span>
				<span class="pageDetail-three-columns-second">
					<cv:msg key="label.hours" bundle="clients"
						params="{{databaseOptions.sweepIntervalHour}}" />
				</span>
				<a class="pull-right" ng-if="!isDatabaseOptionsDisabled()" data-ng-click="toggleOneMinRpoEditor()"> <svg
						width="16px" height="16px" fill="currentColor"
						xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
						<path
							d="M3 17.25V21h3.75L17.81 9.94l-3.75-3.75L3 17.25zM20.71 7.04a1 1 0 0 0 0-1.41l-2.34-2.34a1 1 0 0 0-1.41 0l-1.83 1.83 3.75 3.75 1.83-1.83z" /></svg>
				</a>
			</li>
			<li class="group no-horizontal-padding"
				data-ng-if="databaseOptions.useStorageSpaceFromMA && oneMinRPOEditEnabled">
				<span class="pageDetailColumn margin-top-10-important">
					<cv:msg key="label.commitDailyAtInHHMM" bundle="profiles" />
				</span>
				<span class="pageDetailColumn">
					<span class="inline-time-chooser" data-ng-disabled="disableRPOEdit">
						<input class="addon-option-input" type="number" min="1" max="24"
							name="sweepIntervalHour" id="commitTime"
							data-ng-model="uiModel.oneMinRPO" />
					</span>
					<span data-ng-disabled="disableRPOEdit">
						<a class="horizontal-link-button" data-ng-click="saveOneMinRpo()">
							<i class="glyphicon glyphicon-ok"></i>
						</a>
						<a data-ng-click="toggleOneMinRpoEditor()">
							<i class="glyphicon glyphicon-remove"></i>
						</a>
					</span>
				</span>
			</li>
			<!--  
			<li class="group" data-ng-if="showOptimizeForInstantClone">
				<span class="pageDetailColumn">
					<cv:msg key="label.optimizeInstantClone" bundle="storage" />
				</span>
				<span class="pageDetailColumn">
					<toggle-control
						status="options.optimizeForInstantClone ? 'enabled-activity' : 'disabled-activity'"
						data-ng-click="toggleOptimizeForInstantClone()"> </toggle-control>
				</span>
			</li>
			-->
		</ul>
		</cv-tile-component>
		<cv-plan-associated-entities-count data-ng-if="planAssociatedEntities" plan-associated-entities-count="planAssociatedEntities"></cv-plan-associated-entities-count>
	</div>
</div>
