<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.alertsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.alerts"></cv:cvMessages>
</script>
<div>
	<div class="setup-title">
		<h3 data-ng-if="profileName">{{profileName}}</h3>
		<h4 data-ng-if="!saml && !setup && profileName" class="subtitle">{{title}}<cv-help-component help-text="<cv:msg key="label.inviteUserGroupHelpText" bundle="profiles" />"></cv-help-component></h4>
		<h1 data-ng-if="!saml && !setup && !profileName" class="subtitle">{{title}}<cv-help-component help-text="<cv:msg key="label.inviteUserGroupHelpText" bundle="profiles" />"></cv-help-component></h1>
		<h1 data-ng-if="!saml && setup && !createLaptopPlan">{{title}}<cv-help-component help-text="<cv:msg key="label.inviteUserGroupHelpText" bundle="profiles" />"></cv-help-component></h1>
		<h1 data-ng-if="saml">{{title}}<cv-help-component help-text="<cv:msg key="label.associationHelpText" bundle="users" />"></cv-help-component></h1>
		<h1 data-ng-if="createLaptopPlan"><cv:msg key="label.inviteUserGroup" bundle="profiles" /><cv-help-component help-text="<cv:msg key="label.inviteUserGroupHelpText" bundle="profiles" />"></cv-help-component></h1>
		<div class="invite-error-message {{inviteMessage.type}} serverMessage">{{inviteMessage.message}}</div>
	</div>
	<!-- // name // -->
	<div class="setup-content medium-width" data-ng-controller="userAndGroupInviteController">
		<p class="serverMessage">{{usersOrGroupsAssociatedMessage.message}}</p>
		<a data-ng-click="inviteAnotherUserOrGroup()" data-ng-show="formInviteUsersAndGroup.hide"><cv:msg key="label.inviteAnotherUsersOrGroups" bundle="profiles" /></a>
		<form name="inviteUsersAndGroupForm" data-cv-submit="" novalidate autocomplete="off" data-ng-hide="formInviteUsersAndGroup.hide" class="bootstrap-wrapper form-horizontal">
			<div class="invite-error-message {{associatePlanMessage.type}} serverMessage">{{associatePlanMessage.message}}</div>
		<div class="panel panel-default">
		<div class="panel-body">
		<div class="form-group" data-ng-if="!saml && setup">
		    <label class="col-xs-12 col-md-4 col-lg-4" for="planType" ><cv:msg key="placeholder.selectPlan" bundle="profiles" /></label>
			<div class="col-xs-12 col-md-8 col-lg-8">
				<select name="planType"
						id="planType"
						data-ng-options="plans.planSummary.plan.planName for plans in planList"
						data-ng-model="selectedPlan.plan">
					<option value=""> </option>
				</select>
			</div>
		</div>
		<div class="form-group">
			<div class="col-xs-12">
				<div id="emailErrorMessage" class="invite-error-message error serverMessage text-align-left"><cv:msg key="error.validEmailError" bundle="alertsJs" /></div>
				<div id="emailErrorMessageForSAML" class="invite-error-message error serverMessage text-align-left"><cv:msg key="error.emailErrorMessageForSAML" bundle="profiles" /></div>
			</div>
		</div>
			<div class="user-invite-dailog" data-ng-class="{'invite-setup-background-dlo': setup}">
				<div class="add-users group plan-usergroup-invite" data-ng-if="showSearchArea">
						<input id="userList">
				</div>
				<div class="added-users plan-invite-user-modal">
					<div class="peopleInfos ownerInfo">
							<div class="users-list">
								<ul class="group">
									<li class="users-list__user " data-ng-repeat="user in userList.userList" data-ng-class="{'deleted-user':user.state=='delete'}">
										<span class="user-type">
											<input data-ng-if="!saml" type="checkbox" data-ng-model="user.id2" id="user_{{user.name}}" name="user_{{user.name}}" data-ng-disabled="user.state=='delete'" />
											<label title="{{user.text}}" for="user_{{user.name}}"  class="notify-user" data-id="{{user.name}}"><span>{{user.text}}</span></label>
											<span title="Remove {{user.name}}" class="delete-row" ng-click="deleteUser(user,true)">&times;</span>
											<span class="redo-row" data-ng-click="redoUser(user)" data-ng-if="user.state=='delete'">
												<svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
	    												<path d="M0 0h24v24H0z" fill="none"/>
	    												<path d="M12.5 8c-2.65 0-5.05.99-6.9 2.6L2 7v9h9l-3.62-3.62c1.39-1.16 3.16-1.88 5.12-1.88 3.54 0 6.55 2.31 7.6 5.5l2.37-.78C21.08 11.03 17.15 8 12.5 8z"/>
												</svg>
											</span>
									 	</span>
									</li>
									<li class="users-list__user"  data-ng-repeat="group in userList.userGroupList" data-ng-class="{'deleted-user':group.state=='delete'}">
										<span class="group-type">
											<input data-ng-if="!saml" type="checkbox" data-ng-model="group.id2" id="group_{{group.name}}" name="group_{{group.name}}" data-ng-disabled="group.state=='delete'">
											<label title="{{group.text}}" for="group_{{group.name}}" class="notify-user" data-id="{{group.name}}"><span>{{group.text}}</span></label>
											<span title="Remove {{group.name}}" class="delete-row" ng-click="deleteUser(group,true)">&times;</span>
											<span class="redo-row" data-ng-click="redoUser(group)" data-ng-if="group.state=='delete'">
											<svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
    												<path d="M0 0h24v24H0z" fill="none"/>
    												<path d="M12.5 8c-2.65 0-5.05.99-6.9 2.6L2 7v9h9l-3.62-3.62c1.39-1.16 3.16-1.88 5.12-1.88 3.54 0 6.55 2.31 7.6 5.5l2.37-.78C21.08 11.03 17.15 8 12.5 8z"/>
											</svg>
											</span>
									 	</span>
									</li>
									<li class="users-list__user" data-ng-repeat="egroup in userList.externalGroupList" data-ng-class="{'deleted-user':egroup.state=='delete'}">
										<span class="group-type">
											<input data-ng-if="!saml" type="checkbox" data-ng-model="egroup.id2" id="egroup_{{egroup.name}}" name="egroup_{{egroup.name}}" data-ng-disabled="egroup.state=='delete'" />
											<label title="{{egroup.text}}" for="egroup_{{egroup.name}}" class="notify-user" data-id="{{egroup.name}}"><span>{{egroup.text}}</span></label>
											<span title="Remove {{egroup.name}}" class="delete-row" ng-click="deleteUser(egroup,true)">&times;</span>
											<span class="redo-row" data-ng-click="redoUser(egroup)" data-ng-if="egroup.state=='delete'">
												<svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
	    												<path d="M0 0h24v24H0z" fill="none"/>
	    												<path d="M12.5 8c-2.65 0-5.05.99-6.9 2.6L2 7v9h9l-3.62-3.62c1.39-1.16 3.16-1.88 5.12-1.88 3.54 0 6.55 2.31 7.6 5.5l2.37-.78C21.08 11.03 17.15 8 12.5 8z"/>
												</svg>
											</span>
									 	</span>
									</li>
									<li class="users-list__user " data-ng-repeat="ngroup in userList.nonGalaxyUserList" data-ng-class="{'deleted-user':ngroup.state=='delete'}">
										<span class="email-type">
											<input type="checkbox" data-ng-model="ngroup.id2" id="ngroup_{{ngroup.name}}" name="ngroup_{{ngroup.name}}" data-ng-disabled="ngroup.state=='delete'">
											<label title="{{ngroup.text}}" for="ngroup_{{ngroup.name}}" class="notify-user" data-id="{{ngroup.name}}"><span>{{ngroup.text}}</span></label>
											<span title="Remove {{ngroup.name}}" class="delete-row" data-ng-click="deleteUser(ngroup,true)">&times;</span>
											<span class="redo-row" data-ng-click="redoUser(ngroup)" data-ng-if="ngroup.state=='delete'">
												<svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
	    												<path d="M0 0h24v24H0z" fill="none"/>
	    												<path d="M12.5 8c-2.65 0-5.05.99-6.9 2.6L2 7v9h9l-3.62-3.62c1.39-1.16 3.16-1.88 5.12-1.88 3.54 0 6.55 2.31 7.6 5.5l2.37-.78C21.08 11.03 17.15 8 12.5 8z"/>
												</svg>
											</span>
									 	</span>
									</li>
								</ul>
								<ul data-ng-if="!saml && (userList.externalGroupList.length > 0 || userList.userGroupList.length > 0 || userList.userList.length > 0)">
									<li class="invite-user-modal-message">
										<cv:msg key="label.sendToEmail" bundle="profiles" />
									</li>
								</ul>
								<ul data-ng-if="saml" class="group"data-ng-repeat="domain in userList.domainList">
									<li class="users-list__user" data-ng-class="{'deleted-user':domain.state=='delete'}">
										<span class="domain-type">
											<label title="{{domain.text}}" for="domain_{{domain.name}}" class="notify-user" data-id="{{domain.name}}"><span>{{domain.text}}</span></label>
											<span title="Remove {{domain.name}}" class="delete-row" data-ng-click="deleteUser(domain,true)">&times;</span>
											<span class="redo-row" data-ng-click="redoUser(domain)" data-ng-if="domain.state=='delete'">
												<svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
	    												<path d="M0 0h24v24H0z" fill="none"/>
	    												<path d="M12.5 8c-2.65 0-5.05.99-6.9 2.6L2 7v9h9l-3.62-3.62c1.39-1.16 3.16-1.88 5.12-1.88 3.54 0 6.55 2.31 7.6 5.5l2.37-.78C21.08 11.03 17.15 8 12.5 8z"/>
												</svg>
											</span>
									 	</span>
									</li>
								</ul>
							</div>
					</div>
				</div>
			</div>
</div></div>
			<div data-ng-if="!setup" class="button-container">
				<button id="inviteUserGroupProfile_button_#3858" data-ng-if="!createLaptopPlan" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="cancel()"><cv:msg key="action.cancel" bundle="profiles" /></button> 
				<button data-ng-if="!createLaptopPlan" id="inviteUserGroupProfile_button_#3965" type="button" class="btn btn-primary cvBusyOnAjax" data-ng-click="saveList()" >{{saveButtonText}}</button>
				<button data-ng-if="createLaptopPlan" id="retentionPoliciesProfile_button_#5812" type="button" data-ng-click="goPreviousStep()" class="btn btn-default cvBusyOnAjax"><cv:msg key="action.previous" bundle="profiles"/></button>
				<button data-ng-if="createLaptopPlan" id="inviteUserGroupProfile_button_#9697" type="button" data-ng-if="showFinish" data-ng-click="saveUserAndGroup()" class="btn btn-primary cvBusyOnAjax"><cv:msg key="action.save" bundle="profiles" /></button>
			</div>
			<div data-ng-if="setup" class="button-container">
				<button id="inviteUserGroupProfile_button_#9448" type="button" data-ng-click="skip()" class="btn btn-default cvBusyOnAjax"><cv:msg key="action.skip" bundle="profiles" /></button> 
				<button id="inviteUserGroupProfile_button_#9697" type="button" data-ng-if="showFinish" data-ng-click="saveUserAndGroup()" class="btn btn-primary cvBusyOnAjax"><cv:msg key="action.save" bundle="profiles" /></button> 
			</div>
		</form>
		<div class="button-container centered" data-ng-show="formInviteUsersAndGroup.hide">
			<button id="inviteUserGroupProfile_button_#6199" type="button" class="btn btn-default cvBusyOnAjax skip-btn--hidden" data-ng-click="skipInvite()"><cv:msg key="Continue" /></button> 
		</div>
	</div>
</div>
