<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1><cv:msg key="dialogTitle.editStorage" bundle="collections"/></h1>
</div>
<span class="setup-content">
<div class="bootstrap-wrapper"> <!-- //max-width-600-center // -->
	<div>
	<div class="{{editStorageServerMessage.type}} serverMessage">{{editStorageServerMessage.message}}</div>
	<form class="form-horizontal" name="editStorageForm" data-cv-submit="saveStorage()" novalidate autocomplete="off">
		<div class="panel panel-default no-border">
		<div class="panel-body">
		<div class="form-group">
		<label class="col-xs-12 col-lg-5" for="storage"><cv:msg key="label.library" bundle="collections"/></label>
		<div class="col-xs-12 col-lg-7">
		<select id="storage" name="storage" data-ng-model="sp.libraryId"
						data-ng-options="lib.id as lib.label for lib in libraries | orderBy : 'label'" required
						data-ng-class="{'has-error': cv.editStorageForm.needsAttention(editStorageForm.storage)}">
					<option value=""><cv:msg key="placeholder.storage" bundle="collections"/></option>
				</select>
				<span class="help-block" data-ng-show="cv.editStorageForm.needsAttention(editStorageForm.storage)"><cv:msg key="error.storage" bundle="collections"/></span>
		</div>
		</div>
		</div>
		<div class="panel-body">
			<div class="form-group">
				<label class="col-xs-12 col-lg-5" data-ng-if="planSubType == 'Laptop'" for="retention"><cv:msg key="label.retentionPeriod" bundle="collections"/></label>
				<label class="col-xs-12 col-lg-5" data-ng-if="planSubType == 'Server'" for="retention" ><cv:msg key="label.retentionDays" bundle="collections"/></label>
				<div class="col-xs-12 col-lg-7">
					<input data-ng-if="planSubType != 'Snap'" id="retention" name="retention" type="number" min="0" max="9999" data-ng-model="sp.retentionInDays" /><span data-ng-if="planSubType != 'Snap'"><cv:msg key="label.days" bundle="collectionsJs"/></span>
					<span class="help-block" data-ng-show="planSubType != 'Snap' && cv.editStorageForm.needsAttention(editStorageForm.retention)"><cv:msg key="error.retentionPeriod" bundle="collections"/></span>
				</div>
			</div>
			<div class="form-group">
				<label class="col-xs-12 col-lg-5" data-ng-if="planSubType == 'Snap'" for="snapRecoveryPoints"><cv:msg key="label.snapRecoveryPoints" bundle="profiles"/></label>
				<div class="col-xs-12 col-lg-7 text-align-left">
				<input class="col-xs-12 col-lg-3" data-ng-if="planSubType == 'Snap'" id="snapRecoveryPoints" name="snapRecoveryPoints" type="number" min="1" max="9999" data-ng-model="sp.snapRecoveryPoints" />
				<span class="help-block" data-ng-show="planSubType == 'Snap' && cv.editStorageForm.needsAttention(editStorageForm.snapRecoveryPoints)"><cv:msg key="error.snapRecoveryPoints" bundle="profiles"/></span>
				</div>
			</div>
		</div>
		</div>
		<div class="button-container">
			<button id="editStorageDLO_button_#8560" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="cancel()"><cv:msg key="action.cancel" bundle="profiles"/></button> 
			<button id="editStorageDLO_button_#0864" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="action.save" bundle="profiles"/></button> 
		</div>
	</form>
	</div>
</div>
</span>
