<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<div>
	<script nonce="${sessionScope.cspNonce}" >
		<cv:cvMessages bundle="localization.storage"></cv:cvMessages>
		<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
		<cv:cvMessages bundle="localization.replicationGroups"></cv:cvMessages>
	</script>
	<div class="setup-title">
		<h3 data-ng-if="modalTitle" data-ng-bind="modalTitle"></h3>
		<h3 data-ng-if="!modalTitle && !isRPStore"><cv:msg key="title.editBackupWindow" bundle="profiles"/></h3>
		<h3 data-ng-if="!modalTitle && isRPStore"><cv:msg key="title.editRPPeakWindow" bundle="storage"/></h3>
	</div>
	<div class="setup-content reduced-padding-top">
		<div class="text-help" data-ng-if="!isRPStore && !isReplication">
			<cv:msg key="info.backupWindow" bundle="profiles"/>
			<br />
			<cv:msg key="info.backupWindow2" bundle="profiles"/>
		</div>
		<div class="text-help" data-ng-if="isRPStore"><cv:msg key="info.rpPeakWindow" bundle="storage"/><cv-help-component ng-cloak help-text="<cv:msg key="info.offPeakPruning" bundle="storage"/>" help-placement="right"></cv-help-component></div>
		<div class="text-help" data-ng-if="isReplication">
			<cv:msg key="info.replicationWindow" bundle="replicationGroups"/>
			<br />
			<cv:msg key="info.replicationWindow2" bundle="replicationGroups"/>
		</div>
		<div data-ng-controller="setBackupWindowController">
		<table class="time-obj">
			<thead>
				<tr>
					<th></th>
					<th class="label-time" data-ng-repeat="time in timeLabel" data-ng-class="{'dot':time.label%2==1}">
						<div data-ng-if="time.val==0 || time.val==23" class="moon">
							<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 50 50"><path d="M25.54-.21h0a20.36,20.36,0,0,0-9.25,17c0,11.35,9.51,20.54,21.22,20.54a21.57,21.57,0,0,0,12.17-3.73A25.81,25.81,0,0,1,25.54,49.79c-14.26,0-25.83-11.19-25.83-25s11.57-25,25.83-25Z"/></svg>
						</div>
						<div data-ng-if="time.val==12" class="sun">
							<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 50 50"><path d="M48.76,23.83H43.5a1.32,1.32,0,0,0,0,2.64h5.26a1.32,1.32,0,0,0,0-2.64Z"/><path d="M38.1,13.51a1.3,1.3,0,0,0,.93-.39L42.75,9.4a1.32,1.32,0,0,0-1.86-1.86l-3.72,3.72a1.32,1.32,0,0,0,.93,2.25Z"/><path d="M39,37.32a1.31,1.31,0,0,0-1.86,1.85l3.72,3.72a1.3,1.3,0,0,0,1.86,0,1.32,1.32,0,0,0,0-1.86Z"/><path d="M25.08,42.25a1.32,1.32,0,0,0-1.32,1.32v5.26a1.32,1.32,0,0,0,2.64,0V43.57A1.31,1.31,0,0,0,25.08,42.25Z"/><path  d="M25.08,8A1.32,1.32,0,0,0,26.4,6.72V1.47a1.32,1.32,0,1,0-2.64,0V6.73A1.31,1.31,0,0,0,25.08,8Z"/><path d="M25.08,12.06A13.16,13.16,0,1,0,38.24,25.22,13.17,13.17,0,0,0,25.08,12.06Z"/><path d="M11.13,13.13a1.3,1.3,0,0,0,1.86,0,1.32,1.32,0,0,0,0-1.86L9.27,7.54A1.32,1.32,0,0,0,7.41,9.4Z"/><path d="M11.13,37.32,7.41,41a1.32,1.32,0,0,0,0,1.86,1.3,1.3,0,0,0,1.86,0L13,39.17a1.31,1.31,0,0,0-1.86-1.85Z"/><path  d="M8,25.15a1.32,1.32,0,0,0-1.32-1.32H1.41a1.32,1.32,0,0,0,0,2.64H6.67A1.31,1.31,0,0,0,8,25.15Z"/></svg>
						</div>
						<div data-ng-if="time.val != 0 && time.val != 12 && time.val != 23" class="no-symbol">
							&nbsp;
						</div>
						<div data-ng-class="{'no-color':time.label%2==1}">{{time.label}}</div>
					</th>
				</tr>
			</thead>
			<tbody>
				<tr id="{{day.val}}" class="label-day" data-ng-repeat="day in dayLabel">
					<td class="label-day"><a href="" data-ng-click="clickAllday(day)">{{getDayName(day.val)}}</a></td>
					<td class="week-time" date-time-id="{{time.val}}" data-ng-repeat="time in timeLabel" data-ng-init="selected=false" data-ng-class="{'selected':changeColor(day.val,time.val)}" data-ng-mouseenter="mouseEnter(day.val,time.val)"  data-ng-mousedown="mouseDown(day.val,time.val)">
						<div class="week-time-tooltip">{{time.label+' ' + time.type +' - ' + (time.label==12? 1: time.label+1) + ' ' + (time.label==11? (time.type=='am'? 'pm':'am'):time.type)}}</div>
					</td>
				</tr>
			</tbody>
			<tfoot>
				<tr>
					<td colspan="{{ timeLabel.length + 1 }}" class="legend">
						<ul class="legend-list">
							<li class="legend-object">
								<div class="legend-symbol week-time selected"></div>
								<span data-ng-if="!isRPStore"><cv:msg key="label.runInterval" bundle="profiles"/></span>
								<span data-ng-if="isRPStore"><cv:msg key="label.peakTitle" bundle="storage"/></span>
							</li>
							<li class="legend-object">
								<div class="legend-symbol week-time"></div>
								<span data-ng-if="!isRPStore"><cv:msg key="label.doNotRunInterval" bundle="profiles"/></span>
								<span data-ng-if="isRPStore"><cv:msg key="label.offPeakInterval" bundle="storage"/></span>
							</li>
						</ul>
					</td>
				</tr>
			</tfoot>
		</table>
		
		<ul class="schedule-list-backup">
			<li>
				<b data-ng-if="!isRPStore && !isReplication"><cv:msg key="label.backupWindowSchedule" bundle="storage"/></b>
				<b data-ng-if="isReplication"><cv:msg key="label.replicationWindowSchedule" bundle="replicationGroups"/></b>
				<a data-ng-if="!isRPStore" class="clear-link" href="" data-ng-click="selectAll()"><cv:msg key="action.selectAll" bundle="profiles"/></a>
				<b data-ng-if="isRPStore"><cv:msg key="label.peakWindow" bundle="storage"/></b>
				<a class="clear-link" href="" data-ng-click="clear()"><cv:msg key="action.clear" bundle="profiles"/></a>
			</li>
			<li data-ng-if="sentenceList === null" data-ng-bind="disabledMessage"></li>
			<li data-ng-repeat="(key,value) in sentenceList">{{key + ' : ' + value.join(",&nbsp;&nbsp;")}}</li>
		</ul>
		</div>
		<div class="button-container">
			<button id="editPlanOperationWindowModal_button_#5265" class="btn btn-default cvBusyOnAjax" data-ng-click="close()"><cv:msg key="action.cancel" bundle="profiles"/></button> 
			<button id="editPlanOperationWindowModal_button_#4242" class="btn btn-primary cvBusyOnAjax" data-ng-click="setSchedule()"><cv:msg key="action.save" bundle="profiles"/></button> 
		</div>
	</div>
</div>