<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
</script>
<div class="setup-title">
		<h1>{{title}}</h1>
</div>
<div class="setup-content">
	<form name="addFolderForm" cv-hide-api data-cv-submit="addFolder()" novalidate autocomplete="off">
		<div class="{{backupContentMessage.type}} serverMessage">{{backupContentMessage.message}}</div>
		<div id="content-library-container" class="content-library" data-ivh-treeview="contentLibrary" data-ivh-treeview-expand-to-depth="1" data-ivh-treeview-use-checkboxes="true" data-ivh-treeview-on-cb-change="selectionChanged(ivhNode, ivhIsSelected, ivhTree)"
			ivh-treeview-node-tpl="template"
		>
		</div>
		<label data-ng-hide="enableAddFolder"><a href="" data-ng-click="addFolderName()"><cv:msg key="label.customContent" bundle="profiles"/></a>
		</label>
		
		<div data-ng-show="enableAddFolder" class="row host-name-input-wrapper text-align-left">
			<div class="col-sm-12 col-lg-4">
				<label for="path"><cv:msg key="label.customPath" bundle="profiles"/></span>
			</div>
			<div class="col-sm-12 col-lg-8">
				<input type="text" ng-blur="addFolderPath()" class="float-none" name="folderName" id="path" data-ng-model="folderName"  
					placeholder="<cv:msg key="label.enterPath" bundle="profiles"/>" autofocus/>
				<span ng-disabled="!folderName">
					<span class="k-icon k-i-plus cursor-pointer font-size-22" title="Add" ng-click="addFolderPath()"></span>
				</span>
				<div class="help-block margin-left-0" data-ng-if="pathNotValid">
					<span><i class="ion-alert-circled"></i> <cv:msg key="error.path" bundle="profiles"/></span>
				</div>
				<div ng-repeat="folderPath in folderPaths" class="info-tag float-left">
					<div class="cv-flex">
						 <span title="{{folderPath}}" class="crop" ng-bind="folderPath"></span>
						 <span>
							 <a class="close-icon k-icon k-i-close cursor-pointer" ng-click="removeFolderPath($index)"></a>
						 </span>
					</div>
				</div>
			</div>
		</div>
		
		<div class="button-container">
				<button id="createNewFolder_button_#7259" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="cancel()"><cv:msg key="action.cancel" bundle="profiles"/></button> 
				<button id="createNewFolder_button_#8189" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="action.save" bundle="profiles"/></button> 
		</div>
	</form>
</div>
