<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
</script>
<h1><cv:msg key="label.scheduleAndStorage" bundle="profiles"/></h1>
<div class="{{laptopBackupScheduleMessage.type}} serverMessage">{{laptopBackupScheduleMessage.message}}</div>
<cv-plan-creation-messages data-ng-if="showMessagesLoaded" show-messages="showMessages"></cv-plan-creation-messages>
<div class="row">
	<div class="col-md-12">
		<cv-tile-component data-ac-id="label_copies-profiles" data-title='<cv:msg key="label.copies" bundle="profiles"/>'>
			<div class="setup-input-group" data-ng-if="globalTemplate.deriveSettings.definesStorage.overrideEntity !== OVERRIDE_OPTIONS.NOT_ALLOWED">
				<cv-derivable-input-toggle data-model="globalTemplate.deriveSettings.definesStorage.definesEntity"
						class="row" data-toggle-class="col-xs-6 col-sm-5" data-help-text-class="col-xs-6 col-sm-7"
						data-ng-if="isDerived" data-derive-setting="globalTemplate.deriveSettings.definesStorage.overrideEntity">
				</cv-derivable-input-toggle>
			</div>
			<div class="extra-top-padding text-center subtext medium-size"
				data-ng-if="globalTemplate.deriveSettings.definesStorage.overrideEntity === OVERRIDE_OPTIONS.NOT_ALLOWED">
				<span><cv:msg key="label.overrideOptionsHelpText.notAllowed.short" bundle="profiles"/></span>
			</div>
			<!-- primary storage pool  -->
			<div class="margin-top-10" data-cv-derivable-input data-override-base="!isDerived || globalTemplate.deriveSettings.definesStorage.definesEntity">
			<label for="storage" class="select-label inline-label"><span class="label-spacer"><cv:msg key="label.primaryStorage" bundle="profiles"/></span>
				<select id="storage" name="storage" data-ng-model="globalTemplate.storageInfo.primaryStorage"
						data-ng-options="storagePool.storagePoolEntity.storagePoolName for storagePool in storagePools" class="no-float-auto min-width"
						data-ng-change="changeSecondaryStorageList(globalTemplate.storageInfo.primaryStorage)">
					<option value=""><cv:msg key="placeholder.selectStorage" bundle="profiles"/></option>
				</select>
			</label>
			<!-- <label for="primaryRetention">
				<span class="label-spacer"><cv:msg key="label.retentionPeriod" bundle="collections"/></span>
				<cv-plan-day-input data-cv-id="primaryRetention" data-cv-name="primaryRetention" data-cv-class="'select-label'"
						data-cv-model="globalTemplate.storageInfo.primaryRetentionInDays">
				</cv-plan-day-input>
			</label> -->
			</div>
			<!-- secondary storage pool  -->
			<div class="margin-top-10" data-ng-if="enableSecondaryStorage"
					data-cv-derivable-input data-override-base="!isDerived || globalTemplate.deriveSettings.definesStorage.definesEntity">
				<input type="checkbox" id="enableSecondaryStorage" data-ng-click="handleAuxCopySchedule(globalTemplate.showSecondaryStorage)" data-ng-model="globalTemplate.showSecondaryStorage" />
				<label for="enableSecondaryStorage"><cv:msg key="label.enableSecondaryStorage" bundle="profiles"/></label>
				<label data-ng-if="globalTemplate.showSecondaryStorage" for="secondaryStorage" class="select-label inline-label"><span class="label-spacer"><cv:msg key="label.secondaryStorage" bundle="profiles"/></span>
					 <select id="secondaryStorage" name="secondaryStorage" data-ng-model="globalTemplate.storageInfo.secondaryStorage"
						data-ng-options="storagePool.storagePoolEntity.storagePoolName for storagePool in secondaryStoragePools"
						class="no-float-auto min-width">
						<option value=""><cv:msg key="placeholder.selectSecondaryStorage" bundle="profiles"/></option>
					</select>
				</label>
				<!-- <label data-ng-show="globalTemplate.showSecondaryStorage" for="secondaryRetention">
					<span class="label-spacer"><cv:msg key="label.retentionPeriod" bundle="collections"/></span>
					<cv-plan-day-input data-cv-id="secondaryRetention" data-cv-name="secondaryRetention" data-cv-class="'select-label'"
							data-cv-model="globalTemplate.storageInfo.secondaryRetentionInDays">
					</cv-plan-day-input>
				</label> -->
			</div>
			<!-- secondary storage pool end -->
		</cv-tile-component>
		<cv-tile-component data-ac-id="info_help_laptopSla-profiles" data-title="<cv:msg key="label.rpo" bundle="profiles"/>"
				help-text="<cv:msg key="info.help.rpo" bundle="profiles"/> <cv:msg key="info.help.laptopRpo" bundle="profiles"/>">
			<div class="setup-input-group" data-ng-if="globalTemplate.deriveSettings.definesSchedule.overrideEntity !== OVERRIDE_OPTIONS.NOT_ALLOWED">
				<cv-derivable-input-toggle data-model="globalTemplate.deriveSettings.definesSchedule.definesEntity"
						class="row" data-toggle-class="col-xs-6 col-sm-5" data-help-text-class="col-xs-6 col-sm-7"
						data-derive-setting="globalTemplate.deriveSettings.definesSchedule.overrideEntity" data-ng-if="isDerived">
				</cv-derivable-input-toggle>
			</div>
			
			<div class="extra-top-padding text-center subtext medium-size"
				data-ng-if="globalTemplate.deriveSettings.definesSchedule.overrideEntity === OVERRIDE_OPTIONS.NOT_ALLOWED">
				<span><cv:msg key="label.overrideOptionsHelpText.notAllowed.short" bundle="profiles"/></span>
			</div>
			<cv-derivable-input data-override-base="!isDerived || globalTemplate.deriveSettings.definesSchedule.definesEntity">
				<!--
				<label class="laptop-sla-interval">
					<label for="sla" class="inline-label inner-label">
						<span class="label-spacer">
							<cv:msg key="label.backupCoverage" bundle="profiles"/>
						</span>
					</label>
					<label class="inline-label inner-label select-label">
						<select id="sla" name="sla" data-ng-model="globalTemplate.slaInterval"
							data-ng-options="slaInterval for slaInterval in slaIntervals"
							class="no-float-auto min-width">
						</select>
					</label>
					<label class="inline-label inner-label"><cv:msg key="label.slaDays" bundle="profiles" /></label>
				</label>
				-->
				<label class="margin-top-10 inline-label">
					<span class="label-spacer">
						<cv:msg key="label.backupFrequency" bundle="profiles"/>
					</span>
					<input class="laptop-sla" id="rpoHours" name="rpoHours" type="number" min="1" max="{{!isLaptopPlan ? '' : maximumRPOlimit}}"
					data-ng-pattern="/^[0-9]*$/" required data-ng-model="globalTemplate.rpoHours"/>&nbsp;
					<div ng-if="!isLaptopPlan"><cv:msg key="label.hours" bundle="schedule" /></div>
					<select ng-model="automaticScheduleType" data-ng-change="backupFreqChanged(automaticScheduleType)" data-ng-options="incrementalBackupFreq.value as incrementalBackupFreq.name for incrementalBackupFreq in automaticIncrementalBackupFreqs"  class="no-float-auto laptop-backup-frequency-select appearance-auto"></select>
					<%-- <input class="laptop-sla" id="rpoMinutes" name="rpoMinutes" type="number" min="0" max="60" data-ng-model="globalTemplate.rpoMinutes"/>&nbsp;<cv:msg key="label.minutes" bundle="schedule" /> --%>
				</label>
				<!--
				<label>
					<span class="label-spacer backup-window-label"><cv:msg key="label.backupWindow" bundle="profiles"/></span>
					<cv-backup-window-list data-cv-model="globalTemplate.backupWindow"></cv-backup-window-list>
				</label>
				-->
				<uib-accordion close-others="true" class="tile-accordion" data-ng-if="associatedSchedulesEnabled">
					<div uib-accordion-group is-open="status.schedule">
						<uib-accordion-heading>
							<i class="glyphicon" data-ng-class="{'glyphicon-chevron-down': status.schedule, 'glyphicon-chevron-right': !status.schedule}"></i>
							<cv:msg key="label.associatedSchedule" bundle="schedule"/>
							<a data-ng-if="status.schedule" href="" class="pull-right accordion-heading-action-link" data-ng-click="addSchedule()"
									data-ng-class="{disabled: isDerived && !globalTemplate.deriveSettings.definesSchedule.definesEntity}"><cv:msg key="label.addSchedule" bundle="profiles"/></a>
						</uib-accordion-heading>
					<div class="schedule-list">
						<ul class="add-schedule__List group" >
							<li class="ellipsis-parent ellipsis-content" data-ng-repeat="schedule in addedSchedules track by $index">
								<span data-uib-tooltip='<cv:msg key="error.rpoHours" bundle="profiles"/>' data-tooltip-enable="(schedule.flags === slaFlag) && !globalTemplate.rpoHours">
									<a class="always-enabled" data-ng-click="editSchedule(schedule)"
											data-ng-class="{disabled: (schedule.flags === slaFlag) && !globalTemplate.rpoHours}">
										{{schedule.name}}
									</a>
								</span>
								<span data-ng-if="schedule.flags === slaFlag" class='parenthetical-text'>- <cv:msg key="label.rpoSchedule" bundle="profiles"/></span>
							</li>
						</ul>
						<ul class="add-schedule__List group" data-ng-if="addedSchedules.length==0">
							<li class="ellipsis-parent ellipsis-content "><cv:msg key="error.noScheduleAdded" bundle="schedule"/> </li>
						</ul>
					</div>
					</div>
				</uib-accordion>
			</cv-derivable-input>
		</cv-tile-component>
		<%-- <cv-tile-component data-ac-id="label_associatedSchedule-schedule" data-ng-if="showAssociatedSchedules" sla="true" data-title='<cv:msg key="label.associatedSchedule" bundle="schedule"/>'>
			<cv-derivable-input data-override-base="!isDerived || globalTemplate.deriveSettings.definesSchedule.definesEntity">
				<ul class="list-style__row group" data-ng-repeat="schedule in addedSchedules">
					<li class=""><a data-ng-click="editSchedule(schedule)">{{schedule.name}}</a><span data-ng-if="schedule.flags === slaFlag" class='parenthetical-text'>- <cv:msg key="label.rpoSchedule" bundle="profiles"/></span></li>
				</ul>
				<ul class="list-style__row group" data-ng-if="addedSchedules.length==0">
					<li class=""><cv:msg key="error.noScheduleAdded" bundle="schedule"/></li>
				</ul>
				<div class="page-details-box-links">
					<a href="" data-ng-click="addSchedule()"><cv:msg key="label.addSchedule" bundle="profiles"/></a>
				</div>
			</cv-derivable-input>
		</cv-tile-component> --%>
	</div>
</div>
<div class="button-container">
	<!-- <button id="backupScheduleProfile_button_#3117" type="button" data-ng-click="skipStep()" class="btn btn-default cvBusyOnAjax"><cv:msg key="action.skip" bundle="profiles"/></button> -->
	<button id="backupScheduleProfile_button_#5458" type="button" data-ng-click="goPreviousStep()" class="btn btn-default cvBusyOnAjax"><cv:msg key="action.previous" bundle="profiles"/></button> 
	<button id="backupScheduleProfile_button_#1444" type="button" data-ng-click="savebackupScheduleTab()" class="btn btn-primary cvBusyOnAjax"><cv:msg key="action.next" bundle="profiles"/></button> 
</div>