<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.users"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.browse"></cv:cvMessages>
	<cv:cvMessages bundle="localization.navJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.archiving"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1 data-ng-if="restoreMode"><cv:msg key="Restore" bundle="browse"/></h1>
	<h1 data-ng-if="!restoreMode"><span ng-if="isArchiveClient"><cv:msg key="label.nav.archive" bundle="navJs"/></span><span ng-if="!isArchiveClient"><cv:msg key="header.backup" bundle="serversJs"/></span></h1>
</div>
<div class="setup-content">
	<form name="browseServer" id="browseServer" data-cv-submit="restore()" novalidate autocomplete="off">
		<div class="{{restoreSubclientMessge.type}}">{{restoreSubclientMessge.message}}</div>
		<label class="cv-label" >
		<span data-ng-if="restoreMode">{{selectSubclientToRestoreLabel}}</span>
		<span data-ng-if="!restoreMode">{{selectSubclientToBackupLabel}}</span>
		</label>

		<div class="restoreBackupGrid" data-ng-if="showBackupAndRestoreGrid">
<cv-server-filter id="agent-filter" data-ng-if="gridReady && agentFilters && agentFilters.length > 1" filter-label="{{agentLabel}}" toolbar-template-class="backup-restore-grid-toolbar" filter-list="agentFilters"
													filter-current="agentIndex" scroll-threshold="300" width-limit="330"></cv-server-filter>
<cv-server-filter id="backup-set-filter" data-ng-if="gridReady && fsBackupSetFilters" filter-label="{{subClientFilterLabel}}" toolbar-template-class="backup-restore-grid-toolbar" filter-list="fsBackupSetFilters"
													filter-current="currentBackupsetIndex" ng-click="computeMaxHeightBackupsetDropdown()" dropdown-template-class="backupsets-backup-restore-modal"></cv-server-filter>
<cv-kendo-grid id="content-group-kendo-grid"  ng-if="fsContentGroupGridOptions"
				data-cv-grid-options="fsContentGroupGridOptions"></cv-kendo-grid>
		</div>
		<div data-ng-if="!showBackupAndRestoreGrid">
			<div id="restore-subclient" class="restore-modal"
			data-ivh-treeview="agentList"
			data-ivh-treeview-expand-to-depth="3"
			data-ivh-treeview-use-checkboxes="true"
			data-ivh-treeview-on-cb-change="selectionChanged(ivhNode, ivhIsSelected, ivhTree)"
			ivh-treeview-node-tpl="template">
			</div>
		</div>

		<div class="button-container">
				<button id="backupAndRestoretModal_button_#9296" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="cancel()"><cv:msg key="action.cancel" bundle="profiles"/></button>
				<button id="backupAndRestoretModal_button_#5527" type="submit" class="btn btn-primary cvBusyOnAjax"  data-ng-class="{'busy':loading}" data-ng-disabled="disableSave">
				<span data-ng-if="restoreMode">{{selectContentLabel}}</span>
				<span data-ng-if="!restoreMode"><cv:msg key="action.select" bundle="serversJs"/></span>
				</button>
		</div>
	</form>
</div>


<script  type="text/x-kendo-template" id="content-group-detail-grid-template">
	<div class="col-sm-4 text-detail-grid">
		<p><cv:msg key="label.profile" bundle="profiles" /></p>
		#if(planEntity.planId && hasAssociatedSubclientPolicy && !isOneTouchSubclient) {
		#<p class="crop" title="<cv:msg key='label.backupContentFromPlan' bundle='fs' />"
		>
		<cv:msg key="label.backupContentFromPlan" bundle="fs" />
		</p>#
		}#
		<p>
			#if(archivalSolutionState) {
			#<cv:msg key="label.excludedFromArchiving" bundle="archiving" />#
			} else {
			#<cv:msg key="label.excludedFromBackup" bundle="fs"/>#
			}#
		</p>
		<p>
			#if(archivalSolutionState) {
			#<cv:msg key="label.lastArchivingSize" bundle="archiving" /> #
			} else {
			#<cv:msg key="label.lastbackup.size" bundle="collections" /> #
			}#
		</p>

	</div>
	<div class="col-sm-6">
		<p>
			#if(planEntity.planName) {
			#<a href="\\#/profileDetails/#:planEntity.planId#">#:planEntity.planName#</a>#
			} else {
			# <cv:msg key="label.notAssigned" bundle="exchange" />#
			}#
		</p>
		#if(planEntity.planId && hasAssociatedSubclientPolicy && !isOneTouchSubclient) {
		#<p  class="content-from-plan-toggle"></p>#
		}#
		<p>#if(formattedExcludeContent) {
			#<span>#:formattedExcludeContent#</span>#
			} else {
			#<span cv-toggle-content="<cv:msg key='info.noExcludeContent' bundle='servers'/>" cv-toggle="tooltip"><cv:msg key='info.noExcludeContent' bundle='servers'/></span>#
			}#</p>
		<p>#:formattedAppSize#</p>
	</div>
</script>