<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
<cv:cvMessages bundle="localization.settingsJs"></cv:cvMessages>
</script>
<fmt:bundle basename="localization.settings">
<h1 class="page-title">
	<span class="name">
		<fmt:message key="pageHeader.licenseAndRegistration" />
	</span>
</h1>
<div class="row">
	<div class="col-md-6">
	<cv-tile-component data-title='<fmt:message key="label.registrationDetails" />' loader="applyLicense" data-ng-if="applyLicense.length !== 0">
		<ul class="list-style-secondary">
				<li class="group">
					<span class="pageDetailColumn"><fmt:message key="label.commcellId" /></span>
					<span class="pageDetailColumn">{{applyLicense.licenseInfo.commcellId}}</span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><fmt:message key="label.commServeIPAddress" /></span>
					<span class="pageDetailColumn">{{applyLicense.licenseInfo.commserveId}}</span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><fmt:message key="label.licenseIPAddress" /></span>
					<span class="pageDetailColumn">DUMMY DATA 255.255.255</span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><fmt:message key="label.edition" /></span>
					<span class="pageDetailColumn">{{applyLicense.licenseInfo.oemName}}</span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><fmt:message key="label.licenseMode" /></span>
					<span class="pageDetailColumn">{{applyLicense.licenseInfo.licenseMode}}</span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><fmt:message key="label.serialNumber" /></span>
					<span class="pageDetailColumn">{{applyLicense.licenseInfo.serialNo}}</span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><fmt:message key="label.registrationCode" /></span>
					<span class="pageDetailColumn">{{applyLicense.licenseInfo.regCode}}</span>
				</li>
				<li class="group">
					<span class="pageDetailColumn" data-ng-show='!applyRegistered'><fmt:message key="label.notRegistered" /></span>
					<span class="pageDetailColumn" data-ng-show='applyRegistered'><fmt:message key="label.registered" /></span>
					<span class="pageDetailColumn">
						<button id="applylicense_button_#9858" type="button" class="btn btn-primary cvBusyOnAjax" ng-click='registerLicense()' data-ng-disabled='applyRegistered'><fmt:message key="action.register" /></button>
					</span>
				</li>
			</ul>
	</cv-tile-component>
	<cv-tile-component data-title='<fmt:message key="label.applyLicense" />' loader="applyLicense" data-ng-hide="applyLicense.length === 0">
		<div class="info">
		<fmt:message key="label.evaluationEndedText"/> <a href="mailto:Prodreg@commvault.com?subject=Activate/Update license&body=%0D%0A Serial Number :{{license.licenseInfo.serialNo}}%0D%0A Registration Code :{{license.licenseInfo.regCode}}%0D%0A">prodreg@commvault.com</a> <fmt:message key="label.evalApplyLicense" />
		</div>
		<ul class="list-style-secondary">
				<li class="group">
					<span class="pageDetailColumn"><fmt:message key="label.licenseFile" /></span>
					<span class="pageDetailColumn">
						<input id="uploadFile" placeholder="Choose File" disabled="disabled" />
								<span class="fileUpload btn">
								    <span>Browse</span>
								    <input id="uploadBtn" type="file" class="upload" />
								</span>
								<button id="applylicense_button_#2446" type="button" class="btn btn-primary cvBusyOnAjax" ng-click='updateLicense()'>Apply</button>
					</span>
				</li>
		</ul>
	</cv-tile-component>
<!--
						<div class='col-md-12 apply-title'>
								<h4>Apply License</h4>
						</div>
						</div>
						<div class='row license-details'>
								<div class='col-md-12'>Product evaluation has ended.To activate license send an email to commVault customer Support<br>at <a href="mailto:Prodreg@commvault.com?subject=Activate/Update license">Prodreg@commvault.com</a> or apply license file.</div>
							<div class='col-md-3 license-label file-upload-section'>
								License File
							</div>
							<div class='col-md-9 file-upload-section'>
								<div class='col-md-9'>
								<input id="uploadFile" placeholder="Choose File" disabled="disabled" />
								<div class="fileUpload btn btn-primary">
								    <span>Browse</span>
								    <input id="uploadBtn" type="file" class="upload" />
								</div>
								<button id="applylicense_button_#6650" type="button" class="btn btn-primary cvBusyOnAjax" ng-click='updateLicense()'>Apply</button>
								</div>
							</div>
						</div>
					</div>
				</div>
	</div>
	 -->
	</div>
</div>
</fmt:bundle>