<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
	<cv:cvMessages bundle="localization.collections"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1><cv:msg key="label.addSnapPlan" bundle="profiles"/></h1>
</div>
<div class="setup-content server-plan smaller-inputs" data-ng-controller="createProfileController">
	<div class="{{generalSetupMessage.type}} serverMessage">{{generalSetupMessage.message}}</div>
	<p data-ng-if="!showCreatePlanForm" class="{{backupContentMessage.type}} serverMessage">{{planExistedMessage.message}}</p>
	<p class="text-center"><a data-ng-click="goToCreatePlan()" data-ng-hide="showCreatePlanForm || !showPlanSkip || !skipForSetup"> <cv:msg key="label.CreateNewPlan" bundle="profiles"/></a></p>
	<form data-ng-show="!skipForSetup || showPlanSkip===false || showCreatePlanForm" name="addServerPLanForm"
			data-cv-submit="addSnapPlan()" data-cv-validate="true" novalidate autocomplete="off">
		<!-- // name // -->
			<div class="global-options remove-border-padding">
				<label for="planName"><cv:msg key="label.profileName" bundle="profiles" />
					<input type="text" name="planName" data-ng-model="globalTemplate.name" id="planName" data-autoselect="{{autoSelect}}" autofocus />
 				</label>
			</div>
	<h4><cv:msg key="label.storages" bundle="profiles"/></h4>
		<!-- // primary storage // -->
		<div class="global-options remove-border-padding">
		<label for="primaryStorage" class="select-label"><cv:msg key="label.primaryStorage" bundle="profiles"/>
				 	<select id="primaryStorage" name="primaryStorage" data-ng-model="globalTemplate.storageInfo.primaryStorage"
						data-ng-options="storagePool.storagePoolEntity.storagePoolName for storagePool in storagePools"
							data-ng-class="{'has-error': cv.addServerPLanForm.needsAttention(addServerPLanForm.primaryStorage)}">
						<option value=""><cv:msg key="placeholder.selectStorage" bundle="profiles"/></option>
					</select>
		</label>
		</div>
		<!-- snap recovery points -->
		<div class="global-options remove-border-padding collections-global-options add-server-plan">
			<label for="snapRecoveryPoints"><cv:msg key="label.snapRecoveryPoints" bundle="profiles"/>
				<input id="snapRecoveryPoints" name="snapRecoveryPoints" type="number" data-ng-model="globalTemplate.storageInfo.snapRecoveryPoints" class="less-width storage-retention-input snap-recovery-input" />
			 </label>
		</div>
		<!-- remove this check box in sp12, since backend not completed yet, will do this in sp13 -->
<%-- 		<div class="global-options remove-border-padding">
				<input type="checkbox" id="enableBackupCopy" data-ng-click="handleAuxCopySchedule(enableBackupCopy)" ng-init="enableBackupCopy=true" data-ng-model="enableBackupCopy" />
				<label for="enableBackupCopy"><cv:msg key="label.moveDataToStorageLibrary" bundle="profiles"/></label>
		</div> --%>
		<!-- RPO and SLA start -->
		<h4 class="plan"><cv:msg key="label.rpo" bundle="profiles"/><cv-help-component help-text="<cv:msg key="info.help.rpo" bundle="profiles"/>"></cv-help-component></h4>
		<!--
		<div class="global-options remove-border-padding collections-global-options add-server-plan sla-interval-input">
			<label for="sla">
				<cv:msg key="label.backupCoverage" bundle="profiles"/>
			</label><label class="select-label snap-sla-interval-select">
				&#8203;
				<select id="sla" name="sla" data-ng-model="globalTemplate.slaInterval"
					data-ng-options="slaInterval for slaInterval in slaIntervals">
				</select>
			</label><label class="sla-interval-unit"><cv:msg key="label.slaDays" bundle="profiles" /></label>
		</div>
		-->
		<div class="global-options remove-border-padding collections-global-options add-server-plan">
			<label for="rpo">
				<cv:msg key="label.backupFrequency" bundle="profiles"/>
				<span><input id="rpo" name="rpo" type="number" min="1" required data-ng-model="globalTemplate.rpo" class="less-width storage-retention-input snap-sla-input" /><cv:msg key="label.hours" bundle="schedule" /></span>
			</label>
		</div>
		<div class="global-options remove-border-padding collections-global-options add-server-plan">
			<label>
				<span class="backup-window-label">
					<cv:msg key="label.backupWindow" bundle="profiles"/>
				</span>
				<span class="snap-backup-window-list-wrapper">
					<cv-backup-window-list data-cv-model="globalTemplate.backupWindow"></cv-backup-window-list>
				</span>
			</label>
		</div>
		<!-- RPO and SLA end -->
		<div class="schedule" data-ng-if="associatedSchedulesEnabled">
		<uib-accordion close-others="true" class="text-left">
			<div uib-accordion-group is-open="status.schedule">
				<uib-accordion-heading>
					<i class="glyphicon" data-ng-class="{'glyphicon-chevron-down': status.schedule, 'glyphicon-chevron-right': !status.schedule}"></i>
					<cv:msg key="label.associatedSchedule" bundle="schedule"/>
					<a data-ng-if="status.schedule" href="" class="pull-right accordion-heading-action-link" data-ng-click="addSchedule()"><cv:msg key="label.addSchedule" bundle="profiles"/></a>
				</uib-accordion-heading>
			<div class="schedule-list">
				<ul class="add-schedule__List group" data-ng-repeat="schedule in addedSchedules track by $index">
					<li class="ellipsis-parent ellipsis-content "><a data-ng-click="editSchedule(schedule)">{{schedule.name}}</a><span data-ng-if="schedule.flags === slaFlag" class='parenthetical-text'>- <cv:msg key="label.rpoSchedule" bundle="profiles"/></span></li>
				</ul>
				<ul class="add-schedule__List group" data-ng-if="addedSchedules.length==0">
					<li class="ellipsis-parent ellipsis-content "><cv:msg key="error.noScheduleAdded" bundle="schedule"/> </li>
				</ul>
			</div>
			</div>
		</uib-accordion>
		</div>
		<div class="button-container">
				<button id="addSnapPlan_button_#7420" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="cancel()"><cv:msg key="action.cancel" bundle="profiles"/></button> 
				<button id="addSnapPlan_button_#9625" type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-disabled="disableNext"><cv:msg key="action.save" bundle="profiles"/></button> 
		</div>
	</form>
</div>