<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.settingsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.navJs"></cv:cvMessages>
</script>
<div>
	<div class="setup-title">
		<h1><cv:msg key="label.nav.operationWindow" bundle="navJs"/></h1>
	</div>

		<div class="no-padding margin-top-15 setup-content">
			<span class="{{operationWindowMessage.type}} serverMessage">{{operationWindowMessage.message}}</span>
		</div>
		<form name="addOperationWindowRuleForm" novalidate data-cv-submit="addOperationWindowRule()" class="bootstrap-wrapper form-horizontal custom-jobs-view-modal" autocomplete="off" id="addOperationWindowRuleForm">
			<div class="panel-body">
			<!-- // name // -->
			<div class="form-group padding-bottom-5">
				<label for="operationRuleName" class="col-xs-12 col-md-5 col-lg-5"><cv:msg key="label.name" bundle="settingsJs"/></label>
				<div class="col-xs-12 col-md-7 col-lg-7">
					<input type="text" name="operationRuleName" data-ng-model="model.operationRuleName" id="operationRuleName" required />
						<span class="help-block" data-ng-show="cv.addOperationWindowRuleForm.needsAttention(addOperationWindowRuleForm.operationRuleName)"><cv:msg key="error.name" bundle="settingsJs"/></span>
				</div>
			</div>
			<div class="form-group padding-top-5">
                <label for="allowedOps" class="col-xs-12 col-md-5 col-lg-5"><cv:msg key="label.operations" bundle="settingsJs"/></label>
                <div class="col-xs-12 col-md-7 col-lg-7 margin-bottom-10">
                     <div class="margin-top-10" data-ng-repeat="operation in allowedOps track by $index">
                     	<input type="checkbox" name="{{operation.name}}" id="{{operation.name}}" data-ng-model="operation.selected" />
                     	<label class="no-margin checkbox-label" for="{{operation.name}}">{{operation.name}}</label>
                     </div>
                </div>
            </div>
            <!-- Time  interval -->
            <div class="form-group"><h4 class="margin-top-15 col-xs-12 col-md-12 col-lg-12"><cv:msg key="label.timeIntervals" bundle="settingsJs"/></h4></div>

			<!-- // days // -->
            <div class="form-group">
                <label for="daysOfWeek" class="col-xs-12 col-md-5 col-lg-5"><cv:msg key="label.onDaysOfWeek" bundle="settingsJs"/></label>
                <div class="col-xs-12 col-md-7 col-lg-7"><!-- style="width:98%;" -->
                     <div class="cv-help-block padding-top-5 margin-0" data-ng-show="showDaysError"><cv:msg key="error.daysOfWeek" bundle="settingsJs"/></div>
                     <div class="row col-lg-5 col-xs-6 col-md-6" data-ng-repeat="dayOfWeek in model.daysOfWeek track by $index">
                     <input type="checkbox" name="daysOfWeek" id="{{dayOfWeek.name}}" data-ng-model="dayOfWeek.selected" data-ng-change= "selectDeselectDay(dayOfWeek)"/><label class="checkbox-label" for="{{dayOfWeek.name}}">{{dayOfWeek.name}}</label>
                     </div>
                </div>
			</div>

			<!-- // weeks // -->
			<div class="form-group">
				<label for="weeksOfTheMonth" class="col-xs-12 col-md-5 col-lg-5"><cv:msg key="label.ofWeeksOfMonth" bundle="settingsJs"/></label>
				<div class="col-xs-12 col-md-7 col-lg-7"><!-- style="width:98%;" -->
						<div class="cv-help-block padding-top-5 margin-0" data-ng-show="showWeeksError"><cv:msg key="error.weekOfMonth" bundle="settingsJs"/></div>
						<div class="row col-lg-5 col-xs-6 col-md-6" data-ng-repeat="week in model.weeksOfTheMonth track by $index">
						<input type="checkbox" name="weeksOfTheMonth" id="{{week.name}}" data-ng-model="week.selected" data-ng-disabled="week.disabled" data-ng-change="selectDeselectWeek(week)"/><label class="checkbox-label" for="{{week.name}}">{{week.name}}</label>
						</div>
				</div>
			</div>

			<!-- // Info text  // -->
			<div class="form-group">
				<label  class="col-xs-12 col-md-5 col-lg-5"></label>
				<label  class="col-xs-12 col-md-7 col-lg-7 font-size-12" data-ng-if="dayOfWeekString !== '' &&  weekOfMonthString !== ''"><cv:msg key="label.infoLabel" bundle="settingsJs"/><b>{{dayOfWeekString}}</b><cv:msg key="conjunction.of" bundle="settingsJs"/><b>{{weekOfMonthString}}</b><cv:msg key="label.week" bundle="settingsJs"/></label>
			</div>
			<!-- Do not run time interval -->
			<div class="form-group">
			<label for="daysOfWeek" class="padding-bottom-10 col-xs-12 col-md-12 col-lg-12"><cv:msg key="label.doNotRunIntervalsDialog" bundle="settingsJs"/> <span class="help-info optional-text padding-left-10"> (<cv:msg key="label.clickAndDrag" bundle="settingsJs"/>)</span> 	</label>
				<div id="operation-window-table" class="margin-left-10 margin-bottom-10 col-xs-12 col-md-12 col-lg-12">
					<table drag-select drag-select-ids="ids">
					   <tr id="TIME">
						   <td id="{{time.id}}" data-ng-repeat="time in timeToSelect" data-ng-class="{'eng-selected-item' : changeColor('{{time.id}}')}"></td>
					   </tr>
					</table>
					<span class="help-block" data-ng-show="showIntervalError"><cv:msg key="error.noDoNotRunInterval" bundle="settingsJs"/></span>
					<div class="hours">
      					<span data-ng-repeat="time in timeToSelect" data-ng-if="time.type" >{{time.value}}<span>{{time.type}}</span> </span>
    				</div>
				</div>
			</div>
			<!-- Do not run interval end-->

			<!-- // start date // -->
			<div class="form-group">
				<div class="col-xs-12 col-md-12 col-lg-12">
					<toggle-control status="dateToggle" data-ng-click="enableDisableDate()" true-property="true"></toggle-control>
					<label for="enableDate" class="cv-checkbox-label operation-rule-enable-date"><cv:msg key="action.enableDate" bundle="settingsJs"/></label>
				</div>
			</div>

			<div class="form-group" data-ng-if="enableDate">
				<label for="startDate" class="col-xs-12 col-md-5 col-lg-5"><cv:msg key="label.startDate" bundle="settingsJs" /></label>


				<div class="col-xs-12 col-md-7 col-lg-7">
					<div class="calendar-wrapper date-picker modal-calendar">
						<div class="input-group full-width">
						<input name="startDate" id="startDate" type="text" data-ng-model="model.startDate" data-ng-change="onStartDateChange()" uib-datepicker-popup="MM/dd/yyyy" data-min-date="minDate" is-open="datepicker.from" datepicker-options="dateOptions" close-text="Close" />
							<span class="input-group-btn">
						    	<button id="addOperationWindowModal_button_#4949" type="button" class="btn btn-primary" data-ng-click="open('from')">
						    		<i class="glyphicon glyphicon-calendar"></i>
						    	</button>
						    </span>
					    </div>
				    </div>
					<span class="cv-help-block" data-ng-show="cv.addOperationWindowRuleForm.needsAttention(addOperationWindowRuleForm.startDate)"><cv:msg key="error.startDate" bundle="settingsJs"/></span>
				</div>
			</div>


			<!-- // end date // -->
		   	<div class="form-group" data-ng-if="enableDate">
				<label for="endDate" class="col-xs-12 col-md-5 col-lg-5"><cv:msg key="label.endDate" bundle="settingsJs" /></label>


				<div class="col-xs-12 col-md-7 col-lg-7">
					<div class="calendar-wrapper date-picker modal-calendar">
						<div class="input-group full-width">
						<input data-ng-change="endDateChanged()" name="endDate" id="endDate" type="text" uib-datepicker-popup="MM/dd/yyyy" data-min-date="checkMinDate()" data-ng-model="model.endDate" is-open="datepicker.to" close-text="Close" datepicker-options="dateOptions" />
							<span class="input-group-btn">
						    	<button id="addOperationWindowModal_button_#6713" type="button" class="btn btn-primary" data-ng-click="open('to')">
						    		<i class="glyphicon glyphicon-calendar"></i>
						    	</button>
						    </span>
				    	</div>
				    </div>
				    <span class="cv-help-block" data-ng-show="cv.addOperationWindowRuleForm.needsAttention(addOperationWindowRuleForm.endDate)"><cv:msg key="error.endDate" bundle="settingsJs"/></span>
					<span class="cv-help-block" data-ng-show="showEndDateError"><cv:msg key="error.endDateSmallerThanStartDate" bundle="settingsJs"/></span>
				</div>
			</div>


			<!-- // donot submit job // -->
			<div class="form-group">
					<div class="col-xs-12 col-md-12 col-lg-12">
						<toggle-control status="model.doNotSubmitJob" data-ng-click="enableDisableDoNotSubmitJob()"></toggle-control>
						<cv-help-text help-label="action.doNotSubmitJob" help-text="action.doNotSubmitJob.helpText"/></span>
					</div>
			</div>
			<div class="button-container">
				<button id="addOperationWindowModal_button_#2712" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="cancel()"><cv:msg key="action.cancel" bundle="settingsJs"/></button>
				<button id="addOperationWindowModal_button_#3694" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="action.save" bundle="profiles"/></button>
			</div>
			</div>
		</form>
</div>