<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<div>
	<script nonce="${sessionScope.cspNonce}" >
		<cv:cvMessages bundle="localization.users"></cv:cvMessages>
		<cv:cvMessages bundle="localization.settings"></cv:cvMessages>
	</script>
	<div class="setup-title">
		<h1 data-ng-if="!setup"><cv-help-text use-icon="true" data-ng-if="model.focusOn == attrTypeFlags.LDAPQueryParam" help-direction="bottom" help-label-localized="{{title}}" help-text="helpText.ldapQueryParam" /><cv-help-text use-icon="true" data-ng-if="model.focusOn == attrTypeFlags.otherAttribute" help-direction="bottom" help-label-localized="{{title}}" help-text="helpText.overriddenAttributes" /><cv-help-text use-icon="true" data-ng-if="model.focusOn != attrTypeFlags.otherAttribute && model.focusOn != attrTypeFlags.LDAPQueryParam" help-direction="bottom" help-label-localized="{{title}}" help-text="label.addDomainHelptext" /></h1>
		<h1 data-ng-if="setup"><cv:msg key="pageHeader.addNameServer" bundle="users" /><cv-help-component help-text="<cv:msg key="label.addDomainHelptext" bundle="users" />"></cv-help-component></h1>
	</div>
	<div class="setup-content medium-width">
		<p class="{{nameServerWindowMessage.type}} serverMessage">{{nameServerWindowMessage.message}}</p>
		<p class="{{domainExistedMessage.type}} serverMessage">{{domainExistedMessage.message}}</p>
		<a data-ng-click="goToAddDomain()" data-ng-hide="showAddDomainForm || !showSkip"> <cv:msg key="pageHeader.addNameServer" bundle="users"/></a>
		<form data-cv-submit="addNameServer()" novalidate autocomplete="off" name="addNameServerForm">
			<div data-ng-show="!setup || showSkip===false || showAddDomainForm">
				<cv-add-name-server
					data-model="model"
					data-domain-list="domainList"
					data-password-placeholder="passwordPlaceholder"
					data-is-optional="isOptional">
				</cv-add-name-server>
				<div class="button-container" data-ng-if="!setup">
						<button id="addNameServerModal_button_#4072" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="cancel()"><cv:msg key="action.cancel" bundle="users" /></button> 
						<button id="addNameServerModal_button_#3290" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="action.save" bundle="users" /></button> 
				</div>
				<div class="button-container" data-ng-if="setup && !mspSetupTenant">
						<button id="addNameServerModal_button_#6521" type="button" class="btn btn-default cvBusyOnAjax skip-btn--hidden" data-ng-click="skip()" data-ng-if="showSkip"><cv:msg key="Skip" /></button> 
						<button id="addNameServerModal_button_#1850" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="action.save" bundle="users" /></button> 
				</div>
				<div class="button-container" data-ng-if="mspSetupTenant">
						<button id="addNameServerModal_button_#2531" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="button.finish" bundle="users" /></button> 
				</div>
			</div>
			<div data-ng-hide="showAddDomainForm || !showSkip" class="button-container centered">
				<button id="addNameServerModal_button_#7443" type="button" class="btn btn-default cvBusyOnAjax skip-btn--hidden" data-ng-click="skip()"><cv:msg key="label.continue" bundle="profiles" /></button> 
			</div>
		</form>
	</div>
</div>