<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.devices"></cv:cvMessages>
	<cv:cvMessages bundle="localization.users"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1><cv:msg key="label.activateDevice" bundle="devices"/></h1>
</div>
<div class="bootstrap-wrapper modal-margin">
	<form class="form-horizontal" name="activateDeviceForm" data-cv-submit="activate()" novalidate autocomplete="off">
		<div data-ng-if="model.activationMode !== 'DEVICETOPLAN'" class="panel panel-default no-border">
			<div class="panel-body">
			<p data-ng-if="activateDeviceMessage.message" class="{{activateDeviceMessage.type}} serverMessage text-center" >{{activateDeviceMessage.message}}</p>
				<div class="form-group">
					<label class="col-xs-12 col-lg-6" for="activateByUser">
						<input id="activateByUser" type="radio" name="activateByUser" value="USER"
						data-ng-model="model.activationMode" /><cv:msg key="label.activateByUser" bundle="devices"/>
					</label>
					<label class="col-xs-12 col-lg-6" for="activateByPlan">
						<input id="activateByPlan" type="radio" name="activateByPlan" value="PLAN"
						data-ng-model="model.activationMode" /><cv:msg key="label.activateByPlan" bundle="devices"/>
					</label>
				</div>
			</div>
		</div>
		
		<div class="panel panel-default no-border" data-ng-if="(model.activationMode === 'USER')">
			<div class="panel-body">
				<div class="form-group" data-ng-if="!owner">
					<label class="col-xs-12 col-lg-4" for="owner"><cv:msg key="label.user" bundle="devices"/></label>
					<div class="col-xs-12 col-lg-8">
						<div class="padding-right-20">
							<isteven-multi-select id="activateDevice_isteven-multi-select_#3447"  
								input-model="users" 
								output-model="selectedUsers" 
								button-label="userName" 
								item-label="userName" 
								tick-property="selected" 
								class="isteven-multi-select user-group-select" 
								helper-elements="none" 
								selection-mode="single" 
								on-close="changeUser()" 
								translation="localLang">
							</isteven-multi-select>
						</div>
					</div>
				</div>
				<span data-ng-show="loader && !owner" class="grid-data-spinner" >
						<img src="${pageContext.request.contextPath}/common/img/ajax-loader.gif">
				</span>
				<div class="form-group" data-ng-if="planDetails && hasPlan && !owner">
					<label class="col-xs-12 col-lg-4" for="owner"><cv:msg key="label.profile" bundle="profiles"/></label>
					<label class="col-xs-12 col-lg-8">{{planDetails.summary.plan.planName}}</label>
				</div>
				
				<div class="form-group" data-ng-if="hasPlan">
					<p class="info-text text-left" data-ng-if="!laptopName">
						<span data-ng-if="!laptopName" ><cv:msg key="label.willBeActivated" bundle="devices"/></span>
						<span data-ng-if="laptopName"><cv:msg key="info.laptop" bundle="devices"/><b>{{laptopName}}</b>&nbsp;<cv:msg key="label.clientWillBeActivated" bundle="devices"/></span>
						<b>{{userName}}</b>&nbsp;<cv:msg key="label.andAssociatedTo" bundle="devices"/>&nbsp;<b>{{planName}}</b>
					</p>
					<p class="info-text text-left" data-ng-if="laptopName">
						<cv:msg key="info.laptop" bundle="devices"/><b>{{laptopName}}</b>&nbsp;<cv:msg key="label.clientWillBeActivated" bundle="devices"/><b>{{userName}}</b>&nbsp;<cv:msg key="label.andAssociatedTo" bundle="devices"/>&nbsp;<b>{{planName}}</b>
					</p>
				</div>
				
				<div class="form-group" data-ng-if="disabledActivate">
					<p class="info-text text-left">{{activateDevicePlanMessage}}</p>
				</div>
			</div>
		</div>
		
		
		<div class="panel panel-default no-border" data-ng-if="model.activationMode === 'PLAN' || model.activationMode === 'DEVICETOPLAN'">
			<div class="panel-body">
				<div class="form-group" data-ng-if="plans.length > 0">
					<label class="col-xs-12 col-lg-4" for="owner"><cv:msg key="label.profiles" bundle="profiles"/></label>
					<div class="col-xs-12 col-lg-8">
						<div class="padding-right-20">
							<isteven-multi-select id="activateDevice_isteven-multi-select_#2554"  
								input-model="plans" 
								output-model="selectedPlans" 
								button-label="planName" 
								item-label="planName" 
								tick-property="selected" 
								class="isteven-multi-select user-group-select" 
								helper-elements="none" 
								selection-mode="single" 
								on-close="changePlan()" 
								translation="localLang">
							</isteven-multi-select>
						</div>
					</div>
				</div>
				<div class="form-group" data-ng-if="plans.length === 0">
					<p class="info-text text-left ">
						<cv:msg key="error.noProfiles" bundle="profiles"/>
					</p>
				</div>
			</div>
		</div>
		<div class="button-container">
			<button id="activateDevice_button_#4430" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="cancel()"><cv:msg key="action.cancel" bundle="profiles"/></button> 
			<button id="activateDevice_button_#1132" type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-disabled="disabledActivate && (model.activationMode === 'USER')"><cv:msg key="action.save" bundle="profiles"/></button> 
		</div>
	</form>
</div>
